

#include <stdio.h>
#include <math.h>

int TwoSides;
int NPTS;
float RAD;

main(argc, argv)
    int argc;
    char **argv;
{
	int i, j;
	double f, x, y, z, x2, y2;
	int t1, t2, t3, t4;

	if (argc > 4)
	{
		fprintf(stderr, "usage: %s [-p<num_pts>] [-r<radius>] [-two]\n",
			argv[0]);
	}
	TwoSides = 0;
	NPTS = 0;
	RAD = 1.0;
	for (i = 1; i < argc; i++)
	{
		if ((argv[i][0] == '-')&&(argv[i][1] == 'p'))
		{
			NPTS = atoi(&argv[i][2]);
			if (((NPTS / 4) * 4) != NPTS)
			{
				fprintf(stderr, "Warning NPTS (%d) is not a multiple of four\n", NPTS);
				NPTS = ((NPTS / 4) * 4);
				fprintf(stderr, "Setting NPTS  to (%d)\n", NPTS);
			}
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 'r'))
		{
			RAD = atof(&argv[i][2]);
			if (RAD <= 0.0)
			{
				fprintf(stderr, "Warning RAD (%f) is too small setting it to 1.0\n", RAD);
				RAD = 1.0;
			}
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 't'))
		{
			TwoSides = 1;
		}
	}

	if (NPTS == 0)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}

	printf("%d\n", ((NPTS * ((NPTS / 2) - 1)) + 2));
	if (TwoSides)
	{
		printf("%d\n",2*(((NPTS * 2) * ((NPTS / 2) - 2)) + (NPTS * 2)));
	}
	else
	{
		printf("%d\n", (((NPTS * 2) * ((NPTS / 2) - 2)) + (NPTS * 2)));
	}
	for (i=0; i<=(NPTS / 2); i++)
	{
		f = ((double)i / (NPTS / 2)) + 0.5;
		x2 = RAD * cos(f * M_PI);
		y2 = RAD * sin(f * M_PI);
		if ((i > 0) && (i < (NPTS / 2)))
		{
			for (j=0; j<NPTS; j++)
			{
				f = ((double)j * 2) / NPTS;
				x = x2 * cos(f * M_PI);
				y = y2;
				z = x2 * sin(f * M_PI);
				printf("%lf %lf %lf\n", x, y, z);
			}
		}
		else
		{
			printf("%lf %lf %lf\n", 0.0, y2, 0.0);
		}
	}

	t1 = 0;
	t2 = 1;
	t3 = 2;
	for (j=1; j<NPTS; j++)
	{
		printf("%d %d %d\n", t1, t2, t3);
		if (TwoSides)
		{
			printf("%d %d %d P2\n", t1, t3, t2);
		}
		t2++;
		t3++;
	}
	printf("%d %d %d\n", t1, t2, t1 + 1);
	if (TwoSides)
	{
		printf("%d %d %d P2\n", t1, t1 + 1, t2);
	}

	t1 = 1;
	t2 = 2;
	t3 = NPTS + 1;
	t4 = NPTS + 2;
	for (i=2; i<(NPTS / 2); i++)
	{
		for (j=1; j<NPTS; j++)
		{
			printf("%d %d %d\n", t1, t3, t4);
			printf("%d %d %d\n", t1, t4, t2);
			if (TwoSides)
			{
				printf("%d %d %d P2\n", t1, t4, t3);
				printf("%d %d %d P2\n", t1, t2, t4);
			}
			t1++;
			t2++;
			t3++;
			t4++;
		}
		t2 -= NPTS;
		t4 -= NPTS;
		printf("%d %d %d\n", t1, t3, t4);
		printf("%d %d %d\n", t1, t4, t2);
		if (TwoSides)
		{
			printf("%d %d %d P2\n", t1, t4, t3);
			printf("%d %d %d P2\n", t1, t2, t4);
		}
		t1 = t2 + NPTS;
		t2 = t1 + 1;
		t3 = t4 + NPTS;
		t4 = t3 + 1;
	}

	for (j=1; j<NPTS; j++)
	{
		printf("%d %d %d\n", t3, t2, t1);
		if (TwoSides)
		{
			printf("%d %d %d P2\n", t3, t1, t2);
		}
		t1++;
		t2++;
	}
	printf("%d %d %d\n", t3, t2 - NPTS, t1);
	if (TwoSides)
	{
		printf("%d %d %d P2\n", t3, t1, t2 - NPTS);
	}
}

