
#ifndef _TM_H
#define _TM_H

#include <stdio.h>
#include <stdlib.h>
#include <tcl.h>
#include <Xm/Xm.h>

#if XmVersion == 1001
#  define MOTIF11
#endif

#ifdef MOTIF11
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#define XmFONTLIST_DEFAULT_TAG XmSTRING_DEFAULT_CHARSET
#endif

#ifdef DEBUG_MALLOC
#include <dbmalloc.h>
#endif

#define TM_MAXARGS 100
#define TM_NUM_PARAMS 10

/* global vbl names for stuf used in Text verify callbacks */
#define TM_TEXT_DOIT "_Tm_Text_Doit"
#define TM_TEXT_STARTPOS "_Tm_Text_StartPos"
#define TM_TEXT_ENDPOS "_Tm_Text_EndPos"
#define TM_TEXT_PTR "_Tm_Text_Ptr"
#define TM_TEXT_LENGTH "_Tm_Text_Length"

/* global vbl names for result capturing */
#define TM_RESULT_BUF "_Tm_Result_Buf"
#define TM_SAVE_RESULT "_Tm_Save_Result"

/* global vbl names for stuff used in convertProc in D&D */
#define TM_CONVERT_TYPE "_Tm_Convert_Type"
#define TM_CONVERT_VALUE "Tm_Convert_Value"


/*
 * This contains info that is common to all widgets
 * created under one display
 */
typedef struct Tm_Display {
    Display	*display;
    Widget	toplevel;
    Widget	commWidget;	/* used for send command */
    Atom 	registryProperty;
    Atom	commProperty;
} Tm_Display;

/*
 * each widget created by tcl has one of these
 */
typedef struct Tm_Widget {
    Widget	widget;		/* Xt widget */
    char	*pathName;	/* full path from `.' */
    Tcl_Interp  *interp;	/* interp for this widget */
    char 	*parent;	/* parent path name from `.' */
    char	*dropProc;	/* D&D proc */
    char	*transferProc;	/* D&D proc */
    char 	*convertProc;	/* D&D proc */
    Tm_Display	*displayInfo;	/* info shared by all in this interp */
}   Tm_Widget;

/* This structure is used as the client data field in callback functions */
typedef struct Tm_ClientData {
    char	*callback_func;
    Tm_Widget   *widget_info;
}   Tm_ClientData;

/* This structure is used for Input Handlers */
typedef struct Tm_InputData {
    Tcl_Interp *interp;
    char *command;	/* command to be executed by input handler */
} Tm_InputData;

/* This structure is used for Timer Handlers */
typedef struct Tm_TimerData {
    Tcl_Interp *interp;
    char *command;	/* command to be executed by input handler */
} Tm_TimerData;

/*
extern Tcl_HashTable WidgetTable;
*/

typedef struct {
    char *fileName;
}   Tm_ResourceType, *Tm_ResourceTypePtr;

typedef int (*Tm_WidgetCmdProc)_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
            int argc, char **argv));

/* used in drag and drop */
typedef struct Tm_TransferStruct {
    char *value;
    char *closure;
} Tm_TransferStruct;

/* strings for use in widget create commands */
#define ArrowButton		"xmArrowButton"
#define BulletinBoard		"xmBulletinBoard"
#define BulletinBoardDialog	"xmBulletinBoardDialog"
#define CascadeButton		"xmCascadeButton"
#define Command			"xmCommand"
#define DialogShell		"xmDialogShell"
#define DrawingArea		"xmDrawingArea"
#define DrawnButton		"xmDrawnButton"
#define ErrorDialog		"xmErrorDialog"
#define FileSelectionBox	"xmFileSelectionBox"
#define FileSelectionDialog	"xmFileSelectionDialog"
#define Form			"xmForm"
#define FormDialog		"xmFormDialog"
#define Frame			"xmFrame"
#define InformationDialog	"xmInformationDialog"
#define Label			"xmLabel"
#define List			"xmList"
#define MainWindow		"xmMainWindow"
#define MenuBar			"xmMenuBar"
#define MessageBox		"xmMessageBox"
#define MessageDialog		"xmMessageDialog"
#define OptionMenu		"xmOptionMenu"
#define PanedWindow		"xmPanedWindow"
#define PopupMenu		"xmPopupMenu"
#define PromptDialog		"xmPromptDialog"
#define PulldownMenu		"xmPulldownMenu"
#define PushButton		"xmPushButton"
#define QuestionDialog		"xmQuestionDialog"
#define RowColumn		"xmRowColumn"
#define Scale			"xmScale"
#define ScrollBar		"xmScrollBar"
#define ScrolledList		"xmScrolledList"
#define ScrolledText		"xmScrolledText"
#define ScrolledWindow		"xmScrolledWindow"
#define SelectionBox		"xmSelectionBox"
#define SelectionDialog		"xmSelectionDialog"
#define Separator		"xmSeparator"
#define Text			"xmText"
#define TextField		"xmTextField"
#define ToggleButton		"xmToggleButton"
#define TopLevelShell		"topLevelShell"
#define WarningDialog		"xmWarningDialog"
#define WorkingDialog		"xmWorkingDialog"

#endif /* _TM_H */
