static char sccsid[] = "@(#)func.c	1.5 10/8/92 By Ed Falk, (C) Sun Micro" ;
/**********
 *
 *
 *	 @@@@   @@@   @       @@@@  @@@@@   @@@    @@@   @
 *	@      @   @  @      @        @    @   @  @   @  @
 *	@      @@@@@  @      @        @    @   @  @   @  @
 *	@      @   @  @      @        @    @   @  @   @  @
 *	 @@@@  @   @  @@@@@   @@@@    @     @@@    @@@   @@@@@
 *
 *	CALCTOOL - HP calculator emulator
 *
 *	This is the button interpreter
 *
 *	Edward A. Falk
 *	Sun Microsystems
 *
 *	Mar, 1986
 *
 *
 **********/

#include <stdio.h>
#include <math.h>
#include <values.h>
#include <errno.h>
/****
 *
 * Constants,  typedefs, externals, globals, statics, macros
 *
 ****/


#include "calc.h"


static  double  Powrs[11][4] = {
        {      1.0,            1.0,            1.0,                1.0 },
        {      2.0,            8.0,           10.0,               16.0 },
        {      4.0,           64.0,          100.0,              256.0 },
        {      8.0,          512.0,         1000.0,             4096.0 },
        {     16.0,         4096.0,        10000.0,            65536.0 },
        {     32.0,        32768.0,       100000.0,          1048576.0 },
        {     64.0,       262144.0,      1000000.0,         16777216.0 },
        {    128.0,      2097152.0,     10000000.0,        268435456.0 },
        {    256.0,     16777216.0,    100000000.0,       4294967296.0 },
        {    512.0,    134217728.0,   1000000000.0,      68719476736.0 },
        {   1024.0,   1073741824.0,  10000000000.0,    1099511627776.0 } } ;

#define	LN10	2.302585093


extern	double	Constant ;
extern	double	Conversion ;


#define abs(x)		((x)<0?-(x):(x))


/******
 *
 * EN	- function terminates entry of a number
 *
 * NL	- "no lift" - stack lift disabled by this function
 *		by default, stack lift is enabled.
 * LF   - "lift" - stack lift enable left unchanged
 *
 * LX	- function updates Lastx
 *
 * stack is lifted by Cond_Lift if enabled
 * stack is lifted by Push_Stack unconditionally
 *
 * "stack lift" means that when the user starts to key in a new number or
 * enters one in any other way (such as recalling a register), the
 * entire stack is pushed.  (t-reg is lost).  Some operations, such as
 * "enter" or "clear-x" disable stack lift, so that new numbers destroy
 * the old contents of x-reg.
 *
 ******/


typedef	unsigned long	bool ;

#define EN	if(Display_State==KEY_IN) Add_Number()
#define	LF	new_pend = Pending_Lift
#define NL	new_pend = 0
#define	LX	Lastx = xreg


#define	Push_Stack()	( treg = zreg ,  zreg = yreg ,  yreg = xreg  )
#define	Cond_Lift()	if(Pending_Lift) Push_Stack()
#define	Drop_Stack()	( xreg=yreg , yreg=zreg , zreg=treg )
#define	Roll_Down()	( tmp=xreg, xreg=yreg, yreg=zreg, zreg=treg, treg=tmp )
#define	Roll_Up()	( tmp=treg, treg=zreg, zreg=yreg, yreg=xreg, xreg=tmp )

#define	toRAD(x)	((x)*M_PI/180.0)
#define toDEG(x)	((x)*180.0/M_PI)

#define	max(x,y)	((x)>(y)?(x):(y))


	double	toHMS(), toH(), Calc_sin(), Calc_cos(), Calc_tan(),
		Calc_asin(), Calc_acos(), Calc_atan(),
		Calc_inv(), Calc_Round(), Calc_fact(), Calc_ln(),
		Calc_log(), Calc_pow(), setbool(), Cyx(), Pyx() ;

	int	Get_Conv(), Get_Const() ;

	bool	ibool() ;




Cmd_Parse(Key_Code)
	int	Key_Code ;
{
	double	tmp ;
	int	i ;
	int	new_pend ;

	enum Trig_State_t old_trig_state = Trig_State ;
	enum Pending_Op_t old_pending_op = Pending_Op ;
	int	old_radix = radix ;
extern	int	is_small ;

	bool	M16 = 0xffff ;



	/* let's be semi-clever about this and list the keys in their
		approximate frequency */



	new_pend = 1 ;

	if (Display_State == ERROR) Display_State = XREG ;


switch(Pending_Op)
{
    case Fx:
    case Gx:	Key_Code = ((int) (Key_Code/10)) * 10 ;
		if (Pending_Op == Gx) Key_Code += 2 ;
		Pending_Op = NORM ;
    case NORM:
	switch(Key_Code)
	{

		/* middle keys */

	    case 471:	Add_Digit(0) ; break ;		/* these first 20 or */
	    case 371:	Add_Digit(1) ; break ;		/* keys are in rough */
	    case 381:	Add_Digit(2) ; break ;		/* order of frequency*/
	    case 391:	Add_Digit(3) ; break ;		/* as they are data  */
	    case 271:	Add_Digit(4) ; break ;		/* entry             */
	    case 281:	Add_Digit(5) ; break ;
	    case 291:	Add_Digit(6) ; break ;
	    case 171:	Add_Digit(7) ; break ;
	    case 181:	Add_Digit(8) ; break ;
	    case 191:	Add_Digit(9) ; break ;
	    case 111:	Add_Digit(10) ; break ;
	    case 121:	Add_Digit(11) ; break ;
	    case 131:	Add_Digit(12) ; break ;
	    case 141:	Add_Digit(13) ; break ;
	    case 151:	Add_Digit(14) ; break ;
	    case 161:	Add_Digit(15) ; break ;
	    case 481:	Add_DP() ; break ;		/* . */
	    case 361:	EN ; NL ; Push_Stack() ; break ;	/* enter */
	    case 401:	EN ; LX ; yreg += xreg ; Drop_Stack() ; break ;	/* + */
	    case 301:	EN ; LX ; yreg -= xreg ; Drop_Stack() ; break ;	/* - */
	    case 201:	EN ; LX ; yreg *= xreg ; Drop_Stack() ; break ;	/* * */
	    case 101:	EN ; LX ; yreg *= Calc_inv(xreg); Drop_Stack(); break ;
	    case 351:	if (Display_State!=KEY_IN)		/* <- */
			    {NL; xreg=0.0; Display_State=XREG; }
			else
			    Backarrow() ;
			break ;
	    case 261:	Add_Exp() ; break ;			/* EEX */
	    case 491:	if (Display_State!=KEY_IN)		/* CHS */
			    xreg = -xreg ;
			else
			    Add_Negate() ;
			break ;


	    case 211:	EN ; LX ; xreg = sqrt(xreg) ; break ;	/* sqrt */
	    case 221:	EN ; LX ; xreg = exp(xreg) ; break ;	/* e**x */
	    case 231:	EN ; LX ; xreg = exp(LN10*xreg) ; break ; /* 10**x */
	    case 241:	EN ; LX ; yreg = Calc_pow(yreg,xreg) ;	/* y**x */
			    Drop_Stack() ; break ;
	    case 251:	EN ; LX ; xreg = Calc_inv(xreg) ; break ;  /* 1/x */
	    case 321:	EN ; NL ; LX ; Sigma_Plus() ; break ;	/* 'sigma' + */
	    case 331:	EN ; Roll_Down() ; break ;		/* R v */
	    case 341:	EN ; tmp=xreg; xreg=yreg; yreg=tmp; break ; /* x<>y */
	    case 411:	LF ; Close_Calc() ; break ;		/* close */
	    case 420:
	    case 421:
	    case 422:	LF ; Pending_Op = Fx ; break ;		/* f */
	    case 430:
	    case 431:
	    case 432:	LF ; Pending_Op = Gx ; break ;		/* g */
	    case 441:	LF ; Pending_Op = STO ; break ;		/* STO */
	    case 451:	LF ; Pending_Op = RCL ; break ;		/* RCL */


		/* top keys */

	    /*
	     * The "BIN" key has been usurped to a double duty:
	     * If the whole calculator is in "little" mode (it's been
	     * brought up NOT showing all of the buttons), then BIN will
	     * expand it to full size.  (The button below it will shrink
	     * it back down.)  Else, it just sets the radix to BINary, like
	     * it used to.
	     */
	    case 110:	if( is_small )
			  { LF; get_big(); }
			else
			  { EN; radix = BIN ; }
			break;
	    case 120:	EN ; radix = OCT ; break ;		/* OCT */
	    case 130:	EN ; radix = DEC ; break ;		/* DEC */
	    case 140:	EN ; radix = HEX ; break ;		/* HEX */
	    case 150:	EN ; LX ;  yreg = setbool(ibool(yreg) & ibool(xreg)) ;
				Drop_Stack() ; break ;		/* AND */
	    case 160:	EN ; LX ;  yreg = setbool(ibool(yreg) ^ ibool(xreg)) ;
				Drop_Stack() ; break ;		/* XOR */
	    case 170:	LF ; Pending_Op = P_FIX ; break ;	/* FIX */
	    case 180:	LF ; Pending_Op = P_SCI ; break ;	/* SCI */
	    case 190:	LF ; Pending_Op = P_ENG ; break ;	/* ENG */
	    case 100:	LF ; Display_E = !Display_E ; break ;	/* "E" */
	    case 210:	EN ; get_small( ); break;		/* shrink */
	    case 240:	EN ; LX ;  xreg = setbool(ibool(xreg) << 1) ;
				break ;				/* << */
	    case 250:	EN ; LX ;  xreg = setbool(ibool(xreg) >> 1) ;
				break ;				/* >> */
	    case 260:	EN ; LX ; Calc_torect() ; break ;
	    case 270:	EN ; LX ; xreg = Calc_sin(xreg) ; break ;   /* SIN */
	    case 280:	EN ; LX ; xreg = Calc_cos(xreg) ; break ;   /* COS */
	    case 290:	EN ; LX ; xreg = Calc_tan(xreg) ; break ;   /* TAN */
	    case 200:	LF ; Pending_Op = HYP ; break ;		/* HYP */
	    case 310:	EN ; Cond_Lift() ; xreg = Conversion ; break ;
	    case 320:	for(i=2;i<=7;Memory_Regs[i++]=0.0) ;	/* clr sigma */
				xreg=yreg=zreg=treg = 0.0; break ;
	    case 330:   xreg=yreg=zreg=treg = 0.0 ; break ;	/* clr stk */
	    case 340:	LF ; EN ; for(i=0;i<=9;Memory_Regs[i++]=0.0) ; break ;
	    case 350:	LF ; sleep(2) ; break ;			/* clr prfix */
	    case 360:	EN ; LX ; treg=zreg=xreg ; xreg=yreg ;
				yreg=zreg ; break ;		/* K */
	    case 370:	EN ; LX ; yreg=Pyx(yreg,xreg) ;
			    Drop_Stack() ; break ;		/* Py,x */
	    case 380:	EN ; LX ; xreg = toHMS(xreg) ; break ;	/* ->HMS */
	    case 390:	EN ; LX ; xreg = toRAD(xreg) ; break ;	/* ->RAD */
	    case 410:	LF ; Calc_Help() ; break ;		/* close */
	    case 440:	EN ; LX ; xreg -= (int) xreg ; break ;	/* frac */
	    case 470:	EN ; LX ; xreg = Calc_fact(xreg) ; break ; /* x! */
	    case 480:	EN ; LX ; Calc_yr() ; break ;		/* y,r */
	    case 490:	EN ; Calc_LR() ; break ;		/* L.R. */
	    case 400:	EN ; Cond_Lift() ; xreg = M_PI ; break ;

		/* bottom buttons */

	    case 112:	EN ; LX ; xreg = setbool(ibool(xreg) >> 16) ;
			break ;					/* ->16 */
	    case 122:	EN ; LX ; xreg = setbool(ibool(xreg) & M16) ;
			break ; 				/* &16 */
	    case 132:	EN ; LX ; xreg = setbool((ibool(xreg)) ) ;
			break ; 				/* &32 */
	    case 142:	EN ; LX ; xreg = setbool(~ibool(xreg)) ;
			break ;					/* NOT */
	    case 152:	EN ; LX ; yreg = setbool(ibool(yreg) | ibool(xreg)) ;
				Drop_Stack() ; break ;		/* OR */
	    case 162:	EN ; LX ;  yreg = setbool(~(ibool(yreg) ^ ibool(xreg)));
				Drop_Stack() ; break ;		/* XNOR */
	    case 172:	LF ; Trig_State=DEG ; break ;		/* DEG */
	    case 182:	LF ; Trig_State=RAD ; break ;		/* RAD */
	    case 192:	LF ; Trig_State=GRD ; break ;		/* GRD */
	    case 102:	LF ; Display_0x = !Display_0x ; break ;	/* "0x" */
	    case 212:	EN ; LX ; xreg*=xreg ; break ;		/* X**2 */
	    case 222:	EN ; LX ; xreg=Calc_ln(xreg) ; break ;	/* ln */
	    case 232:	EN ; LX ; xreg=Calc_log(xreg) ; break ;	/* log */
	    case 242:	EN ; LX ; xreg*=yreg*.01 ; break ;	/* % */
	    case 252:	EN ; LX ; yreg = (xreg-yreg)*Calc_inv(yreg)*100.0 ;
			    Drop_Stack() ; break ;		/* d% */
	    case 262:	EN ; LX ; Calc_topolar() ; break ;	/* ->P */
	    case 272:	EN ; LX ; xreg = Calc_asin(xreg) ; break ; /* sin-1 */
	    case 282:	EN ; LX ; xreg = Calc_acos(xreg) ; break ; /* cos-1 */
	    case 292:	EN ; LX ; xreg = Calc_atan(xreg) ; break ; /* tan-1 */
	    case 202:	LF ; Pending_Op = HYPINV ; break ;	/* hyp-1 */
	    case 312:	EN ; Cond_Lift() ; xreg = Constant ; break ;
	    case 322:	EN ; NL ; LX ; Sigma_Minus() ; break ;	/* sigma - */
	    case 332:	EN ; Roll_Up() ; break ;		/* R ^ */
	    case 342:	EN ; LX ; xreg=Calc_Round(xreg) ; break ; /* round */
	    case 352:	NL ; xreg=0.0; Display_State=XREG; break ; /* CLX */
	    case 362:	EN ; Cond_Lift() ; xreg=Lastx ; break ;	/* last x */
	    case 372:	EN ; LX ; yreg=Cyx(yreg,xreg) ;
			    Drop_Stack() ; break ;		/* Cy,x */
	    case 382:	EN ; LX ; xreg = toH(xreg) ; break ;	/* -> H */
	    case 392:	EN ; LX ; xreg = toDEG(xreg) ; break ;	/* ->DEG */
	    case 302:	EN ; LX ; yreg = toHMS( toH(yreg) - toH(xreg) ) ;
				Drop_Stack() ; break ;		/* HMS- */
	    case 412:	LF ; Quit_Calc() ; break ;		/* close */
	    case 442:	EN ; LX ; xreg = (int) xreg ; break ;	/* INT */
	    case 472:	EN ; Average() ; break ;		/* average */
	    case 482:	EN ; Std_Dev() ; break ;		/* std dev */
	    case 492:	EN ; LX ; xreg=fabs(xreg) ; break ;	/* ABS */
	    case 402:	EN ; LX ; yreg = toHMS( toH(yreg) + toH(xreg) ) ;
				Drop_Stack() ; break ;		/* HMS- */

	    default:	LF ;
	} break ;


    case RCL:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Cond_Lift() ; xreg=Memory_Regs[0] ; break ;
	    case 37:	EN ; Cond_Lift() ; xreg=Memory_Regs[1] ; break ;
	    case 38:	EN ; Cond_Lift() ; xreg=Memory_Regs[2] ; break ;
	    case 39:	EN ; Cond_Lift() ; xreg=Memory_Regs[3] ; break ;
	    case 27:	EN ; Cond_Lift() ; xreg=Memory_Regs[4] ; break ;
	    case 28:	EN ; Cond_Lift() ; xreg=Memory_Regs[5] ; break ;
	    case 29:	EN ; Cond_Lift() ; xreg=Memory_Regs[6] ; break ;
	    case 17:	EN ; Cond_Lift() ; xreg=Memory_Regs[7] ; break ;
	    case 18:	EN ; Cond_Lift() ; xreg=Memory_Regs[8] ; break ;
	    case 19:	EN ; Cond_Lift() ; xreg=Memory_Regs[9] ; break ;
	    case 42:	LF ; Pending_Op = Fx ; break ;
	    case 43:	LF ; Pending_Op = Gx ; break ;
	    default:	LF ;
	} break ;

    case STO:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Memory_Regs[0] = xreg ; break ;
	    case 37:	EN ; Memory_Regs[1] = xreg ; break ;
	    case 38:	EN ; Memory_Regs[2] = xreg ; break ;
	    case 39:	EN ; Memory_Regs[3] = xreg ; break ;
	    case 27:	EN ; Memory_Regs[4] = xreg ; break ;
	    case 28:	EN ; Memory_Regs[5] = xreg ; break ;
	    case 29:	EN ; Memory_Regs[6] = xreg ; break ;
	    case 17:	EN ; Memory_Regs[7] = xreg ; break ;
	    case 18:	EN ; Memory_Regs[8] = xreg ; break ;
	    case 19:	EN ; Memory_Regs[9] = xreg ; break ;
	    case 40:	Pending_Op = STOa ; break ;
	    case 30:	Pending_Op = STOs ; break ;
	    case 20:	Pending_Op = STOx ; break ;
	    case 10:	Pending_Op = STOd ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	}
	    break ;

    case STOa:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Memory_Regs[0] += xreg ; break ;
	    case 37:	EN ; Memory_Regs[1] += xreg ; break ;
	    case 38:	EN ; Memory_Regs[2] += xreg ; break ;
	    case 39:	EN ; Memory_Regs[3] += xreg ; break ;
	    case 27:	EN ; Memory_Regs[4] += xreg ; break ;
	    case 28:	EN ; Memory_Regs[5] += xreg ; break ;
	    case 29:	EN ; Memory_Regs[6] += xreg ; break ;
	    case 17:	EN ; Memory_Regs[7] += xreg ; break ;
	    case 18:	EN ; Memory_Regs[8] += xreg ; break ;
	    case 19:	EN ; Memory_Regs[9] += xreg ; break ;
	    case 40:	Pending_Op = STOa ; break ;
	    case 30:	Pending_Op = STOs ; break ;
	    case 20:	Pending_Op = STOx ; break ;
	    case 10:	Pending_Op = STOd ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	}
	    break ;

    case STOs:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Memory_Regs[0] -= xreg ; break ;
	    case 37:	EN ; Memory_Regs[1] -= xreg ; break ;
	    case 38:	EN ; Memory_Regs[2] -= xreg ; break ;
	    case 39:	EN ; Memory_Regs[3] -= xreg ; break ;
	    case 27:	EN ; Memory_Regs[4] -= xreg ; break ;
	    case 28:	EN ; Memory_Regs[5] -= xreg ; break ;
	    case 29:	EN ; Memory_Regs[6] -= xreg ; break ;
	    case 17:	EN ; Memory_Regs[7] -= xreg ; break ;
	    case 18:	EN ; Memory_Regs[8] -= xreg ; break ;
	    case 19:	EN ; Memory_Regs[9] -= xreg ; break ;
	    case 25:	EN ; Memory_Reg_I -= xreg ; break ;
	    case 40:	Pending_Op = STOa ; break ;
	    case 30:	Pending_Op = STOs ; break ;
	    case 20:	Pending_Op = STOx ; break ;
	    case 10:	Pending_Op = STOd ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	}
	    break ;

    case STOx:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Memory_Regs[0] *= xreg ; break ;
	    case 37:	EN ; Memory_Regs[1] *= xreg ; break ;
	    case 38:	EN ; Memory_Regs[2] *= xreg ; break ;
	    case 39:	EN ; Memory_Regs[3] *= xreg ; break ;
	    case 27:	EN ; Memory_Regs[4] *= xreg ; break ;
	    case 28:	EN ; Memory_Regs[5] *= xreg ; break ;
	    case 29:	EN ; Memory_Regs[6] *= xreg ; break ;
	    case 17:	EN ; Memory_Regs[7] *= xreg ; break ;
	    case 18:	EN ; Memory_Regs[8] *= xreg ; break ;
	    case 19:	EN ; Memory_Regs[9] *= xreg ; break ;
	    case 25:	EN ; Memory_Reg_I *= xreg ; break ;
	    case 40:	Pending_Op = STOa ; break ;
	    case 30:	Pending_Op = STOs ; break ;
	    case 20:	Pending_Op = STOx ; break ;
	    case 10:	Pending_Op = STOd ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	}
	    break ;

    case STOd:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Memory_Regs[0] *= Calc_inv(xreg) ; break ;
	    case 37:	EN ; Memory_Regs[1] *= Calc_inv(xreg) ; break ;
	    case 38:	EN ; Memory_Regs[2] *= Calc_inv(xreg) ; break ;
	    case 39:	EN ; Memory_Regs[3] *= Calc_inv(xreg) ; break ;
	    case 27:	EN ; Memory_Regs[4] *= Calc_inv(xreg) ; break ;
	    case 28:	EN ; Memory_Regs[5] *= Calc_inv(xreg) ; break ;
	    case 29:	EN ; Memory_Regs[6] *= Calc_inv(xreg) ; break ;
	    case 17:	EN ; Memory_Regs[7] *= Calc_inv(xreg) ; break ;
	    case 18:	EN ; Memory_Regs[8] *= Calc_inv(xreg) ; break ;
	    case 19:	EN ; Memory_Regs[9] *= Calc_inv(xreg) ; break ;
	    case 25:	EN ; Memory_Reg_I *= Calc_inv(xreg) ; break ;
	    case 40:	Pending_Op = STOa ; break ;
	    case 30:	Pending_Op = STOs ; break ;
	    case 20:	Pending_Op = STOx ; break ;
	    case 10:	Pending_Op = STOd ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	} break ;

    case P_FIX:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Display_Type = FIX ; Display_Digits=0 ; break ;
	    case 37:	EN ; Display_Type = FIX ; Display_Digits=1 ; break ;
	    case 38:	EN ; Display_Type = FIX ; Display_Digits=2 ; break ;
	    case 39:	EN ; Display_Type = FIX ; Display_Digits=3 ; break ;
	    case 27:	EN ; Display_Type = FIX ; Display_Digits=4 ; break ;
	    case 28:	EN ; Display_Type = FIX ; Display_Digits=5 ; break ;
	    case 29:	EN ; Display_Type = FIX ; Display_Digits=6 ; break ;
	    case 17:	EN ; Display_Type = FIX ; Display_Digits=7 ; break ;
	    case 18:	EN ; Display_Type = FIX ; Display_Digits=8 ; break ;
	    case 19:	EN ; Display_Type = FIX ; Display_Digits=9 ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	} LF ; break ;

    case P_SCI:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Display_Type = SCI ; Display_Digits=0 ; break ;
	    case 37:	EN ; Display_Type = SCI ; Display_Digits=1 ; break ;
	    case 38:	EN ; Display_Type = SCI ; Display_Digits=2 ; break ;
	    case 39:	EN ; Display_Type = SCI ; Display_Digits=3 ; break ;
	    case 27:	EN ; Display_Type = SCI ; Display_Digits=4 ; break ;
	    case 28:	EN ; Display_Type = SCI ; Display_Digits=5 ; break ;
	    case 29:	EN ; Display_Type = SCI ; Display_Digits=6 ; break ;
	    case 17:	EN ; Display_Type = SCI ; Display_Digits=7 ; break ;
	    case 18:	EN ; Display_Type = SCI ; Display_Digits=8 ; break ;
	    case 19:	EN ; Display_Type = SCI ; Display_Digits=9 ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	} LF ; break ;

    case P_ENG:
	Pending_Op = NORM ;
    	Key_Code /= 10 ;
	switch(Key_Code)
	{
	    case 47:	EN ; Display_Type = ENG ; Display_Digits=0 ; break ;
	    case 37:	EN ; Display_Type = ENG ; Display_Digits=1 ; break ;
	    case 38:	EN ; Display_Type = ENG ; Display_Digits=2 ; break ;
	    case 39:	EN ; Display_Type = ENG ; Display_Digits=3 ; break ;
	    case 27:	EN ; Display_Type = ENG ; Display_Digits=4 ; break ;
	    case 28:	EN ; Display_Type = ENG ; Display_Digits=5 ; break ;
	    case 29:	EN ; Display_Type = ENG ; Display_Digits=6 ; break ;
	    case 17:	EN ; Display_Type = ENG ; Display_Digits=7 ; break ;
	    case 18:	EN ; Display_Type = ENG ; Display_Digits=8 ; break ;
	    case 19:	EN ; Display_Type = ENG ; Display_Digits=9 ; break ;
	    case 42:	Pending_Op = Fx ; break ;
	    case 43:	Pending_Op = Gx ; break ;
	    default: ;
	} LF ; break ;

    default:
	Pending_Op = NORM ;
}


	if(isinf(xreg) || isnan(xreg))
	{
	    xreg = 0.0 ;
	    Display_State = ERROR ;
	}

	Pending_Lift = new_pend ;

	if( old_trig_state != Trig_State  ||
	    old_pending_op != Pending_Op  ||
	    old_radix != radix ) 
	    Update_Anns() ;
}




	/* various calculator function */




Sigma_Plus()
{
	Memory_Regs[2]++ ;
	Memory_Regs[3] += xreg ;
	Memory_Regs[4] += xreg*xreg ;
	Memory_Regs[5] += yreg ;
	Memory_Regs[6] += yreg*yreg ;
	Memory_Regs[7] += xreg*yreg ;

	Drop_Stack() ;
	xreg = Memory_Regs[2] ;
}



Sigma_Minus()
{
	Memory_Regs[2]-- ;
	Memory_Regs[3] -= xreg ;
	Memory_Regs[4] -= xreg*xreg ;
	Memory_Regs[5] -= yreg ;
	Memory_Regs[6] -= yreg*yreg ;
	Memory_Regs[7] -= xreg*yreg ;

	Drop_Stack() ;
	xreg = Memory_Regs[2] ;
}



Average()
{
	double	t ;

/*	if(Memory_Regs[2]==0.0)
	{
	    Display_State = ERROR ;
	    xreg = 0.0 ;
	}
	else */
	{
	    if (Pending_Lift) { treg = yreg ; zreg = xreg ; }
	    else	      { treg = zreg ; zreg = yreg ; }

	    t = 1/Memory_Regs[2] ;

	    xreg = Memory_Regs[3]*t ;
	    yreg = Memory_Regs[5]*t ;
	}
}



Std_Dev()
{
	double	t ;

	if(Memory_Regs[2]<=1.0)
	{
	    Display_State = ERROR ;
	    xreg = 0.0 ;
	}
	else
	{
	    if (Pending_Lift) { treg = yreg ; zreg = xreg ; }
	    else	      { treg = zreg ; zreg = yreg ; }

	    t = 1.0/(Memory_Regs[2]*(Memory_Regs[2]-1)) ;

	    xreg = sqrt
		((Memory_Regs[2]*Memory_Regs[4]-Memory_Regs[3]*Memory_Regs[3])
		* t ) ;
	    yreg = sqrt
		((Memory_Regs[2]*Memory_Regs[6]-Memory_Regs[5]*Memory_Regs[5])
		* t ) ;
	}
}



Calc_yr()
{
	double	M, N, P, x ;

	if(Memory_Regs[2]<=1.0)
	{
	    Display_State = ERROR ;
	    xreg = 0.0 ;
	}
	else
	{
	    if (Pending_Lift) { treg = yreg ; zreg = xreg ; }
	    else	      { treg = zreg ; zreg = yreg ; }

	    x = xreg ;
	    M = Memory_Regs[2]*Memory_Regs[4] - Memory_Regs[3]*Memory_Regs[3] ;
	    N = Memory_Regs[2]*Memory_Regs[6] - Memory_Regs[5]*Memory_Regs[5] ;
	    P = Memory_Regs[2]*Memory_Regs[7] - Memory_Regs[3]*Memory_Regs[5] ;
	    yreg = P / sqrt ( M*N ) ;
	    xreg = ( M*Memory_Regs[5] + P*(Memory_Regs[2]*x - Memory_Regs[3]) )
		/ (M*Memory_Regs[2]) ;
	}
}



Calc_LR()
{
	double	t, M, P ;

	if(Memory_Regs[2]<=1.0)
	{
	    Display_State = ERROR ;
	    xreg = 0.0 ;
	}
	else
	{
	  if (Pending_Lift) { treg = yreg ; zreg = xreg ; }
	  else		    { treg = zreg ; zreg = yreg ; }

	  t = 1/(Memory_Regs[2]*(Memory_Regs[2]-1)) ;

	  M = Memory_Regs[2]*Memory_Regs[4] - Memory_Regs[3]*Memory_Regs[3] ;

	  P = Memory_Regs[2]*Memory_Regs[7] - Memory_Regs[3]*Memory_Regs[5] ;

	  yreg = P/M ;

	  xreg = (M*Memory_Regs[5] - P*Memory_Regs[3]) / (Memory_Regs[2]*M) ;
	}
}



double
ifact(x)
	double	x ;
{
	double	a ;
	int	i ;

	i = x ;
	a=1.0 ;
	while((i > 0) && (a!=HUGE)) a *= (float) i-- ;
	return a ;
}



double
Calc_fact(x)
	double	x ;
{
	double	a ;
	extern	int signgam ;
	extern int errno; 

	if (x==(int)x)
	    a = ifact(x) ;
	else
	{
/* Bug fix in gamma function call.
 * Andrew C. Pineda , 4 April 1991
 *	    a = gamma(x+1) ;
 */
	    a = lgamma(x+1.e0) ;
/* Bug fix ACP
*	    if (a>706.0) 
*/
	    if (a> LN_MAXDOUBLE || errno == EDOM) {
		Display_State = ERROR ;
		a = 0.0 ;
	    }
	    else {
		a=(signgam>0)?(exp(a)):(-exp(a));
	    }
	}

	return ( a ) ;
	    
}




double
Cyx(y,x)
	double	x,y ;
{
	return ifact(y)/(ifact(y-x)*ifact(x)) ;
}



double
Pyx(y,x)
	double	x,y ;
{
	return ifact(y)/ifact(y-x) ;
}



double
toHMS(x)
	double	x ;
{
	int	h,m,s ;

	h = (int) (x += .00005 ) ;
	m = (int) (x = (x-h)*60 ) ;
	s = (int) ((x-m)*60) ;

	return(h + m/100.0 + s/10000.0) ;
}


double
toH(x)
	double	x ;
{
	int	h,m,s ;

	h = (int) (x += .00005 ) ;
	m = (int) (x= (x-h)*100 ) ;
	s = (int) ((x-m)*100) ;

	return ( h + m/60.0 + s/3600.0 ) ;
}





double
Calc_sin(x)
	double	x ;
{
	if (Trig_State==DEG) x*=M_PI/180.0 ;
	else if (Trig_State==GRD) x*=M_PI/200.0 ;

	return(sin(x)) ;
}



double
Calc_cos(x)
	double	x ;
{
	if (Trig_State==DEG) x*=M_PI/180.0 ;
	else if (Trig_State==GRD) x*=M_PI/200.0 ;

	return(cos(x)) ;
}



double
Calc_tan(x)
	double	x ;
{
	double	c ;
	if (Trig_State==DEG) x*=M_PI/180.0 ;
	else if (Trig_State==GRD) x*=M_PI/200.0 ;

	c = cos(x) ;
/*	if(fabs(c)<0.0000000001)
	{
	    Display_State = ERROR ;
	    c = 0.0 ;
	}
	else */
	    c = sin(x)/c ;

	return(c) ;
}



double
Calc_asin(x)
	double	x ;
{
	double	t ;

	t = asin(x) ;
	if(Trig_State==DEG) t*=180.0/M_PI ;
	else if (Trig_State==GRD) t*=200.0/M_PI ;

	return(t) ;
}



double
Calc_acos(x)
	double	x ;
{
	double	t ;

	t = acos(x) ;
	if(Trig_State==DEG) t*=180.0/M_PI ;
	else if (Trig_State==GRD) t*=200.0/M_PI ;

	return(t) ;
}



double
Calc_atan(x)
	double	x ;
{
	double	t ;
	t = atan(x) ;
	if(Trig_State==DEG) t*=180.0/M_PI ;
	else if (Trig_State==GRD) t*=200.0/M_PI ;
	return(t) ;
}



double
Calc_inv(x)
	double	x ;
{
	double	t ;

	t = 1.0/x ;
	if (isinf(t)) {
	    Display_State = ERROR ;
	    t = 0.0 ;
	}

	return(t) ;
}



double
Calc_Round(x)
	double	x ;
{
/* Bug Fix by ACP.
 * Used to cast to int which dies for big numbers. 
 * Better to use anint function call. */
	return( anint(x*Powrs[Display_Digits][radix]) /
	    Powrs[Display_Digits][radix] ) ;
}



Calc_torect()
{
	double	x, y ;

	x=Calc_cos(yreg) * xreg ;
	y=Calc_sin(yreg) * xreg ;
	xreg = x ;
	yreg = y ;
}



Calc_topolar()
{
	double	r,t ;

	r=hypot(xreg,yreg) ;
	t=atan2(yreg,xreg) ;
	if(Trig_State==DEG) t*=180.0/M_PI ;
	else if (Trig_State==GRD) t*=200.0/M_PI ;

	xreg = r ;
	yreg = t ;
}



double
Calc_ln(x)
	double	x ;
{
	if(x > 0.0)
	  return(log(x)) ;
	else
	{
	  Display_State = ERROR ;
	  return(0.0) ;
	}
}



double
Calc_log(x)
	double	x ;
{
	if(x > 0.0)
	  return(log10(x)) ;
	else
	{
	  Display_State = ERROR ;
	  return(0.0) ;
	}
}



double
Calc_pow(y,x)
	double	x,y ;
{
	if(y>0 || (x == ((int) x)))
	  return(pow(y,x)) ;
	else
	{
	  Display_State = ERROR ;
	  return(0.0) ;
	}
}



bool
ibool(x)
	double	x ;
{
	bool	p ;

	if(x > 68719476736.00)
	  return(0) ;
	else if (x < -68719476736.00)
	  return(0) ;

	else
	{
	  while(x < 0.0)
	    x += 4294967296.00 ;
	  while(x > 4294967296.00)
	    x -= 4294967296.00 ;

	  p = x ;
	  return(p) ;
	}
}
	



double
setbool(p)
	bool	p ;
{
	bool	q ;
	double	rval ;

	q = p & 0x80000000 ;

	p &= 0x7fffffff ;

	rval = p ;
	if(q) rval += 2147483648.0 ;
	return rval;
}
