/*
 * This is just a test.
 * You can use this program as an external menu for the netserv
 *
 * Call: netserv -exmenu xmserv
 * with 'xmserv' = pathname of this program
 */

#include <stdio.h>
#include <unistd.h>

#include <X11/Intrinsic.h>

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/FormP.h>
#include <Xm/FileSB.h>
#include <Xm/ToggleB.h>
#include <Xm/Scale.h>

enum { MENU_NOP , MENU_LOADMAZE , MENU_RUNGAME , MENU_STOPGAME , MENU_LIST , 
       MENU_DISCONNECT , MENU_SETMODE , MENU_SETDIVIDER , MENU_ERROR ,
       MENU_RUNTEAMGAME , MENU_SETTEAMS };

String resources[] = {
  "*titlelabel.labelString: Netservcontrol",
  "*pushquit.labelString: Quit Prorgamm",
  "*pushrun.labelString: Run Game",
  "*pushrun1.labelString: Run Game with Teams",
  "*pushstop.labelString: Stop Game",
  "*pushlist.labelString: List Connections",
  "*pushteam.labelString: Select Teams",
  "*tok.labelString: Ok",
  "*tcancel.labelString: 	Cancel",
  "*tscale.minimum:	1",
  "*tscale.maximum:	16",
  "*tscale.showValue:	True",
  "*tscale.orientation:	Horizontal",
 NULL
};

void ButtonCB(Widget w,XtPointer p1,XtPointer p2);
void InputHandler(XtPointer c,int *s,XtInputId *id);
void SetTeamValues(void),GetTeamValues(void);
Widget CreateTeamDialog(Widget parent);

XtAppContext app_con;
Widget teamdialog,teams[32];
int teamnr[32] = { 0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7} ;

void main(int argc,char **argv)
{
  Widget top,vrow,form,tmp,quit,run,run1,stop,list,team;
  Arg args[2];

  top = XtAppInitialize(&app_con, "Netserv", NULL, 0,
                        &argc, argv, resources, NULL, 0);

  teamdialog = CreateTeamDialog(top);

  form = XtCreateManagedWidget("form",xmFormWidgetClass,top,NULL,0);

  vrow = XtCreateManagedWidget("vrow",xmRowColumnWidgetClass,form,NULL,0);

  XtCreateManagedWidget("titlelabel",xmLabelWidgetClass,vrow,NULL,0);  

  XtCreateManagedWidget("a_separator",xmSeparatorWidgetClass,vrow,NULL,0);

  stop = XtCreateManagedWidget("pushstop",xmPushButtonWidgetClass,vrow,NULL,0);
  run = XtCreateManagedWidget("pushrun",xmPushButtonWidgetClass,vrow,NULL,0);
  run1 = XtCreateManagedWidget("pushrun1",xmPushButtonWidgetClass,vrow,NULL,0);
  list = XtCreateManagedWidget("pushlist",xmPushButtonWidgetClass,vrow,NULL,0);
  team = XtCreateManagedWidget("pushteam",xmPushButtonWidgetClass,vrow,NULL,0);

  XtCreateManagedWidget("a_separator",xmSeparatorWidgetClass,vrow,NULL,0);

  XtSetArg(args[0],XtNorientation,XmHORIZONTAL);
  tmp = XtCreateManagedWidget("a_row",xmRowColumnWidgetClass,vrow,args,1);
  quit = XtCreateManagedWidget("pushquit",xmPushButtonWidgetClass,tmp,NULL,0);

  XtAddCallback(run, XmNactivateCallback, ButtonCB,(XtPointer) 1);
  XtAddCallback(run1, XmNactivateCallback, ButtonCB,(XtPointer) 5);
  XtAddCallback(quit, XmNactivateCallback, ButtonCB,(XtPointer) 0);
  XtAddCallback(stop, XmNactivateCallback, ButtonCB,(XtPointer) 2);
  XtAddCallback(list, XmNactivateCallback, ButtonCB,(XtPointer) 3);
  XtAddCallback(team, XmNactivateCallback, ButtonCB,(XtPointer) 4);

  XtAppAddInput(app_con,0,(XtPointer)XtInputReadMask,InputHandler,(XtPointer)0);

  XtRealizeWidget(top);
  XtAppMainLoop(app_con);
}

void ButtonCB(Widget w,XtPointer p1,XtPointer p2)
{
  char buf[64];
  int i;

  switch( (int) p1)
  {
    case 0:
      XtDestroyApplicationContext(app_con);
      exit(0);
      break;
    case 1:
      buf[0] = MENU_RUNGAME;
      fwrite(buf,1,1,stdout);
      fflush(stdout);
      break;
    case 2:
      buf[0] = MENU_STOPGAME;
      fwrite(buf,1,1,stdout);
      fflush(stdout);
      break;
    case 3:
      buf[0] = MENU_LIST;
      fwrite(buf,1,1,stdout);
      fflush(stdout);
      break;
    case 4:
      XtManageChild(teamdialog);
      break;
    case 5:
      buf[0] = MENU_SETTEAMS;
      for(i=0;i<32;i++)
        buf[i+1] = (char) teamnr[i];
      fwrite(buf,33,1,stdout);
      fflush(stdout);
      buf[0] = MENU_RUNTEAMGAME;
      fwrite(buf,1,1,stdout);
      fflush(stdout);
      break;
    case 6:
      GetTeamValues();
      XtUnmanageChild(teamdialog);
      break;
    case 7:
      SetTeamValues();
      XtUnmanageChild(teamdialog);
      break;
  }
}

void InputHandler(XtPointer c,int *s,XtInputId *id)
{
  char buf[1024];
  int i;
  memset(buf,0,1024);
  i = read(*s,buf,1024);
  fprintf(stderr,"%d:%s\n",i,buf);
  if(i == 0) 
  {
    XtDestroyApplicationContext(app_con);
    exit(0);
  }
}

Widget CreateTeamDialog(Widget parent)
{
  Widget t,r,rb,r1,t1;
  int i,j,k;
  Arg args[4];
  char *labels[] = { "Players 1 to 8" , "Players 9 to 15" , 
                     "Players 16 to 24" , "Players 25 to 32" };

  t = XmCreateFormDialog(parent,"TeamSelection",NULL,0);
  r = XtCreateManagedWidget("a_row",xmRowColumnWidgetClass,t,NULL,0);
  XtSetArg(args[0],XmNlabelString,XmStringCreateSimple("Please select the teams:"));
  XtCreateManagedWidget("a_label",xmLabelWidgetClass,r,args,1);
  XtCreateManagedWidget("a_separator",xmSeparatorWidgetClass,r,NULL,0);

  XtSetArg(args[0],XmNorientation,XmHORIZONTAL);
  r1 = XtCreateManagedWidget("a_row",xmRowColumnWidgetClass,r,args,1);

  for(k=0,j=0;j<4;j++)
  {
    rb = XtCreateManagedWidget("a_row",xmRowColumnWidgetClass,r1,NULL,0);
    XtSetArg(args[0],XmNlabelString,XmStringCreateSimple(labels[j]));
    XtCreateManagedWidget("alabel",xmLabelWidgetClass,rb,args,1);
    for(i=0;i<8;i++,k++)
    {
      teams[k] = XtCreateManagedWidget("tscale",xmScaleWidgetClass,rb,NULL,0);
    }
  }

  XtCreateManagedWidget("a_separator",xmSeparatorWidgetClass,r,NULL,0);
  XtSetArg(args[0],XmNorientation,XmHORIZONTAL);
  r1 = XtCreateManagedWidget("a_row",xmRowColumnWidgetClass,r,args,1);
  t1 = XtCreateManagedWidget("tok",xmPushButtonWidgetClass,r1,NULL,0);
  XtAddCallback(t1, XmNactivateCallback, ButtonCB,(XtPointer) 6);
  t1 = XtCreateManagedWidget("tcancel",xmPushButtonWidgetClass,r1,NULL,0);
  XtAddCallback(t1, XmNactivateCallback, ButtonCB,(XtPointer) 7);

  SetTeamValues();

  return t;
}

void SetTeamValues(void)
{
  int i;

  for(i=0;i<32;i++)
    XmScaleSetValue(teams[i],teamnr[i]+1);
}

void GetTeamValues(void)
{
  int i;

  for(i=0;i<32;i++)
  {
    XmScaleGetValue(teams[i],&teamnr[i]);
    teamnr[i]--;
  }
}

