/* This is a demonstration on how to write robots.
 * This is the basecode.
 * Write your own: own_action()/init_robot() - functions (see dummy.c)
 * and compile the whole stuff with robot.o and allmove.o!
 */

#include "netmaze.h"

#include <sys/types.h>

#ifdef RS6000
 #include <sys/select.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <memory.h>

#include "network.h"

#include "trigtab.h"

#define TRUE  1
#define FALSE 0

struct shared_struct shstr;
struct shared_struct *sm = &shstr;

void io_handler();
void work_input(char *buf,int len);
void send_owndata(void);
void send_ownname(void);
void send_ownready(void);
void send_owncomment(void);
void send_ident(void);
void send_end(void);

/* extern: allmove.c */
extern void move_all(PLAYER*,int*);
extern void run_game(MAZE*,PLAYER*);
extern void myrandominit(long);

/* extern: user-defined-functions */
extern int own_action(void);
extern void start_robot(void);
extern int init_robot(void);

static int own_socket;         /* streams socket descriptor */
static int ownnumber;

#ifdef HAVE_FDSET
struct fd_set readmask;
#else
struct fd_mask readmask;
#endif

static struct hostent *hp;            /* pointer to host info for remote host */
static struct sockaddr_in remoteaddr; /* server connect */

int main(int argc,char **argv)
{
  int  ret;
  char hostname[256];

#ifdef USE_SIGVEC
  struct sigvec vec;
#else
  struct sigaction vec;
#endif

  if(argc != 2)
  {
    fprintf(stderr,"%s: usage: %s <serverhostname>\n",argv[0],argv[0]);
    exit(1);
  }
  strcpy(hostname,argv[1]);

  if(!init_robot())
  {
    fprintf(stderr,"%s: Can't initialize the robot.\n",argv[0]);
    exit(1);
  }

#ifdef USE_SIGVEC
  vec.sv_handler = (void (*)) io_handler;
  vec.sv_mask = 0;
  vec.sv_flags = 0;
  if ( sigvector(SIGIO, &vec, (struct sigvec *) 0) == -1)
    perror(" sigaction(SIGIO)");
#else
  vec.sa_handler = (void (*)) io_handler; 
 #ifdef RS6000 /* ibm rs/6000 */
   sigemptyset(&vec.sa_mask);
 #else
  vec.sa_mask = 0;
 #endif
  vec.sa_flags = 0;
  if ( sigaction(SIGIO, &vec, (struct sigaction *) 0) == -1)
    perror(" sigaction(SIGIO)"); 
#endif
  remoteaddr.sin_family = AF_INET;

  sm->sologame = FALSE;
  sm->winneranz = WINNERANZ;


  if ((hp = gethostbyname(hostname) ) == NULL)
  {
    fprintf(stderr, "netmaze: %s not found in /etc/hosts\n",hostname); exit(1);
  }

  remoteaddr.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;

  if((own_socket = socket(AF_INET, SOCK_STREAM, 0)) == -1)
  {
    fprintf(stderr, "netmaze: unable to create socket\n"); exit(1);
  }

  remoteaddr.sin_port = htons(NETMAZEPORT);
  FD_ZERO(&readmask);
  FD_SET(own_socket,&readmask);

  if ( (ret=connect(own_socket,(struct sockaddr *) &remoteaddr, sizeof(struct sockaddr))) == -1) 
  {
     perror("connect"); exit(1);
  }

  send_ident();
  send_ownname();
  send_owncomment();
  printf("Connectet to %s. Connectcode: %d.\n",hostname,ret);

  for(;;) io_handler();
}

void io_handler(int a)
{
  int	numfds;
  static char	buf[256];
  int	count,len;
  static int frag=0,fraglen;

#ifdef HAVE_FDSET
  struct fd_set readmask1;
#else
  struct fd_mask readmask1;
#endif

  for(;;)
  {
    readmask1 = readmask;

    if((numfds = select(32,&readmask1,NULL,NULL,NULL))< 0) 
      continue;

    if(numfds == 0) break;

    if(FD_ISSET(own_socket,&readmask1))
    {
      if(frag > 0)
      {
        if((count = recv(own_socket,buf+fraglen,frag,0)) != frag)
	{
	  fprintf(stderr,"Major protocoll-error: %d!!\n",buf[0]);
	  return;
	}
	fprintf(stderr,"Tried to handle fragmentation\n");
	work_input(buf,fraglen+frag);
	frag = 0;
	continue;
      }
      else if( (count = recv(own_socket,buf,1,0)) != 1) /* nicht optimal */
      {
        if(count == 0)
        {
          fprintf(stderr,"I've lost the Server-Connection\n");
          exit(3);
        }
        fprintf(stderr,"IO: error reading ident\n"); return;
      }
      if((len = (int) nm_field[(int) *buf]) > 0)
      {
        if(len > 1)
        {
          count = recv(own_socket,buf+1,len-1,0);
          if(count != len-1)
          {
            fprintf(stderr,"IO: wrong length: %d %d\n",len-1,count);
            if(count >= 0)
            {
              frag = len - 2 - count;
              fraglen = count + 2;
              continue;
            }
          }
        } 
        work_input(buf,len);
      }
      else
      {
        if((count = recv(own_socket,buf+1,1,0)) != 1) /* nicht optimal */
        {
          fprintf(stderr,"IO: error reading blklen\n");  return;
        }
        len = (int) buf[1];
        if(len > 2)
        {
          if((count = recv(own_socket,buf+2,len-2,0)) != (len-2) )
          {
            fprintf(stderr,"IO-1: wrong length - possibly fragmented %d %d %d %d\n",len-2,count,(int) buf[0],(int) buf[1]); 
            if(count >= 0)
	    { 
	      frag = len - 2 - count;
              fraglen = count + 2;
	      continue;
            }
	  }
        }
        work_input(buf,len);
      }
    }
  }
}

void work_input(char *buf,int len)
{
  char data = NM_PONG;
  int (*hfeld)[MAZEDIMENSION],(*vfeld)[MAZEDIMENSION];
  int i,j;
  long randbase;

  switch(*buf)
  {
    case NM_STARTGAME:
        sm->anzplayers = (int) buf[2];
        ownnumber = sm->shownumber = sm->shownumbertmp = (int) buf[3];
        sm->numteams = (int) buf[6];
        for(i=0;i<sm->anzplayers;i++)
        {
          sm->playfeld[i].team = buf[16+i];
        }
        randbase = (long) (unsigned char) buf[5];
        randbase += ((long) (unsigned char) buf[4]) << 8;
        myrandominit(randbase);
        nm_field[NM_ALLDATA] = (char) sm->anzplayers + 1;
        sm->gamemode = (int) buf[7];
        sm->gamemode += ((int) buf[8])<<8;
        sm->config.divider = (int) buf[9];
        run_game(&(sm->std_maze),sm->playfeld);
        start_robot(); 
        send_ownready();
        sm->gameflag = TRUE;
        break;
    case NM_STOPGAME:
        sm->gameflag = FALSE;
	break;
    case NM_PAUSEGAME:
	break;
    case NM_MAZEH: 
        hfeld = sm->std_maze.hwalls;
        sm->std_maze.xdim = (int) buf[2];
        i = (int) buf[3];
        for(j=0;j<sm->std_maze.xdim;j++)
        {
          hfeld[i][j] = (int) buf[j+4];
        }
        break;
    case NM_MAZEV:
        vfeld = sm->std_maze.vwalls;
        sm->std_maze.ydim = (int) buf[2];
        i = (int) buf[3];
        for(j=0;j<sm->std_maze.ydim;j++)
        {
          vfeld[j][i] = (int) buf[j+4];
        }
        break;
    case NM_ALLDATA:
        for(i=0;i<sm->anzplayers;i++)
          sm->sticks[i] = (int) buf[i+1];
        move_all(sm->playfeld,sm->sticks); 
        sm->ownstick = own_action(); 
        if(sm->gameflag)
          send_owndata();
        else 
          send_end();
	break;
    case NM_OWNDATA:
	break;
    case NM_MESSAGE:
        fprintf(stderr,"MASTER-MESSAGE: %s\n",&(buf[2]));
	break;
    case NM_INFO:
	break;
    case NM_TIMEERROR:
	break;
    case NM_OWNNAME:
	break; 
    case NM_ALLNAMES:
        strncpy(sm->playfeld[(int) (unsigned char) buf[2]].name,buf+3,buf[1]-3);
        sm->playfeld[(int)(unsigned char)buf[2]].name[(int)(unsigned char)buf[1]-3] = 0;
	break; 
    case NM_PING:
        send(own_socket,&data,1,0);
	break; 
    case NM_PONG:
	break;
    case NM_QUIT:
	break;
    case NM_READY:
	break;
    case NM_RANDOM:
        break;
    case NM_OWNCOMMENT:
        break;
    case NM_ALLCOMMENTS:
        strncpy(sm->playfeld[(int) (unsigned char) buf[2]].comment,buf+3,buf[1]-3);
        sm->playfeld[(int)(unsigned char)buf[2]].comment[(int)(unsigned char)buf[1]-3] = 0;
        break;
  }
}


void send_owndata(void)
{
  char data[2];
  data[0] = NM_OWNDATA;
  data[1] = (char) sm->ownstick;

  send(own_socket,data,2,0);
}

void send_ownready(void)
{
  char data = NM_READY;
  send(own_socket,&data,1,0);
}

void send_owncomment(void)
{
  char buf[100];

  buf[0] = NM_OWNCOMMENT;
  buf[1] = strlen(sm->owncomment)+2;
  strcpy(buf+2,sm->owncomment);
  send(own_socket,buf,buf[1],0); 
}

void send_ownname(void)
{
  char buf[100];

  buf[0] = NM_OWNNAME;
  buf[1] = strlen(sm->ownname)+2;
  strcpy(buf+2,sm->ownname);
  send(own_socket,buf,buf[1],0); 
}

void send_ident(void)
{
  char buf[10];

  buf[0] = NM_SETMODE;
  buf[1] = (char) ((PLAYERMAGIC>>24) & 0xff);
  buf[2] = (char) ((PLAYERMAGIC>>16) & 0xff);
  buf[3] = (char) ((PLAYERMAGIC>>8) & 0xff);
  buf[4] = (char) (PLAYERMAGIC & 0xff);
  send(own_socket,buf,5,0);
}

void send_end(void)
{
  char data[] = { NM_END };
  send(own_socket,data,1,0);
}
