/* This is the Netserv/(Netsubserv) V0.34 . (Jan 1993)
 * ------------------------------------------------ 
 * written & copyrights (c) by M.Hipp 
 *
 * It's hard to understand the code, (also for me)
 * because the server is grown enormous. 
 * The subserv-stuff isn't debugged (and not complete)!!
 * 
 * You should use subservers if you have two pools/subnets with a slow
 * line between. Then the server sends only one packet to his
 * subserv, which resends the packet to his clients.
 * Don't use them (the subservs) if all the clients are in the same subnet.
 * (*blush* , but the subserv didn't work any more since V0.3)
 *
 * A lot machines are having problems if more than one application wants
 * to use the itimer. In this case the signal is delivered delayed
 * and the game slows down extremly.
 *
 * known Subserv-Bugs: Subservs can't handle leaving players while playing.
 *       You shouldn't start a game if in the same moment a new 
 *       client wants to connect. 
 *       No name-deliver and some name-problems. 
 *       Only one Subserv-level allowed ..
 *       etc....
 *
 * If I have some time I will rewrite the whole servercode.
 */

#include "netmaze.h"

#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef RS6000
 #include <sys/select.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <strings.h>
#include <memory.h>

#include "network.h"

#define BPI 32		/* bits per int */
#define BUFLEN	256
#define MAXSLOTS 48

typedef struct playerinfo
{
  char name[MAXNAME+1]; 
  char comment[MAXCOMMENT+1];
  int  team;
} PLAYERINFO;

typedef struct netplayer  /* all important informations to handle the */
{			  /* connections to this server */
  int number; 
  char name[MAXNAME+1];
  char hostname[256];
  char comment[MAXCOMMENT+1];
  int mode; /* direct Player/Cam/(Master)/Subserver */
  int team;
  int playing;
  int active;
  struct sockaddr remoteaddr;  /* remote socket address */
  struct netplayer *next;
  struct netplayer *last;
  int complete;   /* need to handle fragmented packets */
  int socket;     /* socketnumber */
  int joydata;
  int response;
  int sernum;
  unsigned long lasttick;

  /* additional informations for handling subservers */
  PLAYERINFO *playinfo[MAXPLAYERS];
  int joysticks[MAXPLAYERS];
  int numplay;
  int numconnect;

} NETPLAYER;

int anz_player,anz_pump,anz_wait,response,anz_connects = 0;
int numteams=0;
int numplay=0,numcam=0,numsubserv=0; /* nur anzahl dieses servers */
int subservmode = 0;
int firstnum=0; /* first playernumber for the subserver */

volatile unsigned long timerticks=0;

unsigned long lasttick=0,starttick=0;
int gameflag=FALSE;
int gamemode = GM_CLASSIC; /* default */
int divider=0; /* DIVIDER_1 */
int no_newplayer = FALSE;
void pump_data(void);
char *mazebuf;
int acc_socket,master_socket;
int menu_in=0,menu_out=1,use_exmenu=FALSE;
char *exmenu_name;
int menumode=1,nomaze=TRUE;
unsigned long interwait;
int nodelay = TRUE; /* test */

/* extern: maze.c */
extern int create_maze(MAZE *mazeadd);
extern int load_maze(char *name,MAZE *mazeadd);

void send_names(void);
void accept_socket(void);
void close_socket(int i);
void close_timeout_sockets(void);
int  init_random(void),findfreeslot(void);
void send_message(char *str,int slot);
void resend(char *buf,int len,int mode);
void connect_master(char *hostname);
void usage(void);
void print_menu(void);
void assemble_joy(char *,int);
void init_slots(int first,int *);
void send_subdata(void);
void handle_input(void);
void send_substart(char *buf,int len);
char *get_hostname(int i,char *name);
void setup_sigchild(void);

long ping_cnt;

NETPLAYER *root_player=NULL;
MAZE std_maze;

struct sockaddr_in myaddr; 	/* local socket address */

#ifdef HAVE_FDSET
struct fd_set readmask;
#else
struct fd_mask readmask;
#endif

#ifdef USE_SIGVEC
struct sigvec vec,vec1;
#else
struct sigaction vec,vec1;
#endif

#ifdef ITIMERVAL
struct itimerval value,ovalue; 
#else
struct itimerstruct value,ovalue;
#endif

struct timeval notimeout;

void inter(int),work_input(char *buf,int len,NETPLAYER *);
void do_timer(void);
void work_input1(char *buf,int len);
NETPLAYER *np_alloc(void);
void send_maze(void);
void send_start(void);
void start_game(int *);
void end_game(void);
void send_info(void);
void send_comments(void);
void start_signal(void),ping_pong(void);
void io_cntl(void);
void handle_sigchild(int s);

NETPLAYER slots[MAXPLAYERS]; /* new */

enum { MENU_NOP , MENU_LOADMAZE , MENU_RUNGAME , MENU_STOPGAME , MENU_LIST , 
       MENU_DISCONNECT , MENU_SETMODE , MENU_SETDIVIDER , MENU_ERROR ,
       MENU_RUNTEAMGAME , MENU_SETTEAMS };


int main(int argc,char **argv,char **environ)
{
  char hostname[256];
  int i;   

  if(argc != 1)
  {
    for(i=1;i<argc;i++)
    {
      if((strcmp(argv[i],"-server") == 0) || (strcmp(argv[i],"-s") == 0)) 
      {
        i++;
        subservmode = TRUE;
        if(strlen(argv[i]) > 255)
        {
          fprintf(stderr,"Hostname too long!!\n");
          exit(1);
        }
        strcpy(hostname,argv[i]);
      }
      else if((strcmp(argv[i],"-help") == 0) || (strcmp(argv[i],"-h") == 0))
        usage();
      else if(strcmp(argv[i],"-exmenu") == 0)
      {
        i++;
        use_exmenu = TRUE;
        exmenu_name = argv[i];
      }
      else
        usage();
    }
  }

  if(use_exmenu)
  {
    int f;
    int fd1[2];
    int fd2[2];
    char *argv1[] = { "NetservExternalMenu" , NULL };

    pipe(fd1);
    pipe(fd2);
    menu_in = fd1[0];
    menu_out = fd2[1];
    setup_sigchild();

    if((f=fork()) == 0)
    {
      close(0);
      close(1);
      dup(fd2[0]);
      dup(fd1[1]);
      close(fd1[0]); close(fd1[1]); close(fd2[0]); close(fd2[1]);
      if(execve(exmenu_name,argv1,environ) < 0)
      {
        fprintf(stderr,"Can't spawn external menu.\n");
        exit(1);
      }
    }
    if(f == -1) 
    {
      fprintf(stderr,"Can't fork external menu!\n");
      use_exmenu = FALSE;
    }
  }

  if(create_maze(&std_maze))
    nomaze=FALSE;

  for(i=0;i<MAXPLAYERS;i++)
  {
    slots[i].active = 0;
  }

  myaddr.sin_family = AF_INET;
  myaddr.sin_addr.s_addr = INADDR_ANY;
  myaddr.sin_port = htons(NETMAZEPORT);
  if( (acc_socket = socket(AF_INET, SOCK_STREAM, 0)) == -1) { perror(argv[0]); exit(1); }

  FD_ZERO(&readmask);
  FD_SET(acc_socket, &readmask);
  if(!use_exmenu)
    FD_SET(0,&readmask); /* stdin */
  else
    FD_SET(menu_in,&readmask); /* external menu */

  if (bind(acc_socket,(struct sockaddr *) &myaddr, sizeof(struct sockaddr)) == -1) 
  {  
    perror("bind"); exit(1);
  }

  if (listen(acc_socket, 5) == -1 ) { perror(argv[0]); exit(1); }

  if(!subservmode)
  {
    menumode = 0;
    start_signal();
    printf(" Netmaze Server 1993 by MH ...\n");
    printf(" Using Port: %d\n",NETMAZEPORT);
    print_menu();
  }
  else
  {
    menumode = 1;
    connect_master(hostname);
    printf(" Netmaze SubServer 1993 by MH ...\n");
    printf(" Now entering Subservmode ..(at your own risk!)\n");
  }

  for(;;)
    io_cntl();
}

/**********************************
 * handle external menu input
 */

void handle_exinput(void)
{
  int len,i;
  static char line[256];
  static int cmdlen,bytesleft=0;
  static int teams[MAXPLAYERS];

  if(!bytesleft) /* read a new command */
  {
      if((len = read(menu_in,line,1)) != 1)
      {
        fprintf(stderr,"ExMenuReadError! -> EXIT\n");
        exit(1);
      }
      cmdlen = 1; bytesleft = 0;
      switch((int) line[0])
      {
        case MENU_LOADMAZE:
          bytesleft = read(menu_in,line+1,1);
          cmdlen = bytesleft + 1;
          break;
        case MENU_RUNGAME:
          break;
        case MENU_RUNTEAMGAME:
          break;
        case MENU_STOPGAME:
          break;
        case MENU_LIST:
          break;
        case MENU_DISCONNECT:
          bytesleft = 1;
          cmdlen = 2;
          break;
        case MENU_SETMODE:
          bytesleft = 4;
          cmdlen = 5;
          break;
        case MENU_SETDIVIDER:
          bytesleft = 1;
          cmdlen = 2;
          break;
        case MENU_SETTEAMS:
          bytesleft = 32;
          cmdlen = 33;
          break;
      }
  }
  else
  {
    len = read(menu_in,line+cmdlen-bytesleft,bytesleft);
    bytesleft -= len;
  }

  if(bytesleft == 0) /* execute the command */
  {
    switch((int) line[0])
    { 
      case MENU_LOADMAZE:
        break;
      case MENU_RUNGAME:
        if(menumode > 0) return;
        if(nomaze == TRUE)
        {
          printf("Load/Reinit a Maze first!\n");
          return;
        }
        if(numplay == 0)
        { 
          printf("No player yet!\nTry again later\n");
          return;
        }
        numteams = 0;
        start_game(NULL);
        menumode = 2;
        break;
      case MENU_RUNTEAMGAME:
        if(menumode > 0) return;
        if(nomaze == TRUE)
        {
          printf("Load/Reinit a Maze first!\n");
          return;
        }
        if(numplay == 0)
        {  
          printf("No player yet!\nTry again later\n");
          return;
        }
        numteams = 0;
        for(numteams=0,i=0;i<numplay;i++)
        {
          if(teams[i] > numteams) numteams = teams[i];
        }
        numteams++;
        fprintf(stderr,"%d",numteams);
        start_game(teams);
        menumode = 2;
        break;
      case MENU_STOPGAME:
        end_game();
        break;
      case MENU_LIST:
        printf("No.: |     Player-Name: | connected from:\n");
        printf("-----+------------------+----------------\n");
        for(i=0;i<MAXPLAYERS;i++)
        {
          if(slots[i].active == 2)
          {
            printf("%3d  | %16s | %s\n",i,slots[i].name,slots[i].hostname);
         }
        } 
        printf("-----+------------------+----------------\n");
        break;
      case MENU_DISCONNECT:
        if(slots[(int) line[1]].active == 2)
          close_socket((int) line[1]);
        break;
      case MENU_SETMODE:
        break;
      case MENU_SETDIVIDER:
        break;
      case MENU_SETTEAMS:
        for(i=0;i<32;i++)
        {
          if((teams[i] < 0) || (teams[i] > MAXPLAYERS))
            teams[i] = 0;
          else
            teams[i] = (int) line[i+1];
        }
        break;
    }
  }
  
}

/*********************************+
 * handle input (ugly)
 */

void handle_input(void)
{
  char line[256],name[100];
  int len,c=0,a,i,j;
  int teams[MAXPLAYERS];
  char *num;

  memset(line,0,256);
  len = read(0,line,255);

  if(len == 0) 
  {
    fprintf(stderr,"OOPS: end-of-file??\n");
    return;
  }
 
  a = sscanf(line,"%d%s",&c,name);
  if(a == 0) 
  {
    printf("Unknown command\n");  
    print_menu();
    return;
  }
  switch(c)
  {
    case 1:
      if(menumode > 0) return;
      if(a == 1)
      {
        printf("OK .. re-initalize builtin-maze\n");
        if(create_maze(&std_maze))
          nomaze=FALSE;
        else
        {
          printf("Can't init maze\n");
          nomaze=TRUE;
        }
      } 
      else
      {
        if(load_maze(name,&std_maze) == TRUE) 
        {
          nomaze=FALSE;
          printf("Maze is OK!\n");
        }
        else
        {
          nomaze=TRUE;
          printf("Can't load '%s'\n",name);
        }
      }
      break;
    case 2:
      if(menumode > 0) return;
      if(nomaze == TRUE)
      {
        printf("Load/Reinit a Maze first!\n");
        return;
      }
      if(numplay == 0)
      { 
        printf("No player yet!\nTry again later\n");
        return;
      }
      if(a == 1)
      {
        numteams = 0;
        start_game(NULL);
        menumode = 2;
      }
      else
      {
        numteams = 0;
        for(i=0;i<MAXPLAYERS;i++) teams[i] = 0;
        num = strtok(line,"\n\t ");
        for(i=0;;i++)
        {
          num = strtok(NULL,"\n\t ");
          if(num == NULL) break;
          sscanf(num,"%d",&teams[i]);
          if((teams[i] < 0) || (teams[i] > MAXPLAYERS))
          {
            i = 0;
            break;
          }
        }
        if(i > 0)
        {
          for(numteams=0,j=0;j<i;j++)
          {
            if(teams[j] > numteams) numteams = teams[j];
          }
          numteams++;

          if(numplay == 0)
          { 
            printf("No player yet!\nTry again later\n");
          }
          else
          {  
            start_game(teams);
            menumode = 2;
          }
        }
        else printf("Illegal team-selection!\n");
      }
      break;
    case 3:
      end_game();
      break;
    case 4:
      printf("No.: |     Player-Name: | connected from:\n");
      printf("-----+------------------+----------------\n");
      for(i=0;i<MAXPLAYERS;i++)
      {
        if(slots[i].active == 2)
        {
          printf("%3d  | %16s | %s\n",i,slots[i].name,slots[i].hostname);
        }
      }
      printf("-----+------------------+----------------\n");
      break;
    case 5:
      if(a == 2)
      {
        sscanf(line,"%d %d",&j,&i);
        if(slots[i].active == 2)
          close_socket(i);
      }
      else
      {
        printf("Too few parameters.\n");
      }
      break;
    case 6:
      if(a == 1)
      {
        if(gamemode == 0)
        {
          gamemode = GM_REFLECTINGSHOTS | GM_DECAYINGSHOTS | GM_MULTIPLESHOTS |
                     GM_WEAKINGSHOTS | GM_ALLOWHIDE | GM_ALLOWRADAR;
          printf(" Enhanced gamemode selected!\n");
        }
        else if(!(gamemode & GM_FASTWALKING))
        {
          gamemode = GM_REFLECTINGSHOTS | GM_DECAYINGSHOTS | GM_MULTIPLESHOTS |
                     GM_FASTWALKING | GM_FASTRECHARGE | GM_ALLOWRADAR;
          printf(" Enhanced just-for-fun gamemode selected!\n"); 
        }
        else
        {
          gamemode = 0;
          printf(" Classic gamemode selected!\n"); 
        }
      }
      break;
    case 7:
      divider++; 
      if(divider == 3) 
        divider = 0;
      switch(divider)
      {
        case 0:
          printf(" OK. Now the divider is: 1.\n");
          break;
        case 1:
          printf(" OK. Now the divider is: 2.\n");
          break;
        case 2:
          printf(" OK. Now the divider is: 4.\n");
          break;
      }
      break;
    case 9:
      if(menumode > 0) return;
      for(i=0;i<MAXPLAYERS;i++)
      {
        if(slots[i].active == 2)
        {
          close_socket(i);
        } 
      }
      exit(0);
      break;
    default:
      printf("Unknown command\n");
      print_menu();
      break;
  }
}

/**********************/
/* Instal Mastertiner */
/**********************/

void start_signal(void)
{
  value.it_interval.tv_sec = 0;
  value.it_value.tv_sec =  1;
#ifdef ITIMERVAL
  value.it_value.tv_usec = 0;
  value.it_interval.tv_usec = DRAWTIME;
#else
  value.it_value.tv_nsec = 0;
  value.it_interval.tv_nsec = DRAWTIME;
#endif

  setitimer(ITIMER_REAL,&value,&ovalue);

#ifdef USE_SIGVEC
  vec1.sv_handler = (void (*)) inter;
  vec1.sv_mask = 0;
  vec1.sv_flags = 0;
  if (sigvector(SIGALRM, &vec1, (struct sigvec *) 0) == -1) perror("SIGALRM\n");
#else
  vec1.sa_handler = (void (*)) inter;
 #ifdef RS6000 /* ibm rs/6000 */
   sigemptyset(&vec1.sa_mask);
 #else
  vec1.sa_mask = 0;
 #endif
  vec1.sa_flags = 0;
  if ( sigaction(SIGALRM, &vec1, (struct sigaction *) 0) == -1) perror("SIGALRM\n");
#endif

}

void setup_sigchild(void) /* for external menu */
{
#ifdef USE_SIGVEC
  struct sigvec svec1;

  svec1.sv_handler = (void (*)) handle_sigchild;
  svec1.sv_mask = 0;
  svec1.sv_flags = 0;
  if(sigvector(SIGCHLD, &svec1, (struct sigvec *) 0) == -1) perror("SIGCHLD\n");
#else
  struct sigaction svec1;

  svec1.sa_handler = (void (*)) handle_sigchild;
 #ifdef RS6000 /* ibm rs/6000 */
   sigemptyset(&svec1.sa_mask);
 #else
  svec1.sa_mask = 0;
 #endif
  svec1.sa_flags = 0;
  if(sigaction(SIGCHLD,&svec1,(struct sigaction *)0) == -1) perror("SIGCHLD\n");
#endif
}

void handle_sigchild(int s)
{
  int stat,cpid;
  cpid = wait(&stat);
  fprintf(stderr,"Child (exmenu?): %d died.\n",cpid);
  exit(1); /* ok, that's the hard way */
}


/*************************/
/* Setup Masterconnect   */
/*************************/

void connect_master(char *hostname)
{
  struct hostent *hp;
  struct sockaddr_in remoteaddr; /* server connect */
  int flag = 1,ret;
  char buf[10];
 
  remoteaddr.sin_family = AF_INET;

  if ((hp = gethostbyname(hostname) ) == NULL)
  {
    fprintf(stderr, "netserv: Can't resolve %s\n",hostname); exit(1);
  }

  remoteaddr.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;
  if((master_socket = socket(AF_INET, SOCK_STREAM, 0)) == -1)
  {
    fprintf(stderr, "netserv: unable to create socket\n"); exit(1);
  }
  remoteaddr.sin_port = htons(NETMAZEPORT);
  if (ioctl(master_socket, FIOASYNC, &flag) == -1) 
  { 
    perror(" async "); exit(1);
  }
  FD_SET(master_socket,&readmask);
  if((ret=connect(master_socket,(struct sockaddr *) &remoteaddr, sizeof(struct sockaddr))) == -1) 
  {
     fprintf(stderr, "netserv: unable to connect to masterserv\n"); exit(1);
  }
  flag = -getpid();
  if (ioctl(master_socket, SIOCSPGRP, &flag) == -1)
  { 
    perror(" process group."); 
  } 

  buf[0] = NM_SETMODE; /* send ident */
  buf[1] = (char) ((SUBSERVMAGIC>>24) & 0xff); /* & 0xff not necessary */
  buf[2] = (char) ((SUBSERVMAGIC>>16) & 0xff);
  buf[3] = (char) ((SUBSERVMAGIC>>8) & 0xff);
  buf[4] = (char) (SUBSERVMAGIC & 0xff);
  send(master_socket,buf,5,0);
}

/************************/
/* Timer-Signal-Handler */
/************************/

void inter(int sig)
{
  static int l = 0;
  switch(divider)
  {
    case 0:
      timerticks++;     /* enough for about 6 years :-) */
      break;
    case 1:
      if(++l > 1) 
      { 
        l = 0;
        timerticks++;       
      }
      break;
    case 2:
      if(++l > 3) 
      { 
        l = 0;
        timerticks++;       
      }
      break;
  }
  /* the timertick is for syncronisation */
  /* the main timer-function is called by the main loop */
  /* so we don't have to care about (very tricky) interrupt conditions. */
}

/********************************
 * the main timerfunction 
 */

void do_timer(void)
{
  int i;

  lasttick = timerticks;

  if(gameflag)
  {
    if(!response)
    {
      if(!(timerticks & 0x1f)) fprintf(stderr,"!");
      response = anz_wait;
      pump_data();
      interwait = 0;
    }
    else
    {
      interwait++;
      if((interwait & 0x1f) == 0x1f)
      {
        for(i=0;i<MAXPLAYERS;i++)
          if((slots[i].playing == TRUE) && (slots[i].active == 2) &&
             (!slots[i].response))
          {
            fprintf(stderr,"Player %d doesn't response!\n",i);
          }
      }
      if(interwait > 100)
        close_timeout_sockets();
    }
  }
  else
  {
    if(menumode == 2)
    {
      if(!response)
      {
        menumode = 3;
        gameflag = TRUE;
        printf("ok ... ACTION!!! ...[(3) stop game] \n");
      }
      else
      {
        if(timerticks - starttick > 100)
        {
          close_timeout_sockets();
        }
      } 
    }
    else if(menumode == 3)
    {
      menumode = 0;
      print_menu();
    }
  }
}

/***********************************
 * I/O-Signal-Handler
 */

void io_cntl(void)
{
#ifdef HAVE_FDSET
  struct fd_set readmask1;
#else
  struct fd_mask readmask1; 
#endif

  int count,len;
  int numfds,i;
  char buf[BUFLEN];

  for(;;)
  {
    readmask1 = readmask; 

    /* we need max. 3+32 (+cams) filedescriptors
     * if select returns with a value < 0 we expect a SIGNAL not an error 
     */
    if ((numfds = select(36,&readmask1,NULL,NULL,NULL)) < 0) 
    {
      if(timerticks > lasttick) /* the 'if' shouldn't be necessary */
        do_timer();
      continue; 
    }
    if(timerticks > lasttick) 
      do_timer();

    if(numfds == 0) break;

    /* master-socket */
    if((subservmode) && (FD_ISSET(master_socket,&readmask1)))
    {
      if((count = recv(master_socket,buf,1,0)) != 1)
      {
        fprintf(stderr,"oops ... lost Masterconnect\n");
        /* */
        FD_CLR(master_socket,&readmask);
        continue;
      }
      
      if((len = (int) nm_field[(int) *buf]) > 0) /* fixed length command */
      {
        if(len > 1)
        {
          count = recv(master_socket,buf+1,len-1,0);
          if(count != len-1)
          {
            fprintf(stderr,"IO: wrong length\n");
            return;
          }
        } 
        work_input1(buf,len);
      }
      else
      {  /* getting length */
        if((count = recv(master_socket,buf+1,1,0)) != 1) /* nicht optimal */
        {
          fprintf(stderr,"IO: error reading blklen\n");  
          return;
        }
        len = (int) buf[1];
        if(len > 2)
        {
          if((count = recv(master_socket,buf+2,len-2,0)) != (len-2) )
          {
            fprintf(stderr,"IO-1: wrong length\n"); 
            return;
          }
        }
        work_input1(buf,len);
      }
    }

    /*
     * slave-sockets 
     */
    for(i=0;(i<MAXPLAYERS) && (slots[i].active > 0);i++)
    {
      if((slots[i].active == 2) && (FD_ISSET(slots[i].socket,&readmask1)))
      {
        slots[i].lasttick = timerticks;
        if((count = recv(slots[i].socket,buf,1,0)) != 1) /* nicht optimal */
        {
          close_socket(i);
          continue;
        }
        if((len = (int) nm_field[(int) *buf]) > 0) /* fixed length command */
        {
          if(len > 1)
          {
            count = recv(slots[i].socket,buf+1,len-1,0);
            if(count != len-1)
            {
              fprintf(stderr,"IO: wrong length\n");
              return;
            }
          } 
          work_input(buf,len,&slots[i]);
        }
        else
        {  /* getting length */
          if((count = recv(slots[i].socket,buf+1,1,0)) != 1) /* nicht optimal */
          {
            fprintf(stderr,"IO: error reading blklen\n");  
            return;
          }
          len = (int) buf[1];
          if(len > 2)
          {
            if((count = recv(slots[i].socket,buf+2,len-2,0)) != (len-2) )
            {
              fprintf(stderr,"IO-1: wrong length\n"); 
              return;
            }
          }
          work_input(buf,len,&slots[i]);
        }
      }
    }

    /*
     * accept_socket
     */
    if (FD_ISSET(acc_socket, &readmask1)) 
    {
      accept_socket();
    }

    if(use_exmenu)
    {
      if(FD_ISSET(menu_in,&readmask1))
        handle_exinput();
    }
    else /* keyboard (stdin) */
    {
      if(FD_ISSET(0,&readmask1))
        handle_input();
    }

  }
} /* end io_handler */


/*************************************
 * (try to) accept a new socket
 */

void accept_socket(void)
{
  int i;
  int addrlen = sizeof(struct sockaddr);
  
  i = findfreeslot();

  slots[i].number   = 0;
  slots[i].lasttick = timerticks;
  slots[i].playing  = FALSE;
  slots[i].mode     = 0; /* unidentified */
  slots[i].response = FALSE;
  slots[i].socket   = accept(acc_socket,&slots[i].remoteaddr,&addrlen);
  if(slots[i].socket == -1 ) 
  {
    perror("accept call failed"); exit(1);
  }
  slots[i].active   = 2; /* sloteintrag aktivieren */ 

  get_hostname(i,slots[i].hostname);

  printf("\n accepted a connection request from [%s].\n",slots[i].hostname);

  FD_SET(slots[i].socket,&readmask);
  anz_connects++;
  if(no_newplayer == TRUE)
  {
    send_message("please wait .. another game is running!\n",i);
  }
}

/************************
 * resolve hostname
 */

char *get_hostname(int i,char *name)
{
  struct hostent *hp;
  char *saddr = (char *) &(((struct sockaddr_in *) &slots[i].remoteaddr)->sin_addr.s_addr);
  hp = gethostbyaddr(saddr,4,AF_INET);

  if(strlen(hp->h_name) > 0)
    strcpy(name,hp->h_name);
  else
    sprintf(name,"%d.%d.%d.%d",(int) saddr[0],(int) saddr[1],(int) saddr[2],(int) saddr[3]);
  return name;
}

/**********************************
 * close a connection
 */

void close_socket(int i)
{
  FD_CLR(slots[i].socket,&readmask); /* shutdown ? */
  close(slots[i].socket);
  slots[i].active = 1;
  anz_connects--;
  slots[i].socket = -1;
  switch(slots[i].mode)
  {
    case SUBSERVMODE:
      numsubserv--; /* !! */
      numplay -= slots[i].numconnect;
      break;
    case CAMMODE:
      numcam--;
      break;
    case PLAYERMODE:    
      numplay--;
      break;
  }
  if(slots[i].playing == TRUE)
  {
    slots[i].playing = FALSE;
    anz_player -= slots[i].numplay;
    anz_wait--;
    if(!slots[i].response)
      response--;

    if(subservmode)
    {
      if(!response) send_subdata();
    }
    else
    {
      if((anz_player == 0) || (anz_wait == 0)) /* double-check */
      {
        fprintf(stderr,"Last active player has left the game.\n");
        fprintf(stderr,"-> Game ended.\n");
        end_game();
      }
    }
  }
  fprintf(stderr,"I've lost a connection ...\n");
}

/*********************************
 * close not responding sockets
 */

void close_timeout_sockets(void)
{
  int i;
  for(i=0;i<MAXPLAYERS;i++)
  {
    if((slots[i].playing == TRUE) && (slots[i].active == 2))
    {
      if(!slots[i].response)
      {
        fprintf(stderr,"Player %d doesn't response .. -> shutdown\n",i);
        close_socket(i);
      }
    }
  }
}

/*******************************/
/* handling an incoming packet */
/*******************************/

void work_input(char *buf,int len,NETPLAYER *player)
{
  char data = NM_PING;
  unsigned long lval;
  char c = NM_INCPLAYER;

  if((player->mode == 0) && (*buf != NM_SETMODE)) return; /* !ident */

  switch(*buf)
  {
/*    case NM_STARTGAME:
	break;
    case NM_STOPGAME:
	break;
    case NM_PAUSEGAME:
	break;
    case NM_MAZEH: 
	break;
    case NM_MAZEV:
        break;
    case NM_ALLDATA:
	break; */
    case NM_OWNDATA:
        if(player->mode == PLAYERMODE)
        {
	  player->joydata = (int) buf[1];
          if(player->playing == TRUE)
          {
            response--;
            player->response = TRUE;
            if(interwait && !response && nodelay)
              do_timer();
            if((subservmode) && (!response) )
            {
              send_subdata();
            }
          }
        }
	break;
    case NM_SUBDATA:
        if(player->mode == SUBSERVMODE)
        {
          memcpy(player->joysticks,buf+2,player->numplay);
          if(player->playing == TRUE)
          {
            response--;
            player->response = TRUE;
            if((subservmode) && (!response))
            {
              send_subdata();
            }
          }
        }
        break;
    case NM_MESSAGE:
        printf("%s\n",buf+2);
	break;
/*    case NM_INFO:
	break;
    case NM_TIMEERROR:
	break; */
    case NM_OWNNAME:
	strncpy(player->name,&(buf[2]),buf[1]-2);
        player->name[buf[1]-2] = 0;
	break; 
/*    case NM_ALLNAMES:
	break; 
    case NM_PING:
	break;  */
    case NM_PONG:
        ping_cnt--;
        if(ping_cnt > 0) 
          send(slots[0].socket,&data,1,0); /* not correct !! */
	break;
/*    case NM_QUIT:
	break; */
    case NM_READY:
	response--;
        player->response = TRUE;
        if((!response) && (subservmode))
        {
          send(master_socket,buf,len,0); /* weiterreichen */
        }
	break;
/*    case NM_RANDOM:
        break; */
    case NM_END:
        if((gameflag == TRUE) && (player->playing == TRUE))
        { 
          fprintf(stderr,"END");
          send(master_socket,buf,len,0);
          end_game();
        }
        break;
/*    case NM_CNTRL:
	break; */
    case NM_INCPLAYER:
        if(player->mode == SUBSERVMODE)
        {
          player->numconnect++; /* all potential players */
          numplay++;
          if(subservmode)
            send(master_socket,buf,len,0);
        }
	break;
    case NM_DECPLAYER:
        if(player->mode == SUBSERVMODE)
        {
          player->numconnect--;
          numplay--;
          if(subservmode)
            send(master_socket,buf,len,0);
        }
	break;
    case NM_SETMODE:
        if(player->mode == 0)
        {
          lval = 0;
          lval |= ((unsigned long) buf[1]) << 24;
          lval |= ((unsigned long) buf[2]) << 16;
          lval |= ((unsigned long) buf[3]) << 8;
          lval |= ((unsigned long) buf[4]);

          switch(lval)
          {
            case CAMMAGIC:
              player->mode = CAMMODE;
              numcam++;
              printf("It's a CAM\n");
              break;
            case SUBSERVMAGIC:
              player->mode = SUBSERVMODE;
              numsubserv++;
              printf("It's a SUBSERVER\n");
              break;
            case PLAYERMAGIC:
              player->mode = PLAYERMODE;
              numplay++;
              printf("It's a normal PLAYER\n");
              send(master_socket,&c,1,0);
              break;
            default:
              printf("Unknown Ident-Magic: Do you use different netprotocolls?\n");
              break;
          }
        }
        break;
/*    case NM_ENUM:
        break; */
      case NM_OWNCOMMENT:
        strncpy(player->comment,&(buf[2]),buf[1]-2);
        player->comment[buf[1]-2] = 0;
        break;
      case NM_ALLCOMMENTS:
        break;
  }
}

/************************************/
/* handling incoming master-packet  */
/************************************/

void work_input1(char *buf,int len)
{
  switch(*buf)
  {
    case NM_STARTGAME:
        send_substart(buf,len);
	break;
    case NM_STOPGAME:
        resend(buf,len,1);
        end_game();
	break;
    case NM_PAUSEGAME:
        resend(buf,len,1);
  	break;
    case NM_MAZEH:
        resend(buf,len,1);
	break;
    case NM_MAZEV:
        resend(buf,len,1);
        break;
    case NM_ALLDATA:
        assemble_joy(buf,len);
	break;
    case NM_MESSAGE:
        printf("%s\n",buf+2);
        resend(buf,len,0);
	break;
    case NM_INFO:
	break;
    case NM_TIMEERROR:
	break;
    case NM_OWNNAME:
	break; 
    case NM_ALLNAMES:
	break; 
    case NM_PING:
	break; 
    case NM_PONG:
	break;
    case NM_QUIT:
	break;
    case NM_READY:
	break;
    case NM_RANDOM:
        break;
    case NM_END:
        /* free no_newplayer .. -> resend to all subservers */
        break;
    case NM_CNTRL:
	break;
    case NM_INCPLAYER:
	break;
    case NM_DECPLAYER:
	break;
    case NM_SETMODE:
	break;
    case NM_ENUM:
        no_newplayer = TRUE;
        init_slots((int) buf[1],NULL);  
        firstnum = (int) buf[1];
        break;
  }
}

/***********************************/
/* Subserv: ReSend incoming data   */
/***********************************/

void resend(char *buf,int len,int mode)
{
  int i,j;

  for(i=0,j=0;i<MAXPLAYERS;i++)
  {
    if(slots[i].active == 2) 
      if((slots[i].playing == TRUE) || (mode == 0)) 
      {
        send(slots[i].socket,buf,len,0);  
      }
  }
} 

/***********************************/
/* Start Game  (master)            */
/***********************************/

void start_game(int *teams)
{
  no_newplayer = TRUE;
  anz_player = numplay;

  init_slots(0,teams);

  send_names();
  send_comments();
  send_maze();
  send_start();
}


/**************************/
/* init_slots (+subservs) */
/**************************/

void init_slots(int first,int *teams)
{
  char buf[10];
  int i,j;

  anz_wait=0;

  for(i=0,j=first;i<MAXPLAYERS;i++)
  {
     if(slots[i].active == 2)
     {
       if(slots[i].mode == PLAYERMODE)
       {
         slots[i].joydata = 0;
         slots[i].response = FALSE;
         slots[i].playing = TRUE;
         slots[i].numplay = 1; /* logo */
         slots[i].number = j;
         if(teams == NULL)
           slots[i].team = j;
         else
           slots[i].team = teams[j];
         j++;
         anz_wait++;
       }
       else
       {
         slots[i].response = FALSE;
         if(slots[i].numconnect > 0)
           slots[i].playing = TRUE;
         memset(slots[i].joysticks,0,MAXPLAYERS);
         slots[i].numplay = slots[i].numconnect;
         slots[i].number = j;
         if(slots[i].numplay > 0)
         {
           slots[i].playing = TRUE;
           anz_wait++;
         }
         j += slots[i].numplay;
         buf[0] = NM_ENUM;
         buf[1] = (char)  slots[i].number;
         send(slots[i].socket,buf,2,0); /* enum server-tree */
       }
     }
  }
}

/***********************/
/* Spielende           */
/***********************/

void end_game(void)
{
  int j;
  char data[2];

  gameflag = FALSE;
  no_newplayer = FALSE;

  for(j=0;j<MAXPLAYERS;j++)
  {
    if((slots[j].playing == TRUE) && (slots[j].active == 2))
    {
      data[0] = NM_STOPGAME;
      send(slots[j].socket,data,1,0);
    }
    slots[j].playing = FALSE;
  }

}

/**********************************/
/* Sende Routinen                 */
/**********************************/

void send_maze(void)
{
  int (*hfeld)[MAZEDIMENSION],(*vfeld)[MAZEDIMENSION];
  int dim,i,j;
  char buf[MAZEDIMENSION+10];

  hfeld = std_maze.hwalls;
  vfeld = std_maze.vwalls;
  dim = std_maze.xdim;

  for(i=0;i<=dim;i++)
  {
    for(j=0;j<dim;j++)
      buf[j+4] = (char) hfeld[i][j];
    buf[0] = NM_MAZEH;
    buf[1] = dim+4;
    buf[2] = (char) dim;
    buf[3] = (char) i;
    for(j=0;j<MAXPLAYERS;j++)
    {
      if((slots[j].playing == TRUE) && (slots[j].active == 2))
        send(slots[j].socket,buf,dim+4,0);
    }
  }

  for(i=0;i<=dim;i++)
  {
    for(j=0;j<dim;j++)
      buf[j+4] = (char) vfeld[j][i];
    buf[0] = NM_MAZEV;
    buf[1] = dim+4;
    buf[2] = (char) dim;
    buf[3] = (char) i;
    for(j=0;j<MAXPLAYERS;j++)
    {
      if((slots[j].playing == TRUE) && (slots[j].active == 2))
        send(slots[j].socket,buf,dim+4,0);
    }
  }
}

/*********************/
/* Send Names        */
/*********************/

void send_names(void)
{
  char data[256];
  int i,j;

  for(j=0;j<MAXPLAYERS;j++)
  {
    if((slots[j].playing == TRUE) && (slots[j].active == 2))
    {
      for(i=0;i<MAXPLAYERS;i++)
      {
        if((slots[i].playing == TRUE) && (slots[i].active == 2))
        {
          data[0] = NM_ALLNAMES;
          data[1] = 3 + strlen(slots[i].name);
          data[2] = (char) slots[i].number;
          strcpy(data+3,slots[i].name);
          send(slots[j].socket,data,data[1],0);
        }
      }
    }
  }
}

/*********************/
/* Send Comments     */
/*********************/

void send_comments(void)
{
  char data[256];
  int i,j;

  for(j=0;j<MAXPLAYERS;j++)
  {
    if((slots[j].playing == TRUE) && (slots[j].active == 2))
    {
      for(i=0;i<MAXPLAYERS;i++)
      {
        if((slots[i].playing == TRUE) && (slots[i].active == 2))
        {
          data[0] = NM_ALLCOMMENTS;
          data[1] = 3 + strlen(slots[i].comment);
          data[2] = (char) slots[i].number;
          strcpy(data+3,slots[i].comment);
          send(slots[j].socket,data,data[1],0);
        }
      }
    }
  }
}


/*****************************************************/
/* Startsymbol senden                                */
/* Inclusive Anzahl Players & Spezielle Playernumber */
/*****************************************************/

void send_start(void)
{
  char data[MAXPLAYERS+10];
  int j,rndwert;

  response = anz_wait;
  
  data[0] = NM_STARTGAME;
  data[1] = anz_player + 16; 
  data[2] = (char) anz_player;
  anz_pump = anz_player;
  printf("Starting game with %d player(s).\n",anz_player);

  rndwert = rand();
  data[4] = rndwert >> 8;
  data[5] = rndwert & 0xff;

  if(numteams == 0)
    data[6] = (char) anz_player;
  else
    data[6] = numteams;

  data[7] = (unsigned char) (gamemode & 0xff);
  data[8] = (unsigned char) (gamemode>>8);
  data[9] = (unsigned char) divider;

  /* data 10 - 15 free for future changes */

  for(j=0;j<MAXPLAYERS;j++)
  {
    if((slots[j].playing == TRUE) && (slots[j].active == 2))
    {
      data[16+slots[j].number] = slots[j].team;
    }
  }

  for(j=0;j<MAXPLAYERS;j++)
  {
    if((slots[j].playing == TRUE) && (slots[j].active == 2))
    {
      slots[j].response = FALSE;
      data[3] = (char) slots[j].number;
      send(slots[j].socket,data,data[1],0);
    }
  }
  starttick = timerticks;
}

/********************************/
/* Send-Sub-Start               */
/********************************/

void send_substart(char *buf,int len)
{
  char data[10];
  int j;

  response = anz_wait;

  anz_player = (int) buf[1];
  nm_field[NM_ALLDATA] = buf[1] + 1 - (char) numplay;
  
  data[0] = NM_STARTGAME;
  data[1] = buf[1];
  anz_pump = anz_player;
  printf("START: %d %d\n",anz_player,(int) data[1]);

  data[3] = buf[3];
  data[4] = buf[4];

  for(j=0;j<MAXPLAYERS;j++)
  {
    if((slots[j].playing == TRUE) && (slots[j].active == 2))
    {
      slots[j].response = FALSE;
      data[2] = (char) slots[j].number;
      send(slots[j].socket,data,5,0);
    }
  }
}

int init_random(void)
{
  return(1234);
}

void send_info(void)
{
  
}

/********************/
/* Send Message     */
/********************/

void send_message(char *str,int slot)
{
  char data[256];

  data[0] = NM_MESSAGE;
  data[1] = strlen(str)+3;
  strcpy(data+2,str);
  send(slots[slot].socket,data,data[1],0);
}

/*********************/
/* Send Subdata      */
/*********************/

void send_subdata(void)
{
  char data[100];
  int i;

  data[0] = NM_SUBDATA;
  data[1] = (char) numplay + 2;

  for(i=0;i<MAXPLAYERS;i++)
  {
    if((slots[i].playing == TRUE) && (slots[i].active == 2))
    {
      if(slots[i].mode == PLAYERMODE)
      {
        data[slots[i].number+2-firstnum] = (char) slots[i].joydata; 
      }
      else
      {
        memcpy(data+slots[i].number+2-firstnum,slots[i].joysticks,slots[i].numplay);
      }
      slots[i].response = 0;
    }
  }
  send(master_socket,data,numplay+2,0);  
}

/********************/
/* Daten pumpen     */
/********************/

void pump_data(void)
{
  char data[MAXPLAYERS+2];
  char data1[MAXPLAYERS+2];
  int i;

  for(i=0;i<MAXPLAYERS;i++)
  {
    if((slots[i].playing == TRUE) && (slots[i].active == 2))
    {
      if(slots[i].mode == PLAYERMODE)
      {
        data[slots[i].number+1] = (char) slots[i].joydata; 
      }
      else
      {
        memcpy(data+slots[i].number+1,slots[i].joysticks,slots[i].numplay);
      }
      slots[i].response = FALSE;
    }
  }
  
  data[0] = NM_ALLDATA;
  data1[0] = NM_ALLDATA; 

  for(i=0;i<MAXPLAYERS;i++)
  {
    if((slots[i].playing == TRUE) && (slots[i].active == 2))
    {
      if(slots[i].mode == PLAYERMODE)
      {
        send(slots[i].socket,data,anz_pump+1,0);
      }
      else
      {
        memcpy(data1+1,data+1,slots[i].number);
        memcpy(data1+1+slots[i].number,data+1+slots[i].number+slots[i].numplay,anz_pump-slots[i].number-slots[i].numplay);
        send(slots[i].socket,data1,anz_pump+1-slots[i].numplay,0);
      }
    }
  }
}

/****************************/
/* assemble-joydata         */
/****************************/

void assemble_joy(char *buf,int len)
{
  char data[MAXPLAYERS+2];
  char data1[MAXPLAYERS+2];
  int i;

  response = anz_wait;

  memcpy(data+1,buf+1,firstnum);
  memcpy(data+1+firstnum+numplay,buf+1+firstnum,len-1-firstnum);
  for(i=0;i<MAXPLAYERS;i++)
  {
    if((slots[i].playing == TRUE) && (slots[i].active == 2))
    {
      if(slots[i].mode == PLAYERMODE)
      {
        data[slots[i].number+1] = (char) slots[i].joydata; 
      }
      else
      {
        memcpy(data+slots[i].number+1,slots[i].joysticks,slots[i].numplay);
      }
      slots[i].response = 0;
    }
  }
  
  data[0] = NM_ALLDATA;
  data1[0] = NM_ALLDATA; 

  for(i=0;i<MAXPLAYERS;i++)
  {
    if((slots[i].playing == TRUE) && (slots[i].active == 2))
    {
      if(slots[i].mode == PLAYERMODE)
      {
        send(slots[i].socket,data,anz_pump+1,0);
      }
      else
      {
        memcpy(data1+1,data+1,slots[i].number);
        memcpy(data1+1+slots[i].number,data+1+slots[i].number+slots[i].numplay,anz_pump-slots[i].number-slots[i].numplay);
        send(slots[i].socket,data1,anz_pump+1-slots[i].numplay,0);
      }
    }
  }
}

/***************************/
/* Ping-Pong-Speed-Test    */
/***************************/

void ping_pong(void)
{
  int i;
  long start,end;
  char data = NM_PING;

  for(i=0;i<MAXPLAYERS;i++)
  {
    if(slots[i].active == 2)
    {
      ping_cnt = 100;

      fprintf(stderr,"Start Ping-Pong with slots %d\n",i);

      start = clock();
      send(slots[i].socket,&data,1,0);

      while(ping_cnt > 0) /* ioctl(root_player->socket,I_FLUSH,FLUSHRW) */;

      end = clock();
      fprintf(stderr,"End Ping-Pong %ld\n",end-start);
    }
  }
}

/***********************************/
/* searching a free NETPLAYER-slot */
/***********************************/

int findfreeslot(void)
{
  int i;
  
  for(i=0;i<MAXPLAYERS;i++)
  {
    if(slots[i].active < 2) return(i);
  }
  return(-1);
}

/***************************/
/* little help for newbies */
/***************************/

void usage(void)
{
  printf("No options .. just start the program\n");
  printf("this message:\n  netserv [-h|-help]\n");
  printf("soon coming ... subservmode: (in about 5-10 years)\n");
  printf("  netserv [-s|-server <masterserverhostname>]\n\n");
  exit(0);
}

void print_menu(void)
{
  if(use_exmenu) return;

  printf("\t****************** MENU ******************\n");
  printf("\t1 [mazename] => Reinit/Load a maze\n");
  printf("\t2 [teamlist] => Start game [with teams]\n");
  printf("\t3            => Stop a running game\n");
  printf("\t4            => List connections\n"); 
  printf("\t5 <No.>      => Shutdown a connection <No.>\n");
  if(gamemode == 0)
    printf("\t6            => Enable extended gamemode\n");
  else if(!(gamemode & GM_FASTWALKING))
    printf("\t6            => Enable extended just-for-fun gamemode\n");
  else
    printf("\t6            => Enable classic gamemode\n");
  switch(divider)
  {
    case 0:
      printf("\t7            => Change 'beat' divider (current: 1)\n"); 
      break;      
    case 1:
      printf("\t7            => Change 'beat' divider (current: 2)\n"); 
      break;      
    case 2:
      printf("\t7            => Change 'beat' divider (current: 4)\n"); 
      break;      
  }
  printf("\t------------------------------------------\n");
  printf("\t9            => Quit\n\n");
}

