/*
 * load and transform maze-datas
 */

#include <stdio.h>

#include "netmaze.h"
#include "defmaze.h"

static int work_maze(MAZE *mazeadd,char* cbuffer);

/************************************/
/* Speicher fuer Maze bereitstellen */
/************************************/

int create_maze(MAZE *mazeadd)
{ 
  int i;
  char *cbuffer,*buffer;

  mazeadd->xdim  = defmazelen>>1;
  mazeadd->ydim  = defmazelen>>1; 
  mazeadd->setlist = NULL;
  mazeadd->bitlist = NULL;

  if ((buffer = cbuffer = (char *) malloc(10000U)) == NULL) return FALSE;

  for(i=0;i<defmazelen;i++,buffer += BPL)
  { 
     strcpy(buffer,defmazedata[i]);
  }

  if( work_maze(mazeadd,cbuffer) == TRUE)
  {
    printf("Defaultmaze is ok!\n");
    free(cbuffer);
    return TRUE;
  }
  else
  {
    free(cbuffer);
    return FALSE;
  }
}

/******************************/
/* Maze laden & bearbeiten    */    
/******************************/

int load_maze(char *name,MAZE *mazeadd)
{
  char *cbuffer,*buffer;
  FILE *handle;
  int dim,i,flag = !EOF,ret=FALSE;
  
  if ((cbuffer = buffer = (char *) malloc(16384U)) == NULL) return FALSE;

  if ( (handle = fopen(name,"r")) != NULL)
  {
    fscanf(handle,"%d\n",&dim);
    if(dim % 2 == 0) dim++;
    if ((dim >= 3) && (dim <= BPL-1) /* && (dim % 2 == 1) */ )
    {
      for(i=0;i<=dim;i++,cbuffer += BPL)
      {   
         if ((flag = fscanf(handle,"%s",cbuffer)) == EOF) break; 
      }

      fclose(handle);
      if(i == dim)
      {
        mazeadd->xdim = dim/2;
        mazeadd->ydim = dim/2;
        ret = work_maze(mazeadd,buffer);
      }
    }
  }
  free(buffer);
  return ret;
}

/*****************************/
/* Maze-roh-daten bearbeiten */
/*****************************/

static int work_maze(MAZE *mazeadd,char* buffer)
{
  int (*hfeld)[MAZEDIMENSION],(*vfeld)[MAZEDIMENSION];
  int dimension,i,j,i1,j1,err_x=0,err_y=0;
   
  hfeld = mazeadd->hwalls;
  vfeld = mazeadd->vwalls;
  dimension = (mazeadd->xdim)*2+1;

  for(j1=0,j=0;(j<dimension/2+1) && (!err_x);j1+=2,j++)
  {
    for(i1=0,i=0;(i<dimension/2) && (!err_x);i1+=2,i++)
    {
      switch(*(buffer+i1+1+j1*BPL))
      {
        case 'X': 
          if ( (*(buffer+i1+j1*BPL) != 'X') || (*(buffer+i1+2+j1*BPL) != 'X'))
          {
            err_x = i1+2; err_y = j1+1; 
            break;
          }
          hfeld[j][i] = TRUE;
          break;
        case '*':
          if ( (*(buffer+i1+j1*BPL) != '*') || (*(buffer+i1+2+j1*BPL) != '*'))
          {
            err_x = i1+2; err_y = j1+1;
            break;
          }
          hfeld[j][i] = TRUE;   
          break;
        case '.':
          hfeld[j][i] = FALSE;
          break;
        default:
          err_x = i1+2; err_y = j1+1;
          break;
      }

      switch(*(buffer+j1+(i1+1)*BPL))
      {
        case 'X':
          if ((*(buffer+j1+i1*BPL) != 'X') || (*(buffer+j1+(i1+2)*BPL) != 'X'))
          {
            err_x = j1+1; err_y = i1+2;
            break;
          }
          vfeld[i][j] = TRUE;
          break;
        case '*':
          if ((*(buffer+j1+i1*BPL) != '*') || (*(buffer+j1+(i1+2)*BPL) != '*'))
          {
            err_x = j1+1; err_y = i1+2;
            break;
          }
          vfeld[i][j] = TRUE;
          break;
        case '.':
          vfeld[i][j] = FALSE;
          break;
        default:
          err_x = j1+1; err_y = i1+2;
          break;
      }
    }
  }

  if(err_x == 0)
    return TRUE;

  printf("mazeerror at: x(%d) y(%d)\n",err_x,err_y);
  return FALSE;
}


