/***********************************************************************
 *
 * Mpeg Widget
 *
 ***********************************************************************/

#ifndef _X_MPEG_H
#define _X_MPEG_H

/* this means it uses Motif subclassing, else just from Core */
#define MPEG_IS_MOTIF_WIDGET

#ifdef MPEG_IS_MOTIF_WIDGET
#include <Xm/Xm.h>
#else
#include <X11/Intrinsic.h>
#endif

#include "video.h"

#ifdef __cplusplus
extern "C" {
#endif

/* resource strings */
#define XtNdither "dither"
#define XtCDither "Dither"
#define XtNshowCount "showCount"
#define XtCShowCount "ShowCount"
#define XtNmovieStoppedCallback "movieStoppedCallback"
#define XtNsource "source"
#define XtCSource "Source"

/* for use as a Motif widget */
#define XmNdither	XtNdither
#define XmCDither 	XtCDither
#define XmNshowCount 	XtNshowCount
#define XmCShowCount 	XtCShowCount
#define XmNmovieStoppedCallback 	XtNmovieStoppedCallback

/* Movie status */
#define XmpegMOVIE_RUNNING     0
#define XmpegMOVIE_PAUSED      1
#define XmpegMOVIE_NOT_STARTED 2
#define XmpegMOVIE_FINISHED    3

/* play for how long */
#define MPEG_PLAY_FOREVER	-2
#define MPEG_PLAY_TO_END	-1

/******** struct returned from movieStopped callback *******/
typedef struct {
    String	source;
    short	reason;
}   XmpegCallbackStruct; 


externalref WidgetClass xmpegWidgetClass;

typedef struct _XmpegClassRec *XmpegWidgetClass;
typedef struct _XmpegRec      *XmpegWidget;


/********    Public Function Declarations    ********/
#ifdef MPEG_IS_MOTIF_WIDGET
#ifdef _NO_PROTO
extern Widget XmCreateMpeg() ;
#else
extern Widget XmCreateMpeg( 
                        Widget parent,
                        char *name,
                        ArgList arglist,
                        Cardinal argcount) ;

#endif /* _NO_PROTO */
#endif /* MPEG_IS_MOTIF_WIDGET */

#ifdef _NO_PROTO
extern int XmpegMovieStatus() ;
#else
extern int XmpegMovieStatus( 
                        Widget w) ;

#endif /* _NO_PROTO */

#ifdef _NO_PROTO
extern void XmpegRewindMovie() ;
#else
extern void XmpegRewindMovie( 
                        Widget w) ;

#endif /* _NO_PROTO */

#ifdef _NO_PROTO
extern void XmpegPlayMovie() ;
#else
extern void XmpegPlayMovie( 
                        Widget w,
			int count) ;
#endif /* _NO_PROTO */

#ifdef _NO_PROTO
extern void XmpegStopMovie() ;
#else
extern void XmpegStopMovie( 
                        Widget w) ;

#endif /* _NO_PROTO */
/********    End Public Function Declarations    ********/


#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* _X_MPEG_H */
/* DON'T ADD ANYTHING AFTER THIS #endif */
