/* keyboard.h: takes care of the keyboard window. */

#ifndef	_keyboard_h_
#define	_keyboard_h_

#include <Xm/Xm.h>

#ifdef	_NO_PROTO
Widget	MakeKeyboard() ;
void	RedrawKeyboard() ;
Boolean	IsHomePosition() ;
#else
Widget	MakeKeyboard(Widget) ;
void	RedrawKeyboard(Widget) ;
Boolean	IsHomePosition(int, int) ;
#endif

/* number of rows on the keyboard */
#define NUMROWS 5
typedef char *Keyboard[NUMROWS] ;

extern Keyboard	*p_tab, *e_tab, *q_tab, *d_tab ;
extern int	*rowsp, *colsp, *rowse, *colse ;
extern int	rowsd[], rowsq[], colsd[], colsq[] ;

extern int	*lr_tab ;
extern Widget	keys[5][14], keyframes[5][14], shifts[2], shiftframes[2] ;
extern int	lastshift, nextshift ;

#define Spacebar "                        "

extern Widget	filterlabel ;

extern Pixmap	keytoppm25, keytoppm75, keytoppmbg ;

extern Widget	speedbox, mistakebox ;

#endif	/* _keyboard_h_ */
