/*
 * This file is for just setting up the structs, etc
 */
/* stdio SHOULD get included by Xos.h or something */
/* but it doesn't with sunos, at least */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <Xfuncs.h>
#include <Xlib.h>
#include <Xatom.h>
#include <Xutil.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xos.h>

#include "defs.h"
#include "externs.h"

/* translations[] keeps track of which kanji it is okay to test the
 *	user on. Likewise with numberofkanji, highest, and lowest.
 *	YES, it is best to keep in a large array, otherwise
 *	it would be difficult to switch between grade levels.
 */
struct translationstruct *translations[MAXKANJIALLOWED];
int numberofkanji,highest,lowest;


/* random debugging util? */
void printline(unsigned char *s)
{
	while(*s){
		putchar(*s++);
	}
	putchar('\n');
}

/* Since there is no standard util to convert hex ascii to int,...
 *  have to supply our own..
 *  It isn't incredibly efficient.. let's hope the compiler is smart.
 *  only used in readstructs()
 */
int xtoi(unsigned char * s)
{
	int out=0;
	sscanf(s,"%x",&out);
	return out;
}

/* getline:
 *	reads a line (from dictionary).
 *	returns true (1) if read aline, otherwise,
 *	returns false (0);
 *
 *	used in "readstructs", below.
 */

unsigned char instring[2][MAXLINELEN];
unsigned char *inptr=NULL;
int whichstring;

int getline(FILE *fp,unsigned char *s)
{
	if(inptr==NULL){
		inptr= &instring[0][100];
		whichstring=0;
	}
	for(;;){
		int i;
		if(inptr == &instring[whichstring][100]){
			whichstring = 1-whichstring;
			inptr=instring[whichstring];
			i=fread(instring[whichstring],1,100,fp);
			if(i<100){
				instring[whichstring][i]='\0';
				/* okay, we put the termination signal in.
				 * But if there is a complete line in there,
				 * it should be read with our buffering
				 */
			}
		}
		switch(*inptr){
			case 0:
				*s = '\0';
				return 0;
			case 10:
			case 13:
				*inptr='\0';
				*s++ = *inptr++;
				return 1;
			default:
				*s++ = *inptr++;
		}
	}
}

/* nextword:
 *	Goes to first whitespace, then sets pointer to
 *	beginning of non-white-space.
 *
 *	Returns 1 on success, 0 on fail
 */
int nextword(unsigned char **stringp)
{
	while(!isspace(**stringp)){
		if(stringp == '\0')
			return 0;
		*stringp +=1;
	}
	/* now on space */
	while(isspace(**stringp)){
		if(stringp == '\0')
			return 0;
		*stringp +=1;
	}
	return 1;
	
}

/* nextchar:
 * returns pointer to next non-whitespace char
*/
unsigned char *nextchar(unsigned char *c)
{
	while(isspace(*c)){
		if(*c == '\0') break;
		c++;
	}
	return c;
}

/* StripBrackets:
 *	Gets rid of those annoying {enlish}{english2} brackets.
 *	PRESUMES first char of source is '{'!!
 *      Well, actually, it nicely sets a null string if otherwise.
 */
void StripBrackets(char *dest,unsigned char *source)
{
	unsigned char *parse = &source[1];

	if(source[0] != '{'){
		dest[0] = '\0';
		return;
	}
	/* (*dest) is always assumed to be needing a write */

	do {
		switch(*parse){
			case '{':
				*dest++ = ':';
				*dest++ = ' ';
				break;
			case '}':
				break;
			default:
				*dest++ = *parse;				
		}
		parse++;
	} while((*parse != '\n') && (*parse != '\0'));
	*dest = '\0';
	return;
}


/* Okay, it's not actually pronunciation we're reading.
 * We are reading the "no-yoni" and "kun-yoni" interpretation
 * in kanjidic
 */
void ReadPronunciation(unsigned char **Pstring,int kanjinum)
{
	XChar2b kanabuffer[MAXLINELEN];
	XChar2b *pronunciation;
	int pronun_len;
	unsigned char *parse = *Pstring;

	pronunciation = kanabuffer;
	/* We now read stuff into kanabuffer  */

	if(*parse == '{'){
		/* only english exists,
		 *  (no kanji, even)
		 * so set to null */
		translations[kanjinum] == NULL;
		return;
	}
	
	while((*parse > 127) && (*parse != '\0')){
		/* kanjidic seems to have high bit set on
		 * Kana.. which we need to strip both of!!
		 */
		pronunciation->byte1= (*parse++ & 0x7f);
		pronunciation->byte2= (*parse++ & 0x7f);
		pronunciation++;
		/* skip space, and put in divider if
		 * second reading is there
		 */
		while(*parse == ' ') {
			parse++;
			if(*parse == '\0')
				break;
			if(*parse >127){
			   pronunciation->byte1 = 0x21;
			   pronunciation->byte2 = 0x27;
			   pronunciation++;
			}
		}
	}
	pronunciation->byte1=pronunciation->byte2 = 0;
	pronun_len = strlen((char *) kanabuffer);

	translations[kanjinum]->pronunciation =
		(XChar2b *) malloc(sizeof(char) * (pronun_len+4));
	if(translations[kanjinum]->pronunciation == NULL){
		fprintf(stderr,"Not enough memory to read in dictionary\n");
		exit(0);
	}
#ifdef NOMEMSET
	strncpy(translations[kanjinum]->pronunciation,
	         kanabuffer, pronun_len+1);
#else
	memcpy(translations[kanjinum]->pronunciation,
	       kanabuffer,sizeof(char) * (pronun_len+1));
#endif

	/* now position parse pointer for next step:
	 *  reading english
	 */
	while(*parse != '{'){
		if(*parse == '\0'){
			return;
		}
		parse++;
	}

	*Pstring = parse;
}

/* readstructs:
 *	the main dictionary reading routine.
 *	Fills in the global translationstruct with
 *	all that is available for each selected kanji, in
 *	Grade, "pronunciation", english translation, and
 *	frequency of use (by native speakers)
 */
void readstructs(){
	int i;
	unsigned char instring[MAXLINELEN];
	FILE *fp;
	char command_string[100];
	int namelen;/* length of filename, and flag */
	int extlen;

	if(access(dictname,R_OK)!= 0){
		fprintf(stderr,"Cannot open dict file %s\n",dictname);
		exit(0);
	}
#ifdef UNCOMPRESS

	namelen = strlen(dictname);
	extlen = strlen(UNCOMPRESSEXT);
	if(strncmp(&dictname[namelen-extlen],UNCOMPRESSEXT,extlen) != 0 ){
		namelen = 0;/* flag for later on */
		fp = fopen(dictname,"r");
	} else {
		sprintf(command_string,"%s %s",UNCOMPRESS,dictname);
		fp = popen(command_string,"r");
	}
#else
	fp = fopen(dictname,"r");
#endif /* UNCOMPRESS */
	if(fp == NULL){
		perror("cannot open kanji translation file");
		fprintf(stderr,"Looking for %s\n",dictname);
#ifdef UNCOMPRESS
		if(namelen >0)
			fprintf(stderr,"Using uncompression method \"%s\"\n",
				UNCOMPRESS);
#endif
		exit(0);
	}

	printf("opened dictionary %s \n",dictname);
	lowest = highest = 0;
	
#ifdef NOMEMSET
	for(i=MINKANJIALLOWED;i<MAXKANJIALLOWED;i++)
		translations[i] = (void *) NULL;
#else
	memset(translations,0,sizeof(struct translationstruct *) * MAXKANJIALLOWED);
#endif
	while (getline(fp,instring) != 0) {
		int Kanji;
		int freq,grade;
		unsigned char *parse;
		int instrlen;	/* length of pronunciation */

		if(strlen(instring) <10) continue;

		/*try to get kanji Index right away */
		Kanji = xtoi(&instring[2]);


		/* skip comments, and kanji not specified in
		 * the usefile
		 */	
		if(Kanji < MINKANJIALLOWED) {
			continue;
		}

		parse = &instring[2];
		if(parse == NULL){
			continue;
		}
		/* now parse for grade level, frequency, and english */
		freq = grade = 0;

		nextword(&parse);
		/* check for high bit set, which means
		 * start of kana definition of kana
		 */
		/* used to have (*parse != '{')  */
		while ( (*parse < 127)  && (*parse != '{') ) {
			
			switch(*parse){
				case 'G':
					grade = atoi(++parse);
					break;
				case 'F':
					freq = atoi(++parse);
					break;
				default:
					break;
			}
			nextword(&parse);
		}
		
		
		/**********************************************
		 *  Now we know that we have a useable/wanted *
		 *  dictionary definition                     *
		 *********************************************/
		if((lowest==highest) && (highest==0)){
			lowest = highest = Kanji;
		} else{
			if(Kanji < lowest) lowest = Kanji;
			if (Kanji > highest) highest = Kanji;
		}
		
		translations[Kanji] = (struct translationstruct *)
			malloc(sizeof(struct translationstruct));
		if (translations[Kanji] == NULL){
			perror("Cannot allocate memory for translation table\n");
			exit(errno);
		}
		translations[Kanji]->frequency = freq;
		translations[Kanji]->grade_level = grade;

		ReadPronunciation(&parse,Kanji);
		/*
		 * translations[Kanji]->pronunciation[0].byte1=0;
		 * translations[Kanji]->pronunciation[0].byte2=0;
		 */


		instrlen = strlen(parse)+1;
		translations[Kanji]->english = (char *) malloc(instrlen);
		if(translations[Kanji]->english == NULL){
			perror("Cannot allocate memory for translation table\n");
			exit(errno);		
		}

		StripBrackets(translations[Kanji]->english,parse);

	} /* and repeat until end of file */
#ifdef UNCOMPRESS
	if(namelen >0)
		pclose(fp);
#endif	

	fclose(fp);
}

