#include <stdlib.h>
#include <stdio.h>

#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Shell.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Composite.h>
#include "defs.h"
#include "externs.h"

#include "icon.xbm"

Boolean useKanji[MAXKANJIALLOWED];
int lowfrequency,highfrequency;
XFontStruct *largekfont;
XFontStruct *smallkfont;
XFontStruct *fixedfont;


/*
 * We  must have these resources set!!
 *
 * ( Note the similarity between this stuff and optionDescList[].
 *   coincidence? I think not :-)
 */
static char *fallback[] = {
	"KDrill.notallT:  0",
	"KDrill.noBell:		0",
	"KDrill*nousefile:	0",
	"KDrill*usefile:	.kanjiusefile", 
	DICTLOCATION,
	"KDrill*kanjifont:	kanji24",
	"KDrill*smallkanji:	kanji16",
	"KDrill*font:		fixed",
	"KDrill*gradelevel:	0",
	"KDrill*showkana:	0",
	"KDrill*lowfrequency:	0",
	"KDrill*highfrequency:	0",
	"KDrill*logfile:	none",
	NULL
};

/* command line arguments should set the appropriate resources.. so we can
 * pull them out when wanted
 */
static XrmOptionDescRec optionDescList[] = {
	{"-notallT",	".notallT",XrmoptionNoArg,"1"},
	{"-usefile",	".usefile",	XrmoptionSepArg,(caddr_t) NULL},
	{"-nousefile",  ".nousefile",	XrmoptionNoArg, "1"},
	{"-dictfile",	".dictfile",	XrmoptionSepArg,(caddr_t) NULL},
	{"-font",	".font",	XrmoptionSepArg,(caddr_t) NULL},
	{"-kanjifont",	".kanjifont",	XrmoptionSepArg,(caddr_t) NULL},
	{"-smallkanji",	".smallkanji",	XrmoptionSepArg,(caddr_t) NULL},
	{"-noBell",     ".noBell",	XrmoptionNoArg, "1"},
	{"-guessmeaning",".guessmeaning",XrmoptionNoArg,"1"},
	{"-showkana",   ".showkana",    XrmoptionNoArg,"1"},
	{"-showinorder",   ".showinorder",    XrmoptionNoArg,"1"},
	{"-gradelevel", ".gradelevel",  XrmoptionSepArg,(caddr_t) NULL},
	{"-lowfrequency",	".lowfrequency",XrmoptionSepArg,(caddr_t) NULL},
	{"-highfrequency",	".highfrequency",XrmoptionSepArg,(caddr_t) NULL},
	{"-logfile",	".logfile",	XrmoptionSepArg,(caddr_t) NULL},
	
	
};



/* initgc:
 *	Initialises global gc values.
 *      We don't really need this any more. But
 *	GC's are good to have, I suppose.
 */
void initgc(){

	gc =  XCreateGC(display,mainwindow,0,NULL);
	cleargc = XCreateGC(display,mainwindow,0,NULL);

	XSetForeground(display,gc,black);
	XSetBackground(display,gc,white);
	XSetForeground(display,cleargc,white);
	XSetBackground(display,cleargc,black);

}

/* getusefile:
 *	Gets a "usefile", to abridge the full dictionary.
 *	If possible, will get it from the user's home directory,
 *	otherwise, tries current directory
 */
FILE *getusefile(){
	FILE *f;
	char *homedir;
	char fullname[100];

	if(usefile == NULL) return NULL;
	fullname[0] = '\0';
	if(strncmp(usefile,"~/",2) == 0) {
		homedir = (char *) getenv("HOME");
		if(homedir == NULL){
			perror("Cannot expand '~' char. no HOME env. varriable");
			exit(0);
		}
		sprintf(fullname,"%s%s",homedir,&usefile[1]);
	} else {
		strcpy(fullname,usefile);
	}

	if((f = fopen(fullname,"r")) == NULL){
		printf("%s does not exist. Using entire dictionary...",
		         fullname);
		usefile = NULL;
	} else {
		printf("using \"%s\" to abridge dictionary\n",fullname);
		if(!useUsefile)
			puts("(-nousefile option used. Will not abridge, unless requested.)");
	}
	return f;
}

/* inituse:
 *
 *	revamped from 2.9.3 version.
 *	We now have a dedicated useKanji[] array.
 *
 *	Either set all useKanji elements to 1, or
 *	zero out, and set to specifications of usefile contents.
 *
 */

void inituse(){
	FILE *f;
	int i;
	char inbuf[100];

	f = getusefile();


#ifdef NOMEMSET
	if(usefile == NULL){
		usefilecallback(usefilebutton,NULL,NULL);
		i = MINKANJIALLOWED;
		while(i<MAXKANJIALLOWED){
			useKanji[i++] = 1;
		}
		return;
	} else {	/* set all to UNREADABLE, for now */
		i = MINKANJIALLOWED;
		while(i<MAXKANJIALLOWED){
			useKanji[i++] = 0;
		}
#else

	if(usefile == NULL){
		usefilecallback(usefilebutton,NULL,NULL);
		memset(useKanji,1,sizeof(Boolean[MAXKANJIALLOWED]));
		return;
	} else {	/* set all to UNREADABLE, for now */
		memset(useKanji,0,sizeof(Boolean[MAXKANJIALLOWED]));
	}
#endif

	while(fgets(inbuf,99,f) != NULL){
		int usechar;
		usechar = xtoi(inbuf);
		if( usechar<MAXKANJIALLOWED)
			useKanji[usechar] = 1;
	}
}


/* initstuffs:
 *	calls the various init routines to setup
 *	GCs, fonts, dictionaries, and widgets
 *	(But initializing the translations is done later)
 */

static Pixmap iconpixmap;

void initstuffs(int *argc,char *argv[])
{
	char tempnumber[10];
	/*XWMHints wmhints;*/

	srand48 (time(NULL));

	toplevel = XtVaAppInitialize(&Context,"KDrill",
 				   optionDescList,XtNumber(optionDescList),
 				   argc,argv,
				   fallback,
 				   NULL,NULL);

	if(*argc >1){
		usage();
	}

	/* Get command line options... yeah, we should do this in a
	 *  struct, in one go... but some things need to be initalized
	 * later
	 */
	switchKanaEnglish = !GetXtBoolean("notallT","NotallT");
	useUsefile = !GetXtBoolean("nousefile","Nousefile");
	doBell = !GetXtBoolean("noBell","NoBell");
	showinorder = GetXtBoolean("showinorder","Showinorder");
	if(GetXtBoolean("guessmeaning","Guessmeaning"))
		Kanji2English = GUESSMEANING;

	lowfrequency = GetXtNumber("lowfrequency","Lowfrequency");
	if((lowfrequency <0) || (lowfrequency >=MAXKANJIALLOWED))
		lowfrequency = 0;
	highfrequency = GetXtNumber("highfrequency","Highfrequency");
	if((highfrequency <0) || (highfrequency >=MAXKANJIALLOWED))
		highfrequency = 0;

	GetXtString("gradelevel","Gradelevel",tempnumber);
	parsegrades(tempnumber);
	

	/* display variable initialized in here */
	MakeWidgets();

	XtRealizeWidget(toplevel);
	mainwindow = XtWindow(form);

	iconpixmap = XCreateBitmapFromData(display,mainwindow,
					   icon_bits,icon_width,icon_height);

	XtVaSetValues(toplevel,XtNiconName,"kdrill",
				XtNiconPixmap,iconpixmap,
				NULL);
#ifdef OLDWAY
wmhints.icon_pixmap = iconpixmap;
	wmhints.flags = IconPixmapHint;

	XSetWMProperties(display,mainwindow,"kdrill","kdrill",
			NULL,NULL, /* argv,argc */
			NULL,&wmhints,NULL); /* size, wmhints, classhints */
#endif /* OLDWAY */


	white = WhitePixel(display,0);
	black = BlackPixel(display,0);
	initgc();
	
}

/* initlog
 *	sets up logfile, if "-logfile filename" option is used
 */

void initlog(){
	char logname[200];

	logfile = NULL;

	GetXtString("logfile","Logfile",logname);
	if(strcmp(logname,"none") != 0){
		if(strcmp(logname,"NOT SET") == 0){
			fprintf(stderr,"logname not set?\n");
			return;
		}
		logfile = fopen(logname,"w");
		if(logfile == NULL){
			fprintf(stderr,"Could not open logfile %s\n",logname);
		} else {
			fprintf(logfile,"#\n#Logfile of mistakes made in kdrill\n");
			fprintf(logfile,"#   This file can be used directly as a usefile\n");
			fprintf(logfile,"#        (provided there are more than 8 different first numbers)\n");
			fprintf(logfile,"#   Lines with same first numbers only count as one entry\n");
			fprintf(logfile,"#   Syntax of logfile is:\n");
			fprintf(logfile,"# Realkanji -> Guessedkanji\n");			
		}
	}
}
