#include <stdio.h>

#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Xaw/Box.h>
#include <Xaw/AsciiText.h>
#include "defs.h"
#include "externs.h"

Widget toplevel,form;
Widget kanjiform,englishform,buttonform;

Widget quitbutton,statusline;
Widget orderbutton,usefilebutton;
Widget currentkanjiForm,currentkanjiGrade,currentkanjiFreq,currentkanjiNum;

Widget kanjimode,englishmode,togglekana;
Widget englishWidget[NUMBEROFCHOICES],kanjiWidget[NUMBEROFCHOICES];

/* Assume "True" == 1 !! */
char * orderlabel[2] = {
	"Showing randomly",
	"Showing in order",
};
char * usefilelabel[2] = {
	"No    Usefile",
	"Using Usefile",
};

void ordercallback(Widget w,XtPointer data,XtPointer calldata){
		   showinorder = !showinorder;
		   XtVaSetValues(w,XtNlabel,orderlabel[(int) showinorder],NULL);
		   switch(showinorder){
			case 0:
				setstatus("Will now select kanji randomly");
				break;
			case 1:
				setstatus("Will now go through kanji in order of #");
				break;


		   }
		   return;
}
		   
void usefilecallback(Widget w,XtPointer data,XtPointer calldata){
	char statbuff[300];
		   switch(useUsefile){
			case 1:
				useUsefile = 0;
				if(usefile != NULL)
					setstatus("Will now ignore usefile");
				break;
			case 0:
				if(usefile == NULL){
					setstatus("No usefile to use");
					break;
				}
				useUsefile = 1;
				sprintf(statbuff,"now using usefile %s",
					usefile);
				setstatus(statbuff);
				break;
		   }
		XtVaSetValues(w,XtNlabel,usefilelabel[(int) useUsefile],NULL);
		   return;
}
		   

/* DescribeCurrent()
 *	Sets labels to display difficulty of
 *	Current "true" kanji"
 */
void DescribeCurrent(kanjinum)
int kanjinum;
{
	char gradelabel[10],freqlabel[10],numlabel[10];



	if(translations[kanjinum]->grade_level !=0){
		sprintf(gradelabel,"G: %4d",translations[kanjinum]->grade_level);
	} else {
		sprintf(gradelabel,"G:     ");
	}
	if(translations[kanjinum]->frequency !=0){
		sprintf(freqlabel,"F: %4d",translations[kanjinum]->frequency);
#ifdef DEBUG
	printf("Describing %x\n",kanjinum);
	printf("Freqnum %d\n",translations[kanjinum]->frequency);
#endif

	} else {
		sprintf(freqlabel,"F:     ");
	}
	sprintf(numlabel,"#: %4x",kanjinum);

	XtVaSetValues(currentkanjiGrade,XtNlabel,gradelabel,NULL);
	XtVaSetValues(currentkanjiFreq,XtNlabel,freqlabel,NULL);
	XtVaSetValues(currentkanjiNum,XtNlabel,numlabel,NULL);
}


/* MakeKanjiButtons()
 *  set up kanji button widgets at initialization
 */
void MakeKanjiButtons(){
	int i;
	/* make KANJI buttons */
	for(i=0;i<NUMBEROFCHOICES;i++){
		char labl[20];
		sprintf(labl,"kanji%d",i);

		if(i==0){
		    kanjiWidget[i]=XtVaCreateWidget(
			labl,commandWidgetClass,kanjiform,
			XtNlabel,"",
			XtNwidth,50, XtNheight,50,
			XtNshapeStyle,XawShapeOval,
			XtNencoding,XawTextEncodingChar2b,
			XtNfont,largekfont,
			NULL);
		} else {
		    kanjiWidget[i]=XtVaCreateWidget(
			labl,commandWidgetClass,kanjiform,
			XtNlabel,"",
			XtNwidth,50, XtNheight,50,
			XtNshapeStyle,XawShapeOval,
			XtNencoding,XawTextEncodingChar2b,
			XtNfont,largekfont,
			XtNfromHoriz,kanjiWidget[i-1],
			NULL);
		}
		XtAddCallback(kanjiWidget[i],XtNcallback,kanjicallback,(XtPointer)i);
	}
	XtManageChildren(kanjiWidget,4);

	/* * * * * * * * * * * * * * * * * * * * * * *
	 * THE REST of the widgets are for the
	 * "current kanji" window
	 */
	currentkanjiForm = XtVaCreateManagedWidget(
			"curkanjiForm",boxWidgetClass,kanjiform,
			XtNhorizDistance,40,
			XtNright,XawChainRight,XtNleft,XawChainRight,
			XtNfromHoriz,kanjiWidget[NUMBEROFCHOICES-1],NULL);
	currentkanjiGrade = XtVaCreateManagedWidget(
			"curkanjiGrade",labelWidgetClass,currentkanjiForm,
			XtNlabel,"G:     ",
			NULL);
	currentkanjiFreq = XtVaCreateManagedWidget(
			"curkanjiFreq",labelWidgetClass,currentkanjiForm,
			XtNlabel,"F:     ",
			XtNfromVert,currentkanjiGrade,
			NULL);
	currentkanjiNum = XtVaCreateManagedWidget(
			"curkanjiNum",labelWidgetClass,currentkanjiForm,
			XtNlabel,"#:     ",
			XtNfromVert,currentkanjiFreq,
			NULL);
}
/* MakeEnglishButtons:
 * Just that. initialize the english buttons that display the possible
 * guesses.
 */
void MakeEnglishButtons(){
	int i;
	for(i=0;i<NUMBEROFCHOICES;i++){
		char labl[20];
		sprintf(labl,"english%d",i);

		if(i==0){
		   englishWidget[0]=XtVaCreateWidget(
			labl,commandWidgetClass,englishform,
			XtNwidth,FULLWIDTH,
			XtNright,XawChainRight,
			XtNleft,XawChainLeft,
			XtNfont,fixedfont,
			XtNshapeStyle,XawShapeRoundedRectangle,
			XtNcornerRoundPercent,50,
			NULL);
		} else {
		   englishWidget[i]=XtVaCreateWidget(
			labl,commandWidgetClass,englishform,
			XtNwidth,FULLWIDTH,
			XtNright,XawChainRight,
			XtNleft,XawChainLeft,
			XtNfont,fixedfont,
			XtNshapeStyle,XawShapeRoundedRectangle,
			XtNcornerRoundPercent,50,
		/***/	XtNfromVert,englishWidget[i-1],
			NULL);
		}
		XtAddCallback(englishWidget[i],XtNcallback,englishcallback,(XtPointer) i);

	}
	XtManageChildren(englishWidget,4);
}

void initfonts(){
	char LargeKname[100],SmallKname[100],Fixedname[100];

	GetXtString("kanjifont","Kanjifont",LargeKname);
	GetXtString("smallkanji","Smallkanji",SmallKname);
	GetXtString("font","Font",Fixedname);

#ifdef DEBUG
	printf("kanjifont from resources is \"%s\"\n",LargeKname);
	printf("smallkanjifont from resources is \"%s\"\n",SmallKname);
	printf("regular font from resources is \"%s\"\n",Fixedname);
#endif
	largekfont = XLoadQueryFont(display,LargeKname);
	smallkfont = XLoadQueryFont(display,SmallKname);
	fixedfont  = XLoadQueryFont(display,Fixedname);
	if(largekfont == NULL){
		fprintf(stderr,"could not load large kanji font\n");
		exit(0);
	}
	if(smallkfont == NULL){
		fprintf(stderr,"could not load small kanji font\n");
		exit(0);
	}
	if(fixedfont == NULL){
		fprintf(stderr,"could not load english font??\n");
		exit(0);
	}
	

}

/* Accelerator()
 *	a jumping-off point for keyboard accelerators
 */
void Accelerator(Widget w,XEvent *event,String *params,Cardinal *num_params){
	int int_store;
	char *param = *params;
	
	if(*num_params <1){
		puts("Warning: Accelerator function must have one argument!");
		return;
	}
	if(*num_params >1){
		printf("Warning: Accelerator functions take one argument, and one only\n");
	}
	switch(param[0]){
		case 'k':
			ChangeMode(NULL,(XtPointer) GUESSKANJI,NULL);
			break;
		case 'm':
			ChangeMode(NULL,(XtPointer) GUESSMEANING,NULL);
			break;
		case 'e':
			ChangeMode(NULL,(XtPointer) TOGGLEKANA,NULL);
			break;
		case 'c':
			cheatcallback(NULL,NULL,NULL);
			break;
		case 'o':
			ordercallback(orderbutton,NULL,NULL);
			break;
		case 'u':
			usefilecallback(usefilebutton,NULL,NULL);
		case 'S':
			param+=1;
			int_store = (*param)-'0';
			GradeCallback(gradeButtons[int_store],
				      (XtPointer) int_store,NULL);
			break;				      
	}
}

static char *guessAccel = " \
  Ctrl<Key>q:	quit()\n \
  None<Key>1:		guess-meaning(0)\n \
  None<Key>2:		guess-meaning(1)\n \
  None<Key>3:		guess-meaning(2)\n \
  None<Key>4:		guess-meaning(3)\n \
  <Key>k:		Accelerator(k)\n \
  <Key>m:		Accelerator(m)\n \
  <Key>e:		Accelerator(e)\n \
  <Key>c:		Accelerator(c)\n \
  <Key>o:		Accelerator(o)\n \
  <Key>u:		Accelerator(u)\n \
  Shift<Key>a:		Accelerator(S0)\n \
  Shift<Key>1:		Accelerator(S1)\n \
  Shift<Key>2:		Accelerator(S2)\n \
  Shift<Key>3:		Accelerator(S3)\n \
  Shift<Key>4:		Accelerator(S4)\n \
  Shift<Key>5:		Accelerator(S5)\n \
  Shift<Key>6:		Accelerator(S6)\n \
  Shift<Key>+:		Accelerator(S7)\n \
  "; 

static XtActionsRec kdrillActionList[] = {
	{ "quit",		quit},
	{ "update-frequency",	UpdateFrequency},
	{ "guess-meaning",	Guessvalue},
	{ "Accelerator",	Accelerator},
};
	
/* MakeWidgets()
 *	highest level routine for making ALL the widgets.
 */

void MakeWidgets(){
	XtAccelerators AllAccel;
	Widget cheatbutton; /* we don't need this saved.. */
#ifdef DEBUG
puts("Starting MakeWidgets");
#endif

	/* I suppose I shouldn't hard-code window-width and height..
		but it makes things easier for now.
	*/
	form = XtVaCreateManagedWidget("kdrill",formWidgetClass,
					   toplevel,
		      XtNx,200, XtNy,100,
		      XtNvSpace,16,
		      XtNhSpace,10,
		      NULL);
	kanjiform = XtVaCreateManagedWidget("kdrill",formWidgetClass,
					   form, NULL);

	display = XtDisplay(toplevel);

	initfonts();

	MakeKanjiButtons();

	englishform = XtVaCreateManagedWidget("kdrill",formWidgetClass,form,
					     XtNfromVert,kanjiform,
					   NULL);
	MakeEnglishButtons();

	buttonform = XtVaCreateManagedWidget("kdrill",formWidgetClass,form,
					     XtNfromVert,englishform,
					    NULL);



	kanjimode = XtVaCreateManagedWidget(
			"kanjimode",commandWidgetClass, buttonform,
			XtNlabel,"Guess kanji",
			/*XtNfromVert,statusline,*/
			XtNvertDistance,8,
			XtNshapeStyle,XawShapeOval,
			XtNwidth,BUTTONSWIDTH,
			NULL);

	englishmode = XtVaCreateManagedWidget(
			"englishmode",commandWidgetClass, buttonform,
			XtNlabel,"Guess Meaning",
			XtNfromVert,kanjimode,
			XtNshapeStyle,XawShapeOval,
			XtNwidth,BUTTONSWIDTH,
			NULL);

	togglekana = XtVaCreateManagedWidget(
			"togglekana",commandWidgetClass,buttonform,
			XtNlabel,"English/Kana",
			XtNshapeStyle,XawShapeOval,
			XtNfromVert,englishmode,
			XtNwidth,BUTTONSWIDTH,
			NULL);



	orderbutton = XtVaCreateManagedWidget("order",commandWidgetClass,buttonform,
			XtNlabel,orderlabel[(int) showinorder],
			XtNvertDistance,8,
			XtNfromVert,togglekana,
			XtNwidth,BUTTONSWIDTH,
			NULL);
	usefilebutton = XtVaCreateManagedWidget("usefile",commandWidgetClass,buttonform,
			XtNlabel,usefilelabel[(int) useUsefile],
			XtNfromVert,orderbutton,
			XtNwidth,BUTTONSWIDTH,
			NULL);


	quitbutton = XtVaCreateManagedWidget("quit",commandWidgetClass,buttonform,
			XtNlabel,"quit",
			XtNvertDistance,10,
			XtNfromVert,usefilebutton,
			XtNshapeStyle,XawShapeEllipse,
			NULL);
	cheatbutton = XtVaCreateManagedWidget("cheat",commandWidgetClass,buttonform,
			XtNfromHoriz,quitbutton,
			XtNvertDistance,10,
			XtNfromVert,usefilebutton,
			NULL);

	statusline = XtVaCreateManagedWidget("status",labelWidgetClass,
					     buttonform,
		      XtNlabel,"Welcome to kanjidrill",
		      XtNwidth,FULLWIDTH,
		      XtNborderWidth,2,
		      XtNvertDistance,STATUSDISTANCE,
		      XtNfromVert,quitbutton,
		      XtNresize,True,
		      NULL);

	MakeGradeSelect();
	MakeFrequency();

	XtAddCallback(kanjimode,XtNcallback,ChangeMode,(XtPointer) GUESSKANJI);
	XtAddCallback(englishmode,XtNcallback,ChangeMode,(XtPointer) GUESSMEANING);
	XtAddCallback(togglekana,XtNcallback,ChangeMode,(XtPointer) TOGGLEKANA);
	XtAddCallback(quitbutton,XtNcallback,quit,NULL);
	XtAddCallback(cheatbutton,XtNcallback,cheatcallback,NULL);
	XtAddCallback(orderbutton,XtNcallback,ordercallback,NULL);
	XtAddCallback(usefilebutton,XtNcallback,usefilecallback,NULL);

	XtAppAddActions(Context,kdrillActionList,XtNumber(kdrillActionList) );
	AllAccel = XtParseAcceleratorTable(guessAccel);
	XtAugmentTranslations(form,AllAccel);
#ifdef DEBUG
puts("Ending MakeWidgets");
#endif
}
