
#include <stdio.h>
#include <stdlib.h>

#include <Xlib.h>
#include <Xatom.h>
#include <Xutil.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Composite.h>

#include "defs.h"
#include "externs.h"
#include "patchlevel.h"

static char *version = VERSION;

Display *display;
int screen;
Window mainwindow,rootwindow;
GC gc,cleargc;
XtAppContext Context;

char *dictname=NULL;
char *usefile=NULL;
FILE *logfile;

XChar2b *kstring;
XChar2b onecharstring;

unsigned long white,black;



/* quitbutton, of course */
void quit(Widget w,XtPointer data,XtPointer calldata)
{
#ifdef DEBUG
	puts("quitting?");
#endif
	XtCloseDisplay(display);
	if(logfile != NULL)
		fclose(logfile);
	exit(0);
}


void usage(){
	printf(" kdrill    --  %s\n",version);
	fflush(stdout);
	puts("A program to drill on kanji to english, or vica versa");
	puts("");
	puts("Options:");
	puts("  -usefile usefilename         Changes abridgement file of dictionary");
	puts("  -nousefile                   Do not abridge initially");
	puts("  -dictfile dictfilename       Changes dictionary file from");
	puts("                               \"kanjidic\" to some other file");
	puts("  -font fontname               Changes english font");
	puts("  -kanjifont Kanjifontname     Changes LARGE kanji font");
	puts("  -smallkanji Kanjifontname    Changes small kanji font");
	puts("  -noBell                      Turns off beep for incorrect answer");
	puts("  -guessmeaning                Starts off with four kanji to one meaning");
	puts("  -notallT                     Allow non-complete dictionary entries.");
	puts("                                  warning: consult man-page.");
	puts("  -showkana                    Start showing kana meanings instead of english");
	puts("  -showinorder                 Go through kanji in order of #, NOT randomly");
	puts("  -gradelevel                  Define while grades should be used.");
	puts("                                use any or all of \"123456+\"");
	puts("   -lowfrequency               Lowest frequency kanji you wish to see.");
	puts("   -highfrequency              Highest frequency kanji you wish to see");
	puts("                  (\"1\" is HIGH, \"2000\" is low)");
	puts("   -logfile filename           Store wrong answers in filename");
	puts("");
	puts("       The above options can also be set as resources,");
	puts("       with the same name as their optionflag");
	puts("");
	exit(0);
}


void Beep(){
	if(doBell)
		XBell(display,100);
}
/* GetXtNumber(), GetXtBoolean(), GetXtString():
 *	Not the "best way" to get resources...
 *	supposed to read them all in at one go.
 *	But I had reasons for reading things in at different times,
 *	and I have stuck to that model
 */

/* GetXtString:
 *	Given the resource name and class, will
 *	 copy the resource string value to
 *	 destinationstring address.
 *	Destination must be MALLOCED ARRAY!!!
 *
 *	Default value of string is "NOT SET".
 *	This is used by initlog()
 *	This should actually be encountered. I provide default values for
 *	all resource strings used.
 */
void GetXtString(char *name,char *class,char *destinationstring)
{
	char resourcename[100],resourceclass[100];
	char buffer[100];
	char *returnstring = buffer;
	

	XtResource resourceList ={
		NULL,NULL,
		XtRString,sizeof(char *),0,
		XtRString,"NOT SET"
	};
	resourceList.resource_name = resourcename;
	resourceList.resource_class = resourceclass;

	strcpy(resourcename,name);
	strcpy(resourceclass,class);

	XtGetApplicationResources(toplevel,&returnstring,
				  &resourceList,1,
				  NULL,0);
	strcpy(destinationstring,returnstring);
}

/* GetXtNumber:
 *	Given resource name and and class, will attempt to look up
 *	resource value in database.
 *	Will return default of 0!!!
 */
int GetXtNumber(char *name,char *class)
{
	char resourcevalue[100];

	GetXtString(name,class,resourcevalue);
	return atoi(resourcevalue);
}
/* GetXtBoolean()
 *	see GetXtNumber.
 *
 *	default of False
 */
Boolean GetXtBoolean(char *name,char *class)
{
	Boolean resourcevalue;
	char resourcename[100],resourceclass[100];

	XtResource resourceList ={
		NULL,NULL,
		XtRBoolean,sizeof(Boolean),0,
		XtRBoolean,False,
	};
	resourceList.resource_name = resourcename;
	resourceList.resource_class = resourceclass;

	strcpy(resourcename,name);
	strcpy(resourceclass,class);

	XtGetApplicationResources(toplevel,&resourcevalue,
				  &resourceList,1,
				  NULL,0);
	return resourcevalue;
}


int main(int argc,char *argv[])
{

	char usefilename[100],dict[200];

	puts("kdrill: Starting up... please wait a while.");
	fflush(stdout);

	/* Widgets get made down in initstuffs()... */
	/* also, resources get called */
	initstuffs(&argc,argv);


	GetXtString("usefile","Usefile",usefilename);
	GetXtString("dictfile","Dictfile",dict);
	dictname = dict;
	usefile = usefilename;

#ifdef DEBUG
	puts("");
	printf("usefile from resources is \"%s\"\n",usefilename);
	printf("dictfile from resources is\" %s\"\n",dictname);
#endif

	/* check for abridgements of the dictionary... */
	inituse();
	/* and actually read in structs of dictionary */
	readstructs(&argc,argv);

	initlog();
	showEnglish = ! GetXtBoolean("showkana","Showkana");
	CountKanji();
	if(numberofkanji<8){
		fprintf(stderr,"There are two few kanji readable in the current configuration\n");
		fprintf(stderr,"Please either reconfigure your usefile, or raise the grade level\n");
		exit(0);
	}

	
	SetupGuess();
	XtAppMainLoop(Context);
	return 0;
}
