.\" kdrill.1 93/10/19
.TH KDRILL 1 "8th March, 1994" "Phil\'s Software"
.SH NAME
kdrill v3.1 \- drill program for kanji chars under Xwindows (X11R5)
.SH OPTIONS

.TP
.B \-usefile \fINewUsefileName\fR
Change usefile.
.TP
.B \-nousefile
Still read in usefile, but ignore it at startup.
.TP
.B \-dictfile \fIOtherKanjidicFile\fR
Change dictionary file name
.TP
.B \-font \fIFontName\fR
Change main english font.
.TP
.B \-kanjifont \fIKanjiFontName\fR
Change large kanji font.
.TP
.B \-smallkanji \fIKanjiFontName\fR
Change small kanji/kana font.
.TP
.B \-noBell 
turns off beep on wrong answer.
.TP
.B \-guessmeaning 
start with one meaning and four kanji to guess from.
.TP
.B \-showinorder
start in ordered mode. Go through desired kanji in order.
.TP
.B \-gradelevel \fI<level #s>\fR
start with different grade levels enabled. [123456+]
.TP
.B \-showkana
start with kana meanings instead of english.
.TP
.B \-lowfrequency #, \-highfrequency #
set lowest and/or highest frequency kanji you want to see.
.TP
.B \-logfile filename
writes a list of wrong answers to file "filename".
.TP
.B \-notallT
don't insist that all dictionary entries have kana AND english.
\fBWARNING!\fR Normal operation is to ignore incomplete entries, and
thereby enable switching from kana to english without changing the quiz
kanji. Using this option will make kdrill move to another kanji if you
switch kana to English or vica versa.
 \[note: default behaviour currently loses 300 kanji, with the kanjidic
file I have currently. All characters with Frequency ratings have full
translations. \]

.SH RESOURCES
All the above options can be set in a resource file, with the same names
as the flags. See the sample "KDrill" file for more detail, which is
normally installed in /usr/lib/X11/app-defaults.

.SH DESCRIPTION

.B kdrill
is a program to drill users on meanings of kanji characters. Various
formats of drills are available:

.RS 5
   kanji to english
   kanji to kana
   english to kanji
   kana to kanji
.RE

.SH PLAYING
kdrill will present you with either four kanji and one meaning, or one
kanji and four meanings [depending on how you configure it]. Click on one
of the group of four to see how well you know the lone kanji or meaning.
You may also use the "1", "2", "3", and "4" keys to make your choice.

.SH DETAILS OF CONFIGURATION
kdrill will use the "kanjidic" file to interpret many of the various
16-bit kanji chars in the
.I kanji24
font supplied with the X11R5 distribution. It checks for a file by the name of
.B ".kanjiusefile"
in the current directory, although this name can be changed either with
the '-usefile' option, or in a resource file.

.I kanjidic
subdivides its entries into grade levels, and frequency ratings. Grade
levels are similar to school grade levels, but more compressed. For
kdrill's purposes, grade levels start at 1, and increase to 6. There are
many kanji that do not have a grade level, due to their infrequency of
use. These are denoted by the "+" character in the grade select window.

The user can restrict the range of kanji to drill on in different, yet
compatible, ways. The first way is to make a ".kanjiusefile" (described below),
with a an explicit list of desired kanji. 

Other ways to limit the range of the drill are to change the
gradelevel, or set a frequency limit.  This can be done by either
clicking buttons in the "Grade Select" window, or entering a value in the
"Frequency Range" section.

Changes you make to the "Grade Select" window or the "Frequency Range"
section will not do anything until you supply the correct match to the
current drill-question (or press the english/kana button).

Any grade level or frequency rating the current kanji has will be
displayed in the top right hand side of the window, next to the "G:" and
"F:" letters. The kanji number will be displayed \fIin
hexadecimal\fR(base 16) after the "#:" sign. It is displayed in
hexadecimal because that is what kanjidic, xfd, and the usefile display.
The frequency  and grade numbers are in decimal.

.SH ORDER
It is possible to be drilled on kanji in order, without repetition until
"all" kanji have been covered. Any restrictions on grade level or
frequency will still apply. To enable or disable ordering, click on the
"Showing randomly" (or "Showing in order") button. You may use the 'o'
key instead, if you wish.

\fINote that "in order" does not mean in order of frequency.\fR It means
in the order represented by the dictionary, denoted by the '#' number
shown at top right.

.SH GRADE SELECT
You may specify which grade levels you wish to study, by clicking on the
buttons labeled: "1", "2", "3", "4", "5", "6", "+", or "All", in the
"Grade Select" window. You may also select/unselect a grade by holding
down shift, followed by "1", "2", "3", "4", "5", "6", "+", or "a".

The "All" feature will select all grades. but it will not unselect them.

The default is to have all the grades enabled.


.SH FREQUENCY RANGE
As mentioned above, some kanji have frequency ratings. The frequency of
the true answer you are guessing will be displayed in the top right
window, next to the "F:" sign, if a frequency rating exists.

The frequency range window allows you to limit the kanji you see based
on their frequency rating. The frequency range window consists of two
subwindows, "High", and "Low". 
.I High
means a kanji that is high frequency. That is to say, something that is
used often. According to the definitions of the dictionary, "1" means the
kanji that is used the 
.I most
often. Setting a number in the "High" window, means that you will see no
kanji that is of higher frequency than that number. Similarly, setting a
number in the "Low" window means that you will see no kanji of frequency
lower than that number.

A "0" (or a blank) in a subwindow indicates no limit in the field.


.SH USEFILES

A usefile consists of a list of hex numbers; one per line, no
initial spaces allowed. A usefile makes the program only use particular
kanji, instead of the thousands possible in the dictionary. It is
possible to add comment lines by having the very first character of a
line be "#". It is also possible to add english reminders after the number
on each line, so you remember what each number is.
Hex numbers can be checked or found by using the "xfd" util on the
"kanji24" font. 

Grade restrictions will apply to ALL kanji selected, even if you have a
usefile. Thus, if all your usefile-defined kanji are of grade 4 or
higher, and you have only selected grades 3 and lower, kdrill will
complain that there are not enough kanji available, and attempt to
add viewable grade levels.

If you wish kdrill to ignore your usefile at first, you may use the
\-nousefile option. You can also change whether the program uses your usefile
interactively while the program is running.

.SH LOGFILES
You can store a list of your incorrect answers with the -logfile option.
That file can then be used the next time you run kdrill, as a usefile!

If you wanted to be efficient, and make a usefile with non-redundant
entries, you could do the following:

  (edit out the initial comments, then..)
   awk '{print $1}' logfile | sort | uniq

If you wanted a histogram of how many times you missed a particular
kanji, you might use

   awk '{print $1}' logfile | sort | uniq -c
  

.SH KANJIDIC
The dictionary, kanjidic, is currently available where it originated, via
ftp from
.I monu6.cc.monash.edu.au,
or from a mirror in the U.S. at ftp.uwtc.washington.edu

At the monu6 site, both the dictionary and this program can currently be
found in
.I /pub/nihongo

.SH BUGS
"kanjidic" isn't perfect. There are "incomplete" entries, missing either
english or kana translations. There are also entries consisting of "See
Nxxxx", which isn't really an improvement.  A new version (Aug. 3rd,
1993) is supposed to have filled in most of the gaps.

It is because of this incompleteness that some features are not
implemented, such as staying with the same kanji when english/kana is
toggled.

.SH AUTHOR
Philip P Brown

(Who does not speak Japanese or Chinese, but hopes to one day)

.SH ACKNOWLEDGEMENTS

Thanks for suggestions and testing go to:
  jcj@it3.crl.mei.co.jp
  webb@camelot.cow.melco.co.jp
  ptk@beta.hut.fi

.SH COPYRIGHT
Philip Brown is currently a student of the University of California.
However, this program was developed entirely by Philip Brown, on his own
computer, not related to any classwork. Philip Brown retains sole right
to this program.

Philip Brown hereby gives permission to use, and/or modify this code, so
long as it it not sold for profit, and he is given credit somewhere in
the code. Separate works originally derived from this code are not
covered by this restriction.

.SH NOTICE
I have spend hundreds of hours on this program.
While I "enjoy" doing this.. it would be a source of great encouragement
to me if I were to receive some financial contribution in appreciation
for this program. I would be a very happy camper if someone sent me a
check for just $10 or something.

I will still be happy to receive suggestions from anyone about this
program. However, your suggestions are much more likely to be
encorporated if your suggestion is accompanied by money.

In fact: I hereby guarantee that if you send me a suggestion, accompanied
by some monitary amount, I will spend a number of hours working on it,
equal or greater to the number of US dollars you send me! (up to the
point at which the feature is implemented, of course :-)

At one time, I was thinking I might like to be a shareware author.
However, the lack of financial response from this has been a little
disheartening. True, it's not an incredibly complex program. But it could
be.... With Your Support!

Philip Brown
December 19th, 1993

philb@soda.berkeley.edu
