/* $Id: main.c,v 1.1 94/04/28 17:41:26 leon Exp $ */
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <X11/Xmu/Editres.h>
#include <X11/Xmu/Converters.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <sys/stat.h>
#include <pwd.h>
#if defined(Mips) && defined(BSD43)
#include <sys/types.h>
#include <sys/dir.h>
#else
#include <dirent.h>
#endif
#include "Year.h"
#include "Day.h"
#include "agenda.h"
#include "group.h"
#define __MAIN_C
#include "main.h"
#include "error.h"
#include "note.h"
#include "actions.h"
#include "easym.h"
#include "options.h"
#include "misc.h"
#include "range.h"
#include "install.h"
#include "alarm.h"




#define TIMER 2000
#define ONE_HOUR 3600000
void AddCalendar(char *);



static XtResource appResources[] = {
#define offset(field) XtOffset(GlobalPtr, field)
  {"mailDomain", "MailDomain", XtRString, sizeof(String),
     offset(mailDomain), XtRImmediate, (caddr_t)0},
  {"selectCursor", "SelectCursor", XtRCursor, sizeof(Cursor),
     offset(selectCursor), XtRString, (caddr_t)"cross"},
  {"banner", "Banner", XmRXmString, sizeof(XmString),
     offset(banner), XtRString, (caddr_t)"ready."},
  {"minuteIncrement", "Increment", XtRInt, sizeof(int),
     offset(minuteIncrement), XtRImmediate, (caddr_t)5},
  {"defaultSnooze", "Snooze", XtRInt, sizeof(int),
     offset(defaultSnooze), XtRImmediate, (caddr_t)300},
#undef offset
};



static XtActionsRec actions[] = {
    {"BriefHelp", BriefHelp},
    {"AutoRaise", AutoRaise},
};


void 
RedrawAll()
{
    YearScanAppointments(year);
    DayScanAppointments(day);
    ClearWidget(year);
    ClearWidget(day);
}




void
LayoutCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmToggleButtonCallbackStruct *cs;
    cs = (XmToggleButtonCallbackStruct *)call_data;
    if(cs->set)
	XtVaSetValues(year, XtNlayout, (char *)client_data, NULL);
}



void
UnmanageCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XtUnmanageChild((Widget)client_data);
}


void
ManageCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XtManageChild((Widget)client_data);
}



void
CreateCalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmSelectionBoxCallbackStruct *cs = 
	(XmSelectionBoxCallbackStruct *)call_data;
    char *calName;
    char fileName[256];
    FILE *file;

    XmStringGetLtoR(cs->value, XmFONTLIST_DEFAULT_TAG, &calName);
    sprintf(fileName, "%s/.%s/%s", getenv("HOME"), APP_NAME, calName);
    /* create new file */
    file = fopen(fileName, "w");
    fclose(file);
    AgendaOpenCalendar(agenda, calName);
    AddCalendar(calName);
    XtFree(calName);
}


void
CreateCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget createD = NULL;
    if(NULL == createD) {
	createD = XmCreatePromptDialog(toplevel, "createD", 0, 0);
	XtAddCallback(createD, XmNokCallback, CreateCalCB, 0);
	XtUnmanageChild(XmSelectionBoxGetChild(createD, XmDIALOG_HELP_BUTTON));
    }
    XtManageChild(createD);
}


void
YearCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Date date;
    int inc = (int)client_data;    
    YearCallbackStruct cs;

    XtVaGetValues(day, XtNdate, &date, 0);
    date.year += inc;
    XtVaSetValues(year, XtNyear, date.year, 0);

    /* update the day view, as if we had clicked */
    cs.date = date;
    DateCB(year, 0, (XtPointer)&cs);
}



void
TodayCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    time_t today;
    struct tm *lt;
    int x, y;
    YearCallbackStruct cs;
    Widget vscroll, hscroll;
    int value, slider, inc, pinc;


    today = time(NULL);
    lt = localtime(&today);
    XtVaSetValues(year, 
		  XtNyear, 1900+lt->tm_year,
		  0);
    /* update the day view, as if we had clicked */
    cs.date.year = 1900+lt->tm_year;
    cs.date.month = lt->tm_mon;
    cs.date.wd = lt->tm_wday-1;
    cs.date.day = lt->tm_mday;
    DateCB(year, 0, (XtPointer)&cs);

    /* center the year widget in the scrolled window */
    YearLocateMonth(year,  lt->tm_mon, &x, &y);
    XtVaGetValues(scrolledy, 
		  XmNverticalScrollBar, &vscroll, 
		  XmNhorizontalScrollBar, &hscroll, 
		  0);
    if(NULL != vscroll) {
	XmScrollBarGetValues(vscroll, &value, &slider, &inc, &pinc);
	XmScrollBarSetValues(vscroll, y, slider, inc, pinc, True);
    }
    if(NULL != hscroll) {
	XmScrollBarGetValues(hscroll, &value, &slider, &inc, &pinc);
	XmScrollBarSetValues(hscroll, x, slider, inc, pinc, True);
    }
}


void
SelectCalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Boolean set = XmToggleButtonGetState(w);
    AgendaSetCalendarStatus(agenda, XtName(w), set);
    RedrawAll();
}



void
AddCalendar(char *name)
{
    /* add a new entry in the calendars box and menus */
    Widget nc1, nc3, group;
    nc1 = 
	XmCreateToggleButton(calendarsM, name, 0, 0);
    XtManageChild(nc1);
    nc3 = XmCreatePushButton(noteD_calendarsM, name, 0, 0);
    XtManageChild(nc3);
    XtAddCallback(nc1, XmNvalueChangedCallback, SelectCalCB, 0);
    group = XmCreatePushButton(membersM, name, 0, 0);
    XtManageChild(group);
    XtAddCallback(group, XmNactivateCallback, GroupCB, 0);
}

#if defined(Mips) && defined(BSD43)
#define dirent direct
#endif

static void
LoadCalendars()
{
    DIR *dir;
    char dirname[MAXNAMLEN+1];
    struct dirent *groupname;

    sprintf(dirname, "%s/.%s", getenv("HOME"), APP_NAME);
    dir = opendir(dirname);
    if(NULL != dir) {
	while(NULL != (groupname = readdir(dir))) {
	    /* discard . and .. */
	    if(groupname->d_name[0] == '.') continue;
	    if( FALSE == AgendaOpenCalendar(agenda, groupname->d_name)) {
		char buf[256];
		sprintf(buf, "Could not open %s", groupname->d_name);
		DisplayError(buf);
	    }
	    else {
		AddCalendar(groupname->d_name);
	    }
	}
	closedir(dir);
    }
	    
}


/* every hour, we check if today has changed
 * 
 * returns: 
 */
void
TodayTimer(XtPointer client_data, XtIntervalId *id)
{
    YearCheckToday(year);
    XtAppAddTimeOut(app_context, ONE_HOUR, TodayTimer, 0); 
}



void
TimeP(XtPointer client_data, XtIntervalId *id)
{
    if(AgendaUpdate(agenda)) {
	RedrawAll();
    }
/*    timer = XtAppAddTimeOut(app_context, TIMER, TimeP, 0);*/
}



void
SaveCB(Widget wid, XtPointer client_data, XtPointer call_data)
{
    AgendaSave(agenda);
}


void
QuitCB(Widget wid, XtPointer client_data, XtPointer call_data)
{
    AgendaSave(agenda);
    Uninstall();
    exit(1);
}






void
DateCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    YearCallbackStruct *cs = (YearCallbackStruct *)call_data;
    char buf[128];

    Date date;
    date = cs->date;
    DaySetDate(day, date);
    YearGetDateString(year, date, buf);
    EmSetLabelString(datel, buf);
}




void
ProtocolSignal()
{
    XtIntervalId timer;
    timer = XtAppAddTimeOut(app_context, 10, TimeP, 0); 
#ifdef Debug
    fprintf(stderr, "Signal caught\n");
#endif /* Debug */
}


extern unsigned long timezone;

void
main(int argc, char* argv[])
{
    Widget tmp;
    Arg args[8];
    int n;
    char fname[32];

    /* do this before anything else, or die */
    toplevel = XtAppInitialize(&app_context, "K-Lendars", 0, 0,
			       &argc, argv, 0, 0, 0);
    sprintf(fname, ".%s/.options", APP_NAME);
    LoadOptionFile(XtDisplay(toplevel), fname);
    LoadMessages(toplevel);
    XtAppAddActions(app_context, actions, XtNumber(actions));
    XtGetApplicationResources(toplevel, &Globals, appResources, 
			      XtNumber(appResources), NULL, 0);
    BuildNoteDialog();
    SanityChecks();
    XtAddEventHandler(toplevel, 0, True, _XEditResCheckMessages, NULL);

    agenda = AgendaCreate(userEmail);
    mainw = XmCreateMainWindow(toplevel, "mainw", 0, 0);
    menubar = XmCreateMenuBar(mainw, "menubar", 0, 0);
    fileM = XmCreatePulldownMenu(menubar, "fileM", 0, 0);
    gotoM = XmCreatePulldownMenu(menubar, "gotoM", 0, 0);
    groupsM = XmCreatePulldownMenu(menubar, "groupsM", 0, 0);
    optionsM = XmCreatePulldownMenu(menubar, "optionsM", 0, 0);
    helpM = XmCreatePulldownMenu(menubar, "helpM", 0, 0);
    
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, fileM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "file", args, n));

    n = 0;
    XtSetArg(args[n], XmNsubMenuId, gotoM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "goto", args, n));

    n = 0;
    XtSetArg(args[n], XmNsubMenuId, groupsM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "groups", args, n));

    n = 0;
    XtSetArg(args[n], XmNsubMenuId, optionsM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "options", args, n));
    
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, helpM); n++;
    XtManageChild(tmp=XmCreateCascadeButton(menubar, "help", args, n));
    XtVaSetValues(menubar, 
		  XmNmenuHelpWidget, tmp,
		  NULL);

    {
	Arg choices[] = {
	    {"1 x 12", (XtArgVal)"1x12"},
	    {"2 x 6", (XtArgVal)"2x6"},
	    {"3 x 4", (XtArgVal)"3x4"},
	    {"4 x 3", (XtArgVal)"4x3"},
	    {"6 x 2", (XtArgVal)"6x2"},
	    {"12 x 1", (XtArgVal)"12x1"},
	};
	Arg args[1];
	
	layoutM = EmCreateRadioMenu(optionsM, "layoutM", LayoutCB,
				    choices, XtNumber(choices));
	XtSetArg(args[0], XmNsubMenuId, layoutM);
	XtManageChild(tmp=XmCreateCascadeButton(optionsM, "layout", args, 1));
    }
    XtManageChild(tmp=XmCreatePushButton(optionsM, "range", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, RangeCB, 0);
    XtManageChild(tmp=XmCreateSeparator(optionsM, "sep", 0, 0));
    XtManageChild(tmp=XmCreateCascadeButton(optionsM, "saveoptions", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, 
		  SaveOptionsCB, fname);
    


    XtManageChild(tmp=XmCreatePushButton(groupsM, "create", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, CreateCB, 0);
    XtManageChild(XmCreateSeparator(groupsM, "sep", 0, 0));
    calendarsM = XmCreatePulldownMenu(groupsM, "calendarsM", 0, 0);
    XtManageChild(tmp=XmCreateCascadeButton(groupsM, "calendars", 0, 0));
    XtVaSetValues(tmp, XmNsubMenuId, calendarsM, 0);
    membersM = XmCreatePulldownMenu(groupsM, "membersM", 0, 0);
    XtManageChild(tmp=XmCreateCascadeButton(groupsM, "members", 0, 0));
    XtVaSetValues(tmp, XmNsubMenuId, membersM, 0);

    XtManageChild(tmp=XmCreatePushButton(fileM, "save", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, SaveCB, 0);

    XtManageChild(tmp=XmCreateSeparator(fileM, "s1", 0, 0));

    XtManageChild(tmp=XmCreatePushButton(fileM, "quit", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, QuitCB, 0);

    /* help menu items */
    XtManageChild(tmp=XmCreatePushButton(helpM, "index", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, HelpCB, 0);
    
/*    XtManageChild(tmp=XmCreatePushButton(helpM, "context", 0, 0));*/
    XtManageChild(tmp=XmCreateSeparator(helpM, "sep", 0, 0));
    XtManageChild(tmp=XmCreatePushButton(helpM, "about", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, AboutCB, 0);

    /* goto menu items */
    XtManageChild(tmp=XmCreatePushButton(gotoM, "today", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, TodayCB, 0);
    XtManageChild(tmp=XmCreateSeparator(gotoM, "s1", 0, 0));
    XtManageChild(tmp=XmCreatePushButton(gotoM, "nexty", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, YearCB, (XtPointer)1);
    XtManageChild(tmp=XmCreatePushButton(gotoM, "prevy", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, YearCB, (XtPointer)-1);

    XtManageChild(menubar);
    form = XmCreateForm(mainw, "form", 0, 0);

    tmp = XmCreateFrame(form, "briefhelpF", 0, 0);
    briefhelp = XmCreateLabel(tmp, "briefhelp", 0, 0);
    XtManageChild(briefhelp);
    XtManageChild(tmp);

    scrolledy = XmCreateScrolledWindow(form, "yearf", 0, 0);
    XtManageChild(scrolledy);
    XtVaSetValues(scrolledy, 
		  XmNleftAttachment, XmATTACH_FORM,
		  XmNtopAttachment, XmATTACH_FORM,
		  XmNbottomAttachment, XmATTACH_WIDGET,
		  XmNbottomWidget, briefhelp,
				   0);

    year = XtVaCreateManagedWidget("year", yearWidgetClass, scrolledy, 
				   XtNagenda, agenda,
				   XtNyear, 1994,
				   0);
    XtAddCallback(year, XtNdateCallback, DateCB, NULL);

    tmp = XtVaCreateManagedWidget("dayf", xmFrameWidgetClass, form,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, year,
				   XmNbottomAttachment, XmATTACH_WIDGET,
				   XmNbottomWidget, briefhelp,
				   XmNrightAttachment, XmATTACH_FORM,
				  0);

    datel = XtVaCreateManagedWidget("datel", xmLabelWidgetClass, tmp, 
				    XmNchildType, XmFRAME_TITLE_CHILD,
				   0);
    XtManageChild(tmp = XmCreateScrolledWindow(tmp, "sday", 0, 0));
    day = XtVaCreateManagedWidget("day", dayWidgetClass, tmp, 
				  XtNagenda, agenda,
				  0);
    XtAddCallback(day, XtNappointmentCallback, NewNoteCB, NULL);
    XtAddCallback(day, XtNnoteCallback, ViewNoteCB, NULL);


    XtManageChild(form);
    XtManageChild(mainw);

    /* load calendars uses widget from the appointment dialog */
    LoadCalendars();
    AgendaUpdate(agenda);
    YearScanAppointments(year);

    XtRealizeWidget(toplevel);


    TodayCB(year, 0, 0);

    /* checks if the procmail filters are corectly installed, 
       disable the members menu elsewhere */
    if(!CheckInstall()) {
	PopInstallDialog(toplevel);
	XtSetSensitive(membersM, False);
    }

    signal(SIGUSR1, ProtocolSignal);
    XtAppAddTimeOut(app_context, ONE_HOUR, TodayTimer, 0); 
    InstallWeekAlarms();
    XtAppMainLoop(app_context);
}
