/* $Id: error.c,v 1.1 94/04/28 17:41:19 leon Exp $ */

#include <X11/Intrinsic.h>
#include <Xm/MessageB.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include "main.h"
#include "error.h"


MessagesRec MessagesStruct;

static XtResource appMessages[] = {
#define offset(field) XtOffset(MessagesRec *, field)
/* Warning messages */
  {"notYetImplemented", "WarningMessage", XtRString, sizeof(String),
     offset(messages[M_NOT_YET_IMPLEMENTED]), XtRImmediate, (caddr_t)0},

/* Error messages */
  {"createGroup", "ErrorMessage", XtRString, sizeof(String),
     offset(messages[M_CREATE_GROUP]), XtRImmediate, (caddr_t)0},
  {"typeNote", "ErrorMessage", XtRString, sizeof(String),
     offset(messages[M_TYPE_NOTE]), XtRImmediate, (caddr_t)0},

/* Working messages */

/* Help messages */
  {"firstDate", "HelpMessage", XtRString, sizeof(String),
     offset(messages[M_FIRST_DATE]), XtRString, (caddr_t)""},
  {"lastDate", "HelpMessage", XtRString, sizeof(String),
     offset(messages[M_LAST_DATE]), XtRString, (caddr_t)""},
  {"newDayHelpMessage", "HelpMessage", XtRString, sizeof(String),
     offset(messages[M_NEW_DAY]), XtRString, (caddr_t)""},
  {"newHour", "HelpMessage", XtRString, sizeof(String),
     offset(messages[M_NEW_HOUR]), XtRString, (caddr_t)""},
#undef offset
};





/* reads the message string resources
 * 
 * returns: nothing
 */
void
LoadMessages(Widget toplevel)
{
    XtGetApplicationResources(toplevel, &MessagesStruct, appMessages, 
			      XtNumber(appMessages), NULL, 0);
};


/* pops up an error dialog, containing the specified string
 * the dialog is APPLICATION_MODAL
 * returns: 
 */
void
DisplayError(char *s)
{
    static Widget errorD = 0;
    XmString xms;

    if(NULL == errorD) {
	errorD = XmCreateErrorDialog(toplevel, "errorD", 0, 0);
	XtUnmanageChild(XmMessageBoxGetChild(errorD, 
					     XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(errorD, 
					     XmDIALOG_CANCEL_BUTTON));
    }
    xms = XmStringCreateSimple(s);
    XtVaSetValues(errorD, XmNmessageString, xms, 0);
    XtManageChild(errorD);
    XmStringFree(xms);
}




/* pops up the help dialog
 * 
 * returns: 
 */
void
HelpCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget helpD = 0;

    if(NULL == helpD) {
	Widget help, tmp;
	helpD = XmCreateFormDialog(toplevel, "helpD", 0, 0);
	help = XmCreateText(helpD, "help", 0, 0);
	XtManageChild(help);
	tmp = XmCreatePushButton(helpD, "dismiss", 0, 0);
	XtManageChild(tmp);
    }
    XtManageChild(helpD);
}




/* pops up the info dialog
 * 
 * returns: 
 */
void
AboutCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget aboutD = 0;

    if(NULL == aboutD) {
	aboutD = XmCreateInformationDialog(toplevel, "aboutD", 0, 0);
	XtUnmanageChild(XmMessageBoxGetChild(aboutD, 
					     XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(aboutD, 
					     XmDIALOG_CANCEL_BUTTON));
    }
    XtManageChild(aboutD);
}
