/* $Id: easym.c,v 1.1 94/04/28 17:41:18 leon Exp $ */
#include <Xm/XmAll.h>






Widget
EmCreateOptionMenu(Widget parent, char *name, ArgList items, int nitems)
{
    Widget button, popup;
    Arg args[2];
    int n;
    char menuname[256];

    sprintf(menuname, "%s_menu", name);
    popup = XmCreatePulldownMenu(parent, menuname, 0, 0);
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, popup); n++;
    button = XmCreateOptionMenu(parent, name, args, n);

    return button;
    
}


void
EmOptionMenuSelectNamedItem(Widget option, char *name)
{
    Widget menu, item;

    XtVaGetValues(option, XmNsubMenuId, &menu, NULL);
    item = XtNameToWidget(menu, name);
    XtVaSetValues(option, XmNmenuHistory, item, NULL);
}



void
EmSetLabelString(Widget label, 
		 char *str)
{
    Arg args[1];
    XmString xms;

    xms = XmStringCreateSimple(str);
    XtSetArg(args[0], XmNlabelString, xms);
    XtSetValues(label, args, 1);
    XmStringFree(xms);
}




void
EmUnmanageCB(Widget w, 
	     XtPointer client_data, 
	     XtPointer call_data)
{
    Widget widget = (Widget)client_data;
    XtUnmanageChild(widget);
}



Widget
EmCreateRadioMenu(Widget parent, char *name, XtCallbackProc cb, 
		  ArgList choices, int count)
{
    Widget menu, widget;
    Arg args[1];
    int i;
 
    XtSetArg(args[0], XmNradioBehavior, True);
    menu = XmCreatePulldownMenu(parent, name, args, 1);
    for(i = 0; i < count; i++) {
	widget = XmCreateToggleButton(menu, choices[i].name, 0, 0);
	XtAddCallback(widget, XmNvalueChangedCallback, cb, (XtPointer)choices[i].value);
	XtManageChild(widget);
    }
    return menu;
}
