/* $Id: cm.h,v 1.1 94/04/28 17:41:16 leon Exp $ */

#ifndef __CM_H
#define __CM_H



#ifndef Create
#define Create(type) ((type *) malloc(sizeof(type)))
#define Destroy(obj) if(0 != obj) {free(obj); obj = 0;}
#endif /* Create */


typedef struct _CmMessage {
    unsigned char type;
    unsigned int len;
    char *msg;
} CmMessageRec;

typedef unsigned int CmGroupId;
typedef struct _CmGroup {
    CmGroupId id;
    int nusers;
    char *name;
    char *application;
    char *admin;
    char *emails;
} CmGroupRec, *CmGroup;
typedef CmGroup Group;



CmGroup
CmOpenGroup(char *application, 
	    char *group,
	    char *admin);



void
CmSaveGroup(CmGroup group);



void
CmCloseGroup(CmGroup group);



void
CmSend(CmGroup group, 
       char *protocol, 
       char *header, 
       char *buffer, 
       int size);



void
CmSendString(CmGroup group, 
	     char *header, 
	     char *string);


void
CmSendAdminMessage(CmGroup group, 
		   char *header, 
		   char *string);



typedef 
   void (*CmArrivalCallbackProc)(CmGroup group, 
				 char *header, 
				 char *msg, 
				 void *closure);

int
CmScanArrivals(CmGroup group, 
	       CmArrivalCallbackProc proc, 
	       void *closure);



#endif /* __CM_H */
