/* $Id: cm.c,v 1.1 94/04/28 17:41:15 leon Exp $ */

#include <stdio.h>
#ifndef Mips
#include <malloc.h>
#endif /* ! Mips */
#include <string.h>
#include <stdlib.h>
#ifdef GCC_SUCKS
#include "gcc_sucks.h"
#endif /* GCC_SUCKS */
#include "cm.h"
#include "misc.h"


#define MAXBUF 1024
#define MAXGROUPS 32
#define True 1
#define False 0

/* slots numbered from 1 to MAXGROUPS */
static CmGroup 
groups[MAXGROUPS+1] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};


static CmGroupId
CmFindFreeSlot()
{
    unsigned int i;
    for(i = 1; i <= MAXGROUPS; i++) {
	if(NULL == groups[i]) return i;
    }
    return 0;
}


CmGroup
CmOpenGroup(char *application, char *group, char *admin)
{
    char str[MAXBUF];
    FILE *file;
    CmGroup res = NULL;
    CmGroupId slot;

    slot = CmFindFreeSlot();
    if(0 == slot) {
	/* no free slot */
	return res;
    }
#ifdef Debug
    fprintf(stderr, "CmOpenGroup: %s %s\n", group, application);
#endif /* Debug */
    sprintf(str, "%s/.%s/.groups/%s", 
	    getenv("HOME"), application, group);
    file = fopen(str, "r");
    str[0] = '\0';
    /* intialize group */
    res = Create(CmGroupRec);
    groups[slot] = res;
    res->id = slot;
    res->name = strdup(group);
    res->application = strdup(application);
    res->nusers = 1;
    if(NULL != file) {
	int l;
	fgets(str, MAXBUF, file);
	fclose(file);
	res->emails = strdup(str);
	l = strcspn(str, " \t\n");
	if(l == 0) {
	    /* no name found */
	    free(res->emails);
	    /* This should always contain the user 's email */
	    res->emails = strdup(admin);
	    res->admin = strdup(admin);
	}
	else {
	    char *p = str;
	    /* count users */
	    while(p) {
		p = strchr(p, ' ');
		if(NULL == p) break;
		p++;
		res->nusers++;
	    }
	    /* group admin is the first name */
	    str[l] = '\0';
	    res->admin = strdup(str);
	}
    }
    else {
	res->emails = strdup(admin);
	res->admin = strdup(admin);
    }
#ifdef Debug
    fprintf(stderr, "CmOpenGroup: %s has %d users\n", group, res->nusers);
#endif /* Debug */
    return res;
}



void
CmSaveGroup(CmGroup group)
{
    char str[MAXBUF];
    FILE *file;

    sprintf(str, "%s/.%s/.groups/%s", 
	    getenv("HOME"), group->application, group->name);
    file = fopen(str, "w");
    str[0] = '\0';
    if(NULL != file) {
	fprintf(file, "%s\n", group->emails);
	sprintf(str, "CmUsers: %s", group->emails);
	CmSendAdminMessage(group, "", str);
	fclose(file);
    }
    else {
	fprintf(stderr, "Cannot save group %s\n", group->name);
    }
}




void
CmCloseGroup(CmGroup group)
{
    groups[group->id] = NULL;
    bzero(group, sizeof(CmGroupRec));
    Destroy(group);
}



void
CmSend(CmGroup group, char *protocol, char *header, char *string, int size)
{
    FILE *file;
    char *filename;
    char command[MAXBUF];
#ifdef Trace
    fprintf(stderr, "CmSend %s\n", string);
#endif /* Trace */
    if(group->nusers < 2) return;
    filename = tempnam(0, ".cm");
    file = fopen(filename, "w");
    if(0 != file) {
	fprintf(file, "CmApplicationName: %s\n", group->application);
	fprintf(file, "CmGroupName: %s\n", group->name);
	fprintf(file, "CmHeader: %s\n", header);
	fprintf(file, "CmMessage:\n%s\n", string);
	fclose(file);
	sprintf(command, "mail <%s -s %s %s", 
		filename, protocol, group->emails);
#ifdef Debug
	fprintf(stderr, "running: %s\n", command);
#endif /* Debug */
	system(command);
	unlink(filename);
    }
    else {
	fprintf(stderr, "Unable to create tmp file '%s'\n", filename);
    };
    free(filename);
}



void
CmSendString(CmGroup group, char *header, char *string)
{
    CmSend(group, "CmProtocol", header, string, strlen(string));
}



void
CmSendAdminMessage(CmGroup group, char *header, char *string)
{
    CmSend(group, "CmAdministration", header, string, strlen(string));
}





static void
CmParseMessage(CmGroup group, unsigned int m, CmArrivalCallbackProc proc,
	       void *closure)
{
    char fn[256];
    FILE *file;
    char  buf[256], msg[MAXBUF], header[64];
    int inheader = True;
    
    sprintf(fn, "%s/.%s/.cmstore/%s/%d", getenv("HOME"), 
	    group->application, group->name, m);
#ifdef Trace
    fprintf(stderr, "scanning %s\n", fn);
#endif /* Trace */
    file = fopen(fn, "r");
    msg[0] = '\0';
    if(NULL != file) {
	while(fgets(buf, 256, file)) {
	    if(inheader) {
		/* euark */
		if(!strncmp("CmHeader:", buf, 9)) {
		    strcpy(header, buf+10);
		}
		if(!strncmp("CmMessage:", buf, 10)) {
		    inheader = False;
		}
	    }
	    else {
		strcat(msg, buf);
	    }
	}
	if(NULL != proc) {
	    (*proc)(group, header, msg, closure);
	}
	fclose(file);
	unlink(fn);
    }
    sprintf(fn, "%s/.%s/.cmstore/%s/last-processed", getenv("HOME"), 
	    group->application, group->name);
    file = fopen(fn, "w");
    if(NULL != file) {
	fprintf(file, "%d\n", m);
	fclose(file);
    };
}


int
CmScanArrivals(CmGroup group, CmArrivalCallbackProc proc, void *closure)
{
    int got = False;
    char fn[256];
    char buf[32];
    FILE *file;
    int n;
    unsigned int arrived = 0, processed = 0;
    
    /* getting last processed msg id */
    sprintf(fn, "%s/.%s/.cmstore/%s/last-processed", getenv("HOME"), 
	    group->application, group->name);
    file = fopen(fn, "r");
    if(NULL != file) {
	fgets(buf, 32, file);
	processed = atoi(buf);
	fclose(file);
    }
      /* getting last arrived msg id */
    sprintf(fn, "%s/.%s/.cmstore/%s/last-arrived", getenv("HOME"), 
	    group->application, group->name);
    file = fopen(fn, "r");
    if(NULL != file) {
	fgets(buf, 32, file);
	arrived = atoi(buf);
	fclose(file);
    }
    
    for(n = processed+1; n <= arrived; n++) {
	CmParseMessage(group, n, proc, closure);
	got = True;
    }
    return got;
}
