/* $Id: cal.h,v 1.1 94/04/28 17:41:13 leon Exp $ */
#ifndef __ABSTRACT_CAL_H
#define __ABSTRACT_CAL_H

#include "date.h"
#include "appointment.h"
#include "cm.h"



typedef struct _CalendarRec {
    char *name;
    unsigned char selected;
    Appointment appointments;
    CmGroup group;
} CalendarRec, *Calendar;





Calendar
ClOpen(char *filename, 
       char *admin);

void
ClSave(Calendar cal, 
       char *filename);


Appointment
ClFindAppointment(Calendar cal, 
		  char *name, 
		  time_t timestamp);

int
ClFindDayAppointment(Calendar cal, 
		     Date date);

Appointment
ClAddAppointment(Calendar cal,
		 Appointment ap);



void
ClRegisterAppointment(Calendar cal, 
		      Appointment ap);


void
ClDestroyAppointment(Calendar cal, 
		    Appointment id);


void
ClRemoveAppointment(Calendar cal, 
		    Appointment id);


typedef void (*ClEnumerateProc)(Calendar cal,
				Appointment id, 
				void *closure);



void
ClEnumerateAppointments(Calendar cal, 
			Date date, 
			ClEnumerateProc proc, 
			void *closure);



void
ClEnumerateAnyAppointments(Calendar cal, 
			   ClEnumerateProc proc, 
			   void *closure);





#endif /* __ABSTRACT_CAL_H */
