/* $Id: actions.c,v 1.1 94/04/28 17:41:05 leon Exp $ */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Label.h>
#include "main.h"
#include "xt_misc.h"
#include "actions.h"



static XmString freezedhelp = NULL;


void
FreezeBriefHelp(char *msg)
{
    if(NULL != freezedhelp) {
	XmStringFree(freezedhelp);
    }
    freezedhelp = XmStringCreateSimple(msg);
    XtVaSetValues(briefhelp, XmNlabelString, freezedhelp, 0, 0);
}


void
UnfreezeBriefHelp()
{
    XmStringFree(freezedhelp);
    XtVaSetValues(briefhelp, XmNlabelString, Globals.banner, 0, 0);
    freezedhelp = NULL;
}



void
BriefHelp(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *numparams)
{
    XmString xms;
    if(NULL != freezedhelp) return;
    if(1 != *numparams) {
	XtAppWarning(app_context, "BriefHelp actions should have one parameter");
	return;
    }
    xms = XmStringCreateSimple(params[0]);
    XtVaSetValues(briefhelp, XmNlabelString, xms, 0, 0);
    XmStringFree(xms);
}




void
AutoRaise(Widget w,
	  XEvent *event,
	  String *params,
	  Cardinal *numparams)
{
    XVisibilityEvent *e = (XVisibilityEvent *)event;
    if(VisibilityUnobscured != e->state) {
	XtRaiseWidget(XtGetShell(w));
    }
}
