/* $Id: Year.c,v 1.1 94/04/28 17:41:01 leon Exp $ */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <stdio.h>
/*#include <stdlib.h>*/
#include "YearP.h"


#define ClearWidget(w) \
XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 9999, 9999, True)

String XtNmonths[] = {
    XtNjanuary, XtNfebruary, XtNmarch, XtNapril, XtNmay, XtNjune, 
    XtNjuly, XtNaugust, XtNseptember, XtNoctober, XtNnovember, XtNdecember,
};





void 
SelectProc(Widget w, XEvent *e, String *args, Cardinal  *num_args);
void 
UnselectProc(Widget w, XEvent *e, String *args, Cardinal  *num_args);
void 
TestProc(Widget w, XEvent *e, String *args, Cardinal  *num_args);


static char defaultTranslations[] = "<Btn1Down>: Select()\n <Btn1Up>: Unselect()\n <Btn3Down>:Test()";
static XtActionsRec actions[] = {
    {"Select", SelectProc},
    {"Unselect", UnselectProc},
    {"Test", TestProc},
};

#define nDays 7
#define nWeeks 6
/* for month compression
#define nWeeks 5 */

static XtResource 
resources[] = {
#define offset(field) XtOffset(YearWidget, year.field)
  {XtNagenda, XtCAgenda, XtRPointer, sizeof(XtPointer),
     offset(agenda), XtRImmediate, (caddr_t)0}, 
  {"yearColor", XtCColor, XtRPixel, sizeof(Pixel),
     offset(yearColor), XtRImmediate, (caddr_t)10},
  {"appointmentColor", XtCAppointmentColor, XtRPixel, sizeof(Pixel),
     offset(appointmentColor), XtRString, "blue"},
  {XtNdayForeground, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayForeground), XtRString, "black"},
  {XtNdayBackground, XtCDayBackground, XtRPixel, sizeof(Pixel),
     offset(dayBackground), XtRString, "grey80"},
  {XtNclosedDayForeground, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(closedDayForeground), XtRString, "red"},
  {XtNclosedDayBackground, XtCDayBackground, XtRPixel, sizeof(Pixel),
     offset(closedDayBackground), XtRString, "grey80"},
  {XtNtodayForeground, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(todayForeground), XtRString, "red"},
  {XtNtodayBackground, XtCDayBackground, XtRPixel, sizeof(Pixel),
     offset(todayBackground), XtRString, "grey80"},
  {XtNclosedDaysFile, XtCString, XtRString, sizeof(String),
     offset(closedDaysFile), XtRString, "~/.closed.days"},

/* month strings */
  {XtNyear, XtCYear, XtRInt, sizeof(int),
     offset(year), XtRString, "0"}, 
  {XtNdateCallback, XtCCallback, XtRCallback, sizeof(XtCallbackList),
     offset(dateCallback), XtRPointer, NULL}, 
  {XtNjanuary, XtCJanuary, XtRString, sizeof(String),
     offset(months[JANUARY]), XtRString, "January"},  
  {XtNfebruary, XtCFebruary, XtRString, sizeof(String),
     offset(months[FEBRUARY]), XtRString, "February"},
  {XtNmarch, XtCMarch, XtRString, sizeof(String),
     offset(months[MARCH]), XtRString, "March"},
  {XtNapril, XtCApril, XtRString, sizeof(String),
     offset(months[APRIL]), XtRString, "April"},
  {XtNmay, XtCMay, XtRString, sizeof(String),
     offset(months[MAY]), XtRString, "May"},
  {XtNjune, XtCJune, XtRString, sizeof(String),
     offset(months[JUNE]), XtRString, "June"},
  {XtNjuly, XtCJuly, XtRString, sizeof(String),
     offset(months[JULY]), XtRString, "July"},
  {XtNaugust, XtCAugust, XtRString, sizeof(String),
     offset(months[AUGUST]), XtRString, "August"},
  {XtNseptember, XtCSeptember, XtRString, sizeof(String),
     offset(months[SEPTEMBER]), XtRString, "September"},
  {XtNoctober, XtCOctober, XtRString, sizeof(String),
     offset(months[OCTOBER]), XtRString, "October"},
  {XtNnovember, XtCNovember, XtRString, sizeof(String),
     offset(months[NOVEMBER]), XtRString, "November"},
  {XtNdecember, XtCDecember, XtRString, sizeof(String),
     offset(months[DECEMBER]), XtRString, "December"},

  {XtNdateFormat, XtCDateFormat, XtRString, sizeof(String),
     offset(dateFormat), XtRString, "dmy"},

/* day strings */
  {XtNmonday, XtCMonday, XtRString, sizeof(String),
     offset(days[MONDAY]), XtRString, "Mon"},
  {XtNtuesday, XtCTuesday, XtRString, sizeof(String),
     offset(days[TUESDAY]), XtRString, "Tue"},
  {XtNwednesday, XtCWednesday, XtRString, sizeof(String),
     offset(days[WEDNESDAY]), XtRString, "Wen"},
  {XtNthursday, XtCThursday, XtRString, sizeof(String),
     offset(days[THURSDAY]), XtRString, "Thu"},
  {XtNfriday, XtCFriday, XtRString, sizeof(String),
     offset(days[FRIDAY]), XtRString, "Fri"},
  {XtNsaturday, XtCSaturday, XtRString, sizeof(String),
     offset(days[SATURDAY]), XtRString, "Sat"},
  {XtNsunday, XtCSunday, XtRString, sizeof(String),
     offset(days[SUNDAY]), XtRString, "Sun"},

/* month colors */
  {XtNjanuaryColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[JANUARY]), XtRString, "black"},
  {XtNfebruaryColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[FEBRUARY]), XtRString, "black"},
  {XtNmarchColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[MARCH]), XtRString, "black"},
  {XtNaprilColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[APRIL]), XtRString, "black"},
  {XtNmayColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[MAY]), XtRString, "black"},
  {XtNjuneColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[JUNE]), XtRString, "black"},
  {XtNjulyColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[JULY]), XtRString, "black"},
  {XtNaugustColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[AUGUST]), XtRString, "black"},
  {XtNseptemberColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[SEPTEMBER]), XtRString, "black"},
  {XtNoctoberColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[OCTOBER]), XtRString, "black"},
  {XtNnovemberColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[NOVEMBER]), XtRString, "black"},
  {XtNdecemberColor, XtCMonthColor, XtRPixel, sizeof(Pixel),
     offset(monthColors[DECEMBER]), XtRString, "black"},

/* day colors */
/*
  {XtNmondayColor, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayColors[MONDAY]), XtRString, "black"},
  {XtNtuesdayColor, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayColors[TUESDAY]), XtRString, "black"},
  {XtNwednesdayColor, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayColors[WEDNESDAY]), XtRString, "black"},
  {XtNthursdayColor, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayColors[THURSDAY]), XtRString, "black"},
  {XtNfridayColor, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayColors[FRIDAY]), XtRString, "black"},
  {XtNsaturdayColor, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayColors[SATURDAY]), XtRString, "red"},
  {XtNsundayColor, XtCDayForeground, XtRPixel, sizeof(Pixel),
     offset(dayColors[SUNDAY]), XtRString, "red"},
     */

/* fonts */
  {"yearFont", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(yearFont), XtRString, XtDefaultFont},
  {"monthFont", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(monthFont), XtRString, XtDefaultFont},
  {"dayFont", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(dayFont), XtRString, XtDefaultFont},

  /* layout resources */
  {"layout", "Layout", XtRString, sizeof(String),
     offset(layout), XtRImmediate, (caddr_t)"4x3"},
  {"leftMargin", "LeftMargin", XtRPosition, sizeof(Position),
     offset(leftMargin), XtRString, (XtPointer)"20"},
  {"topMargin", "TopMargin", XtRPosition, sizeof(Position),
     offset(topMargin), XtRString, (XtPointer)"50"},
  {"monthOffset", "MonthOffset", XtRPosition, sizeof(Position),
     offset(monthOffset), XtRString, (XtPointer)"20"},
  {"dayOffset", "DayOffset", XtRPosition, sizeof(Position),
     offset(dayOffset), XtRString, (XtPointer)"3"},
  {"dayWidth", "DayWidth", XtRPosition, sizeof(Position),
     offset(dayWidth), XtRString, (XtPointer)"25"},
  {"dayHeight", "DayHeight", XtRPosition, sizeof(Position),
     offset(dayHeight), XtRString, (XtPointer)"25"},
  {"dayMargin", "DayMargin", XtRPosition, sizeof(Position),
     offset(dayMargin), XtRString, (XtPointer)"2"},
  {"startWeekOn", "StartWeekOn", XtRWeekDay, sizeof(WeekDay),
       offset(startWeekOn), XtRImmediate, (caddr_t) SUNDAY},

#undef offset
};


static void
ParseLayout(Widget w, char *layout, Cardinal *Hnum, Cardinal *Vnum)
{
    int i;
    Display *dpy = XtDisplay(w);
    static struct _layout {
	char *name;
	Cardinal h;
    } layouts [] = {
	{"12x1", 12},
	{"6x2", 6},
	{"4x3", 4},
	{"3x4", 3},
	{"2x6", 2},
	{"1x12", 1},
    };
    
    *Hnum = 0; 
    for(i = 0; i < XtNumber(layouts); i++) {
	if(!strcmp(layout, layouts[i].name)) {
	    *Hnum = layouts[i].h;
	    *Vnum = 12 / *Hnum;
	}
    }
    if(*Hnum == 0) {
	char msg[80];
	sprintf(msg, "Incorrect value (%s) for resource 'layout'", 
		layout);
	XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
			"conversionError","YearWidget","XtToolkitError",
			msg,
			(String *) NULL, (Cardinal *)NULL);	
	*Hnum = 4;
	*Vnum = 3;
    };
}



Boolean
CvtStringToWeekDay(Display *dpy, XrmValue *args, Cardinal *num_args, 
	       XrmValue *from, XrmValue *to, XtPointer *converter_data)
{
    int i;
    char s[32];
    static struct _names {
	char *name;
	WeekDay day;
    } names[] = {
	{"monday", MONDAY},
	{"tuesday", TUESDAY},
	{"wednesday", WEDNESDAY},
	{"thursday", THURSDAY},
	{"friday", FRIDAY},
	{"saturday", SATURDAY},
	{"sunday", SUNDAY},
    };

    LowerCase((char *)from->addr, s);
    for(i = 0; i < XtNumber(names); i++) {
	if(!strcmp(s, names[i].name)) {
	    bcopy(&(names[i].day), to->addr, to->size);
	    return True;
	}
    }

    XtDisplayStringConversionWarning(dpy, (char *)from->addr, "WeekDay");
    return False;
}

static void
ClassPartInitializeProc()
{
    XtSetTypeConverter(XtRString, XtRWeekDay, CvtStringToWeekDay, NULL, 0,
		       XtCacheNone, NULL);
}



static void 
InitializeProc(Widget w, Widget new, ArgList args, Cardinal *n)
{    

    YearWidget yw = (YearWidget) new;
#define THIS yw->year
    Window win = DefaultRootWindow(XtDisplay(yw));
    Display *dpy = XtDisplay(yw);
    
    THIS.gc = XCreateGC(dpy, win, 0, 0);
    XSetFont(dpy, THIS.gc, THIS.monthFont->fid);
    XSetForeground(dpy, THIS.gc, 
		   BlackPixel(dpy, 0));
    
    THIS.month_gc = XCreateGC(dpy, win, 0, 0);
    XSetFont(dpy, THIS.month_gc, THIS.monthFont->fid);
    XSetForeground(dpy, THIS.month_gc, 
		   BlackPixel(dpy, 0));
    
    
    THIS.day_gc = XCreateGC(dpy, win, 0, 0);
    XSetFont(dpy, THIS.day_gc, THIS.dayFont->fid);
    XSetForeground(dpy, THIS.day_gc, 
		   BlackPixel(dpy, 0));

    THIS.today = Today();
    THIS.firstWeekDayOfTheYear = DateToWeekDay(THIS.year, JANUARY, 1);

    ParseLayout(w, THIS.layout, &(THIS.Hnum), &(THIS.Vnum));

    new->core.width = THIS.Hnum * (THIS.dayWidth * nDays + THIS.leftMargin) 
	+ THIS.leftMargin;
    new->core.height = THIS.Vnum * (THIS.dayHeight * nWeeks + THIS.topMargin)
	+ THIS.topMargin/2;
    YearScanAppointments(new);
    YearScanClosedDays(new);
#undef THIS    
}


void
TestProc(Widget w, XEvent *event, String *args, Cardinal  *num_args)
{
/*    YearRedrawAllAppointments(w);*/
}


static void
ConfigureGcs(Widget w, Date date, Boolean reverse)
{
    YearWidget yw = (YearWidget)w;
    Display *dpy = XtDisplay(w);
#define THIS yw->year
    
#define SetGcs(fore, back) XSetForeground(dpy, THIS.day_gc, fore);\
    XSetForeground(dpy, THIS.gc, back)
		    
	if(!reverse) {
	    SetGcs(THIS.dayForeground, THIS.dayBackground);
	}
	else {
	    SetGcs(THIS.dayBackground, THIS.dayForeground);
	}
    
    if(SameDay(THIS.today, date)) {
	if(!reverse) {
	    SetGcs(THIS.todayForeground, THIS.todayBackground);
	}
	else {
	    SetGcs(THIS.todayBackground, THIS.todayForeground);
	}
    }
    else
	if(YearIsClosedDay(w, date.month, date.day)) {
	    if(!reverse) {
		SetGcs(THIS.closedDayForeground, THIS.closedDayBackground);
	    }
	    else {
		SetGcs(THIS.closedDayBackground, THIS.closedDayForeground);
	    }
	    
	}
#undef SetGcs
#undef THIS    
}


static void
ExposeProc(Widget w, XEvent *event, Region r)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    Display *dpy = XtDisplay(w);
    Window win = XtWindow(w);
    XExposeEvent *e = (XExposeEvent *)event;
    int i, h, v;
    Position x, y, xof, yof, hCenter;
    Month month = JANUARY;
    WeekDay day = SATURDAY;
    Date date;




    THIS.xoffset =  THIS.dayWidth*nDays;
    THIS.yoffset = THIS.dayHeight*nWeeks;
    hCenter = (THIS.dayWidth - 2 * 
	       (THIS.dayFont->max_bounds.rbearing - 
		THIS.dayFont->max_bounds.lbearing)) / 2;
    if(e) {
	XRectangle rect[1];
	rect[0].x = e->x;
	rect[0].y = e->y;
	rect[0].width = e->width;
	rect[0].height = e->height;
	XSetClipRectangles(dpy, THIS.month_gc, 0,0, rect, 1, Unsorted);
	XSetClipRectangles(dpy, THIS.day_gc, 0,0, rect, 1, Unsorted);
	XSetClipRectangles(dpy, THIS.gc, 0,0, rect, 1, Unsorted);
    }

     
    XSetForeground(dpy, THIS.day_gc, THIS.dayForeground);
    for(v = 0; v < THIS.Vnum; v++) {
	for(h = 0; h < THIS.Hnum; h++, month++) {
	    x = THIS.leftMargin+ (THIS.leftMargin + THIS.xoffset)*h;
	    y = THIS.topMargin + (THIS.topMargin + THIS.yoffset)*v;
	    XSetForeground(dpy, THIS.month_gc, 
			   THIS.monthColors[month]);
	    XDrawString(dpy, win, THIS.month_gc,
			x, y - THIS.monthOffset, THIS.months[month], 
			strlen(THIS.months[month]));
	    XDrawRectangle(dpy, win, THIS.month_gc,
			   x, y, THIS.dayWidth*nDays, THIS.dayHeight*nWeeks);
	    day = THIS.startWeekOn;
	    for(i = 0; i < nDays; i++, x+=THIS.dayWidth) {
		XDrawString(dpy, win, THIS.day_gc,
			    x, y - THIS.dayOffset, THIS.days[day], 
			    strlen(THIS.days[day]));
		day ++;
		day %= nDays;

	    }
	    x = THIS.leftMargin+ (THIS.leftMargin + THIS.xoffset)*h;
	    y = THIS.topMargin + (THIS.topMargin + THIS.yoffset)*v;
	}
    }
    day = THIS.firstWeekDayOfTheYear;
    date.year = THIS.year;
    for(month = 0; month < 12; month++) {
	int week = 0;
	int dpos, days;
	int vCenter;
	char buf[8];
	h = month % THIS.Hnum;
	v = month / THIS.Hnum;
	x = THIS.leftMargin+ (THIS.leftMargin + THIS.xoffset)*h;
	y = THIS.topMargin + (THIS.topMargin + THIS.yoffset)*v;
	vCenter = (THIS.dayHeight - (THIS.dayMargin * 2) 
		   - THIS.dayFont->ascent)/2 + THIS.dayMargin;
	week = 0;
	switch (month) {
	case JANUARY:
	case MARCH:
	case MAY:
	case JULY:
	case AUGUST:
	case OCTOBER:
	case DECEMBER:
	    days = 31;
	    break;
	    
	case FEBRUARY:
	    if(IsLeap(THIS.year)) {
		days = 29;
	    }
	    else {
		days = 28;
	    }
	    break;
	default:
	    days = 30;
	    break;
	}
	date.month = month;
	for(i = 0; i < days; i++) {
	    dpos = (day - THIS.startWeekOn);
	    if(dpos < 0) dpos += nDays;
	    sprintf(buf, "%d", i+1);
	    date.wd = day;
	    date.day = i+1;

	    ConfigureGcs(w, date, False);
	    xof = x + dpos*THIS.dayWidth + THIS.dayMargin;
	    yof = y+week*THIS.dayHeight + THIS.dayMargin;
	    XFillRectangle(dpy, win, THIS.gc, xof, yof,
			 THIS.dayWidth-(THIS.dayMargin*2), 
			 THIS.dayHeight-(THIS.dayMargin*2));
	    if(YearFindAppointment(w, date.month, date.day)) {
		XSetForeground(dpy, THIS.gc, 
			       THIS.appointmentColor);
		XDrawRectangle(dpy, win, THIS.gc, xof, yof,
			       THIS.dayWidth-(THIS.dayMargin*2), 
			       THIS.dayHeight-(THIS.dayMargin*2));
	    }
	    XDrawString(dpy, win, THIS.day_gc, 
			xof + hCenter, 
			yof + THIS.dayHeight - THIS.dayOffset - vCenter,
			buf, strlen(buf));


	    day++;
	    day %= nDays;
	    if(dpos == SUNDAY) {
		week++;
/* uncomment for month compression 
		week %= (nWeeks);*/
	    }
	}
    }
    XSetClipMask(dpy, THIS.month_gc, None);
    XSetClipMask(dpy, THIS.day_gc, None);
    XSetClipMask(dpy, THIS.gc, None);
#undef THIS
}


static Boolean
SetValuesProc(Widget currentw, Widget requestw, Widget neww, 
	      ArgList args, Cardinal *num_args)
{
    YearWidget current = (YearWidget)currentw;
    YearWidget new = (YearWidget)neww;
    Boolean redraw = False;
    Display *dpy = XtDisplay(currentw);
    YearPart *cp, *np;
#define CURRENT current->year
#define NEW new->year
    cp = &(current->year);
    np = &(new->year);
    /* any change should be reflected */
    if(bcmp(cp, np, sizeof(YearPart))) redraw = True;

    if(NEW.layout != CURRENT.layout) {
	ParseLayout(neww, NEW.layout, &(NEW.Hnum), &(NEW.Vnum));
	neww->core.width = NEW.Hnum * (NEW.dayWidth * nDays + NEW.leftMargin) 
	    + NEW.leftMargin;
	neww->core.height = 
	    NEW.Vnum * (NEW.dayHeight * nWeeks + NEW.topMargin) + 
	    NEW.topMargin/2;
    }

    if(NEW.monthFont != CURRENT.monthFont) {
	XSetFont(dpy, NEW.gc, NEW.monthFont->fid);
	XSetFont(dpy, NEW.month_gc, NEW.monthFont->fid);
    }

    if(NEW.dayFont != CURRENT.dayFont)
	XSetFont(dpy, NEW.day_gc, NEW.dayFont->fid);

    
    if(NEW.year != CURRENT.year) {
	WeekDay wday;
	wday = DateToWeekDay(NEW.year, JANUARY, 1);
	NEW.firstWeekDayOfTheYear = wday;
	YearScanAppointments(neww);
	YearScanClosedDays(neww);
    }

    return redraw;
#undef CURRENT
#undef NEW
}



YearClassRec yearClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Year",
    /* widget_size		*/	sizeof(YearRec),
    /* class_initialize		*/	ClassPartInitializeProc,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	InitializeProc,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	NULL,
    /* expose			*/	ExposeProc,
    /* set_values		*/	SetValuesProc,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* year fields */
    /* empty			*/	0
  }
};

WidgetClass yearWidgetClass = (WidgetClass)&yearClassRec;





void
SelectProc(Widget w, XEvent *event, String *args, Cardinal  *num_args)
{
     Display *dpy = XtDisplay(w);
     Window win = XtWindow(w);
     YearWidget yw = (YearWidget)w;
     XButtonEvent *e = (XButtonEvent *)event;
#define THIS yw->year
     Cardinal h, v;
     Position x, y, xo, yo;
     Month month;
     Day day;
     int dpos;
     int week = 0;
     static YearCallbackStruct res;
     WeekDay first;
     int firstpos, lastpos;
     
     THIS.clicked = NULL;
     h = (e->x ) / (THIS.leftMargin + THIS.xoffset);
     v = (e->y ) / (THIS.topMargin + THIS.yoffset);
     
     if((h >= THIS.Hnum) || (v >= THIS.Vnum)) return;
     
     month = (Month)(h + THIS.Hnum * v);
     res.date.year = THIS.year;
     res.date.month = month;
     
     x = THIS.leftMargin+ (THIS.leftMargin + THIS.xoffset)*h;
     y = THIS.topMargin + (THIS.topMargin + THIS.yoffset)*v;
     
     
     if((e->x > x) && (e->x < x+THIS.dayWidth*nDays) && 
	(e->y > y) && (e->y < y+THIS.dayHeight*nWeeks)) {
	 /* is the event contained in the month grid ? */
	 xo = e->x - x;
	 yo = e->y - y;
	 
	 dpos = xo / THIS.dayWidth;
	 week = yo / THIS.dayHeight;

	 res.date.wd = (dpos + THIS.startWeekOn) % nDays;
	 first = DateToWeekDay(THIS.year, month, 1);
	 firstpos = (first - THIS.startWeekOn + 7) % nDays;

	 lastpos = firstpos + NumberOfDays(THIS.year, month);

	 if(((week*nDays+dpos) >= firstpos) &&
	    ((week*nDays+dpos) < lastpos)) {
	     char buf[8];
	     int vCenter, hCenter;

	     day = (week*nDays+dpos) - firstpos + 1;
	     res.date.day = day;

	     vCenter = (THIS.dayHeight - (THIS.dayMargin * 2) 
			- THIS.dayFont->ascent)/2 + THIS.dayMargin;
	     THIS.selected.x = x + dpos*THIS.dayWidth + THIS.dayMargin;
	     THIS.selected.y = y+week*THIS.dayHeight + THIS.dayMargin;
	     THIS.selected.width = THIS.dayWidth-(THIS.dayMargin*2);
	     THIS.selected.height = THIS.dayHeight-(THIS.dayMargin*2);
	     
	     ConfigureGcs(w, res.date, True);
	     XFillRectangle(dpy, win, THIS.gc,
			    x + dpos*THIS.dayWidth + THIS.dayMargin, 
			    y+week*THIS.dayHeight + THIS.dayMargin,
			    THIS.dayWidth-(THIS.dayMargin*2), 
			    THIS.dayHeight-(THIS.dayMargin*2));
	     
	     sprintf(buf, "%d", day);

	     hCenter = (THIS.dayWidth - 2 * 
			(THIS.dayFont->max_bounds.rbearing - 
			 THIS.dayFont->max_bounds.lbearing)) / 2;
	     XDrawString(dpy, win, THIS.day_gc,
			 THIS.selected.x + hCenter,
			 THIS.selected.y +THIS.dayHeight 
			 - THIS.dayOffset - vCenter,
			 buf, strlen(buf));

	     XFlush(dpy);
	     THIS.selday = res.date;
	     THIS.clicked = &(res.date);
	     if(THIS.dateCallback != NULL) {
		 res.event = event;
		 XtCallCallbacks(w, XtNdateCallback, &res);
	     }
	 }
     }
#undef THIS
}





void
UnselectProc(Widget w, XEvent *event, String *args, Cardinal  *num_args)
{
    Display *dpy = XtDisplay(w);
    Window win = XtWindow(w);
    YearWidget yw = (YearWidget)w;
    int vCenter, hCenter;
    char buf[8];
#define THIS yw->year

    /* if we clicked outside a month, do nothing */
    if(NULL == THIS.clicked) return;
    vCenter = (THIS.dayHeight - (THIS.dayMargin * 2) 
	       - THIS.dayFont->ascent)/2 + THIS.dayMargin;
    hCenter = (THIS.dayWidth - 2 * 
	       (THIS.dayFont->max_bounds.rbearing - 
		THIS.dayFont->max_bounds.lbearing)) / 2;
    XClearArea(dpy, win, THIS.selected.x, THIS.selected.y,
	       THIS.selected.width, THIS.selected.height, False);
    ConfigureGcs(w, THIS.selday, False);
    XFillRectangle(dpy, win, THIS.gc,
		   THIS.selected.x, THIS.selected.y,
		   THIS.selected.width, THIS.selected.height);
    sprintf(buf, "%d", THIS.clicked->day);
    XDrawString(dpy, win, THIS.day_gc,
		THIS.selected.x + hCenter,
		THIS.selected.y +THIS.dayHeight - THIS.dayOffset - vCenter,
		buf, strlen(buf));
    if(YearFindAppointment(w, THIS.clicked->month, THIS.clicked->day)) {
	XSetForeground(dpy, THIS.gc, 
		       THIS.appointmentColor);
	XDrawRectangle(dpy, win, THIS.gc,
		       THIS.selected.x, THIS.selected.y,
		       THIS.selected.width, THIS.selected.height);

    }
    XFlush(dpy);
#undef THIS
}

 

void
YearAddAppointment(Widget w, Month month, Day day)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    THIS.appointments[day] |= (1 << month);
#undef THIS
}



Boolean
YearFindAppointment(Widget w, Month month, Day day)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    return THIS.appointments[day] & (1 << month);
#undef THIS
}

void
YearScanAppointments(Widget w)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    int month, day;
    Date date;

    for(day = 0; day <=31; day++) {
	THIS.appointments[day] &= 0x0000;
    }
    date.year = THIS.year;
    for(month = 0; month < 12; month++) {
	date.month = month;
	for(day = 0; day <=31; day++) {
	    date.day = day;
	    date.wd = DateToWeekDay(date.year, month, date.day);
	    if(AgendaFindDayAppointment(THIS.agenda, date)) {
		YearAddAppointment(w, month, day);
	    }
	}
    }

#undef THIS
}



void
YearLocateMonth(Widget w, Month month, int *x, int *y)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    int h, v;
    h = month % THIS.Hnum;
    v = month / THIS.Hnum;
    
    *x = (THIS.leftMargin + THIS.xoffset)*h;
    *y = (THIS.topMargin + THIS.yoffset)*v;

#undef THIS
}


Boolean
YearIsClosedDay(Widget w, Month month, Day day)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    return (NULL != (THIS.closedDays[month] & (1 << day)));
#undef THIS
}

void
YearScanClosedDays(Widget w)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    Month m;
    Day  d;
    Date date;
    char buf[512];
    XrmDatabase db;
    char *type;
    XrmValue value;


    db = XrmGetFileDatabase(THIS.closedDaysFile);
    if(NULL == db) return;
    date.year = THIS.year;
    for(m = 0; m < 12; m++) {
	date.month = m;
	THIS.closedDays[m] = 0x00000000;
	for(d = 1; d <= 31; d++) {
	    date.day = d;
	    date.wd = DateToWeekDay(date.year, date.month, date.day);
	    sprintf(buf, "%d.%s.%s.%d.closed", date.year, 
		    MonthName(date.month),
		    WeekDayName(date.wd), date.day);
	    if(XrmGetResource(db, buf, "Year.Month.WeekDay.Day.Closed", 
			      &type, &value)) {
		THIS.closedDays[m] |= (1<<d);
/*		fprintf(stderr, "closed: %s %d %s %d\n", WeekDayName(date.wd),
			date.day, MonthName(date.month), date.year);*/
	    }
	}
    }
    XrmDestroyDatabase(db);
#undef THIS
}


/* formats the given date with the Year widget's resources
 * 
 * returns: 
 */
void
YearGetDateString(Widget w, Date date, char *str)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    char *format = THIS.dateFormat;
    int i;
    char buf[8];

    str[0] = '\0';
    for(i = 0; i < strlen(format); i++) {
	switch(format[i]) {
	case 'y': 
	    sprintf(buf, "%d", date.year);
	    strcat(str, buf);
	    break;
	case 'm':
	    strcat(str, THIS.months[date.month]);
	    break;
	case 'd':
	    sprintf(buf, "%d", date.day);
	    strcat(str, buf);
	    break;
	case 'w':
	    strcat(str, THIS.days[date.wd]);
	    break;
	default:
	    buf[0] = format[i]; buf[1] = '\0';
	    strcat(str, buf);
	}
    }

#undef THIS
}



/* checks if today's date in the widget is today, redraws it if different.
 * 
 * returns: nothing
 */
void
YearCheckToday(Widget w)
{
    YearWidget yw = (YearWidget)w;
#define THIS yw->year
    Date today;

    today = Today();
    if(THIS.today.day != today.day) {
	THIS.today = today;
    }
    ClearWidget(w);
    
#undef THIS
}
