/* multi.h -- local hacks at UNINETT by Sigmund Austigard 1992 */
/*
 *                         COPYRIGHT 1992
 *                            UNINETT
 *                       TRONDHEIM, NORWAY
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY UNINETT. UNINETT MAKES NO
 * REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.
 * IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Uninett not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission.
 *
 */

#ifndef _multi_h
#define _multi_h

#ifdef MULTI
#define extrn
#else
#define extrn extern
#endif

#define LINELENGTH 4096
#define SEGMENTSIZE 8150

typedef enum {
    text, multipart, message, application, image, audio, video
    } _content_type;

typedef enum {
    plain, richtext,                        /* for text */
    mixed, alternative, digest, parallel,   /* for multipart */
    rfc822, partial, externalbody,          /* for message */
    octetstream, postscript, oda, wcl,          /* for application */
    jpeg, gif, xpm,                          /* for image */
    basic,                                  /* for audio */
    mpeg                                    /* for video */
    } _content_subtype;

typedef enum {
    usascii, iso88591, iso88592, iso88593, iso88594, iso88595,
    iso88596, iso88597, iso88598, iso88599
    } _charsets;

typedef enum {
    bit7, bit8, binary, base64, quoted
    } _encoding;

typedef struct {
    _content_type    contentType;
    _content_subtype contentSub;
    _encoding        encoding;
    _charsets        charset;
    Boolean          needBoundary;
    String           boundary;             /* for multipart */
} Switches;

typedef struct buf_struct {
    struct buf_struct *next;
    size_t length;
    u_char line[SEGMENTSIZE];
} buf_list;

typedef unsigned char *UString;

typedef struct _Multi_Part {
    Switches      *switches;
    String        label;
    UString       body;
    UString       data;
    Cardinal      size;
    struct _Multi_Part *next;
    struct _Multi_Part *prev;
    struct _Multi_Part *multi;
    struct _Multi_Part *multihead;
    Boolean       deleted;
} Multi_Part;


/*typedef struct _Multi_List {
    Multi_Part         *part;
    struct _Multi_List *next;
} Multi_List; */


extrn String MixmhEncodeMessage();
extrn Boolean MultiSaveChanges();
extrn Boolean MixmhSaveStringToFile();
extrn Widget initPartstable();
extrn Multi_Part *MixmhMakeMultiView();
extrn UString MixmhMakeViewBuffer();


extern void ParseMimeMessage();
extern void PrintSwitches();
#endif
