/*
Copyright (c) 1991 Bell Communications Research, Inc. (Bellcore)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of Bellcore not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of Bellcore.  BELLCORE 
MAKES NO REPRESENTATIONESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
*/
/****************************************************** 
    Metamail -- A tool to help diverse mail readers 
                cope with diverse multimedia mail formats.

    Author:  Nathaniel S. Borenstein, Bellcore
    Copyright 1990 Bellcore -- All Rights Reserverd

 ******************************************************* */
#include <andrewos.h>
#incewos.h>
#include <stdio.h>
#include <pwd.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sgtty.h>
#include <signal.h>

#define CMDSIZE 1200 /* Maximum size of command to execute */

#ifndef _IBMR2
extern char *malloc(), *realloc();
#endif
extern char *getenv(), *index(), *rindex(), **environ, *gets();

char *FindParam();
extern FILE *popen();
static char *nomem = "Out of memory!";
static char *mmversion = "2.1";
static char *NoAskDefault = "text,text/plain,text/richtex/plain,text/richtext";
static char *QuietDefault = "cat";

struct MailcapEntry {
    char *contenttype;
    char *command;
    char *testcommand;
    int needsterminal;
    int copiousoutput;
    int needtofree;
};

FILE *InputFP = NULL;

int MightAskBeforeExecuting = 1,
    DefinitelyNotTty = 0,
    MaybePageOutput = 0,
    EatLeadingNewlines = 0,
    PrintSomeHeaders = 1,
    DoInBackground = 0,
    Quiet = 0,
    TransparentMode = 0,
    Is822Format = 1,
    DoDebug = 0,
    CParamsAlloced = 0,
    CParamsAlloced = 0,
    CParamsUsed = 0;

char *ContentType = NULL,
    *ContentEncoding = NULL,
    *MailerName = "unknown",
    *MailSubject = "Mail message",
    *MailFrom = "unknown sender",
    *MailSummary = "non-text mail message",
    *mailheaders = NULL,
    **CParams = NULL,
    **CParamValues = NULL,
    *JunkParameter = NULL;

#define ENCODING_NONE 0
#define ENCODING_BASE64 1
#define ENCODING_QUOTEDPRINTABLE 2
#define ENCODING_8BIT 3
int EncodingCode = ENCODING_NONE;

struct NoAskItem {
    char *tkItem {
    char *type;
    struct NoAskItem *next;
} *FirstNoAskItem = NULL,
  *FirstQuietItem = NULL;

char *Cleanse(s) /* no leading or trailing space, all lower case */
char *s;
{
    char *tmp, *news;
    
    /* strip leading white space */
    while (*s && isspace(*s)) ++s;
    news = s;
    /* put in lower case */
    for (tmp=s; *tmp; ++tmp) {
        if (isupper(*tmp)) *tmp = tolower(*tmp);
    }
    /* strip trailing white space */
    while (--tmp && *tmp && isspace(*tmp)) *tmp = NULL;
    retur = NULL;
    return(news);
}

char *UnquoteString(s)
char *s;
{
    char *ans, *t;

    if (*s != '"') return(s);
    ans = malloc(1+strlen(s));
    if (!ans) errorexit(nomem);
    ++s;
    t = ans;
    while (*s) {
        if (*s == '\\') {
            *t++ = *++s;
        } else if (*s == '"') {
            break;
        } else {
            *t++ = *s;
        }
        ++s;
    }
    *t = NULL;
    return(ans);
}

cleanup(signum) 
int signum;
{
    signal(signum, SIG_DFL);
    kill(getpid()m, SIG_DFL);
    kill(getpid(), signum);
}

char **Boundaries = NULL;
int BoundaryCt = 0, BoundaryAlloc = 0;

main(argc, argv)
int argc;
char **argv;
{
    signal(SIGINT, cleanup);
    signal(SIGILL, cleanup);
    signal(SIGTRAP, cleanup);
    signal(SIGIOT, cleanup);
    signal(SIGEMT, cleanup);
    signal(SIGFPE, cleanup);
    signal(SIGBUS, cleanup);
    signal(SIGSEGV, cleanup);
    signal(SIGTERM, cleanup);
#ifdef SIGXCPU
    signal(SIGXCPU, cleanup);
#endif
    ProcessArguments(argc, argv); /* exits on error v); /* exits on error */
    exit(HandleMessage(NULL));
}

HandleMessage(SquirrelFile)
char *SquirrelFile;
/* SquirrelFile, if non-NULL, is a place to save a recognized body instead of executing it. */
{
    if (Is822Format) {
        Read822Prefix(SquirrelFile?0:1);
    } else Is822Format = 1; /* this property is not recursive for multipart or message */
    PrepareMessage();
    if (!ProcessMailcapFiles(SquirrelFile)) return(0);
    if (!lc2strcmp(ContentType, "message")
         || !lc2strcmp(ContentType, "messantType, "message/rfc822")) {
        if (SquirrelFile) return(SaveSquirrelFile(SquirrelFile));
        ContentType = NULL; /* reset default */
        ContentEncoding = NULL; /* reset default */
        return(HandleMessage(NULL)); /* simple recursion */
    }
    if (!lc2strncmp(ContentType, "multipart", 9)) {
        char *tmp, *boundary, LineBuf[2000], NewSquirrelFile[1000];
        char *subtype = NULL;
        int currct, result, IsAlternative, WroteSquirrelFile;

        if (SquirrelFile) return(SaveSquirn(SaveSquirrelFile(SquirrelFile));
        boundary = FindParam("boundary");
        if (!boundary) boundary =JunkParameter; /* backward compatibility hack */
        if (boundary[0] == '"') {
            boundary=UnquoteString(boundary);
        }
        if (!boundary) {
            fprintf(stderr, "There is no multipart boundary specified\n");
            exit(-1);
        }
        subtype = index(ContentType, '/');
        if (subtype) {
            ++subtype;
            subtype = Cleanse(subtype);nse(subtype);
        } else subtype = "mixed";
        DoInBackground = strcmp(subtype, "parallel") ? 0 : 1;
        IsAlternative = strcmp(subtype, "alternative") ? 0 : 1;
        if (IsAlternative) {
            MkTmpFileName(NewSquirrelFile);
            WroteSquirrelFile = 0;
        }
        sprintf(LineBuf, "--%s", boundary);
        strcpy(boundary, LineBuf);
        if (BoundaryCt >= BoundaryAlloc) {
            BoundaryAlloc += 5;
            if (Boundaries) {
                Boundaries = (char *ies = (char **) realloc(Boundaries, BoundaryAlloc*sizeof(char *));
            } else {
                Boundaries = (char **) malloc(BoundaryAlloc*sizeof(char *));
            }
            if (!Boundaries) errorexit(nomem);
        }
        Boundaries[BoundaryCt++] = boundary;
        if (DoDebug) printf("Handling multipart as built-in here.  Boundary: %s\n", boundary);
        while (fgets(LineBuf, sizeof(LineBuf), InputFP)) { /* find start */
            if (!strncmp(LineBuf, boundary, strlen(boundary))) bdary))) break;
        }
        currct = BoundaryCt;
        while(currct == BoundaryCt) {
            if (!strcmp(subtype, "digest")) {
                ContentType = "message/rfc822";
            } else {
                ContentType = NULL; /* reset default */
            }
            ContentEncoding = NULL; /* reset default */
            if (IsAlternative) {
                result = HandleMessage(NewSquirrelFile);
            } else{
                result = HandleMessage(NULL);
            }
            }
            if (result) {
                /* Need to consume the rest of the part */
                ConsumeRestOfPart(NULL);
            } else {
                ++WroteSquirrelFile;
            }
        }
        /* Now we've seen the last encapsulation boundary, but if there is a "postfix"
            we must throw it away.*/
        if (BoundaryCt > 0) {
            ConsumeRestOfPart(NULL);
        }
        if (IsAlternative) {
            if (WroteSquirrelFile) {
                int retcod    int retcode; 
                char Cmd[1300];
                sprintf(Cmd, "metamail %s", NewSquirrelFile);
                retcode = system(Cmd);
                unlink(NewSquirrelFile);
                return(retcode);
            } else {
                printf("Cannot handle any part of multipart/alternative message\n");
            }
        }
        return(0);
    }
    if (!TryBuiltIns(SquirrelFile)) return(0);
    if (!SquirrelFile) { /* Very last resort -- unrecognized types */
        char Fn       char Fname[1000], *s;
        FILE *fp;
        if (MightAskBeforeExecuting
             && !DefinitelyNotTty) {
            printf("\nThis message contains data in an unrecognized format, %s,\nwhich can be decoded and written to a file.\nPlease enter the name of a file to which the data should be written,\nor just press RETURN to skip writing it to a file.\n", ContentType);
            s = (char *) gets(Fname);
        } else {
            MkTmpFileName(Fname);
            printf("\nThis message contains ontains data in an unrecognized format, %s,\nwhich is being decoded and written to the file named %s.\nIf you do not want this data, you probably should delete that file.\n", ContentType, Fname);
        }
        if (Fname[0] == NULL || Fname[0] == '\n') {
            ConsumeRestOfPart(NULL);
            return(0);
        } else {
            fp = fopen(Fname, "w");
            if (!fp) errorexit("Cannot open temporary file");
            TranslateInputToOutput(InputFP, fp, EncodingCode);
            ret      return(fclose(fp));
        }
    }
    return(-1); /* Unrecognized, really */
}

ProcessArguments(argc, argv)
int argc;
char **argv;
{
    int i, RunAsRootOK = 0, DeleteSourceFileWhenDone = 0;
    char *SourceFileName = NULL, *NoAskStr, TmpName[1200], *QuietStr;

    QuietStr = getenv("MM_QUIET");
    if (!QuietStr) {
        QuietStr=QuietDefault;
    }
    if (!strcmp(QuietStr, "1")) {
        Quiet = 1;
    } else {
        struct NoAskItem *qitem;
        char *s, *tmp;
        char *QuietCopy;

        Quiet = 0;
        QuietCopy = malloc(1+strlen(QuietStr));
        if (!QuietCopy) errorexit(nomem);
        strcpy(QuietCopy, QuietStr);
        for (tmp=QuietCopy; *tmp; ++tmp) {
            if (isupper(*tmp)) *tmp = tolower(*tmp);
        }
        do {
            s = index(QuietCopy, ',');
            if (s) *s++ = NULL;
            qitem = (struct NoAskItem *) malloc(sizeof (struct NoAskItem));
            if (!qitem) errorexit(nomem);
            qitem->next = Firstm);
            qitem->next = FirstQuietItem;
            qitem->type = QuietCopy;
            FirstQuietItem = qitem;
            QuietCopy = s;
        } while (QuietCopy);
    }
    if (getenv("MM_TRANSPARENT")) {
        TransparentMode = atoi(getenv("MM_TRANSPARENT")); /* Will not propogate recursively */
    }
    if (getenv("MM_DEBUG")) {
        DoDebug = atoi(getenv("MM_DEBUG"));
    }
    if (DoDebug) printf("Metamail Version %s, debugging turned on.\n", mmversion);
    NoAskStr = getenv("MM_NOASK");
    if (!NoAskStr if (!NoAskStr) NoAskStr = NoAskDefault;
    if (!strcmp(NoAskStr, "1")) {
        MightAskBeforeExecuting = 0;
    } else {
        struct NoAskItem *nai;
        char *s, *tmp;
        char *NoAskCopy;

        NoAskCopy = malloc(1+strlen(NoAskStr));
        if (!NoAskCopy) errorexit(nomem);
        strcpy(NoAskCopy, NoAskStr);
        for (tmp=NoAskCopy; *tmp; ++tmp) {
            if (isupper(*tmp)) *tmp = tolower(*tmp);
        }
        do {
            s = index(NoAskCopy, ',');
            if (s) *        if (s) *s++ = NULL;
            nai = (struct NoAskItem *) malloc(sizeof (struct NoAskItem));
            if (!nai) errorexit(nomem);
            nai->next = FirstNoAskItem;
            nai->type = NoAskCopy;
            FirstNoAskItem = nai;
            NoAskCopy = s;
        } while (NoAskCopy);
    }
    MailerName = getenv("MM_MAILER");
    if (!MailerName) MailerName = "unknown";
    if (getenv("MM_USEPAGER")) {
        MaybePageOutput = atoi(getenv("MM_USEPAGER"));
    }
    if (/* !isatty(0)
 * !isatty(0)
         || !isatty(1)  || */
         (getenv("MM_NOTTTY") && ((atoi(getenv("MM_NOTTTY"))) != 0))) {
	DefinitelyNotTty = 1;
    }
    for (i=1; i<argc; ++i) {
	if (argv[i][0] == '-') {
	    switch (argv[i][1]) {
		case 'b':
		    Is822Format = 0;
		    break;
		case 'B':
		    DoInBackground = 1;
		    break;
		case 'c':
		    if (++i >= argc) usage();
		    ContentType = argv[i];
		    break;
		case 'd':
		    MightAskBeforeExecuting = 0;
		    break;
		case 'e':
		    EatLeadingNewlines = 1;
		    break;
		case 'E':
		    if (++i >= argc) usage();
		    ContentEncoding = argv[i];
		    break;
		case 'f':
		    if (++i >= argc) usage();
		    MailFrom = argv[i];
		    break;
		case 'm':
		    if (++i >= argc) usage();
		    MailerName = argv[i];
		    break;
		case 'p':
		    MaybePageOutput = 1;
		    break;
		case 'r':
		    RunAsRootOK = 1;
                    break;
                case 'R':
                    system("/usr/ucb/reset");
                    if (DoDebug) printf("Executed reset\n");
                    break;
		case 's':
		    if (++i >= argc) usage();
		    MailSubject = argv[i];
		    break;
                case 'T':
                    TransparentMode = 0;
                    break;
                case 'q':
                    Quiet = 1;
		    PrintSomeHeaders = 0;
		    break;
		case 'x':
		    DefinitelyNotTty = 1;
		    break;
		case 'z':
		    DeleteSourceFileWhenDone = 1;
		    break;
		default:
		    usage();
	    }
	} else {
	    if (SourceFileName) {
		usage();
	    } else {
		SourceFileName = argv[i];
	    }
	}
    }
    if (TransparentMode) {
        /* In transparent mode, we want to produce stdout that is what we get in, and do EVERYTHING externally in a terminal window.  This is to make the truly brain-dead mailers like mailtool happy. I am NOT happy about having to do this.  */
        char FullCmd[CMDSIZE];
        int createdfile=0;
        /* So, first we copy everything to stdout */
        if (!edfile=0;
        /* So, first we copy everything to stdout */
        if (!SourceFileName) {
            char LineBuf[2000];
            FILE *fptmp;
            /* Create it, ugh.  Also needs to affect later command. */
            MkTmpFileName(TmpName);
            DeleteSourceFileWhenDone = 1;
            fptmp = fopen(TmpName, "w");
            if (!fptmp) errorexit("Can't open temporary file\n");
            while (fgets(LineBuf, sizeof(LineBuf), stdin)) {
                fputs(LineBuf, fptmp);
            }
            fclose(fptmp);
            SourceFileName =ceFileName = TmpName;
            createdfile = 1;
        }
        sprintf(FullCmd, "cat %s", SourceFileName);
        system(FullCmd); /* Cheesy way to do it */
        /* Then we run ourselves in a terminal window */
        MailSummary = "Metamail"; /* for window label */
        CreateNewWindowPrefix(FullCmd);
        strcat(FullCmd, "metamail -p -T ");
        for (i=1; i<argc; ++i) {
            if (strncmp(argv[i], "-x", 2)) {
                strcat(FullCmd, argv[i]);
                strcat(FullCmdrcat(FullCmd, " ");
            }
        }
        if (createdfile) {
            strcat(FullCmd, "-z ");
            strcat(FullCmd, SourceFileName);
        }
        DefinitelyNotTty = 0;
        SetUpEnvironment();
        if (DoDebug) fprintf(stderr, "Transparent mode:  executing %s\n", FullCmd);
        exit(system(FullCmd));
    }
    if (DefinitelyNotTty && MightAskBeforeExecuting) {
        char FullCmd[CMDSIZE];
        MailSummary = "Metamail"; /* for window label */
        CreateNewWindowPreateNewWindowPrefix(FullCmd);
        strcat(FullCmd, " metamail -p ");
        for (i=1; i<argc; ++i) {
            if (strncmp(argv[i], "-x", 2)) {
                strcat(FullCmd, argv[i]);
                strcat(FullCmd, " ");
            }
        }
        DefinitelyNotTty = 0;
        SetUpEnvironment();
        exit(system(FullCmd));
    }
    if (!Is822Format && !ContentType) {
	fprintf(stderr, "metamail:  -b requires -c.\n");
	usage();
    }
    if (DeleteSourceFileWhenDone && !SourceFileName) {
urceFileName) {
	fprintf(stderr, "metamail:  -z requires -f.\n");
	usage();
    }
    if (!RunAsRootOK && (getuid() == 0 || geteuid() == 0)) {
	fprintf(stderr, "You can not run MetaMail as root unless you use -r.");
	usage();
    }
    if (SourceFileName) {
        InputFP = fopen(SourceFileName, "r");
        if (!InputFP) errorexit("Can't read input file");
        if (DeleteSourceFileWhenDone) unlink(SourceFileName);
    } else InputFP = stdin;
    return(0);
}

usage() {
    fprintf(stderr, "Usage:  metrr, "Usage:  metamail [-b] [-B] [-d] [-e] [-r] [-R] [-p] [-x] [-z] [-c content-type] [-E content-transfer-encoding] [-f from-name] [-m mailername] [-s subject] [message-file-name]\n");
    exit(-1);
}

/* Only one or the other set up builtins gets used,
  depending on whether or not we're in the middle of 
          a multipart/alternative body part */
struct MailcapEntry BuiltIns[] = {
    {"text/*", "cat %s", NULL, 0, 1, 0},
    {NULL, NULL, NULL, 0, 0, 0}};

struct MailcapEntry BuiltInsAlternative[] = {
    [] = {
    {"text/plain", "cat %s", NULL, 0, 1, 0},
    {NULL, NULL, NULL, 0, 0, 0}};

ProcessMailcapFiles(SquirrelFile) 
char *SquirrelFile;
{
    char *path;

    if (path = getenv("MAILCAPS")) { /* color-seperated list of possible mailcaps */
        char *pathcopy, *s;
        pathcopy = malloc(1+strlen(path));
        if (!pathcopy) errorexit(nomem);
        strcpy(pathcopy, path);
        path = pathcopy;
	while(path) {
	    s = index(path, ':');
	    if (s) *s++ = NULL;
	    if (!ProcessMailcap (!ProcessMailcapFile(path, SquirrelFile)) return(0);
	    path = s;
	}
    } else {
	char *userPath;
	char *andrewPath;
	static char *stdpaths[] = { 
	    "/.mailcap",
	    "/etc/mailcap",
	    "/usr/local/etc/mailcap",
	    "/usr/etc/mailcap",
	    "/etc/mailcap",
	    "/usr/public/lib/mailcap",
	    NULL
	};
        int uid = getuid(), i;
        struct passwd *p;
        p = getpwuid(uid);
        if (p) userPath = malloc(5 + strlen(p->pw_dir) + strlen(stdpaths[0]));
        if (!p || !userPath) error|| !userPath) errorexit(nomem);
        strcpy(userPath, p->pw_dir);
        strcat(userPath, stdpaths[0]);
	if (!ProcessMailcapFile(userPath, SquirrelFile)) {
	    free(userPath);
	    return(0);
	}
	andrewPath = (char *) AndrewDir(stdpaths[1]);
	if (!ProcessMailcapFile(andrewPath, SquirrelFile)) {
	    free(andrewPath);
	    return(0);
	}
	for( i = 2; stdpaths[i] != NULL; i++ )
	    if (!ProcessMailcapFile(stdpaths[i], SquirrelFile)) 
		return(0);
    }
    return(-1);
}

TryBuiltIns(SquirrelFile) 
char quirrelFile) 
char *SquirrelFile;
{
    char Buf[2000];
    int i;
    /* Last resort -- for sites that didn't bother putting a "text" line in their mailcap files... */
    if (DoDebug) fprintf(stderr, "Looking for '%s' in built-in content-type handling settings.\n", ContentType);
    for (i=0; BuiltIns[i].contenttype; ++i) {
        if (!TryMailcapEntry(SquirrelFile ? BuiltInsAlternative[i] : BuiltIns[i], SquirrelFile))    return(0);
    }
    return(-1);
}

ProcessMailcapFile(file, SquirrelFile)
char *file, *Sqar *file, *SquirrelFile;
{
    struct MailcapEntry mc;
    FILE *fp = fopen(file, "r");

    if (DoDebug) fprintf(stderr, "Looking for '%s' in mailcap file '%s'.\n", ContentType, file);
    while (fp && !feof(fp)) {
	if (GetMailcapEntry(fp, &mc)) {
            if (!TryMailcapEntry(mc, SquirrelFile)) return(0);
	}
    }
    if (fp) fclose(fp);
    return(-1);
}

char *ShortCommand(progname)
char *progname;
{
    char *s;
    static char FullProgName[500];
    while (*progname && (*progname == '(' || iprogname == '(' || isspace(*progname))) ++progname;
    strcpy(FullProgName, progname);
    s = index(FullProgName, ' ');
    if (s) *s = NULL;
    s = rindex(FullProgName, '/');
    if (s) {
	return(s+1);
    } else {
	return(FullProgName);
    }
}

TryMailcapEntry(mc, SquirrelFile)
struct MailcapEntry mc;
char *SquirrelFile;
{
    StripTrailingSpace(mc.contenttype);
    if (DoDebug) fprintf(stderr, "Trying mailcap entry for '%s'.\n", mc.contenttype);
    if (CtypeMatch(ContentType, mc.contenttype) && Passesenttype) && PassesTest(&mc)) {
        char cmd[CMDSIZE], *s;

        if (SquirrelFile) {
            return(SaveSquirrelFile(SquirrelFile));
        } else {
            char TmpFileName[1000];
            MkTmpFileName(TmpFileName);
            return(ExecuteMailcapEntry(mc, TmpFileName, ContentType, 1));
        }
    }
    if (mc.needtofree) {
        free(mc.contenttype);
        free(mc.command);
    }
    return(-1);
}

SaveSquirrelFile(SquirrelFile)
char *SquirrelFile;
{
    int j;
    FILE *ou  int j;
    FILE *outfp;
    outfp = fopen(SquirrelFile, "w");
    if (!outfp) {
        fprintf(stderr, "Cannot open %s to squirrel away a portion of a multipart/alternative\n", SquirrelFile);
        return(-1);
    }
    fprintf(outfp, "Content-type: %s", ContentType);
    for (j=0; j<CParamsUsed; ++j) {
        fprintf(outfp, " ; ");
        fprintf(outfp, CParams[j]);
        fprintf(outfp, " = ");
        fprintf(outfp, CParamValues[j]);
    }
    fprintf(outfp, "\n\n"); 
    TranslateInputToOutput(InputFP,utput(InputFP, outfp, EncodingCode);
    if (fclose(outfp)) {
        errorexit("fclose failed");
    }
    return(0);
}

ExecuteMailcapEntry(mc, TmpFileName, ThisContentType, NeedToWriteTmpFile)
char *TmpFileName, *ThisContentType;
struct MailcapEntry mc;
int NeedToWriteTmpFile;
{
    int resultcode, DidExecute, UsedTmpFileName;
    char *s, cmd[CMDSIZE];

    BuildCommand(cmd, mc.command, TmpFileName, &UsedTmpFileName);
    if (DoDebug) fprintf(stderr, "Match!  Built command %s.\n", cmd);
    if (mc.co);
    if (mc.copiousoutput && MaybePageOutput) {
        strcat(cmd, " | ");
        s = getenv("METAMAIL_PAGER");
        if (s && strncmp(s, "metamail", 8)) {
            /* If METAMAIL_PAGER is set to "metamail" we override it */
            strcat(cmd, s);
        } else {
            strcat(cmd, "more");
        }
    }
    if (!DefinitelyNotTty) {
        SaveTtyState();
    }
    if (!NeedToAskBeforeExecuting(ThisContentType)
         || OKToRun(ThisContentType, cmd)) {
        /* Limit size of core t size of core dumps */
        char FullCmd[CMDSIZE];
        struct rlimit rlp;

        rlp.rlim_cur = 0;
        rlp.rlim_max = 0;

#if defined(hpux) && (HP_OS >= 80)
#define RLIMIT_CORE 4
#endif
        setrlimit(RLIMIT_CORE, &rlp); 
        if (mc.needsterminal
             && DefinitelyNotTty) {
            CreateNewWindowPrefix(FullCmd);
            strcat(FullCmd, cmd);
        } else {
            strcpy(FullCmd, cmd);
        }
        DidExecute = 0;
        if (UsedTmpFileName) {
         leName) {
            int isempty;
            if (NeedToWriteTmpFile) {
                isempty = WriteTmpFile(TmpFileName);
            } else isempty = 0;
            if (!isempty || strncmp(ThisContentType, "text", 4)) {
                if (DoInBackground && !mc.needsterminal) {
                    char TmpCmd[CMDSIZE];
                    sprintf(TmpCmd, "(%s; rm %s) &", FullCmd, TmpFileName);
                    resultcode = ExecuteCommand(TmpCmd, 1);
                    ++DidExecute;
                } else {  } else {
                    resultcode = ExecuteCommand(FullCmd, 1);
                    unlink(TmpFileName);
                    ++DidExecute;
                }
            } else { /* empty text part, hack to not say "more" */
                unlink(TmpFileName);
            }
        } else {
            FILE *tmpfp;
            ExecuteCommand(FullCmd, 0);
            tmpfp = popen(FullCmd, "w");
            if (!NeedToWriteTmpFile) {
                FILE *tmpfp2;
                int c;

         c;

                tmpfp2 = fopen(TmpFileName, "r");
                if (!tmpfp2) errorexit("Cannot read tmp file");
                while ((c=getc(tmpfp2)) != EOF) {
                    putc(c, tmpfp);
                }
                fclose(tmpfp2);
            } else {
                TranslateInputToOutput(InputFP, tmpfp, EncodingCode);
            }
            resultcode = tmpfp ? pclose(tmpfp) : -1;
            ++DidExecute;
        }
        if (!DefinitelyNotTty && DidExecute) {
            Rest         RestoreTtyState();
            if (mc.copiousoutput && MaybePageOutput) {
                char AnsBuf[100], *s;
                printf("Press RETURN to go on.\n");
                s = gets(AnsBuf);
            }
        }
        if (!resultcode) {
            return(0);
        } else {
            if (DoDebug) fprintf(stderr, "Command execution apparently failed.\n");
            exit(-1);
        }
    } else {
        int InMultipart = BoundaryCt > 0 ? 1 : 0;
        char Buf[2000];
        2000];
        /* user does not want to execute command */
        if (!DefinitelyNotTty) {
            RestoreTtyState();
        }
        if (DoDebug) fprintf(stderr, "Not executing command.\n");
        ConsumeRestOfPart(NULL);
        return(0); /* Did as requested, after all */
    }
    if (!DefinitelyNotTty) {
        RestoreTtyState();
    }
    return(0);
}

PassesTest(mc)
struct MailcapEntry *mc;
{
    int result;
    char cmd[CMDSIZE], TmpFileName[1000];

    if (!mc->testcommand) return(1)stcommand) return(1);
    MkTmpFileName(TmpFileName);
    BuildCommand(cmd, mc->testcommand, TmpFileName, NULL);
    result = system(cmd);
    return(!result);
}

char *
GetCommand(s, t)
char *s, **t;
{
    char *s2;
    int quoted = 0;
    s2 = malloc(strlen(s)*2); /* absolute max, if all % signs */
    if (!s2) errorexit(nomem);
    *t = s2;
    while (s && *s) {
	if (quoted) {
            if (*s == '%') *s2++ = '%'; /* Quote through next level, ugh! */

            *s2++ = *s++;
	    quoted = 0;
	} els   quoted = 0;
	} else {
	    if (*s == ';') {
		*s2 = NULL;
		return(++s);
	    }
	    if (*s == '\\') {
		quoted = 1;
		++s;
	    } else {
		*s2++ = *s++;
	    }
	}
    }
    *s2 = NULL;
    return(NULL);
}	

GetMailcapEntry(fp, mc)
FILE *fp;
struct MailcapEntry *mc;
{
    int rawentryalloc = 2000, len;
    char *rawentry, *s, *t, LineBuf[2000];

    rawentry = malloc(1 + rawentryalloc);
    if (!rawentry) errorexit(nomem);
    *rawentry = NULL;
    while (fgets(LineBuf, sizeof(LineBuf), fp)) {
	ifsizeof(LineBuf), fp)) {
	if (LineBuf[0] == '#') continue;
	len = strlen(LineBuf);
	if (LineBuf[len-1] == '\n') LineBuf[--len] = NULL;
	if ((len + strlen(rawentry)) > rawentryalloc) {
	    rawentryalloc += 2000;
	    rawentry = realloc(rawentry, rawentryalloc+1);
	    if (!rawentry) errorexit(nomem);
	}
	if (LineBuf[len-1] == '\\') {
	    LineBuf[len-1] = NULL;
	    strcat(rawentry, LineBuf);
	} else {
	    strcat(rawentry, LineBuf);
	    break;
	}
    }
    for (s=rawentry; *s && isspace(*s); ++s) ;
    if (!*s) {
	
    if (!*s) {
	/* totally blank entry -- quietly ignore */
	free(rawentry);
	return(0);
    }
    s = index(rawentry, ';');
    if (!s) {
	fprintf(stderr, "metamail: Ignoring invalid mailcap entry: %s\n", rawentry);
	free(rawentry);
	return(0);
    }
    *s++ = NULL;
    mc->needsterminal = 0;
    mc->copiousoutput = 0;
    mc->needtofree = 1;
    mc->testcommand = NULL;
    mc->contenttype = malloc(1+strlen(rawentry));
    if (!mc->contenttype) errorexit(nomem);
    strcpy(mc->contenttype, rawentry);
  pe, rawentry);
    t = GetCommand(s, &mc->command);
    if (!t) {
        free(rawentry);
        return(1);
    }
    while (s && *s && isspace(*s)) ++s;
    s = t;
    while (s) {
	char *arg, *eq;

        t = GetCommand(s, &arg);
	if (t) *t++ = NULL;
        eq = index(arg, '=');
        if (eq) *eq++ = NULL;
        arg = Cleanse(arg);
	if (!strcmp(arg, "needsterminal")) {
	    mc->needsterminal = 1;
	} else if (!strcmp(arg, "copiousoutput")) {
	    mc->copiousoutput = 1;
        } else if (eq && !strelse if (eq && !strcmp(arg, "test")) {
            mc->testcommand = eq;
	} else if (strcmp(arg, "notes")) { /* IGNORE notes field */
	    if (*arg && DoDebug) fprintf(stderr, "metamail: Ignoring invalid mailcap flag: %s\n", arg);
	}
	s = t;
    }
    free(rawentry);
    return(1);
}

errorexit(txt)
char *txt;
{
    if (txt) fprintf(stderr, "metamail: %s\n", txt);
    exit(-1);
}

char *
FreshHeaderCopy(s)
char *s;
{
    char *t, *newcopy;
    int len;

    while (s && *s && isspace(*s) && *s != '\n')sspace(*s) && *s != '\n') ++s;
    t = index(s, '\n');
    while (t && (*(t+1) == ' ' || *(t+1) == '\t')) {
        t = index(t+1, '\n');
    }
    len = t ? (t-s+1) : (strlen(s)+1);
    newcopy = malloc(len+1);
    if (!newcopy) errorexit(nomem);
    strncpy(newcopy, s, len);
    newcopy[len] = NULL;
    return(newcopy);
}

Read822Prefix(PrintHeads)
int PrintHeads;
{
    int SawNewline = 1, bytes = 0, alloced = 1000;
    char c, *s, *t, *tmp;

    if (!PrintSomeHeaders) PrintHeads = 0;
    mailheaders = malloc(alloced+1);
    if (!mailheaders) errorexit(nomem);
    strcpy(mailheaders, "MM_HEADERS=\n");
    bytes = 12;
    t = mailheaders + bytes;
    while ((c = getc(InputFP)) != EOF) {
        if (++bytes >= alloced) {
            alloced += 1000;
            mailheaders = realloc(mailheaders, alloced);
            if (!mailheaders) errorexit(nomem);
            t = mailheaders + bytes - 1;
        }
        if (c == '\n') {
            if (SawNewline) break;
            SawNewline = 1;
        } else SawNewline = 0;
        *t++ = c;
    }
    *t = NULL;
    if (c == EOF) errorexit("Could not find end of mail headers");
    for (s=mailheaders+11; *s; ++s) {
        if (*s == '\n' && (*(s+1) != ' ') && (*(s+1) != '\t')) {
            if (!ContentType && !lc2strncmp(s, "\ncontent-type:", 14)) {
                ContentType = FreshHeaderCopy(s+14);
                StripTrailingSpace(ContentType);
                ParseContentParameters(ContentType);
            } else if (!ContentEncoding && !lc2strncmp(s, "\ncontent-transfer-encoding:", 27)) {
                ContentEncoding = FreshHeaderCopy(s+27);
            } else if (!lc2strncmp(s, "\nsubject:", 9)) {
                if (PrintHeads) phead(s+1);
                MailSubject = FreshHeaderCopy(s+9);
            } else if (!lc2strncmp(s, "\nfrom:", 6)) {
                if (PrintHeads) phead(s+1);
                MailFrom = FreshHeaderCopy(s+6);
            } else if (PrintHeads && !lc2strncmp(s, "\ncontent-description:", 4)) {
                phead(s+1);
            } else if (PrintHeads && !lc2strncmp(s, "\nto:", 4)) {
                phead(s+1);
            } else if (PrintHeads && !lc2strncmp(s, "\ncc:", 4)) {
                phead(s+1);
            }
        }
    }
    if (PrintHeads) printf("\n");
    if (!ContentType) ContentType = "text/plain";
    for (tmp=ContentType; *tmp; ++tmp) {
        if (isupper(*tmp)) *tmp = tolower(*tmp);
    }
}

PrepareMessage() {
    int c;

    EncodingCode = ENCODING_NONE;
    if (ContentEncoding) {
        /* strip leading white space */
        while (*ContentEncoding && isspace(*ContentEncoding)) ++ContentEncoding;
        StripTrailingSpace(ContentEncoding);
        if (!lc2strcmp(ContentEncoding, "base64")) {
            EncodingCode = ENCODING_BASE64;
        } else if (!lc2strcmp(ContentEncoding, "quoted-printable")) {
            EncodingCode = ENCODING_QUOTEDPRINTABLE;
        } else {
            if (lc2strcmp(ContentEncoding, "none")
                 && !lc2strcmp(ContentEncoding, "8bit")
                 && !lc2strcmp(ContentEncoding, "7bit")) {
                fprintf(stderr, "Ignoring unrecognized Content-Transfer-Encoding value: %s\n", ContentEncoding);
            }
        }
    }
    if (EatLeadingNewlines) {
        while ((c = getc(InputFP)) != EOF) {
            if (c != '\n') {
                ungetc(c, InputFP);
                break;
            }
        }
    }
    SetUpEnvironment();  
}

SetUpEnvironment() { 
    int i, j, environsize;
    char **newenviron, *mailervar, *summaryvar, *ctypevar, *versvar, *idvar, *s;
    static char ttyenv[15], debugenv[15], *noaskenv, pagerenv[15], *quietenv;

    for (environsize=0; environ[environsize]; ++environsize) {
	;
    }
    newenviron = (char **) malloc(sizeof(char *) * (16+environsize));
    if (!newenviron) errorexit(nomem);
    mailervar = malloc(13+strlen(MailerName));
    if (!mailervar) errorexit(nomem);
    sprintf(mailervar, "MM_MAILER=%s", MailerName);
    summaryerName));
    if (!mailervar) errorexit(nomem);
    sprintf(mailervar, "MM_MAILER=%s", MailerName);
    summaryvar = malloc(26 + strlen(MailFrom) + strlen(MailSubject));
    if (!summaryvar) errorexit(nomem);
    sprintf(summaryvar, "MM_SUMMARY=%s (from %s)", MailSubject, MailFrom);
    MailSummary = summaryvar+11;
    EliminateNastyChars(MailSummary);
    i = 0;
    if (ContentType) {
        int j, ctypelen = 22+strlen(ContentType);
        for (j=0; j<CParamsUsed; ++j) {
            ctypelen += 6 + strlen(CParams[j]) + strlen(CParamValues[j]);
        }
        ctypevar = malloc(ctypelen);
        if 
        if (!ctypevar) errorexit(nomem);
        for (s=ContentType; *s; ++s) {
            if (isupper(*s)) *s = tolower(*s);
        }
        while (isspace(*--s)) *s = NULL;
        sprintf(ctypevar, "MM_CONTENTTYPE=%s", ContentType);
        for (j=0; j<CParamsUsed; ++j) {
            strcat(ctypevar, " ; ");
            strcat(ctypevar, CParams[j]);
            strcat(ctypevar, " = ");
            strcat(ctypevar, CParamValues[j]);
        }
        newenviron[i++] = ctypevar;
    }
    s = getenv(   s = getenv("MM_ID");
    idvar = malloc(15+(s?strlen(s):0));
    if (!idvar) errorexit(nomem);
    if (s) {
        sprintf(idvar, "MM_ID=%s:%d", s?s:"", getpid());
    } else {
        sprintf(idvar, "MM_ID=%d", getpid());
    }
    newenviron[i++] = idvar;
    if (DoDebug) fprintf(stderr, "Set environ id %s\n", idvar);
    newenviron[i++] = mailheaders ? mailheaders : "MM_HEADERS=unknown";
    newenviron[i++] = mailervar;
    newenviron[i++] = summaryvar;
    sprintf(ttyenv, "MM_NOTTTY=%d", DefinitelyNo DefinitelyNotTty);
    newenviron[i++] = ttyenv;
    sprintf(debugenv, "MM_DEBUG=%d", DoDebug);
    newenviron[i++] = debugenv;
    s = getenv("MM_QUIET");
    if (!s) s = QuietDefault;
    quietenv = malloc(15 + strlen(s));
    if (!quietenv) errorexit(nomem);
    if (Quiet) {
        strcpy(quietenv, "MM_QUIET=1");
    } else {
        sprintf(quietenv, "MM_QUIET=%s", s);
    }
    newenviron[i++] = quietenv;
    s = getenv("MM_NOASK");
    if (!s) s = NoAskDefault;
    noaskenv = malloc(15 + strlen(soc(15 + strlen(s));
    if (!noaskenv) errorexit(nomem);
    if (MightAskBeforeExecuting) {
        sprintf(noaskenv, "MM_NOASK=%s", s);
    } else {
        strcpy(noaskenv, "MM_NOASK=1");
    }
    newenviron[i++] = noaskenv;
    sprintf(pagerenv, "MM_USEPAGER=%d", MaybePageOutput);
    newenviron[i++] = pagerenv;
    for (j=0; j<environsize; ++j) {
        if (strncmp(environ[j], "MM_", 3)) {
            newenviron[i++] = environ[j];
        }
    }
    newenviron[i] = NULL;
    environ = newenviron;
  = newenviron;
    if (DoDebug) {
        printf("Here is the environment:\n\n");
        system("printenv");
    }
}

lc2strncmp(s1, s2, len)
char *s1, *s2;
int len;
{
    if (!s1 || !s2) return (-1);
    while (*s1 && *s2 && len > 0) {
	if (*s1 != *s2 && (tolower(*s1) != *s2)) return(-1);
	++s1; ++s2; --len;
    }
    if (len <= 0) return(0);
    return((*s1 == *s2) ? 0 : -1);
}

lc2strcmp(s1, s2)
char *s1, *s2;
{
    if (!s1 || !s2) return (-1);
    while (*s1 && *s2) {
	if (*s1 != *s2 && (tolower (*s1 != *s2 && (tolower(*s1) != *s2)) return(-1);
	++s1; ++s2;
    }
    return((*s1 == *s2) ? 0 : -1);
}

OKToRun(ctype, progname)
char *ctype, *progname;
{
    char AnsBuf[100], *s;

    while (1) {
        printf("\n");
	printf("This message contains '%s'-format data.\nDo you want to view it using the '%s' command (y/n) [y] ? ", ctype, ShortCommand(progname));
	s = gets(AnsBuf);
	while (s && *s && isspace(*s)) ++s;
	if (*s == 'y' || *s == 'Y' || !*s || *s == '\n') return(1);
	if (*s == 'n' || *s == 'N' || *s =*s == 'N' || *s == 'q' || *s || 'Q') {
	    return(0);
	}
	printf("Please answer yes or no.\n");
    }
}

EliminateNastyChars(s)
char *s;
{
    if (s) for( ; *s ;++s) {
	if (isalnum(*s)) continue;
	if (index(" ,.;:/?\\|[]{}()*&^%#@-_=+~<>\"", *s)) continue;
	if (*s == '\'' || *s == '`') {
	    *s = '"';
	} else {
	    *s = ' ';
	}
    }
}

StripTrailingSpace(s)
char *s;
{
    char *t = s+strlen(s) -1;
    while (isspace(*t)) *t-- = NULL;
}

/* This next routine prints out a mail header, and needsout a mail header, and needs to deal with the new extended charset headers. */
phead(s)
char *s;
{
    char *t = s;

    while (1) {
	t = index(t, '\n');
	if (!t) break;
	if (!isspace(*(t+1))) {
	    *t = NULL;
	    break;
	} else ++t;
    }
    PrintHeader(s, 1);
    printf("\n");
    if (t) *t = '\n';
}

static char PrevCharset[100] = "us-ascii";

/* This is the part that actually handles the charset issues */
PrintHeader(s, ShowLeadingWhitespace)
char *s;
int ShowLeadingWhitespace;
{
    char *next, *chars
{
    char *next, *charset, *encoding, *txt, *txtend, TmpFile[1000];
    int ecode = ENCODING_NONE, CorrectedCharset = 0;
    FILE *fp;

    while (*s && (*s != '=')) {
        if (isspace(*s)) {
            if (ShowLeadingWhitespace) {
                putchar(' ');
            }
        } else {
            if (!ShowLeadingWhitespace) {
                /* Not another encoded word, not leading any more */
                ShowLeadingWhitespace = 1;
                putchar(' ');
            }
            putchar(*s);   putchar(*s);
            if (!CorrectedCharset) {
                CorrectedCharset = 1;
                strcpy(PrevCharset, "us-ascii");
            }
        }
        ++s;
    }
    if (!*s) return;
    if (*(s+1) != '?') {
        putchar('=');
        PrintHeader(++s, 1);
        return;
    }
    charset = s+2;
    encoding = index(charset, '?');
    if (!encoding) {
        putchar('=');
        PrintHeader(++s,1);
        return;
    }
    txt = index(encoding+1, '?');
    if (!txt) {
        putchar('=');
        PrintHeader(++s, 1);
        return;
    }
    txtend = txt;
    do {
        txtend = index(txtend+1, '?');
    } while(txtend && (*(txtend+1) != '='));
    if (!txtend) {
        putchar('=');
        PrintHeader(++s, 1);
    }
    /* Proper parse! Ready to dissect... */
    *encoding = NULL;
    *txt = NULL;
    *txtend = NULL;
    if ((*(encoding+1) == 'q') || (*(encoding+1) == 'Q')) {
        ecode = ENCODING_QUOTEDPRINTABLE;
    } else if ((*(encoding+1) == 'b') || (*(encoding+1) == 'B')) {
        ecode = ENCODING_BASE64;
    } else {
        fprintf(stderr, "Bad encoding value in non-ASCII header string: %s\n", encoding+1);
    }
    if (lc2strcmp(charset, PrevCharset)) {
        char *s2;

        printf("[** %s charset **] ", charset);
        strcpy(PrevCharset, charset);
        for (s2=PrevCharset; *s2; ++s2) {
            if (isupper(*s2)) *s2 = tolower(*s2);
        }
    }
    if (ecode == ENCODING_NONE) {
        printf(txt+1);
    } code == ENCODING_NONE) {
        printf(txt+1);
    } else {
        /* What follows is REALLY bogus, but all my encoding stuff is pipe-oriented right now... */
        MkTmpFileName(TmpFile);
        fp = fopen(TmpFile, "w");
        if (!fp) {
            fprintf(stderr, "Could not open temporary file\n");
        } else {
            char *t;
            for (t=txt+1; *t; ++t) {
                if (*t == '_') {
                    putc(' ', fp);
                } else if (*t == '\n') {
                    putc(' ', fp);
                } else {     } else {
                    putc(*t, fp);
                }
            }
            fclose(fp);
            fp = fopen(TmpFile, "r");
            if (!fp) {
                fprintf(stderr, "Could not open temporary file\n");
            } else {
                TranslateInputToOutput(fp, stdout, ecode);
                fclose(fp);
            }
            unlink(TmpFile);
        }
    }
    *encoding = '?';
    *txt = '?';
    *txtend = '?';
    PrintHeader(txtend + 2, 0);
}

BuildCommand(;
}

BuildCommand(Buf, controlstring, TmpFileName, UsedTmpFileName)
char *Buf, *controlstring, *TmpFileName;
int *UsedTmpFileName;
{
    char *from, *to, *s, *p, *tmp;
    int prefixed = 0;

    if (UsedTmpFileName) *UsedTmpFileName = 0;
    for (from=controlstring, to=Buf; *from; ++from) {
        if (prefixed) {
            prefixed = 0;
            switch(*from) {
                case '%':
                    *to++ = '%';
                    break;
                case 's':
                    if (TmpFileN    if (TmpFileName) {
                        strcpy(to, TmpFileName);
                        to += strlen(TmpFileName);
                        if (UsedTmpFileName) ++(*UsedTmpFileName);
                    }
                    break;
                case '{':
                    s = index(from, '}');
                    if (!s) {
                        fprintf(stderr, "Ignoring ill-formed parameter reference in mailcap file: %s\n", from);
                        break;
                    }
                                ++from;
                    *s = NULL;
                    /* put in lower case */
                    for (tmp=from; *tmp; ++tmp) {
                        if (isupper(*tmp)) *tmp = tolower(*tmp);
                    }
                    p = FindParam(from);
                    if (!p) p = "\"\"";
                    strcpy(to, p);
                    to += strlen(p);
                    *s = '}'; /* restore */
                    from = s;
                    break;
                cas          case 't':
                    /* type/subtype */
                    strcpy(to, ContentType);
                    to += strlen(ContentType);
                    break;
                default:
                    fprintf(stderr, "Ignoring unrecognized format code in mailcap file: %%<%c\n", *from);
                    break;
            }
        } else if (*from == '%') {
            prefixed = 1;
        } else {
            *to++ = *from;
        }
    }
    *to = NULL;
}

WriteTmpFile(fnam
WriteTmpFile(fname)
char *fname;
{
    FILE *fpout;
    int retval = 0;

    fpout = fopen(fname, "w");
    if (!fpout) errorexit("Can't create temporary file");
    TranslateInputToOutput(InputFP, fpout, EncodingCode);
    if (ftell(fpout) == 0) retval = 1;
#ifdef SUPERSTITIOUS 
    putc('\n', fpout); /* Just in case ? */
#endif
    if (fclose(fpout)) errorexit("Can't write temporary file");
    return(retval);
}

TranslateInputToOutput(InputFP, OutputFP, Ecode)
FILE *InputFP, *OutputFP;
int Ecode;
{
 FP;
int Ecode;
{
    char c, Buf[2000];
    int InMultipart = BoundaryCt > 0 ? 1 : 0;

    switch(Ecode) {
        case ENCODING_BASE64:
            from64(InputFP, OutputFP, InMultipart ? Boundaries : NULL, &BoundaryCt);
            break;
        case ENCODING_QUOTEDPRINTABLE:
            fromqp(InputFP, OutputFP, InMultipart ? Boundaries : NULL, &BoundaryCt);
            break;
        default:
            ConsumeRestOfPart(OutputFP);
    }
    if ((InputFP == stdin) && !freopen("/dev/tty", "r", stdin)) {    stdin)) {    fprintf(stderr, "Warning: Cannot freopen /dev/tty to stdin");
    }
}

CreateNewWindowPrefix(Prefix)
char *Prefix;
{
    if (getenv("DISPLAY")) {
        /* X11 */
        strcpy(Prefix, "xterm -title '");
        strcat(Prefix, MailSummary);
        strcat(Prefix, "' -e ");
    } else if (getenv("WINDOW_PARENT")) {
        /* SunView */
        strcpy(Prefix, "shelltool ");
    } else if (getenv("WMHOST")) {
        /* old Andrew WM */
        strcpy(Prefix, "h19 ");
    } else {
         } else {
        /* last resort is to look for /dev/tty */
        if (!freopen("/dev/tty", "r", stdin)){
            errorexit("Don't know how to create a terminal window");
        }
        fprintf(stderr, "Warning, reopened /dev/tty, could be strange.\n");
        Prefix[0] = NULL;
    }
}

static struct sgttyb MyTtyStateIn, MyTtyStateOut;

SaveTtyState() {
    gtty(fileno(stdin), &MyTtyStateIn);
    gtty(fileno(stdout), &MyTtyStateOut);
    /* Bogus -- would like a good portable way to reset the terminalt the terminal state here */
}

RestoreTtyState() {
    stty(fileno(stdin), &MyTtyStateIn);
    stty(fileno(stdout), &MyTtyStateOut);
}

NeedToAskBeforeExecuting(type)
char *type;
{
    struct NoAskItem *nai;
    if (!MightAskBeforeExecuting || DoInBackground) return(0);
    for (nai = FirstNoAskItem; nai; nai = nai->next) {
        if (CtypeMatch(type, nai->type)) return(0);
    }
    return(1);
}

NeedToBeQuiet(cmd)
char *cmd;
{
    struct NoAskItem *nai;
    for (nai = FirstQuietItem; nai; nai =stQuietItem; nai; nai = nai->next) {
        if (!lc2strcmp(nai->type, cmd)) return(1);
    }
    return(0);
}

CtypeMatch(ctype, pat)
char *ctype, *pat;
{
    int len;
    if (!lc2strcmp(ctype, pat)) {
        return(1); /* exact match, case-insensitive */
    }
    len = strlen(pat);
    if ((pat[--len] == '*')
         && (pat[--len] == '/')
         && (!lc2strncmp(ctype, pat, len))
         && (ctype[len] == '/')){
        /* wildcard match */
        return(1);
    }
    return(0);
}

ExecuteCommand();
}

ExecuteCommand(cmd, really)
char *cmd;
int really;
{
    if (!Quiet || DoDebug) {
        if (!NeedToBeQuiet(ShortCommand(cmd))) {
            printf("---Executing: %s\n", DoDebug ? cmd : ShortCommand(cmd));
            fflush(stdout);
        }
    }
    if (really) return(system(cmd));
}

MkTmpFileName(name)
char *name;
{
    static int ctr = 0;
    sprintf(name, "/tmp/metamail.%d.%d.%d", getuid(), getpid(), ctr++);
}

ConsumeRestOfPart(outfp)
FILE *outfp;
{
    char Buf[1000];
    int c;

    1000];
    int c;

    if (BoundaryCt <= 0) {
        while ((c=getc(InputFP)) != EOF) {
            if (outfp) putc(c, outfp);
        }
        return;
    }
    while (fgets(Buf, sizeof(Buf), InputFP)) {
        if ((BoundaryCt > 0)
             && (Buf[0] == '-')
             && (Buf[1] == '-')
             && PendingBoundary(Buf, Boundaries, &BoundaryCt)) {
            break;
        }
        if (outfp) fputs(Buf, outfp);
    }
}

char *paramend(s)
char *s;
{
    int inquotes=0;
    while (*s) {
        while (*s) {
        if (inquotes) {
            if (*s == '"') {
                inquotes = 0;
            } else if (*s == '\\') {
                ++s; /* skip a char */
            }
        } else if (*s == ';') {
            return(s);
        } else if (*s == '"') {
            inquotes = 1;
        }
        ++s;
    }
    return(NULL);
}        

ParseContentParameters(ct)
char *ct;
{
    char *s, *t, *eq;

    CParamsUsed = 0;
    s = index(ct, ';');
    if (!s) return;
    *s++ = NULL;
    d
    *s++ = NULL;
    do {
        t = paramend(s);
        if (t) *t++ = NULL;
        eq = index(s, '=');
        if (!eq) {
            fprintf(stderr, "Ignoring unparsable content-type parameter: '%s'\n", s);
            JunkParameter=Cleanse(s);
        } else {
            if (CParamsUsed >= CParamsAlloced) {
                CParamsAlloced += 10;
                if (CParams) {
                    CParams = (char **) realloc(CParams, (1+CParamsAlloced) * sizeof(char *));
                    CParamValues = (char *es = (char **) realloc(CParamValues, (1+CParamsAlloced) * sizeof(char *));
                } else {
                    CParams = (char **) malloc((1+CParamsAlloced) * sizeof(char *));
                    CParamValues = (char **) malloc((1+CParamsAlloced) * sizeof(char *));
                }
                if (!CParams || !CParamValues) errorexit(nomem);
            }
            *eq++ = NULL;
            s = Cleanse(s);
            CParams[CParamsUsed] = s;
            /* strip leading white space */
     e */
            while (*eq && isspace(*eq)) ++eq;
            /* strip trailing white space */
            StripTrailingSpace(eq);
            CParamValues[CParamsUsed++] = eq; 
            if (DoDebug) printf("NEW PARAMETER: %s VALUE: %s\n", s, eq);
        }
        s = t;
    } while (t);
}

char *FindParam(s)
char *s;
{
    int i;
    for (i=0; i<CParamsUsed; ++i) {
        if (!strcmp(s, CParams[i])) {
            return(CParamValues[i]);
        }
    }
    return(NULL);
}

  return(NULL);
}

