/* $Id: itserver.c,v 1.1 93/10/01 14:47:30 leon Exp Locker: leon $ */
#include <X11/Xatom.h>
#include <stdio.h>
#include "itserver.h"



static Window
ItServerOpenChannel(Display *dpy, char *group)
{
/* 
try to open a new communication channel.
Return Value: None if an error occured or channel ID
*/
    Window channel;
    channel = XCreateWindow(dpy, DefaultRootWindow(dpy), 
			    0, 0, 10, 10, 0, 0, InputOutput, CopyFromParent,
			    None, None);
    if(channel == None) 
	it_error = IT_ERROR_BAD_CHANNEL;
    XSelectInput(dpy, channel, StructureNotifyMask | PropertyChangeMask);
    return channel;
}





static void
ItServerGotConnection(ItChannel *server, XEvent event)
/*
   A property has been written on the server window.
   If the property value is not None, that means that a client asks
   for a connection.
   We check this, and then we call the init_proc defined for the ItServer.
   After that, we select events on this new channel and send a reply on it
   to tell the client that the connection is established.
*/
{
    Window *channels;
    int i;
    Atom atr;
    int afr;
    ItData reply;
    static offset = 0;
    unsigned long nr, bar;
    unsigned char *pr;
    ItMethod cb = (ItMethod)server->init_proc;
    XPropertyEvent *e = (XPropertyEvent *)&event;
    Display *dpy = server->dpy;

    if((e->window == server->server) &&
       (e->atom == server->type) &&(e->state == PropertyNewValue)) {
	XGetWindowProperty(dpy, server->server, server->type, 
			   offset, 1, True, XA_WINDOW, &atr, &afr, 
			   &nr, &bar, (unsigned char **)&pr);
	/* if bar is != 0 the propety contains other values, so
	   it has not been deleted, and then, we must shift offset for 
	   the next read */
	if(server->win != None) {
	    /* we do this AFTER reading the property in order to delete it */
	    DEBUG( 
		    "sorry I can't accept more than 1 connection...\n");
	    return;
	}
	if(bar) 
	    offset++;
	else 
	    offset = 0;
	/* could we really read more than 1 value ???? */

	channels = (Window *)pr;
 	for(i=0; i<nr; i++, channels++) {
	    server->win = *channels;
	    if(server->win) {
#ifdef DebugP
		DEBUG( 
			"ItServerGotConnection: got connection on 0x%x\n", 
			server->win);
#endif
		XSelectInput(e->display, server->win, 
			     PropertyChangeMask|StructureNotifyMask);
		/* send a reply to the client to confirm connection */
		ItServerReply(*server, 0, 0, NULL);
	    }
	}
	/* This core dumps when pr is declared as (ItID *) */
	if(pr) XFree(pr);
    }
}




ItChannel *
ItAppServerInitialize(Display *dpy, char *group, ItDefaultMethod init, 
		      ItDefaultMethod crash)
{
/*
   This initializes a server by openning a channel for the server, then
   we write this channel id in the INSET property of the root window.
*/
    Window none = None;
    ItChannel *channel;

    channel = (ItChannel *)malloc(sizeof(ItChannel));
    if(!channel) {
	it_error = IT_ERROR_BAD_ALLOC;
	return NULL;
    };
    ItInitialize(dpy);
    channel->dpy = dpy;
    channel->win = None;
    channel->read_prop = XA_TO_INSET;
    channel->write_prop = XA_FROM_INSET;
    channel->init_proc = init;
    channel->crash_proc = crash;
    ItDispatcherInitialize(&(channel->dth), 32, 32);

    channel->type = ItGetAtom(dpy, INSET, group);
    if(channel->type == None) return False;
    channel->server = ItServerOpenChannel(dpy, group);
    if(channel->server == None) return False;
#ifdef DebugP
    DEBUG( "ItServerInitialize: openning channel 0x%x\n", 
	    channel->server);
#endif
    XChangeProperty(dpy, DefaultRootWindow(dpy), channel->type, 
		    XA_WINDOW, 32, PropModeReplace, 
		    (unsigned char *)&channel->server, 1);
    XChangeProperty(dpy, channel->server, channel->type, XA_WINDOW, 32,
		    PropModeReplace, (unsigned char *)&none, 1);
    return channel;
}


unsigned
ItServerDispatchEvent(ItChannel *channel, XEvent *event)
/*
   Dispatches messages. First, we give the event to the messages loop.
   If the event if not dispatched, it can be on the server connection 
   channel, so we try to see if the event is a connection request.
*/
{
    if(!ItDispatchEvent(channel, event));
	/* not dispatched */
	if((((XAnyEvent *)event)->window == channel->server)){
	    ItServerGotConnection(channel, *event);
	    return True;
	}
    return False;
}

