/* $Id: itlib.h,v 1.1 93/10/01 14:47:29 leon Exp Locker: leon $ */
#ifndef __ITLIB_H
#define __ITLIB_H

#define DEBUG printf

#include <X11/Intrinsic.h>
#define INSET "INSET_"
#define CWAll (CWX|CWY|CWWidth|CWHeight|CWBorderWidth)
#define IT_MAX_INTS 8
#define IT_MAX_STRING 32


/* global datas */
extern Atom XA_TO_INSET;
extern Atom XA_FROM_INSET;
extern Atom XA_REPLY;
extern Atom XA_TOKEN;

#define IT_ZERO_WIDTH (1 << 12)
#define IT_ZERO_HEIGHT (1 << 13)
#define IT_NEED_REPLY (1 << 14)
#define IT_BROADCAST  (1 << 15)
#define IT_F_MASK 0xFFF
#define IT_REPLY 0


/* error managment */
extern unsigned int it_error;
#define IT_NO_ERROR 0
#define IT_ERROR_BAD_CHANNEL 1
#define IT_ERROR_BAD_ALLOC 2
#define IT_ERROR_BAD_ATOM 3
#define IT_ERROR_SERVER_DEAD 4
#define IT_ERROR_UNKNOWN 5
#define IT_ERROR_NO_TOKEN 6
#define IT_ERROR_CHANNEL_CLOSED 7

/* types */


typedef void * ItObject;
typedef unsigned ItFunction;
typedef struct _ItPacket {
    int i1, i2, i3, i4, i5, i6;
    char *s;
}ItPacket, *ItPackets;

typedef struct _ItHeader {
    ItFunction f;
    ItObject sender;
} ItHeader, *ItHeaders;


typedef struct _ItData {
    int i1,i2, i3, i4, i5, i6, i7, i8;
} ItData, *ItDatas;

char *
ItDataPrint(ItData *data);


typedef struct _ItChannel ItChannel, *ItChannels;
typedef int (*ItMethod)(void *handler, ItData *in, ItData *out, 
		    char *ins, char **outs);
typedef ItMethod *ItMethods;
typedef int (*ItDefaultMethod)(ItChannel *server, ItHeader *header, 
			       ItData *in, ItData *out, 
			       char *ins, char **outs);

typedef struct _ItHandler {
    ItObject local;
    ItObject remote;
}ItHandler, *ItHandlers;

typedef struct _ItDispatcher {
    ItMethods methods;
    unsigned nm;
    ItHandlers handlers;
    unsigned nh, lh;
}ItDispatcher, *ItDispatchers;

struct _ItChannel {
    Display *dpy;
    Window server;
    Window win;
    Atom type;
    Atom read_prop, write_prop;
    ItDispatcher dth;
    ItDefaultMethod init_proc;
    ItDefaultMethod crash_proc;
};
    

/* Interface */

extern void 
ItInitialize (Display *dpy);

extern Atom
ItGetAtom(Display *dpy, char *prefix, char *type);

unsigned
ItRead(ItChannel channel, Atom prop, ItHeader *header, 
       ItData *data, char **s);

unsigned
ItWrite(ItChannel channel, ItObject sender, Atom prop, ItFunction f, 
	ItData *data, char *s);

unsigned
ItWaitForReply(ItChannel channel);

unsigned
ItWaitFor(ItChannel channel, Atom prop);


unsigned
ItRequest(ItChannel channel, ItObject sender, Atom prop, ItFunction f, 
	  ItData *in, ItData *out, char *ins, char **outs);

unsigned
ItSend(ItChannel channel, Atom prop, ItFunction f, 
       ItData *in);

unsigned
ItGetToken(ItChannel channel);

unsigned
ItReleaseToken(ItChannel channel);


#define ItReply(channel, res, data, string)\
ItWrite(channel, 0, XA_REPLY, res, data, string)

#define ItReadReply(channel, res, data, string)\
ItRead(channel, XA_REPLY, res, data, string)



/* from dispatch.c */

extern void 
ItDispatcherInitialize(ItDispatcher *d, int maxm, int maxh);

extern void 
ItSetMethod(ItChannel *c, ItFunction f, ItMethod m);

extern void 
ItSetHandler(ItChannel *c, ItObject remote, ItObject local);

extern unsigned
ItDispatchEvent(ItChannel *c, XEvent *event);




#endif /* __ITLIB_H */
