/* $Id: itlib.c,v 1.1 93/10/01 14:47:29 leon Exp Locker: leon $ */
#include <stdio.h>
#include <strings.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include "itlib.h"

unsigned int it_error;
Atom XA_TO_INSET;
Atom XA_FROM_INSET;
Atom XA_REPLY;
Atom XA_TOKEN;


char *
ItDataPrint(ItData *data)
{
    static char buffer[64];
    sprintf(buffer, "%d, %d, %d, %d, %d, %d, %d, %d\n", 
	    data->i1, data->i2, data->i3, data->i4, 
	    data->i5, data->i6, data->i7, data->i8);
    return buffer;
}

void ItInitialize(Display *dpy)
{
    XA_TO_INSET = XInternAtom(dpy, "XA_TO_INSET", False);
    XA_FROM_INSET = XInternAtom(dpy, "XA_FROM_INSET", False);
    XA_REPLY = XInternAtom(dpy, "XA_REPLY", False);
    XA_TOKEN = XInternAtom(dpy, "XA_TOKEN", False);
    it_error = IT_NO_ERROR;
}


Atom
ItGetAtom(Display *dpy, char *prefix, char *type)
/*
builds the atom name corresponding to the <prefix><type> string
Return Value: None if an error occured or the Atom name
*/
{
    char *propName;
    Atom prop;
    propName = XtMalloc(strlen(prefix) + strlen(type) + 1);
    if(!propName) {
	it_error = IT_ERROR_BAD_ALLOC;
	return None;
    };
    strcpy(propName, prefix);
    strcat(propName, type);
    prop = XInternAtom(dpy, propName, False);
    XtFree(propName);
    if(prop == None) 
	it_error = IT_ERROR_BAD_ATOM;
    return prop;
}


int ItStdXErrorHandler(Display *dpy, XErrorEvent *event)
{
    DEBUG( "*** A channel is closed ***\n");
}

unsigned
ItWrite(ItChannel channel, ItObject sender, Atom prop, ItFunction f, ItData *data, char *s)
/*
   Send data and set the function Id into the <prop> property.
*/
{
    ItHeader header;
#ifdef DebugP
    DEBUG( "ItWrite: sending on 0x%x\n", channel.win);
#endif /* DebugP */
    /* we allow to send messages without data, so configure window 
       only if needed */
/*    XSetErrorHandler(ItStdXErrorHandler);*/
    XSynchronize(channel.dpy, True);
    if(data) {
	XChangeProperty(channel.dpy, channel.win, XA_INTEGER, XA_INTEGER, 32,
			PropModeReplace, (unsigned char *)data, IT_MAX_INTS);
    };

    if(s) {
	XChangeProperty(channel.dpy, channel.win, XA_STRING, XA_STRING, 8,
			PropModeReplace, (unsigned char *)s, strlen(s));
    };

    header.f = f;
    header.sender = sender;
    XChangeProperty(channel.dpy, channel.win, prop, XA_INTEGER, 32,
		    PropModeReplace, (unsigned char *)&header, 2);
    XSynchronize(channel.dpy, False);
/*    XSetErrorHandler(0);*/
}





unsigned
ItRead(ItChannel channel, Atom prop, ItHeader *header, ItData *data, char **s)
/*
   Read data on the specified channel and on the specified property.
*/
   
{
    Window wTrash;
    unsigned int uiTrash;
    Atom atr;
    int afr;
    static offset = 0;
    unsigned long nr, bar;
    unsigned char *pr;
    int *fs;

    XGetWindowProperty(channel.dpy, channel.win, XA_INTEGER, 
		       0, IT_MAX_INTS, True, XA_INTEGER, &atr, &afr, 
		       &nr, &bar, (unsigned char **)&pr);
    bcopy(pr, data, sizeof(ItData));	
    if(pr) {
	XFree(pr);
    };

    /* retieving the XA_STRING property */
    XGetWindowProperty(channel.dpy, channel.win, XA_STRING, 
		       0, 32, True, XA_STRING, &atr, &afr, 
		       &nr, &bar, (unsigned char **)&pr);
    if(atr == None) {
	/* no XA_STRING property */
	s = NULL;
    }
    else {
	if(pr) {
/*	    *s = (char *)strdup(pr); */
	    *s = (char *)malloc(strlen(pr)+1);
	    strcpy(*s, pr);
	    XFree(pr);
	};
    }
    /* retrieving function name */
    XGetWindowProperty(channel.dpy, channel.win, prop, 
		       0, 2, True, XA_INTEGER, &atr, &afr, 
		       &nr, &bar, (unsigned char **)&pr);
    fs = (int *)pr;
    /* if we perform a Read for a reply, we do not need the func */
    if(header && fs) {
	header->f = *fs++;
	header->sender = *((ItObject*)fs);
    };
    if(pr) XFree(pr);


}


unsigned
ItWaitFor(ItChannel channel, Atom prop)
/*
   Wait for a server reply on channel. The reply should arrive on the
   <prop> property.
   Return True if the reply is here, or False if the server is DEAD.
*/
{
    XEvent event;
    for(;;) {
	XWindowEvent(channel.dpy, channel.win, 
		     StructureNotifyMask|PropertyChangeMask, &event);
	switch(event.type) {
	case PropertyNotify: {
	    XPropertyEvent *e = (XPropertyEvent *)&event;
	    if((e->state == PropertyNewValue) &&(e->atom == prop)){
		return True;
	    }; 
	    break;
	}
	case DestroyNotify: {
	    XDestroyWindowEvent *e = (XDestroyWindowEvent *)&event;
	    it_error = IT_ERROR_SERVER_DEAD;
	    return False;
	}
	} /* switch */
    }
}

unsigned
ItWaitForReply(ItChannel channel)
/*
   Wait for a server reply on channel. The reply should arrive on the
   XA_REPLY property.
   Return True if the reply is here, or False if the server is DEAD.
*/
{
    XEvent event;
#ifdef DebugP
DEBUG( "ItWaitForReply: waiting on 0x%x\n", channel.win);
#endif
    for(;;) {
	XWindowEvent(channel.dpy, channel.win, 
		     StructureNotifyMask|PropertyChangeMask, &event);
	switch(event.type) {
	case PropertyNotify: {
	    XPropertyEvent *e = (XPropertyEvent *)&event;
	    if((e->state == PropertyNewValue) &&(e->atom == XA_REPLY)){
#ifdef DebugP
DEBUG( "ItWaitForReply: got reply on 0x%x\n", channel.win);
#endif
		return True;
	    }; 
	    break;
	}
	case DestroyNotify: {
	    XDestroyWindowEvent *e = (XDestroyWindowEvent *)&event;
	    it_error = IT_ERROR_SERVER_DEAD;
	    return False;
	}
	} /* switch */
    }
}


unsigned
ItRequest(ItChannel channel, ItObject sender, Atom prop, ItFunction f, 
	  ItData *in, ItData *out, char *ins, char **outs)
/* 
   process a synchronous call to the server
   Return value: False if request failed, erro code in it_error; 
   True otherwise.
*/
{
    ItHeader res;
    /* send data */
    if(!ItGetToken(channel)) {
	it_error = IT_ERROR_NO_TOKEN;
	fprintf(stderr, "Warning: NO TOKEN\n");
	return False;
    };
    ItWrite(channel, sender, prop, f|IT_NEED_REPLY, in, ins);
    if(ItWaitForReply(channel)) {
	int f;
	/* reply is arrived, we retrieve the values */
#ifdef DebugP
	DEBUG( "ItRequest: got the reply.\n");
#endif /* DebugP */
	ItReadReply(channel, &res, out, outs);
    }
    else {
	DEBUG( "ItRequest: server is DEAD\n");
    };
    ItReleaseToken(channel);
    return res.f;
}


unsigned
ItSend(ItChannel channel, Atom prop, ItFunction f, 
	  ItData *in)
/* 
   process an asynchronous call to the server
   Return value: False if the token was not available
   True otherwise.
*/
{
    if(!ItGetToken(channel)) {
	it_error = IT_ERROR_NO_TOKEN;
	return False;
    };
    ItWrite(channel, 0, prop, f, in, NULL);
    return True;
}



unsigned
ItGetToken(ItChannel channel)
{
    Window wTrash;
    unsigned int uiTrash;
    Atom atr;
    int afr;
    unsigned long nr, bar;
    unsigned char *pr;

    XGetWindowProperty(channel.dpy, channel.win, XA_TOKEN,
		       0, 1, True, XA_INTEGER, &atr, &afr, 
		       &nr, &bar, (unsigned char **)&pr);
    if(pr) XFree(pr);
    return atr;
}


unsigned
ItReleaseToken(ItChannel channel)
{
    int n = 0;
    XChangeProperty(channel.dpy, channel.win, XA_TOKEN, XA_INTEGER,
		    32, PropModeReplace, (unsigned char *)&n, 1);
    XFlush(channel.dpy);
}


