/* $Id: itclient.h,v 1.1 93/10/01 14:47:28 leon Exp Locker: leon $ */
#ifndef __ITCLIENT_H
#define __ITCLIENT_H

#include <X11/Intrinsic.h>
#include "itlib.h"

typedef struct _ItClient ItClient, *ItClients;
typedef (*ItClientInitializeProc)(ItClient *client, Window win);

struct _ItClient {
    ItChannel channel;
    Atom type;
    ItDispatcher dispatcher;
    ItClientInitializeProc init_proc;
};

unsigned
ItClientInitialize(Display *dpy, ItChannel *, char *group);

ItChannel *
ItAppClientInitialize(Display *dpy, char *group);

#define ItClientRequest(channel, sender, func, in, out, ins, outs)\
ItRequest(channel, sender, XA_TO_INSET, func, in, out, ins, outs)


#endif /* __ITCLIENT_H */
