/* $Id: InsetShellP.h,v 1.1 93/10/01 14:47:24 leon Exp Locker: leon $ */
#ifndef _InsetShellP_h
#define _InsetShellP_h


#include <X11/CoreP.h>
#include <X11/ShellP.h>
#include "InsetShell.h"






typedef struct {
    int empty;
} InsetShellClassPart;

typedef struct _InsetShellClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    ShellClassPart      shell_class;
    WMShellClassPart    wm_shell_class;
    VendorShellClassPart vendor_shell_class;
    InsetShellClassPart	inset_shell_class;
} InsetShellClassRec;

extern InsetShellClassRec insetShellClassRec;

typedef struct {
    /* resources */
    Window window;
    ItChannel *channel;
    ItObject remoteID;
    /* private state */
} InsetShellPart;

typedef struct _InsetShellRec {
    CorePart	core;
    CompositePart composite;
    ShellPart  shell;
    WMShellPart wm;
    VendorShellPart vendor;
    InsetShellPart	insetShell;
} InsetShellRec;

#define ItRChannel "ItChannel"
#define ItRObject "ItObject"


int InsetShellQueryGeometry(void *handler,  ItData *in, 
			    ItData *out, char *ins, char **outs);
int InsetShellRealize(void *handler,  ItData *in, ItData *out, 
		      char *ins, char **outs);
int InsetShellDestroy(void *handler,  ItData *in, ItData *out, 
		      char *ins, char **outs);

#endif /* _InsetShellP_h */
