/* $Id: Inset.c,v 1.1 93/10/01 14:47:22 leon Exp Locker: leon $ */
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <stdio.h>
#include "InsetP.h"
#include "itclient.h"
#include "inset.h"

static XtResource resources[] = {
#define offset(field) XtOffsetOf(InsetRec, inset.field)
    /* {name, class, type, size, offset, default_type, None}, */
    { ItNelement, ItCElement, XtRString,
	  sizeof(String), offset(element), XtRString, None },
    { ItNitChannel, ItCItChannel, XtRItChannel,
	  sizeof(ItChannel *), offset(channel), XtRItChannel, None },
#undef offset
};


void ItSetWindow(Widget widget, Window window)
{
    widget->core.window = window;
}


static XtGeometryResult QueryGeometry(Widget w, XtWidgetGeometry *intended,
			       XtWidgetGeometry *preferred);

static void Initialize(Widget w, Widget new, ArgList args, Cardinal n)
{
    XtWidgetGeometry intended, preferred;
    XtGeometryResult res;
    InsetWidget wid=(InsetWidget)new;
    ItChannel *channel;
    char *p = NULL;
    ItData inout;

#ifdef Debug
    DEBUG("Initialize %s\n", wid->core.name);
#endif /* Debug */
    channel = wid->inset.channel;
    ItClientRequest(*channel, wid, 0, &inout, &inout, wid->inset.element, &p);
    /* some important geometry resources are set at creation time and
       some container use these resources to set children geometry,
       so we have to retrieve these ones. 
       We have to be a kind of mirror of the inset widget */
    intended.request_mode = CWX | CWY | CWWidth | CWHeight | 
	CWBorderWidth |	XtCWQueryOnly;
    res = QueryGeometry(new, &intended, &preferred);
    wid->core.width = preferred.width;
    wid->core.height = preferred.height;
}


static void Realize(Widget w, XtValueMask *mask, XSetWindowAttributes *a)
{
    InsetWidget wid = (InsetWidget)w;
    ItChannel *channel;
    char *p = NULL;
    ItData inout;


#ifdef Debug    
    DEBUG("Realize %s\n", wid->core.name);
#endif /* Debug */
    channel = wid->inset.channel;

    XtCreateWindow(w, (unsigned int) InputOutput, 
		   (Visual *) CopyFromParent, *mask, a);
    /* make sure that the window IS created */
    XSync(XtDisplay(w), False);

#ifdef Debug
    DEBUG("sending window id: %x\n", wid->core.window);
#endif /* Debug */
    inout.i1 = (int)wid->core.window;
    ItClientRequest(*channel, wid, REALIZE, &inout, &inout, p, &p);
}



static XtGeometryResult QueryGeometry(Widget w, XtWidgetGeometry *intended,
				      XtWidgetGeometry *preferred)
{
    Widget r;
    ItData in, out;
    char *p = "";
    ItChannel *channel;
    XtGeometryResult res;
    InsetWidget wid = (InsetWidget)w;
#ifdef Debug
    DEBUG("QueryGeometry %s\n", wid->core.name);
#endif /* Debug */

    channel = wid->inset.channel;

    in.i1 = intended->request_mode;
    in.i2 = intended->x;
    in.i3 = intended->y;
    in.i4 = intended->width;
    in.i5 = intended->height;
    in.i6 = intended->border_width;
    in.i7 = (int)intended->sibling;
    in.i8 = intended->stack_mode;

    /* BUG: if we pass p as parameter, without value */
    res = ItClientRequest(*channel, wid, QUERY_GEOMETRY, &in, &out, p, &p);

    preferred->request_mode = out.i1;
    preferred->x = out.i2;
    preferred->y = out.i3;
    preferred->width = out.i4;
    preferred->height = out.i5;
    preferred->border_width = out.i6;
    preferred->sibling = (Widget)out.i7;
    preferred->stack_mode = out.i8;
#ifdef Debug
    DEBUG("QueryGeometry: %dx%d\n", out.i4, out.i5);
#endif /* Debug */

    return res;
    
};



static void 
Destroy(Widget w)
{
    Widget r;
    ItData in, out;
    char *p = "";
    ItChannel *channel;
    InsetWidget wid = (InsetWidget)w;
#ifdef Debug
    DEBUG("Destroy %s", wid->core.name);
#endif /* Debug */

    channel = wid->inset.channel;
    ItClientRequest(*channel, wid, DESTROY, &in, &out, p, &p);
}

InsetClassRec insetClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Inset",
    /* widget_size		*/	sizeof(InsetRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	(XtInitProc)Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	XtInheritResize,
    /* expose			*/	NULL,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	QueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* inset fields */
    /* empty			*/	0
  }
};

WidgetClass insetWidgetClass = (WidgetClass)&insetClassRec;
