/* Ygl: Run 2d-GL programs with standard X11 routines. (C) Fred Hucht 1993/94 */

#define AUTOFLUSH	/* define to generate code for flushing the server via timer */
#define GCLIST		/* define to avoid graphics context swiches */
#define COVERSLEEP	/* define to cover the system commands sleep and usleep with
			   own versions that flushes the X-Server */
#define ORTHO		/* define to enable ortho2 transformations. May be slower */

/* End of configuration */

#ifndef EXTERN
#define EXTERN extern
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <stdio.h>  	/* fprintf */
#include <stdlib.h> 	/* malloc  */

#ifdef YGL_PREFIX	/* If all routines should get the prefix ygl_ to avoid naming conflicts */
#include "prefix.h"
#endif

#include <X11/Ygl.h>

#ifdef MULTIBUF
#include <X11/extensions/multibuf.h>
#endif

#ifdef AUTOFLUSH
#include <signal.h>
#endif

#define YGL_MAXFONTS   		16
#define EnterLeaveMask 		(EnterWindowMask|LeaveWindowMask)
#define D 			_YglDisplayPointer
#define W 			_YglWindowPointer
#define YglScreen		DefaultScreen(D)
#define YglParentWindow		   RootWindow(D, YglScreen)
#define YglScreenHeight  	DisplayHeight(D, YglScreen)
#define YglScreenWidth	  	 DisplayWidth(D, YglScreen)

typedef unsigned long Ulong;
typedef unsigned int  Uint;

typedef struct {
  Window  	win,
          	draw; /* drawable, only differ from win when doublebuffering */
#ifdef MULTIBUF
  Multibuffer 	mbuf[2];
  short 	abuf;
#endif
  GC      	gc;
#ifdef GCLIST
  GC      	chargc;
#endif
#ifdef ORTHO
  double  	xo, yo; /* offset to coords          */
#endif
  double  	xd, yd; /* size of viewport (initial size of window without ortho2) */
  double  	xf, yf; /* scaling factor            */
  int     	xm, ym; /* width, height of window   */
  double  	xp, yp, /* graphics cursor position  */
          	xc, yc; /* text cursor position      */
  short   	rgb;    /* True if window in RGBmode */
} YglWindow;

/* Global symbols */
EXTERN YglWindow *W;
EXTERN Display  *D;

#ifdef GCLIST
EXTERN GC        *_YglGCList;
#endif


#ifdef AUTOFLUSH

/* problem with _YglAllowFlush:
   1) signal_handler won't get called when in routines like sleep or scanf.
   2) Don't know if its good to call XFlush from within a signal handler
      (reentrance of several routines, see man signal).
*/

EXTERN int _YglDoFlush /*, _YglAllowFlush */;

#define I {/*_YglAllowFlush = False;*/ if(D == NULL) { fprintf(stderr, "Ygl: not initialized, use ginit first.\n");exit(1);}}
#define F { if(_YglDoFlush) { XFlush(D); _YglDoFlush=False;}; /*_YglAllowFlush = True;*/ }

#else /*AUTOFLUSH*/

#define I {if(D == NULL) { fprintf(stderr, "Ygl: not initialized, use ginit first.\n");exit(1);}}
#define F

#endif /*AUTOFLUSH*/

#ifdef ORTHO

#define XR(x)  ((int)(W->xf * (x))) 	/* rescaled x */
#define YR(y)  ((int)(W->yf * (y))) 	/* rescaled y */
#define X(x)   XR((x) - W->xo)		/* rescaled and shifted x */
#define Y(y)   (W->ym-1 - YR((y)-W->yo))/* rescaled and shifted and mirrored y */

#else /* ORTHO */

#ifdef NOSCALING

#define XR(x) (x)			/* unscaled x */
#define YR(y) (y)			/* unscaled y */
#define  X(x) XR(x)			/* unscaled x */
#define  Y(y) (W->ym-1 - YR(y))		/* mirrored y */

#else /* NOSCALING */

#define XR(x) ((int)(W->xf * (x))) 	/* rescaled x */
#define YR(y) ((int)(W->yf * (y))) 	/* rescaled y unmirrored */
#define  X(x) XR(x)			/* rescaled x */
#define  Y(y) (W->ym-1 - YR(y))		/* rescaled and mirrored y */

#endif /* NOSCALING */

#endif /* ORTHO */

#define XS(x) X(W->xp = x)		/* return X(x) and set cursor position */
#define YS(y) Y(W->yp = y)		/* return Y(y) and set cursor position */

#define SCP(gx,gy) {W->xp gx;W->yp gy;}	/* Set cursor positions. Ex.: SCP(=x,=y), SCP(+=x,+=y); */

#define MIN(x,y) ((x)<(y) ?   (x) :(y))
#define MAX(x,y) ((x)>(y) ?   (x) :(y))
#define ABS(x)   ((x)< 0  ? (-(x)):(x))
