/* rgb.c by Fred Hucht (C) 1993.
   Example program with two windows,
   one in RGBmode and one in Colormap mode */

#include <gl/gl.h>
#include <gl/device.h>

#define SIZE 256
#define STEP 1

Int32 RGBwin, cwin;

void drawit(int g) {
  short r,b;
  reshapeviewport();
  RGBcolor(0,0,0); clear();
  for(r=0;r<SIZE;r++) for(b=0;b<SIZE;b++) {
    RGBcolor(r, g, b);
    rectfi(STEP*r, STEP*b, STEP*(r+1), STEP*(b+1));
  }
  RGBcolor(255,255,0);
  font(4711);
  cmov2i(10, 10);
  charstr("Hello in Yellow");
}

void drawit2() {
  winset(cwin);
  reshapeviewport();
  color(BLACK); clear();
  color(RED); circf(128,128,100);
  winset(RGBwin);
}

main() {
  Device dev;
  short val;
  int green = 128, openwins=0;
  Int32 xo, yo;
  Char8 *Title = "RGBmode Window";
  
  minsize (SIZE, SIZE);
  /* stepunit(SIZE, SIZE); */
  
  RGBwin = winopen(Title);
  openwins++;
#if 0
  color(BLACK); clear();
  color(RED); circf(128,128,100);
  sleep(5);
#endif
  
  RGBmode();
  gconfig();
  
#if 1
  minsize(256,256);
  cwin = winopen("Colormap Window");
  openwins++;
#endif
  
  qdevice(REDRAW);
  qdevice(KEYBD);
  qdevice(WINCLOSE);
  qdevice(LEFTMOUSE);
  
  winset(RGBwin);
  getsize(&xo,&yo);
  
  loadXfont(4711, "timr14");
  
  while (1) {
    dev = qread(&val);
    switch(dev) {
    case LEFTMOUSE:
      if(val==1) { /* If button pressed */
	Int32 x, y, xs, ys;
	Int16 r, g, b;
	char buf[80];
	getorigin(&x, &y);
	getsize(&xs, &ys);
	x = (getvaluator(MOUSEX) - x) * xo / xs;
	y = (getvaluator(MOUSEY) - y) * yo / ys;
	/* Next line is to get the real color (not the desired)
	   on <24 bit Visuals */
	RGBcolor(x, green, y); gRGBcolor(&r, &g, &b);
	sprintf(buf,"Color at (%d,%d) is (%d,%d,%d).",x,y,r,g,b);
	wintitle(buf);
      } else { /* Restore original title */
	wintitle(Title);
      }
      break;
    case KEYBD:
      switch(val) {
      case '\033' :
	gexit();
	exit(0);
	break;
      case '+':	green += 16; drawit(green); break;
      case '-':	green -= 16; drawit(green); break;
      }
      break;
    case WINCLOSE:
      winclose(val);
      if(0 == --openwins) {
	gexit();
	exit(0);
      }
      break;
    case REDRAW:
      /* printf("REDRAW for window %d\n", val); */
      if(val == cwin)
	drawit2();
      else
	drawit(green);
      break;
    }
  }
}
