/*
** ui_tools.c
**
*/
#include <stdio.h>
#if SYSV_INCLUDES
#	include <memory.h>
#endif
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xew/TextEd.h>

#include "ui_tools.h"

/*
** ***************************************************************
** For documentation of the global UI_ functions, see "ui_tools.h"
** ***************************************************************
*/
void UI_Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
	exit(0);
    }

void UI_Popdown(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	while (!XtIsShell(w))
		w = XtParent(w);
	XtPopdown(w);
    }

/*
** UI_PopupCentered (modified from MIT editres client)
*/
void UI_PopupCentered(event, w, mode)
XEvent * event;
Widget w;
XtGrabKind mode;
    {
	Boolean get_from_cursor = FALSE;
	Arg args[5];
	Cardinal num_args;
	Dimension width, height, b_width;
	Position x0, y0;
	int x, y, max_x, max_y;
	
	XtRealizeWidget(w);
	
	num_args = 0;
	XtSetArg(args[num_args], XtNwidth, &width); num_args++;
	XtSetArg(args[num_args], XtNheight, &height); num_args++;
	XtSetArg(args[num_args], XtNborderWidth, &b_width); num_args++;
	XtSetArg(args[num_args], XtNx, &x0); num_args++;
	XtSetArg(args[num_args], XtNy, &y0); num_args++;
	XtGetValues(w, args, num_args);

	if (x0 <= 0 || y0 <= 0)
	    {
		if (event == NULL)
			get_from_cursor = TRUE;
		else
		    {
			switch (event->type)
			    {
			    case ButtonPress:
			    case ButtonRelease:
				x = event->xbutton.x_root;
				y = event->xbutton.y_root;
				break;
			    case KeyPress:
			    case KeyRelease:
				x = event->xkey.x_root;
				y = event->xkey.y_root;
				break;
			    default:
				get_from_cursor = TRUE;
				break;
			    }
		    }
		if (get_from_cursor)
		    {
			Window root, child;
			int win_x, win_y;
			unsigned int mask;

			XQueryPointer(XtDisplay(w), XtWindow(w), &root,
				      &child, &x, &y, &win_x, &win_y, &mask);
		    }
		width += 2 * b_width;
		height += 2 * b_width;
		x -= ((int) width/2);
		if (x < 0) 
			x = 0;
		if ( x > (max_x = (int) (XtScreen(w)->width - width)) )
			x = max_x;
		y -= ( (Position) height/2 );
		if (y < 0) 
			y = 0;
		if ( y > (max_y = (int) (XtScreen(w)->height - height)) )
			y = max_y;
		num_args = 0;
		XtSetArg(args[num_args], XtNx, x); num_args++;
		XtSetArg(args[num_args], XtNy, y); num_args++;
		XtSetValues(w, args, num_args);
	    }
	XtPopup(w, mode);
    }

void UI_PopupDialog(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Cardinal n;
	Arg args[4];
	UI_DialogDef *def = (UI_DialogDef *)client_data;
	
	if (!def->shell)
	    {
		/*
		** I don't know what is going on here, but it seems that
		** on X11R5 I have to use XtParent(w) (on Sun I get core
		** if not used), but on one X11R4 I seem to get complaint
		** about NULL parent.. blah --msa
		*/
		if (XtParent(w))
			w = XtParent(w);
		/* end kludge.. Grmph! */

		def->shell = XtCreatePopupShell
			("dialog", transientShellWidgetClass, w, NULL, 0);
		n = 0;
		if (def->label)
		    {
			XtSetArg(args[n], XtNlabel, def->label); n++;
		    }
		if (def->init)
		    {
			XtSetArg(args[n], XtNvalue, def->init); n++;
		    }
		def->dialog = XtCreateManagedWidget
			("Dialog", dialogWidgetClass, def->shell, args, n);
		if (def->okay_data)
		    {
			XawDialogAddButton(def->dialog,"okay", def->callback,
					   def->okay_data);
			XawDialogAddButton(def->dialog,"cancel", def->callback,
					   (XtPointer)0);
		    }
		else
			XawDialogAddButton(def->dialog,"OK", def->callback,
					   (XtPointer)0);
			
	    }
	UI_PopupCentered(NULL, def->shell, XtGrabNone);
    }

void UI_PopupMessage(parent, dialog,
		     name, type, class, defaultp, params, num_params)
Widget parent;
UI_DialogDef *dialog;
String name, type, class, defaultp;
String *params;
Cardinal *num_params;
    {
	char buffer[1000];
	static char message[1000];
	
	XtGetErrorDatabaseText(name,type,class,defaultp,buffer,sizeof(buffer));
	if (params && num_params && *num_params > 0)
	    {
		int i = *num_params, j;
		String par[10];
		if (i > 10)
			i = 10;
		for (j = 0; j < i; j++)
			par[j] = params[j];
		while (i < 10)
			par[i++] = NULL;
		sprintf(message, buffer,
			par[0], par[1], par[2], par[3], par[4],
			par[5], par[6], par[7], par[8], par[9]);
	    }
	else
		strncpy((char *)message, buffer, sizeof(message));
	if (dialog->dialog)
	    {
		Arg args[1];
		XtSetArg(args[0], XtNlabel, message);
		XtSetValues(dialog->dialog, args, (Cardinal)1);
	    }
	UI_PopupDialog(parent, (XtPointer)dialog, (XtPointer)NULL);
    }

static Widget CreateToggleElement(parent, name, args, n)
Widget parent;
char *name;
Arg *args;
int n;
    {
	Widget box, toggle, label;

	XtSetArg(args[n], XtNorientation, XtorientHorizontal); ++n;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	XtSetArg(args[n], XtNhSpace, 1); ++n;
	XtSetArg(args[n], XtNvSpace, 1); ++n;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	box = XtCreateManagedWidget
		("toggleBox", boxWidgetClass, parent, args, n);
	n = 0;
	XtSetArg(args[n], XtNlabel, " "); ++n;
	toggle = XtCreateManagedWidget
		("toggleButton", toggleWidgetClass, box, args, n);
	n = 0;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	label = XtCreateManagedWidget(name, labelWidgetClass, box, args, n);
	return toggle;
    }

/*
** CreateInputElement
*/
static Widget CreateInputElement(parent, prompt, init, args, n)
Widget parent;
char *prompt, *init;
Arg *args;
int n;
    {
	Widget box, label, input;

	XtSetArg(args[n], XtNorientation, XtorientHorizontal); ++n;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	XtSetArg(args[n], XtNhSpace, 1); ++n;
	XtSetArg(args[n], XtNvSpace, 1); ++n;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	box = XtCreateManagedWidget
		("inputBox", boxWidgetClass, parent, args, n);
	n = 0;
	XtSetArg(args[n], XtNlabel, prompt); ++n;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	label = XtCreateManagedWidget
		("inputPrompt", labelWidgetClass, box, args, n);
	n = 0;
	XtSetArg(args[n], XtNresize, True); ++n;
	XtSetArg(args[n], XtNexportFormat, XeTextExport_STRING); ++n;
	if (init)
	    {
		XtSetArg(args[n], XtNcontentString, init); ++n;
		XtSetArg(args[n], XtNcontentLength, strlen(init)); ++n;
	    }
	input = XtCreateManagedWidget
		("inputArea", xeTextEdWidgetClass, box, args, n);
	XtSetKeyboardFocus(box, input);
	return input;
    }

/*
** GetXtArgVal
**	Do the magic (Ugh?) juggling with XrmValue and return a proper
**	XtArgVal
*/
XtArgVal GetXtArgVal(from)
XrmValue *from;
    {
	if (from->size == 0)
		return 0;
	/* Ugh.. --msa */
	if (sizeof(XtArgVal) < from->size)
		return (XtArgVal)from->addr;
	else if (from->size == sizeof(long))
		return (XtArgVal)(*(long *)from->addr);
	else if (from->size == sizeof(int))
		return (XtArgVal)(*(int *)from->addr);
	else if (from->size == sizeof(short))
		return (XtArgVal)(*(short *)from->addr);
	else if (from->size == sizeof(char))
		return (XtArgVal)(*(char *)from->addr);
	else if (from->size == sizeof(XtPointer))
		return (XtArgVal)*((XtPointer *)from->addr);
	return (XtArgVal)(*(char **)from->addr);
    }

/*
** ConvertXtArgVal
**	arg->value is a pointer to string which must be converted to the
**	real resource value.
*/
static void ConvertXtArgVal(w, rlist, num, arg)
Widget w;		/* Widget context */
XtResourceList *rlist;	/* Resource List */
Cardinal *num;		/* Number of resources */
Arg *arg;		/* Arg to process */
    {
	XrmValue from, to;
	XtResourceList r, last;

	from.size = strlen((char *)arg->value)+1;
	from.addr = (XtPointer)arg->value;
	arg->value = 0;
	
	if (!*rlist)
		XtGetResourceList(XtClass(w), rlist, num);
	if (*rlist == NULL || *num == 0)
		return;
	/*
	** Locate the resource to find out the representation size
	*/
	for (r = *rlist, last = &r[*num]; r < last; r++)
		if (strcmp(arg->name, r->resource_name) == 0)
		    {
			XtArgVal tmp;
			/*
			** Support only resources whose values can be
			** directly placed into XtArgVal. Fix later --msa
			*/
			to.size = sizeof(XtArgVal);
			to.addr = (XtPointer)&tmp;
			if (!XtConvertAndStore(w, XtRString, &from,
					       r->resource_type, &to))
				printf("Failed to convert %s to %s\n",
				       (char *)from.addr, r->resource_type);
			arg->value = GetXtArgVal(&to);
		    }
    }


void UI_AcceptPanel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;
	UI_ElementDef *r;
	XtArgVal value;
	int need_convert;
	String s;
	Arg args[20];
	int n, i;
	XtResourceList resources = NULL;
	Cardinal num_resources = 0;

	static long null_value = 0;

	if (!panel || !panel->target)
		return;	/* Nothing to load */

	value = 0;
	need_convert = 0;
	s = NULL;
	n = 0;
	for (r = panel->elements; r->op != UI_EndOp; ++r)
		switch (r->op)
		    {
		    case UI_InputOp:
			value = 0;
			need_convert = 0;
			if (r->widget)
			    {
				long length;
				XtFree((char *)s);
				s = XeTextGetString(r->widget, &length);
				value = (XtArgVal)(s ? s : "");
				need_convert = True;
			    }
			break;
		    case UI_ToggleOp:
			value = 0;
			need_convert = 0;
			/* Fall to RADIO handling */
		    case UI_RadioOp:
			if (r->widget)
			    {
				Arg tmp[1];
				Boolean state;

				XtSetArg(tmp[0], XtNstate, &state);
				XtGetValues(r->widget, tmp, 1);
				if (state)
					value = r->data;
			    }
			break;
		    case UI_LoadOp:
			if (r->name)
			    {
				if (n == XtNumber(args))
				    {
					XtSetValues(panel->target, args, n);
					n = 0;
				    }
				args[n].name = r->name;
				args[n].value = value;
				if (need_convert)
					ConvertXtArgVal(panel->target,
							&resources,
							&num_resources,
							&args[n]);
				n += 1;
			    }
			break;
		    default:
			break;
		    }
	if (n && panel->target)
		XtSetValues(panel->target, args, n);
	XtFree((char *)s);
	XtFree((char *)resources);
    }

/*
** SetElementValue
**	Initialize panel element value from the widget resource
*/
static void SetElementValue(w, r, p, rlist, num)
Widget w;
UI_ElementDef *r;	/* UI_LoadOp element pointer */
UI_ElementDef *p;	/* p < r, points to some source element */
XtResourceList *rlist;
Cardinal *num;
    {
	XtPointer value;
	Widget t = p->widget;
	char buf[20];
	XtResourceList rl, last;
	XtArgVal argval;
	XrmValue ref, to;

	if (p == NULL || r->name == NULL || !w || !t)
		return;	/* Nothing to load. */
	if (!*rlist)
		XtGetResourceList(XtClass(w), rlist, num);
	if (*rlist == NULL || *num == 0)
		return;
	/*
	** Locate the resource to find out the representation size
	*/
	for (rl = *rlist, last = &rl[*num];;)
		if (strcmp(r->name, rl->resource_name) == 0)
			break;
		else if (++rl == last)
			return; /* No resource found */
	value = (XtPointer)XtMalloc(rl->resource_size);
	XtVaGetValues(w, r->name, value, NULL);
	ref.size = rl->resource_size;
	ref.addr = value;
	argval = GetXtArgVal(&ref);
	switch (p->op)
	    {
	    case UI_ToggleOp:
	    case UI_RadioOp:
		/*
		** Set matching radio/toggle button
		*/
		while (p < r && p->data != argval)
			p++;
		if (p == r)
			XawToggleUnsetCurrent(t);
		else
			XawToggleSetCurrent(t, p);
		break;
	    case UI_InputOp:
		/*
		** Load resource value into input element
		*/
		to.size = 0;
		to.addr = NULL;
		if (!XtConvertAndStore(w, rl->resource_type, &ref,
				       XtRString, &to))
			printf("Failed to convert %s to %s\n",
			       rl->resource_type, XtRString);
		XeTextReplace(t, 0L, 200000L, (char *)to.addr, to.size);
		break;
	    default:
		break;
	    }
	XtFree((char *)value);
    }


/*
** UI_SetToggles
**	This functions goes through panel and attempts to match the
**	initial values of the toggle/radio groups with the actual
**	resource settings in effect.
**
**	This function is a kludge, works only if toggle/radio and load
**	operations follow a specific pattern used by this application.
*/
void UI_SetToggles(panel)
UI_PanelDef *panel;
    {
	UI_ElementDef *r, *p;
	XtResourceList resources = NULL;
	Cardinal num_resources = 0;

	for (r = panel->elements, p = NULL; r->op != UI_EndOp; ++r)
		switch (r->op)
		    {
		    case UI_InputOp:
			p = r;
			break;
		    case UI_ToggleOp:
			p = r;
			break;
		    case UI_LoadOp:
			SetElementValue(panel->target, r, p,
					&resources, &num_resources);
			p = NULL;
			break;
		    default:
			break;
		    }
	XtFree((char *)resources);
    }

static Widget CreateElementPanel(parent, name, definition)
Widget parent;
char *name;
UI_ElementDef *definition;
    {
	Arg args[20];
	int n;
	Widget panel, pane, radio = 0;
	char *s;
	UI_ElementDef *r;

	n = 0;
	XtSetArg(args[n], XtNinternalBorderWidth, 0); ++n;
	XtSetArg(args[n], XtNorientation, XtorientHorizontal); ++n;
	pane = panel = XtCreateManagedWidget
		(name, panedWidgetClass, parent, args, n);
	for (r = definition; r->name; r++)
		switch (r->op)
		    {
		    case UI_PaneOp:
			n = 0;
			XtSetArg(args[n], XtNinternalBorderWidth, 0); ++n;
			XtSetArg(args[n], XtNshowGrip, False); ++n;
			pane = XtCreateManagedWidget
				(name, panedWidgetClass, panel, args, n);
			/* FALL THROUGH TO LABEL Handling */
		    case UI_LabelOp:
			n = 0;
			XtSetArg(args[n], XtNborderWidth, 0); ++n;
			XtSetArg(args[n], XtNshowGrip, False); ++n;
			XtSetArg(args[n], XtNjustify, XtJustifyLeft); ++n;
			r->widget = XtCreateManagedWidget
				(r->name, labelWidgetClass, pane, args, n);
			break;
		    case UI_ToggleOp:
		    case UI_RadioOp:
			n = 0;
			XtSetArg(args[n], XtNshowGrip, False); ++n;
			r->widget = CreateToggleElement(pane,r->name,args,n);
			n = 0;
			XtSetArg(args[n], XtNradioData, r); ++n;
			XtSetValues(r->widget, args, n);
			XawToggleChangeRadioGroup
				(r->widget,
				 r->op == UI_RadioOp ? radio : r->widget);
			radio = r->widget;
			break;
		    case UI_InputOp:
			n = 0;
			XtSetArg(args[n], XtNshowGrip, False); ++n;
			r->widget = CreateInputElement
				(pane, r->name, "          ", args, n);
			break;
			
		    default:
			break;
		    }
	return panel;
    }

static Widget CreateBottomPanel(parent, name, set_callback, set_data)
Widget parent;
char *name;
XtCallbackProc set_callback;
XtPointer set_data;
    {
	int n;
	Arg args[3];
	Widget box, but;

	n = 0;
	XtSetArg(args[n], XtNshowGrip, False); ++n;
	XtSetArg(args[n], XtNborderWidth, 0); ++n;
	box = XtCreateManagedWidget(name, boxWidgetClass,parent,args,n);
	n = 0;
	but = XtCreateManagedWidget("set", commandWidgetClass, box, args, n);
	XtAddCallback(but, XtNcallback, set_callback, set_data);
	n = 0;
	but = XtCreateManagedWidget("close",commandWidgetClass,box,args,n);
	XtAddCallback(but, XtNcallback, UI_Popdown, (XtPointer)parent);
    }

void UI_PopupPanel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;
	Widget close, pane;
	Cardinal n;
	Arg args[2];
	char *label;

	if (panel->target)
		label = XtName(panel->target);
	else
		label = panel->name;
	if (!panel->shell)
	    {
		panel->shell = XtCreatePopupShell
			(panel->name, transientShellWidgetClass,
			 XtParent(w), NULL, 0);
		n = 0;
		pane = XtCreateManagedWidget
			("Panel", panedWidgetClass, panel->shell, args, n);
		n = 0;
		XtSetArg(args[n], XtNborderWidth, 0); ++n;
		XtSetArg(args[n], XtNshowGrip, False); ++n;
		panel->label = XtCreateManagedWidget
			(label,labelWidgetClass, pane, args, n);
		CreateElementPanel(pane, "Elements", panel->elements);
		CreateBottomPanel
			(pane, "Bottom", panel->set_callback, panel->set_data);
		UI_SetToggles(panel);
	    }
	else if (label)
	    {
		n = 0;
		XtSetArg(args[n], XtNlabel, label); ++n;
		XtSetValues(panel->label, args, n);
	    }
	UI_PopupCentered(NULL, panel->shell, XtGrabNone);
    }

void UI_CreateMenu(parent, menu)
Widget parent;
UI_MenuDef *menu;
    {
	UI_MenuItemDef *item = menu->items;

	menu->button = XtCreateManagedWidget
		(menu->name, menuButtonWidgetClass, parent, NULL, 0);
	menu->menu = XtCreatePopupShell
		("menu", simpleMenuWidgetClass, menu->button, NULL, 0);
	for ( ;item->name; item++)
	    {
		item->entry = XtCreateManagedWidget
			(item->name, smeBSBObjectClass, menu->menu, NULL, 0);
		XtAddCallback(item->entry, XtNcallback, item->callback,
			      item->client_data);
	    }
    }

/*
** CtStringDone
**	A common return function for all String converters.
**
**	The string parameter 's' must really be a pointer to static
**	storage!!!
*/
static Boolean CvtStringDone(s, to)
char *s;
XrmValue *to;
    {
	int n = strlen(s) + 1;

	if (to->addr != NULL)
	    {
		if (to->size < n)
		    {
			to->size = n;
			return False;
		    }
		memcpy((char *)to->addr, s, n);
	    }
	else
		to->addr = s;
	to->size = n;
	return True;
    }

Boolean CvtInt_String(display, args, num_args, from, to, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	static char buf[20];

	sprintf(buf, "%d", (int)GetXtArgVal(from));
	return CvtStringDone(buf, to);
    }

Boolean CvtPixel_String(display, args, num_args, from, to, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	static char buf[20];
	Colormap cmap;
	XColor query;
	
	if (*num_args > 0)
	    {
		cmap = *((Colormap *)args[0].addr);
		query.pixel = (long)GetXtArgVal(from);
		XQueryColor(display, cmap, &query);
		sprintf(buf, "#%4.4X%4.4X%4.4X",
			(int)query.red, (int)query.green, (int)query.blue);
		return CvtStringDone(buf, to);
	    }
	else
		return CvtStringDone("<Error>", to);
    }

Boolean CvtItemization_String(display, args, num_args, from, to,converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	static char buf[30];
	XeItemization *item = (XeItemization *)GetXtArgVal(from);

	if (item == NULL)
		return CvtStringDone("none", to);
	sprintf(buf, "%s,%d,%d",
		item->identifier_alignment == XeAlignment_START ? "start":
		item->identifier_alignment == XeAlignment_END ? "end" :
		"none",
		(int)item->identifier_start_offset,
		(int)item->identifier_end_offset);
	return CvtStringDone(buf, to);
    }

/*
** UI_Initialize
**	Currently this is only needed to register some type converters
*/
void UI_Initialize(app)
XtAppContext app;
    {
	static XtConvertArgRec cvt_pixel[] =
	    {
		{XtResourceString, (XtPointer)XtNcolormap, sizeof(Colormap)},
	    };
	
	XtAppSetTypeConverter
		(app, XtRInt, XtRString, CvtInt_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRDimension, XtRString, CvtInt_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRPixel, XtRString, CvtPixel_String,
		 cvt_pixel,XtNumber(cvt_pixel),XtCacheNone,(XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRXeItemization, XtRString, CvtItemization_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
    }


