#
# MIME text/enriched definitions for the tagged program
# =====================================================
#
# Each TAG is described in single line consisting of the following fields
#
#	tag:options:class:presentation:begin:line:end
#
# Each field value is a string, with leading and trailing white space
# eliminated. If special characters and white space is required, one
# can enclose the string into double quotes ("...").
#
# tag	is the name of the tag. Currently tags are compared in lower
#	case, so write them in all lower case here. An empty tag sets
#	options for the default initial state.
#
# options
#	gives processing options, each option is represented by a single
#	character. (Convention: lower case letters represent processing
#	options, uppercase letters control syntax options).
#
#	i	inclusive, if the a TAG with the same 'class' is already
#		in effect, this tag will not cause any change and can
#		be optionally ignored. Currently affects only editing and
#		prevents the creating constructs like
#			<bold><bold><bold> ... </bold></bold></bold>
#
#	a, s	add or subtract, multiple stacked TAGs of this class
#		have cumulative interpretation. The counting is based
#		on class field:
#
#		...<bigger>...<smaller>...</smaller>...</bigger>...
#		 0          1           0            1           0
#
#	o	override, the effect of the tag completely overrides the
#		effects of any previous tag that has the same class.
#
#	Options 'i', 'a', 's' and 'o' are mutually exclusive, only one of
#	them will be in effect for each TAG (currently the last specified).
#	The default value is 'i'.
#
#	E	NL (new line) interpretation is as specified in MIME
#		text/enriched: Isolated NLs are interpreted as SPACE, N
#		consecutive NLs (N > 1), will be interpreted as N-1 hard
#		NLs. On output, lines are wrapped below 80 characters, if
#		possible by mapping a SPACE into isolated NL.
#
#	H	All Newlines are assumed as "hard newlines" and interpreted
#		as such. No wrapping occurs on output.
#
# class
#	is a string to be associated with the tag and it is used in grouping
#	tags (see options for description). This string is compared as is,
#	case sensitive.
#
# presentation
#	This string describes the presentation of the content affected by
#	this tag. The string should contain control sequences from
#	ISO 6429 (the list of supported sequences depends on current
#	XeText widget implementation). At any point, the final presentation
#	control string applied will be the concatenation of the presentation
#	strings of all tags in effect at that point:
#
#	..<bold>.......<italic>..............</italic>.......<bold>...
#	 ""    "\033[1m"      "\033[1m\033[3m"       "\033[1m"    ""
#
# begin, line, end
#	Three strings that will be inserted to the layout content:
#	'begin' is used when the tag opens, 'end' is used when it closes
#	and 'line' is used at the beginning of each line that starts
#	with the tag. As with presentation, all these strings are a
#	concatenation of the all strings from the tags in effect.
#	(IMPLEMENTATION UNDER CONSTRUCTION, NOT FULLY WORKING YET)
#
# tag:options:class:	rendition:	begin:	line:	end
# ==================	==========	======	=====	===
:iE:None:		"\033K\033K\033L\033[ F\033[0m"
bold:i:Bold:		"\033[1m"
italic:i:Italic:	"\033[3m"
underline:i:Underline:	"\033[4m"
fixed:i:Fixed:		"\033[19m"
smaller:s:Size:		"\033[11m"
bigger:a:Size:		"\033[12m"
center:o:Alignment:	"\033[6 F"
flushleft:o:Alignment:	"\033[5 F"
flushright:o:Alignment:	"\033[7 F"
flushboth:o:Alignment:	"\033[2 F"
nofill:o:Alignment:	"\033[0 F"
indent:i:Indent:
indentright:i:
excerpt:a:Excerpt::"\036\033[1;31mExcerpt from someone:\r\n":"\033[1;31m> \033[0 H":"\036"
param:i:Param:
