#ifndef _XewTextP_h
#define _XewTextP_h
/*
** Copyright 1992, 1993 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <stdio.h>
#include <X11/Xew/BasicP.h>
#include <X11/Xew/Text.h>

typedef struct _XeTextClass
    {
	int makes_compiler_happy;	/* not used */
    } XeTextClassPart;


typedef struct _XeTextClassRec
    {
	CoreClassPart core_class;
	XeBasicClassPart basic_class;
	XeTextClassPart text_class;
    } XeTextClassRec;

/*
** Snip	is a run of graphic characters having same attributes (font,
**	size,etc), or it is a control element representing a word
**	space, subscript/superscript, movements, inserted hyphen etc.
**	Snip is also used to represent various control functions.
**
** All measures and computations are done using the coordinate system
** of the current output device (that is Pixels on screen).
*/
#define FIELD_MASK(a,w)		(~0<<(a)^~0<<((a)+(w)))
#define FIELD_VALUE(a,v)	((v)<<a)

#define Weight_MASK		FIELD_MASK(0,2)
#define Weight_NORMAL		FIELD_VALUE(0,0)
#define Weight_FAINT		FIELD_VALUE(0,1)
#define Weight_BOLD		FIELD_VALUE(0,2)

#define Underline_MASK		FIELD_MASK(2,2)
#define Underline_NONE		FIELD_VALUE(2,0)
#define Underline_SINGLE	FIELD_VALUE(2,1)
#define Underline_DOUBLE	FIELD_VALUE(2,2)

#define Framing_MASK		FIELD_MASK(4,2)
#define Framing_NONE		FIELD_VALUE(4,0)
#define Framing_FRAMED		FIELD_VALUE(4,1)
#define	Framing_ENCIRCLED	FIELD_VALUE(4,2)

#define Blinking_MASK		FIELD_MASK(6,2)
#define Blinking_STEADY		FIELD_VALUE(6,0)
#define Blinking_SLOWLY		FIELD_VALUE(6,1)
#define Blinking_RAPIDLY	FIELD_VALUE(6,2)
/*
**	Subscript and superscript (6.3) (PLD/PLU only from there)
**	(Oda allows only three states here: either PLD,
**	PLU or none is active at any time).
**
**	*NOTE*	In code the values for UP and DOWN are assumed to be single
**		bit masks.
*/
#define PartialLine_MASK	FIELD_MASK(8,2)
#define PartialLine_NONE	FIELD_VALUE(8,0)
#define PartialLine_UP		FIELD_VALUE(8,1)
#define PartialLine_DOWN	FIELD_VALUE(8,2)

#define Italicized_MASK		FIELD_MASK(10,1)
#define ImageInversion_MASK	FIELD_MASK(11,1)
#define Overlined_MASK		FIELD_MASK(12,1)
#define CrossedOut_MASK		FIELD_MASK(13,1)

/*
** SnipContent
**	will indicate whether the snip represents
**
**	processable content
**		is processed by editing, layout and imaging processes.
**	formatted content
**		is generated by the layout process for the imaging
**		process. This content is ignored by layout and
**		editing processes. In ODIF stream this is indicated
**		by <SOS> ... <ST> sequence.
**	original content
**		is yet unstandardized method of marking processable
**		content that should be *ignored* by the imaging
**		process. This marking also generated by the layout
**		process. Layout and editing processes should treat
**		this the same way as processable content. This feature
**		is required, for example to enable hyphenation in
**		languages where the form of the word changes when it's
**		hyphenated. The suggested indication in ODIF stream
**		is by <SOOS> ... <ST> sequence.
**
**	*NOTE*	The values are tailored so that the processes can
**		use bit test operation in deducing whether they want
**		to deal with particular snip.
**
**		..for editing process ignore, if (SkipContent & 1)
**		..for layout process ignore, if (SkipContent & 1)
**		..for imaging process ignore, if (SkipContent & 2)
*/
#define Content_MASK		FIELD_MASK(14,2)
#define Content_PROCESSABLE	FIELD_VALUE(14,0)
#define Content_FORMATTED	FIELD_VALUE(14,1)
#define Content_ORIGINAL	FIELD_VALUE(14,2)
#define IsEditableContent(x)	(!((x) & Content_FORMATTED))
#define IsImagedContent(x)	(!((x) & Content_ORIGINAL))
/*
**	Justify field contains the current alignment mode for this
**	portion of the text. The value is defined by XeAlignment, but
**	only NONE, START, END and CENTER have meaning here. NONE
**	(default) will use the aligment of the "alignment" resource.
*/
#define Justify_MASK		FIELD_MASK(16,3)
#define Justify_MODE(x)		(XeAlignment)(((x) >> 16) & 0x7)
#define Justify_VALUE(v)	(((int)(v) & 0x7) << 16)
/*
**	Text can be rendered with specific foreground or background color.
**	When not specified, the default background and foreground colors of
**	the widget will be used. The color index defines the color as follows:
**	0=black, 1=red, 2=green, 3=yellow, 4=blue, 5=magenta, 6=cyan and
**	7=white. (ISO 6429: 1988). The color information is coded into 4 bit
**	field such that 0 indicates the default and non-zero value is (color
**	index)+1.
*/
#define Foreground_MASK		FIELD_MASK(19,4)
#define Background_MASK		FIELD_MASK(23,4)
#define Foreground_COLOR(x)	(((x) >> 19) & 0xf)
#define Background_COLOR(x)	(((x) >> 23) & 0xf)
#define Foreground_VALUE(v)	(((v) & 0xf) << 19)
#define Background_VALUE(v)	(((v) & 0xf) << 23)
/*
**
*/
#define Font_MASK		FIELD_MASK(27,4)
#define Font_NUMBER(x)		(((x) >> 27) & 0xf)
#define Font_VALUE(v)		(((v) & 0xf) << 27)

typedef struct SnipMode
    {
	unsigned int bits;
	XeTextTag tag;		/* Logical Content TAG */
    } SnipMode;


/*
** SnipData
*/
typedef struct SnipData
    {
	unsigned short refs;	/* # of Snip's referencing this data */
	unsigned short bytes;	/* # of bytes in character 1, 2 or 4 */
	char *character_set;	/* Character Set Registry & Encoding */
	XFontStruct *font;	/* Font information associated with data */
	char s[1];		/* Start of data, dynamically allocated */
    } SnipData;

#define PreviousSnip(s)	(Snip *)((char *)((s)->back)-XtOffsetOf(Snip,next))
#define HasEndPosition(s) \
	((s)->endseq != Snip_NoEnd || \
	 ((s)->next != NULL && \
	 (((s)->mode.bits ^ (s)->next->mode.bits) & PartialLine_MASK)))
/*
** BUG: The definition below is erroneus in respect to pl? Should really
**	compare the mode of the next non-format Snip? This works most of
**	of the time currently. Fix later. --msa
*/
#define VirtualLength(s) ((s)->length+HasEndPosition(s))


typedef enum
    {
	Break_NONE,
	Break_BPH,	/* Break Permitted Here */
	Break_NBH	/* No Break Permitted Here */
    } SnipBreak;

/*
** SnipSequenceEnd
**	Is non-zero for the last Snip belonging to the sequence. End of
**	sequence indicates also that the current position should be moved
**	the left margin of the positioning area. Additionally, "NL" can
**	be coded into it and causes the current position to move into the
**	next line.
*/
typedef enum
    {
	Snip_NoEnd = 0,		/* Next Snip will continue the same sequence */
	Snip_End = 1,		/* End sequence, move to same "line origin" */
	Snip_EndLine = 2,	/* End sequence && terminate line */
	Snip_EndParagraph = 3	/* End sequence && terminate paragraph */
    } SnipSequenceEnd;

#define HasEndLine(s)		((s)->endseq & 2)
#define HasEndParagraph(s)	((s)->endseq == Snip_EndParagraph)

/*
** Snip
*/
#define Snip_NEXTTABSTOP (0xffff)

typedef struct Snip
    {
	struct Snip *next;	/* Link to next Snip or NULL, if last */
	struct Snip **back;	/* Back link to from where this was pointed */
	SnipMode mode;		/* Current Snip state */
	/*
	** "Spot" flags concerning this snip (tab, tabref and quad are
	** only examined if endseq is non-zero).
	*/
	unsigned int tabref:16;	/* Tabulation Reference */
	unsigned int tab:1;	/* TRUE, if Tabulation Reference present */
	unsigned int quad:3;	/* Forced quad (XeAlignment) */
	unsigned int brk:2;	/* NONE, BPH, NBH */
	unsigned int endseq:2;	/* This marks end of sequence */
	unsigned int space:1;	/* TRUE, if Snip represents white space */
	unsigned int layout:1;	/* TRUE, if layout information computed */
	unsigned int valid:1;	/* TRUE, if layout need not be redone */
	SnipData *head;		/* Pointer to head of Data */
	char *data;		/* Pointer to actual character codes */
	int length;		/* Number of characters */
	/*
	** Fields filled by the content layout process (layout information)
	** Snip rectangle:
	**	Upper Left Corner = (x, y - ascent)
	**	Height = ascent + descent
	**	Width = xWidth
	**
	** The flags layout and valid used as follows
	**
	**	layout	valid
	**	False	False	Default initial state. Snip has not been
	**			assigned a position on display yet.
	**	True	True	State, when layout information has been
	**			computed and it matches the current display
	**	True	False	State, when layout information reflects the
	**			current display, but the real position after
	**			layout would be elsewhere (needed when the
	**			content is deleted).
	**	False	True	Illegal combination. Should never appear.
	*/
	Position x, y;		/* Position of this Snip */
	Dimension xWidth;	/* The width of this element */
	short ascent;		/* Backward extent of this Snip */
	short descent;		/* Forward extent of this Snip */
    } Snip;

typedef struct
    {
	/* resources */
	XeAlignment	alignment;
	XeTextExport	export_format;
	int		first_line_offset;
	XeFont*		fonts;
	Boolean		format;
	String		graphic_rendition;
	Dimension	indentation;
	String		initial_state;
	XeItemization *	itemization;
	Dimension *	kerning_offset;
	XeTabStop *	line_layout_table;
	Dimension	line_spacing;
	Boolean		proportional;
	Dimension	column_width;
	XtCallbackList	layout_callbacks;
	
	/* private state */

	XeTextInsertContext
		inserting;	/* Non-NULL, if text inserting in progress */
	int num_fonts;		/* Number of entries in fonts array */
	int num_tabs;		/* Number of entries in lineLayoutTable */

	Dimension w, h;		/* Computed width, height */
	Dimension x, y;		/* Initial Point (from Content Layout) */
	Snip *first;		/* Snips of this block */
	unsigned long *colors;	/* 8 longs, if texts uses colors */
	GC		mygc;
	GC		mygcXOR;
    } XeTextPart;

typedef struct _XeTextRec
    {
	CorePart	core;
	XeBasicPart	basic;
	XeTextPart	text;
    } XeTextRec;


/* Class pointer */
extern XeTextClassRec xeTextClassRec;

_XFUNCPROTOBEGIN
Snip *_XeInsertSnip(
#if NeedFunctionPrototypes
		 Snip **
#endif
);
void _XeDeleteSnip(
#if NeedFunctionPrototypes
		Snip **
#endif
);
_XFUNCPROTOEND
#endif

