#ifndef _XewTextEdP_h
#define _XewTextEdP_h
/*
** Copyright 1993 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <stdio.h>
#include <X11/Xew/BasicP.h>
#include <X11/Xew/TextP.h>
#include <X11/Xew/TextEd.h>

typedef struct _XeTextEdClass
    {
	int makes_compiler_happy;	/* not used */
    } XeTextEdClassPart;


typedef struct _XeTextEdClassRec
    {
	CoreClassPart core_class;
	XeBasicClassPart basic_class;
	XeTextClassPart text_class;
	XeTextEdClassPart texted_class;
    } XeTextEdClassRec;

typedef struct
    {
	Snip *snip;
	int offset;
    } XeTextPosition;

typedef struct
    {
	long range[2];		/* Range of the selected area */
	XRectangle rect[3];	/* Current Selected Area (for expose) */
	int nrect;		/* Number of rectanges in sel_rect (0,1,3) */
	Atom *selections;	/* Owned selections */
	int atom_count;		/* Number of  atoms in selections */
	int array_size;		/* Size of the selections array */
    } XeTextSelection;

typedef struct
    {
	/* resources */
	Boolean	allow_edit;	/* True, if editing allowed */
	Boolean display_caret;	/* True, if caret symbol is visible */
	long cursor_position;	/* Current position (virtual offset) */
	XtCallbackList modify_callbacks;

	/* private state */

	Pixmap cursor;		/* Cursor Image Bitmap */
	/*
	** Information about the cursor location in various levels. To
	** speed up some processing, the some precomputed information
	** is maintained (matching the cursor_position).
	**
	** (cursor_x, cursor_y) is the current (x,y) location matching
	**	cursor_position.
	** cursor_location is the current (Snip, offset) pointer
	**	matching the cursor_position. This is information is
	**	valid if cursor_valid is True.
	*/
	short cursor_x, cursor_y;
	XeTextPosition cursor_location;
	XeTextSelection s;	/* Current Selection information */
	int mult;		/* Repeater count for actions */
	short cursor_goal;	/* Horizontal target position for cursor */
	Boolean cursor_valid;	/* Cursor location is valid */
	Time time;		/* Time of the last event */
	Region refresh;		/* Region requiring refresh on display */
    } XeTextEdPart;

typedef struct _XeTextEdRec
    {
	CorePart	core;
	XeBasicPart	basic;
	XeTextPart	text;
	XeTextEdPart	texted;
    } XeTextEdRec;

/* Class pointer */
extern XeTextEdClassRec xeTextEdClassRec;
#endif

