#ifndef _XewTextEd_h
#define _XewTextEd_h
/*
** Copyright 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <X11/Xmu/Converters.h>
#include <X11/Xew/Basic.h>
#include <X11/Xew/Text.h>

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 alignment           XeAlignment        XeAlignment     XeStartAligned
 allowEdit           AllowEdit          Boolean         True
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 contentFile         ContentFile        String          NULL
 contentLength       ContentLength      long            Computed from content
 contentOffset       ContentOffset      long            0
 contentStream       ContentStream      FILE *          NULL
 contentString       ContentString      Pointer         NULL
 cursor              Cursor             Cursor          None
 cursorPosition      CursorPosition     long            0
 destroyCallback     Callback		Pointer		NULL
 displayCaret        Output             Boolean         True
 exportFormat        ExportFormat       XeTextExport    XeTextExport_ODIF
 firstLineOffset     Offset             int             0
 fonts               XeFonts            XeFont *        NULL
 format              Format             Boolean         False
 graphicRendition    Rendition          String          NULL
 height		     Height		Dimension	0
 indentation         Offset             Dimension       0
 initialState        Sequence           String          NULL
 itemization         Itemization        XeItemization * NULL
 kerningOffset       KerningOffset      Dimension *     NULL
 lineLayoutTable     LineLayoutTable    XeTabStop *     NULL
 lineSpacing         LineSpacing        Dimension       Computed from font
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 modifyCallback      ModifyCallback           Pointer         NULL
 proportional        Proportional       Boolean         False
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* New fields */
#define XtNallowEdit "allowEdit"
#define XtCAllowEdit "AllowEdit"
#define XtNcursorPosition "cursorPosition"
#define XtCCursorPosition "CursorPosition"
#define XtNmodifyCallback "modifyCallback"
#define XtCModifyCallback "ModifyCallback"
#ifndef XtNdisplayCaret
#define XtNdisplayCaret "displayCaret"
#endif
#ifndef XtCOutput
#define XtCOutput "Output"
#endif
/* Class record constants */

extern WidgetClass xeTextEdWidgetClass;

typedef struct _XeTextEdClassRec *XeTextEdWidgetClass;
typedef struct _XeTextEdRec      *XeTextEdWidget;

/*
** XeTextModifyCallbackData
**	is the data supplied for the XtNmodifyCallback just before
**	the content is prepared for any modifications. The callback
**	function has the option of preventing the modification by
**	setting the field 'cancel' to True.
*/
typedef struct XeTextModifyCallbackData
    {
	int reason;		/* == XeCR_MODIFY_TEXT */
	Boolean cancel;		/* Initialized to False */
    } XeTextModifyCallbackData;

	
_XFUNCPROTOBEGIN
Boolean XeTextSaveAsFile
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 String		/* Name (path) of the file to be written */
#endif
	 );

String XeTextGetString
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long *		/* Number of octets returned */
#endif
	 );

String XeTextGetSubstring
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long *,	/* Number of octets returned */
	 long,		/* Virtual offset to the start of region */
	 long		/* Virtual offset to the end of region */
#endif
	 );

typedef int (*XeTextExtractFeed)
 (
#if NeedFunctionPrototypes
  char *,		/* Extracted text portion */
  int,			/* The length of the text */
  XeTextTag,		/* The content TAG value */
  XtPointer		/* client_data */
#endif
 );

void XeTextExtract
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset to the start of region */
	 long,		/* Virtual offset to the end of region */
	 XeTextExtractFeed, /* Function to receive the content (feed) */
	 XtPointer	/* client_data for the feed function */
#endif
	 );

void XeTextReplace
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset to the start of the replace */
	 long,		/* Virtual offset to the end of the replace */
	 char *,	/* Pointer to the octest to be inserted */
	 long		/* Number of octets to insert */
#endif
	 );

void XeTextInsert
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 char *,	/* Pointer to octest to be inserted */
	 long		/* Number of octets to insert */
#endif
	 );

void XeTextReplaceTagged
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset to the start of replace */
	 long,		/* Virtual offset to the end of replace */
	 char *,	/* Pointer to octets to be inserted */
	 long,		/* Number of octets to insert */
	 XeTextTag	/* The Text tag to be used */
#endif
	 );

long XeTextGetInsertionPoint
	(
#if NeedFunctionPrototypes
	 Widget		/* TextEd Widget pointer */
#endif
	 );

XeTextTag XeTextGetInsertionTag
	(
#if NeedFunctionPrototypes
	 Widget		/* TextEd Widget pointer */
#endif
	 );

void XeTextGetSelectionPosition
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long *,	/* Virtual offset of the start of selection */
	 long *		/* Virtual offset of the end of selection */
#endif
	 );

void XeTextSetSelection
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset of the start of selection */
	 long		/* Virtual offset of the end of selection */
#endif
	 );

void XeTextUnsetSelection
	(
#if NeedFunctionPrototypes
	 Widget		/* TextEd Widget pointer */
#endif
	 );
_XFUNCPROTOEND
#endif
