#ifndef _XewRasterP_h
#define _XewRasterP_h
/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/BasicP.h>
#include <X11/Xew/Raster.h>
#include "ImageTools.h"

typedef struct _XeRasterClass
    {
	int makes_compiler_happy;	/* not used */
    } XeRasterClassPart;

typedef struct _XeRasterClassRec
    {
	CoreClassPart	core_class;
	XeBasicClassPart basic_class;
	XeRasterClassPart raster_class;
    } XeRasterClassRec;

typedef struct
    {
	/* resources */

	long clip_x, clip_y;
	long clip_width, clip_height;
	long raster_width, raster_height;
	Dimension offset_x, offset_y;
	XeColorQuantize color_quantize;
	XeDither dither;

	/* private state */

	/* The Current display version of the Image */

	GC mygc;		/* Graphic Context */
	XeImage *dsp_image;	/* Display Image */
	XeRawImage *raw_image;	/* Raw image data descriptor */
	unsigned int done:1;	/* TRUE, when XeRasterLayout done */
    } XeRasterPart;

typedef struct _XeRasterRec
    {
	CorePart	core;
	XeBasicPart	basic;
	XeRasterPart	raster;
    } XeRasterRec;

/* Class pointer */
extern XeRasterClassRec xeRasterClassRec;

#endif




