/*
** RasterImport module for importing raster images into
** Xew internal format. This module is a generic switching
** point to different format specific import functions and
** is a place for common actions necessary for import.
**
** Copyright 1992,1993,1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/RasterP.h>
#include "ImageTools.h"
#include "RasterImport.h"
#include "RasterTIFF.h"
#include "RasterGIF.h"
#include "RasterJPEG.h"
#include "RasterPBM.h"

void XeRasterImport(w)
XeRasterWidget w;
    {
	_XeDestroyRawImage(w->raster.raw_image);
	switch (w->basic.content_format)
	    {
	    case XeContentFormat_TIFF:
		w->raster.raw_image = XeImport_TIFF(w);
		break;
	    case XeContentFormat_GIF:
		w->raster.raw_image = XeImport_GIF(w);
		break;
	    case XeContentFormat_JPEG:
		w->raster.raw_image = XeImport_JPEG(w);
		break;
	    case XeContentFormat_PBM:
		w->raster.raw_image = XeImport_PBM(w);
		break;
	    default:
		w->raster.raw_image = NULL;
		XeWidgetWarningMsg
			((Widget)w, "formatNotSupported",
			 "Raster widget does not support this format",
			 (String *)NULL, 0);
		break;
	    }
	if (w->raster.raw_image)
	    {
		/* Just make width and height visible as resources */
		w->raster.raster_width = w->raster.raw_image->width;
		w->raster.raster_height = w->raster.raw_image->height;
	    }
    }

