/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#if ANSI_INCLUDES
#	include <stddef.h>
#	include <stdlib.h>
#endif
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/RasterP.h>
/* #include "BasicColor.h" */
#include "RasterImport.h"
#include "RasterLayout.h"
#include "ImageTools.h"

#define offset(field) XtOffsetOf(XeRasterRec, raster.field)

static XtResource resources[] =
    {
	{XtNclipX, XtCClipX, XtRLong, sizeof(long),
		 offset(clip_x), XtRImmediate, (long)0},
	{XtNclipY, XtCClipY, XtRLong, sizeof(long),
		 offset(clip_y), XtRImmediate, (long)0},
	{XtNclipWidth, XtCClipWidth, XtRLong, sizeof(long),
		 offset(clip_width), XtRImmediate, (long)0},
	{XtNclipHeight, XtCClipHeight, XtRLong, sizeof(long),
		 offset(clip_height), XtRImmediate, (long)0},
	{XtNcolorQuantize, XtCColorQuantize, XtRXeColorQuantize,
		 sizeof(XeColorQuantize), offset(color_quantize),
		 XtRImmediate, (XtPointer)XeColorQuantize_FAST},
        {XtNdither, XtCDither, XtRXeDither, sizeof(XeDither), offset(dither),
		 XtRImmediate, (XtPointer)XeDither_FS4 },
	{XtNoffsetX, XtCOffsetX, XtRDimension, sizeof(Dimension),
		 offset(offset_x), XtRImmediate, (long)0},
	{XtNoffsetY, XtCOffsetY, XtRDimension, sizeof(Dimension),
		 offset(offset_y), XtRImmediate, (long)0},
	{XtNrasterWidth, XtCRasterWidth, XtRLong, sizeof(long),
		 offset(raster_width), XtRImmediate, (long)0},
	{XtNrasterHeight, XtCRasterHeight, XtRLong, sizeof(long),
		 offset(raster_height), XtRImmediate, (long)0},
    };
#undef offset

static void ClassPartInitialize(), ClassInitialize();
static void Initialize(), Redisplay(), Resize(), Destroy();
static Boolean SetValues();


XeRasterClassRec xeRasterClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &xeBasicClassRec,
    /* class_name		*/	"XeRaster",
    /* widget_size		*/	sizeof(XeRasterRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMultiple,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* XeBasic fields */
    /* not used			*/	0
  },
  { /* XeRaster fields */
    /* not used			*/	0
  }
};

WidgetClass xeRasterWidgetClass = (WidgetClass)&xeRasterClassRec;

#define	CvtDone(type, value)				\
    do {						\
	if (toVal->addr != NULL)			\
	    {						\
		if (toVal->size < sizeof(type))		\
		    {					\
			toVal->size = sizeof(type);	\
			return False;			\
		    }					\
		*(type*)(toVal->addr) = (value);	\
	    }						\
	else						\
	    {						\
		static type static_val;			\
		static_val = (value);			\
		toVal->addr = (XPointer)&static_val;	\
	    }						\
	toVal->size = sizeof(type);			\
	return True;					\
    } while (0)

static void ClassInitialize()
    {
	XewInitializeWidgetSet();
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

/*
** SetupContent
**	Prepare for viewing raster content
*/
static void SetupContent(w)
XeRasterWidget w;
    {
	Dimension width, height;

	if (w->basic.content_loaded == False)
	    {
		XeRasterImport(w);
		w->basic.content_loaded = True;
		w->raster.done = False;
	    }
	if (w->raster.raw_image)
	    {
		XeBasicScaling((XeBasicWidget)w,
			       w->raster.raw_image->width,
			       w->raster.raw_image->height,
			       &width, &height);
		if (w->basic.resize || w->core.width == 0)
			w->core.width = width;
		if (w->basic.resize || w->core.height == 0)
			w->core.height = height;
		if (w->raster.dsp_image == NULL ||
		    w->raster.dsp_image->image == NULL ||
		    w->raster.dsp_image->image->width != width ||
		    w->raster.dsp_image->image->height != height)
			w->raster.done = False;
	    }
	XSetBackground(XtDisplay(w),w->raster.mygc,w->core.background_pixel);
	XSetForeground(XtDisplay(w),w->raster.mygc,w->basic.foreground_pixel);
    }


static void Initialize (request, new)
Widget request, new;
    {
	XeRasterWidget w = (XeRasterWidget)new;

	w->raster.mygc  =
		XCreateGC(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 0, 0);
	XSetLineAttributes(XtDisplay(w), w->raster.mygc,
			   1, LineSolid, CapButt, JoinMiter);
	w->raster.dsp_image = NULL;
	w->raster.raw_image = NULL;
	w->raster.done = False;
	SetupContent(w);
    }

static void Redisplay(w, e, r)
Widget w;
XExposeEvent *e;
Region r;
    {
	XeRasterWidget rw = (XeRasterWidget)w;

	if (!XtIsRealized(w))
		return;
	if (!rw->raster.done)
		XeRasterLayout(rw);
	if (rw->raster.dsp_image != NULL)
	    {
		int srcx = e->x - rw->raster.offset_x;
		int srcy = e->y - rw->raster.offset_y;
		int dstx = e->x;
		int dsty = e->y;
		unsigned int width = e->width;
		unsigned int height = e->height;
		if (srcx < 0)
		    {
			width += srcx;
			srcx = 0;
			dstx = rw->raster.offset_x;
			
		    }
		if (srcy < 0)
		    {
			height += srcy;
			srcy = 0;
			dsty = rw->raster.offset_y;
		    }
#if 0
		if (r != NULL)
			XSetRegion(XtDisplay(w), rw->raster.mygc, r);
#endif
		_XePutImage((XeBasicWidget)w, rw->raster.mygc,
			    rw->raster.dsp_image,
			    srcx, srcy, dstx, dsty,
			    width, height);
#if 0
		if (r != NULL)
			XSetClipMask(XtDisplay(w), rw->raster.mygc, None);
#endif
	    }
	if (rw->basic.expose_callbacks &&
	    rw->core.widget_class == xeRasterWidgetClass)
	    {
		XeExposeCallbackData data;
		data.reason = XeCR_EXPOSE;
		data.event = e;
		data.region = r;
		XtCallCallbackList
			(w, rw->basic.expose_callbacks, (XtPointer)&data);
	    }
    }


static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	XeRasterWidget cw = (XeRasterWidget)current;
	XeRasterWidget nw = (XeRasterWidget)new;

	if (cw->basic.max_colors != nw->basic.max_colors ||
	    cw->basic.color_mode != nw->basic.color_mode ||
	    cw->basic.colormap_use != nw->basic.colormap_use ||
	    cw->basic.rotation != nw->basic.rotation ||
	    cw->basic.scaling != nw->basic.scaling ||
	    cw->basic.use_shm != nw->basic.use_shm ||
	    cw->basic.mirror_image != nw->basic.mirror_image ||
	    cw->raster.dither != nw->raster.dither ||
	    cw->raster.color_quantize != nw->raster.color_quantize)
		nw->raster.done = False;
	SetupContent(nw);
	return (!nw->raster.done ||
		cw->core.background_pixel != nw->core.background_pixel ||
		cw->basic.foreground_pixel != nw->basic.foreground_pixel);
    }

static void Resize(w)
Widget w;
    {
	SetupContent((XeRasterWidget)w);
    }

static void Destroy(w)
Widget w;
    {
	register XeRasterWidget rw = (XeRasterWidget)w;
	
	XFreeGC(XtDisplay(w), rw->raster.mygc);
	_XeDestroyRawImage(rw->raster.raw_image);
	_XeDestroyImage((XeBasicWidget)rw, rw->raster.dsp_image);
    }

