#ifndef ImageTools_h
#define ImageTools_h
/*
** ImageTools.h
**
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/

#ifdef SH_MEM
#	include <sys/ipc.h>
#	include <sys/shm.h>
#	include <X11/extensions/XShm.h>
#endif

#include <X11/Xew/Basic.h>

typedef unsigned long XePixel;
typedef unsigned char XeSample;

#define XeSample_BITS 8
#define XeSample_RANGE (1<<(XeSample_BITS))
#define XeSample_MAX ((XeSample_RANGE)-1)

typedef struct XeImageChannel
    {
	unsigned char *addr;	/* Starting address */
	int w, h;		/* Width and Height of data (pixels) */
	int line;		/* Increment to get to next scan line */
	int inc;		/* Increment to get to next pixel in line */
    } XeImageChannel;


typedef void (*XeImageOpF)(
#if NeedFunctionPrototypes
			   XeBasicWidget,	/* widget */
			   unsigned char *,	/* in map parameter */
			   unsigned char *,	/* out val parameter */
			   unsigned char *,	/* out map parameter */
			   XeImageChannel *,	/* dst channel(s) */
			   XeImageChannel *	/* src channel(s) */
#endif
			   );

typedef struct XeImageOp
    {
	XeImageOpF op;	/* Function to execute the operation */
	int in_offset;	/* Offset to the in map area in parameter area */
	int val_offset;	/* Offset to the val area in parameter area */
	int out_offset;	/* Offset to the out map area in parameter area */
	int dst, src;	/* Source and destination channel indexes */
    } XeImageOp;

typedef struct XeImage
    {
	XImage *image;		/* X Image structure */
	unsigned char *map;	/* Color Mapping information */
	XeImageOp *image_op;	/* Image processing instructions */
#if SH_MEM
	unsigned int shared:1;	/* True, if MIT_SHM image allocated */
	XShmSegmentInfo shm;	/* Shared memory segment info */
	Pixmap pixmap;		/* Server side Pixmap (if supported) */
#endif
    } XeImage;

typedef enum
    {
	XeImageClass_UNKNOWN,	/* Unspecified type, error */
	XeImageClass_BILEVEL,	/* bi-level (black and white) image */
	XeImageClass_GRAYSCALE,	/* Grayscale image */
	XeImageClass_PALETTE,	/* Palette colour image */
	XeImageClass_FULLCOLOR	/* Full color image */
    } XeImageClass;

typedef enum
    {
	XeImageUnit_NONE,	/* Bare numbers */
	XeImageUnit_INCH,	/* Inch */
	XeImageUnit_CM    	/* Centimeters */
    } XeImageUnit;

typedef enum
    {
	XeImageSpace_NONE,	/* Plain samples (intesity) */
	XeImageSpace_RGB,	/* RGB color space */
	XeImageSpace_YCbCr	/* YCbCr color space */
    } XeImageSpace;

/*
** XeRawImage
**	describes the format and parameters of the internal raw image
*/
typedef struct XeRawImage
    {
	XeImageClass class;		/* Raster Image class */
	XeImageSpace color_space;	/* Image color space */
	XeImageUnit resolution_unit;	/* Unit of the resolution attributes */
	float x_resolution;		/* Horizontal scaling */	
	float y_resolution;		/* Vertical scaling */
	unsigned int width;		/* Number of columns in raster image */
	unsigned int height;		/* Number of rows in raster image */
	/*
	** The following parameters describe the structure of the
	** raw image data:
	**
	** samples_per_pixel	Number of components in pixel value.
	** bits_per_sample	Number of significant bits in each
	**			component sample.
	** bits_per_component	Number of actual bits allocated for
	**			each component (e.g. samples may be
	**			only in range 0-15, but each component
	**			might be allocated one byte).
	** bytes_per_line	Total number of bytes in single pixel
	**			row (this includes all necessary padding).
	*/
	unsigned short samples_per_pixel;
	unsigned short bits_per_sample;
	unsigned short bits_per_component;
	int bytes_per_line;
	unsigned int alloc_data:1;	/* TRUE, if data XtMalloc'ed */
	unsigned int alloc_map:1;	/* TRUE, if color_map XtMalloc'ed */
	unsigned char *data;		/* Raw pixel data buffer */
	unsigned char *color_map;	/* 3 * (1<<bits_per_sample) bytes */
	/*
	** 'channel' is an array of structures that can be used to acces
	** individual channels. The space is allocated as needed, there
	** might be one or more of the structures (num_channels).
	**
	** THE FIELD "channel" MUST BE THE LAST FIELD IN THE STRUCTURE!!!
	*/
	unsigned short num_channels;	/* Number of channels */
	XeImageChannel channel[1];	/* Image Channels */
    } XeRawImage;

_XFUNCPROTOBEGIN
XeImage *_XeCreateImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 XeRawImage *,		/* Raw image description */
	 int,			/* dither (XeDither) */
	 int			/* quantize (XeColorQuantize) */
#endif
	 );

/*
** _XeBuildImage
**	Build the actuall XImage from the raw input image using the
**	control structures.
*/
void _XeBuildImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 XeImage *,		/* Xew Image Control Structure */
	 int n,			/* Number of entries in data */
	 XeImageChannel *	/* Raw Image data channels */
#endif
	 );

void _XePutImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 GC,			/* Graphics context */
	 XeImage *,		/* Image to display */
	 int, int,		/* (src_x, src_y) */
	 int, int,		/* (dst_x, dst_y) */
	 unsigned int,		/* width */
	 unsigned int		/* height */
#endif
	 );

void _XeDestroyImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 XeImage *		/* Display Image descriptor */
#endif
	 );

/*
** _XeCreateRawImage
**	Create empty raw image structure which has room for the
**	specified number of channels.
*/
XeRawImage *_XeCreateRawImage
	(
#if NeedFunctionPrototypes
	 int		/* Number of channel structures */
#endif
	 );

/*
** _XeDestroyRawImage
**	Release all resources allocated to a raw image, including the
**	descriptor structure itself (do not call this for staticly
**	allocated descriptor!)
*/
void _XeDestroyRawImage
	(
#if NeedFunctionPrototypes
	 XeRawImage *		/* Raw Image Descriptor */
#endif
	 );
_XFUNCPROTOEND
#endif


