/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <string.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/BasicP.h>
#include <errno.h>
#include <ctype.h>
#ifdef SH_MEM
#	include <sys/ipc.h>
#	include <sys/shm.h>
#	include <X11/extensions/XShm.h>
#endif
#if ANSI_INCLUDES
#	include <stdlib.h>
#else
extern int atoi( /* No header for this in SYSV? */
#if NeedFunctionPrototypes
		char *
#endif
		);

#endif

#include <fcntl.h>	/* Is this standard header? check! --msa */
#include "BasicColor.h"

/*
** X11R4 doesn't seem to have XmuCvtStringToCursor. Register this
** converter only for post X11R4 releases. The resource 'cursor'
** is defined always, whether converter exists or not.
*/
#define Have_XmuCvtStringToCursor ((XtVersion) > 11004)

#if NeedFunctionPrototypes
static void EnterWindow(Widget, XEvent *, String *, Cardinal *);
static void LeaveWindow(Widget, XEvent *, String *, Cardinal *);
static void Notify(Widget, XEvent *, String *, Cardinal *);
#else
static void EnterWindow();
static void LeaveWindow();
static void Notify();
#endif

static char defaultTranslations[] =
"\
<Btn1Down>,<Btn1Up>: notify()\n\
<EnterWindow>:	enter-window()\n\
<LeaveWindow>:	leave-window()\
";

static XtActionsRec actions[] =
    {
	    {"notify",		Notify},
	    {"enter-window",	EnterWindow},
	    {"leave-window",	LeaveWindow},
    };

#define offset(field) XtOffsetOf(XeBasicRec, basic.field)
static XtResource resources[] =
    {
	{XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
		 offset(cursor), XtRImmediate, (XtPointer) None},
	{XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
		 offset(foreground_pixel), XtRString, XtDefaultForeground},
	{XtNcolormapUse, XtCColormapUse, XtRXeColormapUse,
		 sizeof(XeColormapUse), offset(colormap_use),
		 XtRImmediate, (XtPointer)XeColormapUse_SHARED},
	{XtNcolormapInstall, XtCColormapInstall, XtRBoolean,
		 sizeof(Boolean),offset(colormap_install),XtRImmediate,False},
	{XtNcolorMode, XtCColorMode, XtRXeColorMode,
		 sizeof(XeColorMode), offset(color_mode),
		 XtRImmediate, (XtPointer)XeColorMode_COLOR},
	{XtNcontentFile, XtCContentFile, XtRString, sizeof(String),
		 offset(content_file), XtRImmediate, (XtPointer)NULL},
	{XtNcontentFormat, XtCContentFormat, XtRXeContentFormat,
		 sizeof(XeContentFormat), offset(content_format),
		 XtRImmediate, (long)XeContentFormat_UNKNOWN},
	{XtNcontentStream, XtCContentStream, XtRFile, sizeof(FILE *),
		 offset(content_stream), XtRImmediate, (XtPointer)NULL},
	{XtNcontentString, XtCContentString, XtRString, sizeof(String),
		 offset(content_string), XtRImmediate, (XtPointer)NULL},
	{XtNcontentOffset, XtCContentOffset, XtRLong, sizeof(long),
		 offset(content_offset), XtRImmediate, (long)0},
	{XtNcontentLength, XtCContentLength, XtRLong, sizeof(long),
		 offset(content_length), XtRImmediate, (long)0},
	{XtNcontentLoaded, XtCContentLoaded, XtRBoolean, sizeof(Boolean),
		 offset(content_loaded), XtRImmediate, False},
	{XtNexposeCallback, XtCExposeCallback, XtRCallback, sizeof(XtPointer),
		 offset(expose_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNmaxColors, XtCMaxColors, XtRInt, sizeof(int),
		 offset(max_colors), XtRImmediate, (XtPointer)65535},
	{XtNmirrorImage, XtCMirrorImage, XtRBoolean, sizeof(Boolean),
		 offset(mirror_image), XtRImmediate, False},
	{XtNnotifyCallback, XtCNotifyCallback, XtRCallback, sizeof(XtPointer),
		 offset(notify_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNresize, XtCResize, XtRBoolean, sizeof(Boolean),
		 offset(resize), XtRImmediate, (XtPointer)True},
	{XtNrotation, XtCRotation, XtRInt, sizeof(int),
		 offset(rotation), XtRImmediate, 0},
	{XtNscaling, XtCScaling, XtRXeScaling, sizeof(XeScaling),
		 offset(scaling), XtRImmediate, (XtPointer)XeScaling_WIDTH},
	{XtNuseShm, XtCUseShm, XtRBoolean, sizeof(Boolean),
		 offset(use_shm), XtRImmediate, False},
	{XtNvisual, XtCVisual, XtRVisual,
		 sizeof(Visual *), offset(visual), XtRImmediate, 0},
    };
#undef offset

static void Initialize(), Realize(), Destroy(), Redisplay();
static void ClassPartInitialize(), ClassInitialize();
static Boolean SetValues();

XeBasicClassRec xeBasicClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Basic",
    /* widget_size		*/	sizeof(XeBasicRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* basic fields */
    /* not used			*/	0
  }
};

WidgetClass xeBasicWidgetClass = (WidgetClass)&xeBasicClassRec;


static CvtEnumInfo cvtContentFormat[] =
    {
	{"unknown",	XeContentFormat_UNKNOWN },
	{"iso2022",	XeContentFormat_ISO2022 },
	{"tiff",	XeContentFormat_TIFF },
	{"jpeg",	XeContentFormat_JPEG },
	{"gif",		XeContentFormat_GIF },
	{"pbm",		XeContentFormat_PBM },
	{"cgm",		XeContentFormat_CGM },
	{"h261",	XeContentFormat_H261 },
	{"mpeg",	XeContentFormat_MPEG },
	{"audio",	XeContentFormat_AUDIO },
	{"odif",	XeContentFormat_ODIF },
	{NULL,		sizeof(XeContentFormat) },
    };

static CvtEnumInfo cvtScaling[] =
    {
	{"none",	XeScaling_NONE },
	{"width",	XeScaling_WIDTH },
	{"height",	XeScaling_HEIGHT },
	{"maxaspect",	XeScaling_MAXASPECT },
	{"fitarea",	XeScaling_FITAREA },
	{NULL,		sizeof(XeScaling) },
    };

static CvtEnumInfo cvtColormapUse[] =
    {
	{"shared",	XeColormapUse_SHARED },
	{"sharedown",	XeColormapUse_SHAREDOWN },
	{"optional",	XeColormapUse_OPTIONAL },
	{"private",	XeColormapUse_PRIVATE },
	{NULL,		sizeof(XeColormapUse) },
    };

static CvtEnumInfo cvtColorMode[] =
    {
	{"none",	XeColorMode_NONE},
	{"mono",	XeColorMode_MONO},
	{"gray",	XeColorMode_GRAY},
	{"color",	XeColorMode_COLOR},
	{NULL,		sizeof(XeColorMode) },
    };

static CvtEnumInfo cvtDither[] =
    {
	{"none",	XeDither_NONE},
	{"fs4",		XeDither_FS4 },
	{NULL,		sizeof(XeDither) },
    };

static CvtEnumInfo cvtColorQuantize[] =
    {
	{"fast",	XeColorQuantize_FAST },
	{"heckbert",	XeColorQuantize_HECKBERT },
	{"ppmquant",	XeColorQuantize_PPMQUANT },
	{"jpeg",	XeColorQuantize_JPEG },
	{NULL,		sizeof(XeColorQuantize) },
    };

#define	CvtDone(type, value)				\
    do {						\
	if (toVal->addr != NULL)			\
	    {						\
		if (toVal->size < sizeof(type))		\
		    {					\
			toVal->size = sizeof(type);	\
			return False;			\
		    }					\
		*(type*)(toVal->addr) = (value);	\
	    }						\
	else						\
	    {						\
		static type static_val;			\
		static_val = (value);			\
		toVal->addr = (XPointer)&static_val;	\
	    }						\
	toVal->size = sizeof(type);			\
	return True;					\
    } while (0)


/*
** XeCvtStringToEnum
**	Generic String to Enumeration value converter
*/
Boolean XeCvtStringToEnum(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal, *toVal;
XtPointer *converter_data;
    {
	static int e;

	char lower[100];
	int len;
	String params[1];
	Cardinal num_params;
	char *s = (char *) fromVal->addr;
	CvtEnumInfo *list;

	if (*num_args != 1)
	    {
		XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
				"wrongParameters","XeCvtStringToEnum",
				"XewError",
		       "String to Enumeration conversion needs one argument",
				(String *)NULL, (Cardinal *)NULL);
		return False;
	    }
	list = (CvtEnumInfo *)args[0].addr;
	if (s == NULL || (len = strlen(s)) >= sizeof(lower))
		return False;
	XmuCopyISOLatin1Lowered(lower, s);

	for (;; list += 1)
	    {
		if (list->name == NULL)
		    {
			params[0] = (String)fromVal->addr;
			num_params = 1;
			XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
					"XeCvtStringToEnum",
					"unknownKeyword",
					"XewError",
					"Cannot convert \"%s\" to Enumeration",
					params,
					&num_params);
			return False;
		    }
		if (strcmp(lower, list->name) == 0)
		    {
			e = list->value;
			break;
		    }
	    }
/* For some reason, the CvtDone macro doesn't work!??? gcc problem? */
#if 0
	CvtDone(int, e);
#else
	if (toVal->addr != NULL)
	    {
		if (toVal->size < sizeof(XeScaling))
		    {
			toVal->size = sizeof(XeScaling);
			return False;
		    }
		*(int*)(toVal->addr) = e;
	    }
	else
		toVal->addr = (XPointer)&e;
	toVal->size = sizeof(XeScaling);
	return True;
#endif
    }


typedef enum
    {
	XeUnit_MILLIMETER,
	XeUnit_DIDOTPOINT,
	XeUnit_PICAPOINT,
	XeUnit_INCH,
	XeUnit_AGATE
    } XeUnit;

static double Scale[5][5] =
    {
	/*   millimeters  didotPoints  picaPoints  inches     agates */
	{    1.0,         2.66014,     2.846035,   0.03937,   14.7994   },
	{    0.375920,    1.0,         1.0698821,  0.0148,    5.5634    },
	{    0.351365,    0.934682,    1.0,        0.0138333, 5.2       },
	{    25.4,        67.567568,   72.2893,    1.0,       375.90436 },
	{    0.06757,     0.179746,    0.1923,     0.00266,   1.0       },
    };

/*
** XeConvert
**	Convert a measure given in some unit (SrcU/SrcF) into another
**	unit (DstU/DstF).
*/
static long XeConvert(DstU, DstF, SrcV, SrcU, SrcF)
int DstU, DstF;
long SrcV;
int SrcU, SrcF;
    {
	return ((SrcV*(double)DstF)/SrcF*Scale[SrcU][DstU]+0.5);
    }

/*
** XeConvertScaled
**	Does the same as Convert, but the result is scaled using the
**	specified scaling parameters. The actual result is something like
**
**		 Q
**		--- * Convert(....)
**		 R
**
**	but with the benefit of minimal rounding errors (if you used the
**	the above expression, there would be two roundings...)
*/
static long XeConvertScaled(DstU, DstF, SrcV, SrcU, SrcF, Q, R)
int DstU, DstF;
long SrcV;
int SrcU, SrcF;
long Q, R;
    {
	return (SrcV*(double)DstF*Q)/(SrcF*R) * Scale[SrcU][DstU]+0.5;
    }

typedef struct
    {
	char name[4];
	XeUnit unit;
	int fraction;
    } XeUnitDefinition;

static XeUnitDefinition unit_table[] =
    {
	{ "mm", XeUnit_MILLIMETER, 1, },
	{ "i", XeUnit_INCH, 1, },
	{ "p", XeUnit_PICAPOINT, 1, },
    };

/*
** XeConvertDimension
**	Convert input units into pixels (horizontal or vertical)
**
**	(under construction--keep off!)
*/
static Dimension XeConvertDimension(s, pixels, mms)
char *s;
int pixels;
int mms;
    {
	int d;
	char *q = s;
	XeUnitDefinition *u;

	d = atoi(q);
	while (isdigit(*q))
		++q;
	while (*q == ' ')
		++q;
	for (u = &unit_table[0]; u < &unit_table[XtNumber(unit_table)]; ++u)
		if (strcmp(u->name, q) == 0)
		    {
			return d;
		    }
	return d;
    }


/*
** XeCvtStringToHorizontalValue
*/
Boolean XeCvtStringToHorizontalValue(dpy, args, num_args, fromVal, toVal,
				     converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal, *toVal;
XtPointer *converter_data;
    {
	static int d;

	char *s = (char *) fromVal->addr;

	d = atoi(s); /* Dummy Thing Here */
#if 0
	CvtDone(int, d);
#else
	if (toVal->addr != NULL)
	    {
		if (toVal->size < sizeof(int))
		    {
			toVal->size = sizeof(int);
			return False;
		    }
		*(int*)(toVal->addr) = d;
	    }
	else
		toVal->addr = (XPointer)&d;
	toVal->size = sizeof(int);
	return True;
#endif
    }

static void ClassInitialize()
    {
#if Have_XmuCvtStringToCursor
	static XtConvertArgRec convertArg[] =
	    {
		{
		    XtWidgetBaseOffset,
		    (XtPointer) XtOffsetOf(WidgetRec, core.screen),
		    sizeof(Screen *),
		},
		{
		    XtResourceString,
		    (XtPointer) XtNpointerColor,
		    sizeof(Pixel),
		},
	        {
		    XtResourceString,
		    (XtPointer) XtNpointerColorBackground, 
		    sizeof(Pixel),
		},
		{
		    XtWidgetBaseOffset,
		    (XtPointer) XtOffsetOf(WidgetRec, core.colormap),
		    sizeof(Colormap),
		}
	    };
#endif
	static XtConvertArgRec convertContentFormatArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtContentFormat[0],
		    sizeof(XtPointer),
		}
	    };
	static XtConvertArgRec convertScalingArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtScaling[0],
		    sizeof(XtPointer),
		}
	    };

	static XtConvertArgRec convertColormapUseArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtColormapUse[0],
		    sizeof(XtPointer),
		}
	    };

	static XtConvertArgRec convertColorModeArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtColorMode[0],
		    sizeof(XtPointer),
		}
	    };
	static XtConvertArgRec convertDitherArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtDither[0],
		    sizeof(XtPointer),
		}
	    };
	static XtConvertArgRec convertColorQuantizeArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtColorQuantize[0],
		    sizeof(XtPointer),
		}
	    };

	XewInitializeWidgetSet();
#if Have_XmuCvtStringToCursor
	XtSetTypeConverter(XtRString, XtRColorCursor,
			   XmuCvtStringToColorCursor,
			   convertArg, XtNumber(convertArg), 
			   XtCacheByDisplay, NULL);
#endif
	XtSetTypeConverter(XtRString, XtRXeColormapUse,
			   XeCvtStringToEnum,
			   convertColormapUseArg,
			   XtNumber(convertColormapUseArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRXeColorMode,
			   XeCvtStringToEnum,
			   convertColorModeArg, XtNumber(convertColorModeArg),
			   XtCacheNone, NULL);
	XtSetTypeConverter(XtRString, XtRXeDither,
			   XeCvtStringToEnum,
			   convertDitherArg, XtNumber(convertDitherArg),
			   XtCacheNone, NULL);
	XtSetTypeConverter(XtRString, XtRXeColorQuantize,
			   XeCvtStringToEnum,
			   convertColorQuantizeArg,
			   XtNumber(convertColorQuantizeArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRHorizontalValue,
			   XeCvtStringToHorizontalValue,
			   (XtConvertArgList)NULL, 0,
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRXeScaling,
			   XeCvtStringToEnum,
			   convertScalingArg, XtNumber(convertScalingArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRXeContentFormat,
			   XeCvtStringToEnum,
			   convertContentFormatArg,
			   XtNumber(convertContentFormatArg), 
			   XtCacheNone, NULL);
    }


static void Initialize (request, new)
Widget request, new;
    {
	XeBasicWidget w = (XeBasicWidget)new;

	w->core.border_width = 0;
	w->basic.num_colors = 0;
	w->basic.num_allocated = 0;
	w->basic.alloc = NULL;
	w->basic.cmap = 0;
#ifdef SH_MEM
	if (w->basic.use_shm && XShmQueryExtension(XtDisplay(w)))
	    {
		int major, minor, stat;
		Bool pixs;

		stat = XShmQueryVersion(XtDisplay(w), &major, &minor, &pixs);
		w->basic.use_shm = (stat != 0);
		if (stat && pixs)
			w->basic.use_shm = 2;
	    }
	else
		w->basic.use_shm = False;
#endif
    }

/*
** XeWidgetWarningMsg
**	This function calls XtAppWarningMsg with the fixed class=XeWidgetError,
**	passing other parameters unchanged (expect note, that num_params is
**	is by value here).
*/
void XeWidgetWarningMsg(w, type, defaultp, params, num_params)
Widget w;
String type;
String defaultp;
String *params;
Cardinal num_params;
    {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),/* app_context */
		      (XtClass(w))->core_class.class_name,/* name */
		      type,				/* type */
		      "XeWidgetError",			/* class */
		      defaultp,				/* default */
		      params,				/* params */
		      &num_params);			/* num_params */
    }		      


/*
** XeWidgetErrorMsg
**	This function calls XtAppErrorMsg with the fixed class=XeWidgetError,
**	passing other parameters unchanged. (expect note, that num_params is
**	is by value here).
*/
void XeWidgetErrorMsg(w, type, defaultp, params, num_params)
Widget w;
String type;
String defaultp;
String *params;
Cardinal num_params;
    {
	XtAppErrorMsg(XtWidgetToApplicationContext(w),/* app_context */
		      (XtClass(w))->core_class.class_name,/* name */
		      type,				/* type */
		      "XeWidgetError",			/* class */
		      defaultp,				/* default */
		      params,				/* params */
		      &num_params);			/* num_params */
    }		      


/*
** XeGetVisual
**	Get the poiner to the visual structure associated with the
**	window of the widget. This is two-way request...
*/
Visual *XeGetVisual(w)
Widget w;
    {
	XWindowAttributes attribs;

	XGetWindowAttributes(XtDisplay(w), XtWindow(w), &attribs);
	return attribs.visual;
    }

/*
** XeBasicScaling
**	Compute the scaled size of the given rectangle as dictated by
**	the current values of resources 'scaling', core 'width' and
**	core 'height'
*/
void XeBasicScaling(w, width, height, wScaled, hScaled)
XeBasicWidget w;	/* Basic widget */
int width, height;	/* Actual width/height of the rectangle in pixels */
Dimension *wScaled;	/* New scaled width of rectangle in pixels */
Dimension *hScaled;	/* New scaled height of rectangle in pixels */
    {
	XeScaling scaling = w->basic.scaling;

	if (width == 0 || height == 0)
		scaling = XeScaling_FITAREA; /* Kludge! */
	else if ((w->core.width == 0 && w->core.height == 0) ||
	    (w->core.width == 0 && scaling == XeScaling_WIDTH) ||
	    (w->core.height == 0 && scaling == XeScaling_HEIGHT))
		scaling = XeScaling_NONE;
	else if (scaling == XeScaling_FITAREA ||
		 scaling == XeScaling_MAXASPECT)
		if (w->core.width == 0)
			scaling = XeScaling_HEIGHT;
		else if (w->core.height == 0)
			scaling = XeScaling_WIDTH;
	if (scaling != XeScaling_FITAREA &&
	    (w->basic.rotation == 90 || w->basic.rotation == 270))
	    {
		int tmp = width;
		width = height;
		height = tmp;
	    }
	switch (scaling)
	    {
	    case XeScaling_WIDTH:
		/*
		** Set new width from the core width and set the height
		** from that preserving the aspect ratio.
		*/
		*hScaled = (w->core.width * height + width/2) / width;
		*wScaled = w->core.width;
		break;
	    case XeScaling_HEIGHT:
		/*
		** Set new heigth from the core width and set the width
		** from that preserving the aspect ratio.
		*/
		*wScaled = (w->core.height * width + height/2) / height;
		*hScaled = w->core.height;
		break;
	    case XeScaling_FITAREA:
		/*
		** Set new width and height directly from the core
		** width and height.
		*/
		*wScaled = w->core.width;
		*hScaled = w->core.height;
		break;
	    case XeScaling_MAXASPECT:
		*wScaled = (w->core.height * width + height/2) / height;
		if (*wScaled > w->core.width)
		    {
			*hScaled = (w->core.width * height + width/2) / width;
			*wScaled = w->core.width;
		    }
		else
			*hScaled = w->core.height;
		
		break;
	    case XeScaling_NONE:
	    default:
		/*
		** Return actual size as scaled size
		*/
		*wScaled = width;
		*hScaled = height;
		break;
	    }
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

static void Redisplay(w, e, r)
Widget w;
XExposeEvent *e;
Region r;
    {
	XeExposeCallbackData data;
	data.reason = XeCR_EXPOSE;
	data.event = e;
	data.region = r;
	XtCallCallbackList(w, ((XeBasicWidget)w)->basic.expose_callbacks,
			   (XtPointer)&data);
    }

static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	XeBasicWidget s_old = (XeBasicWidget) current;
	XeBasicWidget s_new = (XeBasicWidget) new;
	Boolean new_cursor = FALSE;
	
	if (s_old->basic.cursor != s_new->basic.cursor)
	    {
		new_cursor = TRUE;
		/*
		** If the converter fails, the cursor will end up Zero,
		** change it into None with a warning.
		*/
		if (s_new->basic.cursor == 0)
		    {
			XtWarning(
			 "Probable incorrect cursor name--replaced with None");
			s_new->basic.cursor = None;
		    }
	    }
	if (s_old->basic.visual != s_new->basic.visual)
	    {
		s_new->basic.visual = s_old->basic.visual;
		XeWidgetWarningMsg((Widget)s_old, "noteBasicVisual",
				   "Cannot change visual with set_values",
				   (String *)NULL, 0);
	    }
	/*
	** If contentString resource is an empty string, make it NULL
	** pointer (without this, it would be hard to make achieve this
	** using editres--well, it's still tricky: first you have to set
	** the string to "", then length to 0 and only after that request
	** loading of content --msa)
	*/
	if (s_new->basic.content_string &&
	    s_new->basic.content_length == 0)
	    {
		s_new->basic.content_length =
			strlen(s_new->basic.content_string);
		if (s_new->basic.content_length == 0)
			s_new->basic.content_string = NULL;
	    }

	if (new_cursor && XtIsRealized(new))
		XDefineCursor(XtDisplay(new), XtWindow(new),
			      s_new->basic.cursor);
	return False;   
    }

/*
** Widget needs to have own Realize function so that different
** visuals can be specified for it.
*/
static void Realize(widget, value_mask, attributes)
Widget widget;
XtValueMask *value_mask;
XSetWindowAttributes *attributes;
    {
	XeBasicWidget w = (XeBasicWidget)widget;
	Visual *visual;

	if (w->basic.visual == NULL)
		visual = (Visual *)CopyFromParent;
	else
	    {
		visual = w->basic.visual;
		if (visual != DefaultVisualOfScreen(XtScreen(w)))
		    {
			w->core.colormap = w->basic.cmap =
				XCreateColormap
					(XtDisplay(w),
					 RootWindowOfScreen(XtScreen(w)),
					 visual, AllocNone);
			attributes->colormap = w->core.colormap;
			*value_mask |= CWColormap;
		    }
	    }
	XtCreateWindow(widget, (unsigned int) InputOutput,
		       visual, *value_mask, attributes);
    }


static void Destroy(w)
Widget w;
    {
	register XeBasicWidget rw = (XeBasicWidget)w;
	
	_XeFreeColors(rw);
    }

/*
** Widget needs to follow cursor to change the colourmaps if private
** colourmaps are installed.
**
** A private colormap is indicated by non-zero value in basic.cmap
** field (which is actually the saved old default colormap).
*/
static void EnterWindow(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {

	XeBasicWidget r = (XeBasicWidget)w;
	Widget wlst[2];
	
	if (r->basic.cmap == 0)
		return;	/* No private colormap, nothing to do */
	if (r->basic.colormap_install)
	    {
		XInstallColormap(XtDisplay(w), r->core.colormap);
		return;
	    }
	while (!XtIsShell(w))
		w = XtParent(w);
	wlst[0] = (Widget)r;
	wlst[1] = w;
	XtSetWMColormapWindows(w, wlst, (Cardinal)2);
    }

static void LeaveWindow(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {
	XeBasicWidget r = (XeBasicWidget)w;

	if (r->basic.cmap == 0)
		return;	/* No private colormap, nothing to do */
	if (r->basic.colormap_install)
	    {
		XUninstallColormap(XtDisplay(w), r->core.colormap);
		return;
	    }
	while (!XtIsShell(w))
		w = XtParent(w);
	XtSetWMColormapWindows(w, &w, (Cardinal)1);
    }

static void Notify(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
    {
	XeNotifyCallbackData call_data;
	call_data.reason = XeCR_NOTIFY;
	call_data.event = event;
	call_data.params = params;
	call_data.num_params = *num_params;
	XtCallCallbackList(w, ((XeBasicWidget)w)->basic.notify_callbacks,
			   (XtPointer)&call_data);
    }

/*
**	Support Functions for the Asynchronous Data Flows
**	*************************************************
*/

/*
** DoneAndDeleteFlow
**	Call widget defined done if still uncalled, and then release all
**	resources associated with the flow. Note, that this will be
**	also called implicitly from DoneAndCloseFile.
*/
static void DoneAndDeleteFlow(df)
XeDataFlow *df;
    {
	if (df->save != NULL)
		(*df->save)(df);
	if (df->id != None)
		XtRemoveInput(df->id);
	if (df->buffer != NULL)
		XtFree((char *)df->buffer);
	XtFree((char *)df);
    }
/*
** DoneAndCloseFile
**	Sometimes Basic has to open the file for the flow. This function
**	takes care of calling the users 'done' function (saved in 'save')
**	and then closes the file.
*/
static void DoneAndCloseFile(df)
XeDataFlow *df;
    {
	if (df->save != NULL)
	    {
		(*df->save)(df);
		df->save = NULL;
	    }
	if (df->fd >= 0)
	    {
		close(df->fd);
		df->fd = -1;
	    }
	DoneAndDeleteFlow(df);
    }
/*
** MoreToFile
**	General function which is called when the output stream
**	is ready for more output (XtInputCallbackProc).
*/
static void MoreToFile(d, fid, id)
XtPointer d;
int *fid;
XtInputId *id;
    {
	XeDataFlow *df = (XeDataFlow *)d;

	XtRemoveInput(*id);
	if (*id != df->id)
		XtWarning("Basic.c/MoreToFile: XtInputId mismatch");
	df->id = None;
	if ((*df->more)(df) < 0)
		(*df->done)(df);
    }
/*
** FromFileToFlow
**	General function to feed octet stream from a file into
**	data flow (XtInputCallbackProc).
**
**	NOTE: This function is *never* called when the flow has
**	      buffered data (df->length > 0).
*/
static void FromFileToFlow(d, fid, id)
XtPointer d;
int *fid;
XtInputId *id;
    {
	XeDataFlow *df = (XeDataFlow *)d;
	char buf[10000];
	int nbytes, obytes;

	if (*id != df->id)
		XtWarning("Basic.c/FromFileToFlow: XtInputId mismatch");
	if ((nbytes = read(*fid, buf, sizeof(buf))) > 0)
	    {
		/*
		** Received at least one byte, feed to the flow.
		*/
		obytes = (*df->feed)(df, buf, nbytes);
		if (obytes == nbytes)
			return;
		XtRemoveInput(*id);
		df->id = None;
		if (obytes < 0)
			(*df->done)(df);
		else
		    {
			df->length = nbytes - obytes;
			df->buffer = (char *)XtMalloc(df->length);
			memcpy(df->buffer, buf + obytes, df->length);
		    }
	    }
	else
	    {
		/*
		** Assume that everything else is EOF
		*/
		XtRemoveInput(*id);
		df->id = None;
		(*df->done)(df);
	    }
    }

/*
** MoreFromStream
**	Is called when input proc should be activated again. It is safe
**	to call multiple times, does nothing if Input is already active.
*/
static int MoreFromStream(df)
XeDataFlow *df;
    {
	if (df->length > 0)
	    {
		int obytes;

		obytes = (*df->feed)(df, df->buffer, df->length);
		if (obytes >= df->length || obytes < 0)
		    {
			XtFree((char *)df->buffer);
			df->buffer = NULL;
			df->length = 0;
			if (obytes < 0)
				return -1;
		    }
		else if (obytes > 0)
		    {
			df->length -= obytes;
			/* memmove(df->buffer, df->buffer + obytes, df->length); -- fix later, msa*/
			memcpy(df->buffer, df->buffer + obytes, df->length);
			return 1;
		    }
		else
			return 1; /* Keep all data in buffer */
	    }
	if (df->fd < 0)
		return -1; /* No input file to read more */
	/*
	** Note: Here we assume 'None' is of valid type for XtInputId and
	** something that never can be a valid XtInputId and use it as a
	** flag to indicate whether input is primed or not..
	*/
	if (df->id == None)
	    {
		df->id = XtAppAddInput
			(XtWidgetToApplicationContext((Widget)df->w),
			 df->fd, (XtPointer)XtInputReadMask,
			 FromFileToFlow, (XtPointer)df);
	    }
	return 1;
    }


/*
** MoreFromString
**	Is called when input proc should be activated again. This function
**	reads from content_string resource.
*/
static int MoreFromString(df)
XeDataFlow *df;
    {
	if (df->length > 0)
	    {
		int obytes;
		XeBasicWidget w = df->w;
		char *buf;
		buf = (char *)w->basic.content_string + w->basic.content_length
			- df->length;
		obytes = (*df->feed)(df, buf, df->length);
		if (obytes >= df->length || obytes < 0)
		    {
			df->length = 0;
			return -1;
		    }
		df->length -= obytes;
		return 1;
	    }
	return -1;
    }

/*
** XeStartInputFlow
**	Initialize reading of the widget content asynchronously using
**	XeDataFlow mechanism. This will hide the actual source of the
**	content stream from the widget implementation. (If content is
**	given with memory pointer, no asynchronous operations really
**	occur, the whole content is just given in single 'feed' call;
**	the mechanism hides file and network access).
**
**	Returns NULL if failure.
*/
XeDataFlow *XeStartInputFlow(w, feed, done)
XeBasicWidget w;
XeDataFlowFeed feed;
XeDataFlowDone done;
    {
	XeDataFlow *df;

	df = (XeDataFlow *)XtMalloc(sizeof(XeDataFlow));
	df->w = w;
	df->feed = feed;
	df->save = done;
	df->done = DoneAndDeleteFlow;
	df->id = None;
	df->buffer = NULL;
	df->length = 0;
	df->fd = -1;
	if (w->basic.content_string != NULL)
	    {
		df->length = w->basic.content_length;
		df->more = MoreFromString;
		return df;
	    }
	else if (w->basic.content_stream != NULL)
	    {
		df->fd = fileno(w->basic.content_stream);
		df->more = MoreFromStream;
		return df;
	    }
	else if (w->basic.content_file != NULL)
	    {
		String params[1];

		df->fd = open(w->basic.content_file, O_RDONLY);
		if (df->fd >= 0)
		    {
			df->more = MoreFromStream;
			df->done = DoneAndCloseFile;
			return df;
		    }
		params[0] = w->basic.content_file;
		XeWidgetWarningMsg((Widget)w,
				   "cannotOpen",
				   "Cannot open file '%s'",
				   params, 1);
	    }
	XtFree((char *)df);
	return NULL;
    }

/*
** FeedFromFlowToFile
**	This is called when there are some output bytes to be
**	written to the output device.
*/
static int FeedFromFlowToFile(df, data, length)
XeDataFlow *df;
char *data;
int length;
    {
	int obytes;

	if (df->fd < 0)
		return -1; /* There is no file to write!!! */
	obytes = write(df->fd, data ? data : "\0", length);
	if (obytes == length && data != NULL)
		return obytes;
	else if (obytes < 0)
	    {
		if (errno != EWOULDBLOCK && errno != EAGAIN)
			return -1;
		obytes = 0; /* Indicate nothing written */
	    }
	/*
	** Note: Here we assume 'None' is of valid type for XtInputId and
	** something that never can be a valid XtInputId and use it as a
	** flag to indicate whether output is primed or not..
	*/
	if (df->id == None)
	    {
		df->id = XtAppAddInput
			(XtWidgetToApplicationContext((Widget)df->w),
			 df->fd, (XtPointer)XtInputWriteMask,
			 MoreToFile, (XtPointer)df);
	    }
	return obytes;
    }

/*
** XeFileOutFlow
**	Initialize asynchronous writing to a file using XeDataFlow
**	mechanism.
**
**	Returns NULL if failure.
*/
XeDataFlow *XeFileOutFlow(w, more, done, fd)
XeBasicWidget w;
XeDataFlowMore more;
XeDataFlowDone done;
int fd;
    {
	XeDataFlow *df;
	int result;

	if (fd < 0)
		return NULL;
	/*
	** (Try to) Set the file into non-blocking mode
	*/
	if (((result = fcntl(fd, F_GETFL, 0)) == -1) ||
	    fcntl(fd, F_SETFL, result | O_NDELAY) == -1)
		XeWidgetWarningMsg((Widget)w,
				   "cannotSetNonBlocking",
				   "Cannot set non-blocking on file.",
				   (char **)NULL, 0);
	/*
	*/
	df = (XeDataFlow *)XtMalloc(sizeof(XeDataFlow));
	df->w = w;
	df->feed = FeedFromFlowToFile;
	df->more = more;
	df->done = DoneAndDeleteFlow;
	df->save = done;
	df->fd = fd;
	df->id = None;
	df->buffer = NULL;
	df->length = 0;
	return df;
    }
