#ifndef _XewAudioP_h
#define _XewAudioP_h
/*
** Copyright 1992 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <stdio.h>
#include <X11/Xew/BasicP.h>
#include <X11/Xew/AnimationP.h>
#include <X11/Xew/Audio.h>

#if NeedFunctionPrototypes
typedef void (*XeAudioNotify)(XeAudioWidget);
typedef int (*XeAudioOpenPlay)(XeAudioWidget);
typedef void (*XeAudioClosePlay)(XeAudioWidget, XeAudioNotify);
typedef void (*XeAudioControl)(XeAudioWidget, int);
typedef void (*XeAudioCleanup)(XeAudioWidget);
#else
typedef void (*XeAudioNotify)();
typedef int (*XeAudioOpenPlay)();
typedef void (*XeAudioClosePlay)();
typedef void (*XeAudioControl)();
typedef void (*XeAudioCleanup)();
#endif

typedef struct _XeAudioClass
    {
	int makes_compiler_happy;	/* not used */
    } XeAudioClassPart;

typedef struct _XeAudioClassRec
    {
	CoreClassPart	core_class;
	XeBasicClassPart basic_class;
	XeAnimationClassPart animation_class;
	XeAudioClassPart audio_class;
    } XeAudioClassRec;

typedef struct XePixmapSet
    {
	struct XePixmapSet *next;
	Display *display;
	Pixmap done;	/* XePlay_FORWARD, current play completed */
	Pixmap play;	/* XePlay_FORWARD, playing */
	Pixmap hold;	/* not FORWARD, waiting for new start */
	Pixmap pause;	/* not FORWARD, paused current playing */
    } XePixmapSet;

typedef struct
    {
	/* resources */
	int		volume;
	/* private state */
	XeDataFlow *flow_in;	/* Input flow (from content) */
	XeDataFlow *flow_out;	/* Output flow (to /dev/audio) */
	XePixmapSet *pixmap_set;/* Pixmaps to be used as background */
	/*
	** Interface to the Audio driver
	*/
	int playing;		/* non-zero, if audio_play owned by this */
	XeAudioOpenPlay open_play;
	XeAudioControl audio_control;
	XeAudioClosePlay close_play;
	XeAudioCleanup audio_cleanup;
    } XeAudioPart;

typedef struct _XeAudioRec
    {
	CorePart	core;
	XeBasicPart	basic;
	XeAnimationPart	animation;
	XeAudioPart	audio;
    } XeAudioRec;

/* Class pointer */
extern XeAudioClassRec xeAudioClassRec;

#endif
