/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/AnimationP.h>


#define offset(field) XtOffsetOf(XeAnimationRec, animation.field)

static XtResource resources[] =
    {
	{XtNfirstFrame, XtCFirstFrame, XtRLong, sizeof(long),
		 offset(first_frame), XtRImmediate, (XtPointer)1},
	{XtNlastFrame, XtCLastFrame, XtRLong, sizeof(long),
		 offset(last_frame), XtRImmediate, (long)0},
	{XtNcurrentFrame, XtCCurrentFrame, XtRLong, sizeof(long),
		 offset(current_frame), XtRImmediate, (long)0},
	{XtNdoneCallback, XtCDoneCallback, XtRCallback, sizeof(XtPointer),
		 offset(done_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNframeCallback, XtCFrameCallback, XtRCallback, sizeof(XtPointer),
		 offset(frame_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNplay, XtCPlay, XtRXePlay, sizeof(XePlay),
		 offset(play), XtRImmediate, XePlay_FORWARD},
	{XtNrate, XtCRate, XtRLong, sizeof(long),
		 offset(rate), XtRImmediate, (long)0},
	{XtNloop, XtCLoop, XtRBoolean, sizeof(Boolean),
		 offset(loop), XtRImmediate, (Boolean)0},
    };
#undef offset

static void ClassPartInitialize(), ClassInitialize(), Initialize();
static Boolean SetValues();

XeAnimationClassRec xeAnimationClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &xeBasicClassRec,
    /* class_name		*/	"XeAnimation",
    /* widget_size		*/	sizeof(XeAnimationRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	NULL,
    /* expose			*/	NULL,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* XeBasic fields */
    /* not used			*/	0
  },
  { /* XeAnimation fields */
    /* not used			*/	0
  }
};

WidgetClass xeAnimationWidgetClass = (WidgetClass)&xeAnimationClassRec;


static CvtEnumInfo cvtPlay[] =
    {
	{"forward",	XePlay_FORWARD },
	{"reverse",	XePlay_REVERSE },
	{"freeze",	XePlay_FREEZE },
	{NULL,		sizeof(XePlay) },
    };

static void ClassInitialize()
    {
	static XtConvertArgRec convertPlayArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtPlay[0],
		    sizeof(XtPointer),
		}
	    };

	XewInitializeWidgetSet();
	XtSetTypeConverter(XtRString, XtRXePlay,
			   XeCvtStringToEnum,
			   convertPlayArg, XtNumber(convertPlayArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal *num_args;
    {
        XeAnimationWidget w = (XeAnimationWidget)new;
	w->animation.frame_num = 0;
    }

static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	return False;   
    }

