/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * The grantlee's plugin to define filters.
 *
 * @author Stephane MANKOWSKI
 */
#include "skggrantleefilters.h"



#include "skgdocumentfilter.h"
#include "skgobjectfilter.h"

SKGGrantleeFilters::SKGGrantleeFilters(QObject* iParent): QObject(iParent)
{}

SKGGrantleeFilters::~SKGGrantleeFilters()
    = default;

QHash< QString, KTextTemplate::Filter* > SKGGrantleeFilters::filters(const QString& iName)
{
    Q_UNUSED(iName)

    QHash<QString, KTextTemplate::Filter*> filtersList;
    filtersList.insert(QLatin1String("query"), new SKGDocumentQueryFilter());
    filtersList.insert(QLatin1String("table"), new SKGDocumentTableFilter());
    filtersList.insert(QLatin1String("display"), new SKGDocumentDisplayFilter());
    filtersList.insert(QLatin1String("att"), new SKGObjectFilter());
    filtersList.insert(QLatin1String("money"), new SKGMoneyFilter());
    filtersList.insert(QLatin1String("percent"), new SKGPercentFilter());
    filtersList.insert(QLatin1String("filesizeformat"), new SKGFileSizeFilter());
    filtersList.insert(QLatin1String("dump"), new SKGDumpFilter());
    filtersList.insert(QLatin1String("encode"), new SKGUrlEncodeFilter());
    filtersList.insert(QLatin1String("replace"), new SKGReplaceFilter());
    return filtersList;
}
