<?php

include_once 'Net/Sieve.php';

class Vacation_Driver_kolab extends Vacation_Driver
{

    function checkConfig(&$realm)
    {
        $realm = 'default';
        return true;
    }

    function setVacation($user, $realm, $pass, $message, $alias)
    {
        $sieve = new Net_Sieve($user . '@' . $realm, $pass);
        if (PEAR::isError($sieve->getError())) {
            $this->err_str = 'Unable to open sieve connection.';
            return false;
        }

        str_replace('"', "'", $message);

        $script = 'require "vacation"; vacation :days 7 :addresses ["' . $user . '@' . $realm . '"] "' . $message . '";';

        if (PEAR::isError($sieve->installScript('kmail-vacation.siv', $script, true))) {
            $this->err_str = 'Unable to install sieve vacation script.';
            return false;
        }

        return true;
    }

    function unsetVacation($user, $realm, $pass)
    {
        $sieve = new Net_Sieve($user . '@' . $realm, $pass);
        if (PEAR::isError($sieve->getError())) {
            $this->err_str = 'Unable to open sieve connection.';
            return false;
        }

        $script = $sieve->getActive();
        if (PEAR::isError($script)) {
            $this->err_str = 'Unable to query active sieve script.';
            return false;
        }

        if ($script == 'kmail-vacation.siv') {
            $vac = $sieve->getScript($script);
            if (preg_match('/require\s+"vacation"\s*;\s+vacation\s+(:days\s+\d+)?\s+:addresses\s+\["[^"]*"\]\s+"[^"]*"\s*;/', $vac) == 0) {
                $this->err_str = 'The active sieve script is not a vacation message. Is forwarding enabled?';
                return false;
            }
        } else {
            $this->err_str = 'The active sieve script is not the standard kolab vacation script.';
            return false;
        }

        if (PEAR::isError($sieve->removeScript($script))) {
            $this->err_str = 'Unable to remove sieve vacation script.';
            return false;
        }

        return true;
    }

}

?>
