<?php
/**
 * $Horde: turba/prefs.php,v 1.16 2003/05/22 19:42:42 chuck Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 * Copyright 2002-2003 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function handle_columnselect($updated)
{
    global $prefs;

    $columns = Horde::getFormData('columns');
    if (!empty($columns)) {
        $prefs->setValue('columns', $columns);
        $updated = true;
    }

    return $updated;
}

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require TURBA_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    include TURBA_BASE . '/config/prefs.php';
}

$title = _("User Options");
require TURBA_TEMPLATES . '/common-header.inc';
Turba::menu();

/* Assign variables for select lists. */
if (!$prefs->isLocked('default_dir')) {
    $default_dir_options = array();
    foreach ($cfgSources as $key => $info) {
        $default_dir_options[$key] = $info['title'];
    }
}

PrefsUI::generateUI($group);

require TURBA_TEMPLATES . '/common-footer.inc';
