<?php

/**
 * Moment_Summarry_Block:: Implementation of the Horde_Block API
 * To display a summary of meetings items
 *
 * $Horde: moment/lib/Block/summary.php,v 1.1 2003/01/29 04:57:07 mikec Exp $
 */
class moment_summary_Block extends Horde_Block {

    /* Constructor */
    function moment_summary_Block($params = array()) 
    {
        $this->_params = $params;
        $this->_app = 'moment';
        $this->_type = 'summary';
    }

    /**
     * Does this block have any user editable parameters?
     *
     * @return boolean  True is there are editable paramters
     *                  False if there are not
     */
    function isEditable() 
    {
        return false;
    }

    /**
     * The title to go in this block.
     *
     * @return string   The title text.
     */
    function _title() 
    {
        global $registry;

        $html  = Horde::link(Horde::url($registry->getInitialPage(), true), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
        $html .= Horde::link(Horde::applicationUrl('meeting.php', true), _("New Meeting"), 'smallheader') . Horde::img('moment.gif', _("New Meeting"), '', Horde::url($registry->getParam('graphics'), true, -1)) . _("New Meeting") . '</a>';

        return $html;
    }
    
    /**
     * The content to go in this block.
     *
     * @return string   The content
     */
    function _content() 
    {
        global $registry, $prefs;
        require_once dirname(__FILE__) . '/../base.php';

        $html = '<table border="0" cellpadding="0" cellspacing="0" width="100%">';
        $html .= '<tr><td colspan="2" class="text"><b>' . _("Today") . '</b></td></tr>';

        $sortby = $prefs->getValue('sortby');
        $sortdir = $prefs->getValue('sortdir');
        $meetings = Moment::listMeetings($sortby, $sortdir);

        $today    = mktime(0, 0, 0, date('n', time()), date('j', time()), date('Y', time()));
        $tomorrow = mktime(0, 0, 0, date('n', time()), date('j', time()) + 1, date('Y', time()));

        $today_html = '';
        $tomorrow_html = '';
        foreach ($meetings as $meeting) {
            $startday = mktime(0, 0, 0, date('n', $meeting['start']), date('j', $meeting['start']), date('Y', $meeting['start']));
            if ($startday == $today) {
                $viewurl = Horde::addParameter('viewMeeting.php', 'meetingID', $meeting['id']);
                $today_html .= '<tr><td class="text">' . date('g:i a', $meeting['start']) . "</td>";
                $today_html .= '<td class="text">';
                $today_html .= Horde::link(Horde::applicationUrl($viewurl, true), $meeting['title']);
                $today_html .= htmlspecialchars($meeting['title']) . '</a></td></tr>';
            } elseif ($startday == $tomorrow) {
                $viewurl = Horde::addParameter('viewMeeting.php', 'meetingID', $meeting['id']);
                $tomorrow_html .= '<tr><td class="text">' . date('g:i a', $meeting['start']) . "</td>";
                $tomorrow_html .= '<td class="text">';
                $tomorrow_html .= Horde::link(Horde::applicationUrl($viewurl, true), $meeting['title']);
                $tomorrow_html .= htmlspecialchars($meeting['title']) . '</a></td></tr>';
            }        
        }

        $html .= empty($today_html) ? '<tr><td colspan="2" class="text"><i>' . _("No Meetings") . '</b></td></tr>' : $today_html;
        $html .= '<tr><td colspan="2" class="text"><br/><b>' . _("Tomorrow") . '</b></td></tr>';
        $html .= empty($tomorrow_html) ? '<tr><td colspan="2" class="text"><i>' . _("No Meetings") . '</b></td></tr>' : $tomorrow_html;
        $html .= '</table>';

        return $html;
    }
}
