<?php
/**
 * $Horde: horde/mobile.php,v 2.6 2003/05/12 16:54:28 jan Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

@define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Identity.php';
require_once HORDE_BASE . '/lib/Mobile.php';

if (!Auth::getAuth()) {
    header('Location: ' . Horde::addParameter(Horde::applicationUrl('login.php', true),
                                              'url', Horde::selfUrl()));
    exit;
}

$identity = new Identity();
$fullname = $identity->getValue('fullname');
if (empty($fullname)) {
    $fullname = Auth::getAuth();
}

$m = &new Horde_Mobile(_("Welcome"));
$m->add(new Horde_Mobile_text(sprintf(_("Welcome, %s"), $fullname)));

// Messy way of linking to active apps that support mobile
// devices. Should be made more elegant at some point.
if (!empty($registry->applications['mimp']['status']) &&
    $registry->applications['mimp']['status'] != 'inactive') {
    $m->add(new Horde_Mobile_link($registry->getParam('name', 'mimp'),
                                  Horde::url($registry->getParam('webroot', 'mimp') . '/'),
                                  $registry->getParam('name', 'mimp')));
}

$m->display();
