<?php
/**
 * Class representing vTimezones
 *
 * $Horde: horde/lib/iCalendar/vtimezone.php,v 1.3 2003/07/03 09:16:40 mikec Exp $
 *
 * Copyright 2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.3 $
 * @since   Horde 3.0
 * @package horde.iCalendar
 */
 class Horde_iCalendar_vtimezone extends Horde_iCalendar {

    function getType()
    {
        return 'vTimeZone';
    }

    function parsevCalendar($data)
    {
        parent::parsevCalendar($data, 'VTIMEZONE');
    }

    function exportvCalendar(&$container)
    {
        return parent::_exportvData('VTIMEZONE');
    }
}

class Horde_iCalendar_standard extends Horde_iCalendar {

    function getType()
    {
        return 'standard';
    }

    function parsevCalendar($data)
    {
        parent::parsevCalendar($data, 'STANDARD');
    }

    function exportvCalendar(&$container)
    {
        return parent::_exportvData('STANDARD');
    }
}

class Horde_iCalendar_daylight extends Horde_iCalendar {

    function getType()
    {
        return 'daylight';
    }

    function parsevCalendar($data)
    {
        parent::parsevCalendar($data, 'DAYLIGHT');
    }

    function exportvCalendar(&$container)
    {
        return parent::_exportvData('DAYLIGHT');
    }
}
